// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StopBackupJobInput
type StopBackupJobInput struct {
	_ struct{} `type:"structure"`

	// Uniquely identifies a request to AWS Backup to back up a resource.
	//
	// BackupJobId is a required field
	BackupJobId *string `location:"uri" locationName:"backupJobId" type:"string" required:"true"`
}

// String returns the string representation
func (s StopBackupJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopBackupJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopBackupJobInput"}

	if s.BackupJobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BackupJobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StopBackupJobInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.BackupJobId != nil {
		v := *s.BackupJobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "backupJobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StopBackupJobOutput
type StopBackupJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopBackupJobOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StopBackupJobOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opStopBackupJob = "StopBackupJob"

// StopBackupJobRequest returns a request value for making API operation for
// AWS Backup.
//
// Attempts to cancel a job to create a one-time backup of a resource.
//
//    // Example sending a request using StopBackupJobRequest.
//    req := client.StopBackupJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StopBackupJob
func (c *Client) StopBackupJobRequest(input *StopBackupJobInput) StopBackupJobRequest {
	op := &aws.Operation{
		Name:       opStopBackupJob,
		HTTPMethod: "POST",
		HTTPPath:   "/backup-jobs/{backupJobId}",
	}

	if input == nil {
		input = &StopBackupJobInput{}
	}

	req := c.newRequest(op, input, &StopBackupJobOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return StopBackupJobRequest{Request: req, Input: input, Copy: c.StopBackupJobRequest}
}

// StopBackupJobRequest is the request type for the
// StopBackupJob API operation.
type StopBackupJobRequest struct {
	*aws.Request
	Input *StopBackupJobInput
	Copy  func(*StopBackupJobInput) StopBackupJobRequest
}

// Send marshals and sends the StopBackupJob API request.
func (r StopBackupJobRequest) Send(ctx context.Context) (*StopBackupJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopBackupJobResponse{
		StopBackupJobOutput: r.Request.Data.(*StopBackupJobOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopBackupJobResponse is the response type for the
// StopBackupJob API operation.
type StopBackupJobResponse struct {
	*StopBackupJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopBackupJob request.
func (r *StopBackupJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
