// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRecoveryPointRestoreMetadataInput
type GetRecoveryPointRestoreMetadataInput struct {
	_ struct{} `type:"structure"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the AWS Region where they are created. They consist of lowercase letters,
	// numbers, and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`

	// An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
	// for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	//
	// RecoveryPointArn is a required field
	RecoveryPointArn *string `location:"uri" locationName:"recoveryPointArn" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRecoveryPointRestoreMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecoveryPointRestoreMetadataInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetRecoveryPointRestoreMetadataInput"}

	if s.BackupVaultName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BackupVaultName"))
	}

	if s.RecoveryPointArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecoveryPointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRecoveryPointRestoreMetadataInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.BackupVaultName != nil {
		v := *s.BackupVaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "backupVaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RecoveryPointArn != nil {
		v := *s.RecoveryPointArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "recoveryPointArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRecoveryPointRestoreMetadataOutput
type GetRecoveryPointRestoreMetadataOutput struct {
	_ struct{} `type:"structure"`

	// An ARN that uniquely identifies a backup vault; for example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	BackupVaultArn *string `type:"string"`

	// An ARN that uniquely identifies a recovery point; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string `type:"string"`

	// A set of metadata key-value pairs that lists the metadata key-value pairs
	// that are required to restore the recovery point.
	RestoreMetadata map[string]string `type:"map"`
}

// String returns the string representation
func (s GetRecoveryPointRestoreMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRecoveryPointRestoreMetadataOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupVaultArn != nil {
		v := *s.BackupVaultArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupVaultArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RecoveryPointArn != nil {
		v := *s.RecoveryPointArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecoveryPointArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.RestoreMetadata) > 0 {
		v := s.RestoreMetadata

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "RestoreMetadata", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

const opGetRecoveryPointRestoreMetadata = "GetRecoveryPointRestoreMetadata"

// GetRecoveryPointRestoreMetadataRequest returns a request value for making API operation for
// AWS Backup.
//
// Returns two sets of metadata key-value pairs. The first set lists the metadata
// that the recovery point was created with. The second set lists the metadata
// key-value pairs that are required to restore the recovery point.
//
// These sets can be the same, or the restore metadata set can contain different
// values if the target service to be restored has changed since the recovery
// point was created and now requires additional or different information in
// order to be restored.
//
//    // Example sending a request using GetRecoveryPointRestoreMetadataRequest.
//    req := client.GetRecoveryPointRestoreMetadataRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRecoveryPointRestoreMetadata
func (c *Client) GetRecoveryPointRestoreMetadataRequest(input *GetRecoveryPointRestoreMetadataInput) GetRecoveryPointRestoreMetadataRequest {
	op := &aws.Operation{
		Name:       opGetRecoveryPointRestoreMetadata,
		HTTPMethod: "GET",
		HTTPPath:   "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}/restore-metadata",
	}

	if input == nil {
		input = &GetRecoveryPointRestoreMetadataInput{}
	}

	req := c.newRequest(op, input, &GetRecoveryPointRestoreMetadataOutput{})
	return GetRecoveryPointRestoreMetadataRequest{Request: req, Input: input, Copy: c.GetRecoveryPointRestoreMetadataRequest}
}

// GetRecoveryPointRestoreMetadataRequest is the request type for the
// GetRecoveryPointRestoreMetadata API operation.
type GetRecoveryPointRestoreMetadataRequest struct {
	*aws.Request
	Input *GetRecoveryPointRestoreMetadataInput
	Copy  func(*GetRecoveryPointRestoreMetadataInput) GetRecoveryPointRestoreMetadataRequest
}

// Send marshals and sends the GetRecoveryPointRestoreMetadata API request.
func (r GetRecoveryPointRestoreMetadataRequest) Send(ctx context.Context) (*GetRecoveryPointRestoreMetadataResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRecoveryPointRestoreMetadataResponse{
		GetRecoveryPointRestoreMetadataOutput: r.Request.Data.(*GetRecoveryPointRestoreMetadataOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRecoveryPointRestoreMetadataResponse is the response type for the
// GetRecoveryPointRestoreMetadata API operation.
type GetRecoveryPointRestoreMetadataResponse struct {
	*GetRecoveryPointRestoreMetadataOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRecoveryPointRestoreMetadata request.
func (r *GetRecoveryPointRestoreMetadataResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
