// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnterStandbyQuery
type EnterStandbyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The IDs of the instances. You can specify up to 20 instances.
	InstanceIds []string `type:"list"`

	// Indicates whether to decrement the desired capacity of the Auto Scaling group
	// by the number of instances moved to Standby mode.
	//
	// ShouldDecrementDesiredCapacity is a required field
	ShouldDecrementDesiredCapacity *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s EnterStandbyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnterStandbyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnterStandbyInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if s.ShouldDecrementDesiredCapacity == nil {
		invalidParams.Add(aws.NewErrParamRequired("ShouldDecrementDesiredCapacity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnterStandbyAnswer
type EnterStandbyOutput struct {
	_ struct{} `type:"structure"`

	// The activities related to moving instances into Standby mode.
	Activities []Activity `type:"list"`
}

// String returns the string representation
func (s EnterStandbyOutput) String() string {
	return awsutil.Prettify(s)
}

const opEnterStandby = "EnterStandby"

// EnterStandbyRequest returns a request value for making API operation for
// Auto Scaling.
//
// Moves the specified instances into the standby state.
//
// For more information, see Temporarily Removing Instances from Your Auto Scaling
// Group (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
//    // Example sending a request using EnterStandbyRequest.
//    req := client.EnterStandbyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnterStandby
func (c *Client) EnterStandbyRequest(input *EnterStandbyInput) EnterStandbyRequest {
	op := &aws.Operation{
		Name:       opEnterStandby,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnterStandbyInput{}
	}

	req := c.newRequest(op, input, &EnterStandbyOutput{})
	return EnterStandbyRequest{Request: req, Input: input, Copy: c.EnterStandbyRequest}
}

// EnterStandbyRequest is the request type for the
// EnterStandby API operation.
type EnterStandbyRequest struct {
	*aws.Request
	Input *EnterStandbyInput
	Copy  func(*EnterStandbyInput) EnterStandbyRequest
}

// Send marshals and sends the EnterStandby API request.
func (r EnterStandbyRequest) Send(ctx context.Context) (*EnterStandbyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &EnterStandbyResponse{
		EnterStandbyOutput: r.Request.Data.(*EnterStandbyOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// EnterStandbyResponse is the response type for the
// EnterStandby API operation.
type EnterStandbyResponse struct {
	*EnterStandbyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// EnterStandby request.
func (r *EnterStandbyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
