// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancersType
type DetachLoadBalancersInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The names of the load balancers. You can specify up to 10 load balancers.
	//
	// LoadBalancerNames is a required field
	LoadBalancerNames []string `type:"list" required:"true"`
}

// String returns the string representation
func (s DetachLoadBalancersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachLoadBalancersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetachLoadBalancersInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if s.LoadBalancerNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("LoadBalancerNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancersResultType
type DetachLoadBalancersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachLoadBalancersOutput) String() string {
	return awsutil.Prettify(s)
}

const opDetachLoadBalancers = "DetachLoadBalancers"

// DetachLoadBalancersRequest returns a request value for making API operation for
// Auto Scaling.
//
// Detaches one or more Classic Load Balancers from the specified Auto Scaling
// group.
//
// This operation detaches only Classic Load Balancers. If you have Application
// Load Balancers or Network Load Balancers, use DetachLoadBalancerTargetGroups
// instead.
//
// When you detach a load balancer, it enters the Removing state while deregistering
// the instances in the group. When all instances are deregistered, then you
// can no longer describe the load balancer using DescribeLoadBalancers. The
// instances remain running.
//
//    // Example sending a request using DetachLoadBalancersRequest.
//    req := client.DetachLoadBalancersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancers
func (c *Client) DetachLoadBalancersRequest(input *DetachLoadBalancersInput) DetachLoadBalancersRequest {
	op := &aws.Operation{
		Name:       opDetachLoadBalancers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachLoadBalancersInput{}
	}

	req := c.newRequest(op, input, &DetachLoadBalancersOutput{})
	return DetachLoadBalancersRequest{Request: req, Input: input, Copy: c.DetachLoadBalancersRequest}
}

// DetachLoadBalancersRequest is the request type for the
// DetachLoadBalancers API operation.
type DetachLoadBalancersRequest struct {
	*aws.Request
	Input *DetachLoadBalancersInput
	Copy  func(*DetachLoadBalancersInput) DetachLoadBalancersRequest
}

// Send marshals and sends the DetachLoadBalancers API request.
func (r DetachLoadBalancersRequest) Send(ctx context.Context) (*DetachLoadBalancersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DetachLoadBalancersResponse{
		DetachLoadBalancersOutput: r.Request.Data.(*DetachLoadBalancersOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DetachLoadBalancersResponse is the response type for the
// DetachLoadBalancers API operation.
type DetachLoadBalancersResponse struct {
	*DetachLoadBalancersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DetachLoadBalancers request.
func (r *DetachLoadBalancersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
