// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteFunctionRequest
type DeleteFunctionInput struct {
	_ struct{} `type:"structure"`

	// The GraphQL API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The Function ID.
	//
	// FunctionId is a required field
	FunctionId *string `location:"uri" locationName:"functionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFunctionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFunctionInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.FunctionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFunctionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionId != nil {
		v := *s.FunctionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "functionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteFunctionResponse
type DeleteFunctionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFunctionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteFunction = "DeleteFunction"

// DeleteFunctionRequest returns a request value for making API operation for
// AWS AppSync.
//
// Deletes a Function.
//
//    // Example sending a request using DeleteFunctionRequest.
//    req := client.DeleteFunctionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteFunction
func (c *Client) DeleteFunctionRequest(input *DeleteFunctionInput) DeleteFunctionRequest {
	op := &aws.Operation{
		Name:       opDeleteFunction,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apis/{apiId}/functions/{functionId}",
	}

	if input == nil {
		input = &DeleteFunctionInput{}
	}

	req := c.newRequest(op, input, &DeleteFunctionOutput{})
	return DeleteFunctionRequest{Request: req, Input: input, Copy: c.DeleteFunctionRequest}
}

// DeleteFunctionRequest is the request type for the
// DeleteFunction API operation.
type DeleteFunctionRequest struct {
	*aws.Request
	Input *DeleteFunctionInput
	Copy  func(*DeleteFunctionInput) DeleteFunctionRequest
}

// Send marshals and sends the DeleteFunction API request.
func (r DeleteFunctionRequest) Send(ctx context.Context) (*DeleteFunctionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteFunctionResponse{
		DeleteFunctionOutput: r.Request.Data.(*DeleteFunctionOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteFunctionResponse is the response type for the
// DeleteFunction API operation.
type DeleteFunctionResponse struct {
	*DeleteFunctionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteFunction request.
func (r *DeleteFunctionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
