// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appmesh

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// An object representing the access logging information for a virtual node.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/AccessLog
type AccessLog struct {
	_ struct{} `type:"structure"`

	// The file object to send virtual node access logs to.
	File *FileAccessLog `locationName:"file" type:"structure"`
}

// String returns the string representation
func (s AccessLog) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessLog) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AccessLog"}
	if s.File != nil {
		if err := s.File.Validate(); err != nil {
			invalidParams.AddNested("File", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessLog) MarshalFields(e protocol.FieldEncoder) error {
	if s.File != nil {
		v := s.File

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "file", v, metadata)
	}
	return nil
}

// An object representing the backends that a virtual node is expected to send
// outbound traffic to.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/Backend
type Backend struct {
	_ struct{} `type:"structure"`

	// Specifies a virtual service to use as a backend for a virtual node.
	VirtualService *VirtualServiceBackend `locationName:"virtualService" type:"structure"`
}

// String returns the string representation
func (s Backend) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Backend) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Backend"}
	if s.VirtualService != nil {
		if err := s.VirtualService.Validate(); err != nil {
			invalidParams.AddNested("VirtualService", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Backend) MarshalFields(e protocol.FieldEncoder) error {
	if s.VirtualService != nil {
		v := s.VirtualService

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "virtualService", v, metadata)
	}
	return nil
}

// An object representing the DNS service discovery information for your virtual
// node.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DnsServiceDiscovery
type DnsServiceDiscovery struct {
	_ struct{} `type:"structure"`

	// Specifies the DNS service discovery hostname for the virtual node.
	//
	// Hostname is a required field
	Hostname *string `locationName:"hostname" type:"string" required:"true"`
}

// String returns the string representation
func (s DnsServiceDiscovery) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DnsServiceDiscovery) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DnsServiceDiscovery"}

	if s.Hostname == nil {
		invalidParams.Add(aws.NewErrParamRequired("Hostname"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DnsServiceDiscovery) MarshalFields(e protocol.FieldEncoder) error {
	if s.Hostname != nil {
		v := *s.Hostname

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "hostname", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing the egress filter rules for a service mesh.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/EgressFilter
type EgressFilter struct {
	_ struct{} `type:"structure"`

	// The egress filter type. By default, the type is DROP_ALL, which allows egress
	// only from virtual nodes to other defined resources in the service mesh (and
	// any traffic to *.amazonaws.com for AWS API calls). You can set the egress
	// filter type to ALLOW_ALL to allow egress to any endpoint inside or outside
	// of the service mesh.
	//
	// Type is a required field
	Type EgressFilterType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s EgressFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EgressFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EgressFilter"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EgressFilter) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object representing an access log file.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/FileAccessLog
type FileAccessLog struct {
	_ struct{} `type:"structure"`

	// The file path to write access logs to. You can use /dev/stdout to send access
	// logs to standard out and configure your Envoy container to use a log driver,
	// such as awslogs, to export the access logs to a log storage service such
	// as Amazon CloudWatch Logs. You can also specify a path in the Envoy container's
	// file system to write the files to disk.
	//
	// The Envoy process must have write permissions to the path that you specify
	// here. Otherwise, Envoy fails to bootstrap properly.
	//
	// Path is a required field
	Path *string `locationName:"path" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s FileAccessLog) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FileAccessLog) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FileAccessLog"}

	if s.Path == nil {
		invalidParams.Add(aws.NewErrParamRequired("Path"))
	}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Path", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FileAccessLog) MarshalFields(e protocol.FieldEncoder) error {
	if s.Path != nil {
		v := *s.Path

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing the health check policy for a virtual node's listener.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/HealthCheckPolicy
type HealthCheckPolicy struct {
	_ struct{} `type:"structure"`

	// The number of consecutive successful health checks that must occur before
	// declaring listener healthy.
	//
	// HealthyThreshold is a required field
	HealthyThreshold *int64 `locationName:"healthyThreshold" min:"2" type:"integer" required:"true"`

	// The time period in milliseconds between each health check execution.
	//
	// IntervalMillis is a required field
	IntervalMillis *int64 `locationName:"intervalMillis" min:"5000" type:"long" required:"true"`

	// The destination path for the health check request. This is required only
	// if the specified protocol is HTTP. If the protocol is TCP, this parameter
	// is ignored.
	Path *string `locationName:"path" type:"string"`

	// The destination port for the health check request. This port must match the
	// port defined in the PortMapping for the listener.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// The protocol for the health check request.
	//
	// Protocol is a required field
	Protocol PortProtocol `locationName:"protocol" type:"string" required:"true" enum:"true"`

	// The amount of time to wait when receiving a response from the health check,
	// in milliseconds.
	//
	// TimeoutMillis is a required field
	TimeoutMillis *int64 `locationName:"timeoutMillis" min:"2000" type:"long" required:"true"`

	// The number of consecutive failed health checks that must occur before declaring
	// a virtual node unhealthy.
	//
	// UnhealthyThreshold is a required field
	UnhealthyThreshold *int64 `locationName:"unhealthyThreshold" min:"2" type:"integer" required:"true"`
}

// String returns the string representation
func (s HealthCheckPolicy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheckPolicy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HealthCheckPolicy"}

	if s.HealthyThreshold == nil {
		invalidParams.Add(aws.NewErrParamRequired("HealthyThreshold"))
	}
	if s.HealthyThreshold != nil && *s.HealthyThreshold < 2 {
		invalidParams.Add(aws.NewErrParamMinValue("HealthyThreshold", 2))
	}

	if s.IntervalMillis == nil {
		invalidParams.Add(aws.NewErrParamRequired("IntervalMillis"))
	}
	if s.IntervalMillis != nil && *s.IntervalMillis < 5000 {
		invalidParams.Add(aws.NewErrParamMinValue("IntervalMillis", 5000))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Port", 1))
	}
	if len(s.Protocol) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Protocol"))
	}

	if s.TimeoutMillis == nil {
		invalidParams.Add(aws.NewErrParamRequired("TimeoutMillis"))
	}
	if s.TimeoutMillis != nil && *s.TimeoutMillis < 2000 {
		invalidParams.Add(aws.NewErrParamMinValue("TimeoutMillis", 2000))
	}

	if s.UnhealthyThreshold == nil {
		invalidParams.Add(aws.NewErrParamRequired("UnhealthyThreshold"))
	}
	if s.UnhealthyThreshold != nil && *s.UnhealthyThreshold < 2 {
		invalidParams.Add(aws.NewErrParamMinValue("UnhealthyThreshold", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HealthCheckPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.HealthyThreshold != nil {
		v := *s.HealthyThreshold

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "healthyThreshold", protocol.Int64Value(v), metadata)
	}
	if s.IntervalMillis != nil {
		v := *s.IntervalMillis

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "intervalMillis", protocol.Int64Value(v), metadata)
	}
	if s.Path != nil {
		v := *s.Path

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "port", protocol.Int64Value(v), metadata)
	}
	if len(s.Protocol) > 0 {
		v := s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "protocol", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TimeoutMillis != nil {
		v := *s.TimeoutMillis

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timeoutMillis", protocol.Int64Value(v), metadata)
	}
	if s.UnhealthyThreshold != nil {
		v := *s.UnhealthyThreshold

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unhealthyThreshold", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An object representing the HTTP routing specification for a route.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/HttpRoute
type HttpRoute struct {
	_ struct{} `type:"structure"`

	// The action to take if a match is determined.
	//
	// Action is a required field
	Action *HttpRouteAction `locationName:"action" type:"structure" required:"true"`

	// The criteria for determining an HTTP request match.
	//
	// Match is a required field
	Match *HttpRouteMatch `locationName:"match" type:"structure" required:"true"`
}

// String returns the string representation
func (s HttpRoute) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpRoute) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HttpRoute"}

	if s.Action == nil {
		invalidParams.Add(aws.NewErrParamRequired("Action"))
	}

	if s.Match == nil {
		invalidParams.Add(aws.NewErrParamRequired("Match"))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(aws.ErrInvalidParams))
		}
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HttpRoute) MarshalFields(e protocol.FieldEncoder) error {
	if s.Action != nil {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "action", v, metadata)
	}
	if s.Match != nil {
		v := s.Match

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "match", v, metadata)
	}
	return nil
}

// An object representing the traffic distribution requirements for matched
// HTTP requests.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/HttpRouteAction
type HttpRouteAction struct {
	_ struct{} `type:"structure"`

	// The targets that traffic is routed to when a request matches the route. You
	// can specify one or more targets and their relative weights to distribute
	// traffic with.
	//
	// WeightedTargets is a required field
	WeightedTargets []WeightedTarget `locationName:"weightedTargets" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s HttpRouteAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpRouteAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HttpRouteAction"}

	if s.WeightedTargets == nil {
		invalidParams.Add(aws.NewErrParamRequired("WeightedTargets"))
	}
	if s.WeightedTargets != nil && len(s.WeightedTargets) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WeightedTargets", 1))
	}
	if s.WeightedTargets != nil {
		for i, v := range s.WeightedTargets {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "WeightedTargets", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HttpRouteAction) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.WeightedTargets) > 0 {
		v := s.WeightedTargets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "weightedTargets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// An object representing the requirements for a route to match HTTP requests
// for a virtual router.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/HttpRouteMatch
type HttpRouteMatch struct {
	_ struct{} `type:"structure"`

	// Specifies the path to match requests with. This parameter must always start
	// with /, which by itself matches all requests to the virtual service name.
	// You can also match for path-based routing of requests. For example, if your
	// virtual service name is my-service.local and you want the route to match
	// requests to my-service.local/metrics, your prefix should be /metrics.
	//
	// Prefix is a required field
	Prefix *string `locationName:"prefix" type:"string" required:"true"`
}

// String returns the string representation
func (s HttpRouteMatch) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpRouteMatch) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HttpRouteMatch"}

	if s.Prefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("Prefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HttpRouteMatch) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "prefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing a listener for a virtual node.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/Listener
type Listener struct {
	_ struct{} `type:"structure"`

	// The health check information for the listener.
	HealthCheck *HealthCheckPolicy `locationName:"healthCheck" type:"structure"`

	// The port mapping information for the listener.
	//
	// PortMapping is a required field
	PortMapping *PortMapping `locationName:"portMapping" type:"structure" required:"true"`
}

// String returns the string representation
func (s Listener) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Listener) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Listener"}

	if s.PortMapping == nil {
		invalidParams.Add(aws.NewErrParamRequired("PortMapping"))
	}
	if s.HealthCheck != nil {
		if err := s.HealthCheck.Validate(); err != nil {
			invalidParams.AddNested("HealthCheck", err.(aws.ErrInvalidParams))
		}
	}
	if s.PortMapping != nil {
		if err := s.PortMapping.Validate(); err != nil {
			invalidParams.AddNested("PortMapping", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Listener) MarshalFields(e protocol.FieldEncoder) error {
	if s.HealthCheck != nil {
		v := s.HealthCheck

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "healthCheck", v, metadata)
	}
	if s.PortMapping != nil {
		v := s.PortMapping

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "portMapping", v, metadata)
	}
	return nil
}

// An object representing the logging information for a virtual node.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/Logging
type Logging struct {
	_ struct{} `type:"structure"`

	// The access log configuration for a virtual node.
	AccessLog *AccessLog `locationName:"accessLog" type:"structure"`
}

// String returns the string representation
func (s Logging) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Logging) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Logging"}
	if s.AccessLog != nil {
		if err := s.AccessLog.Validate(); err != nil {
			invalidParams.AddNested("AccessLog", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Logging) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessLog != nil {
		v := s.AccessLog

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accessLog", v, metadata)
	}
	return nil
}

// An object representing a service mesh returned by a describe operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/MeshData
type MeshData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The associated metadata for the service mesh.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// The associated specification for the service mesh.
	//
	// Spec is a required field
	Spec *MeshSpec `locationName:"spec" type:"structure" required:"true"`

	// The status of the service mesh.
	//
	// Status is a required field
	Status *MeshStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation
func (s MeshData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MeshData) MarshalFields(e protocol.FieldEncoder) error {
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Metadata != nil {
		v := s.Metadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "metadata", v, metadata)
	}
	if s.Spec != nil {
		v := s.Spec

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spec", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "status", v, metadata)
	}
	return nil
}

// An object representing a service mesh returned by a list operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/MeshRef
type MeshRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) of the service mesh.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the service mesh.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MeshRef) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MeshRef) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing the specification of a service mesh.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/MeshSpec
type MeshSpec struct {
	_ struct{} `type:"structure"`

	// The egress filter rules for the service mesh.
	EgressFilter *EgressFilter `locationName:"egressFilter" type:"structure"`
}

// String returns the string representation
func (s MeshSpec) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MeshSpec) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MeshSpec"}
	if s.EgressFilter != nil {
		if err := s.EgressFilter.Validate(); err != nil {
			invalidParams.AddNested("EgressFilter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MeshSpec) MarshalFields(e protocol.FieldEncoder) error {
	if s.EgressFilter != nil {
		v := s.EgressFilter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "egressFilter", v, metadata)
	}
	return nil
}

// An object representing the status of a service mesh.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/MeshStatus
type MeshStatus struct {
	_ struct{} `type:"structure"`

	// The current mesh status.
	Status MeshStatusCode `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s MeshStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MeshStatus) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object representing a virtual node or virtual router listener port mapping.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/PortMapping
type PortMapping struct {
	_ struct{} `type:"structure"`

	// The port used for the port mapping.
	//
	// Port is a required field
	Port *int64 `locationName:"port" min:"1" type:"integer" required:"true"`

	// The protocol used for the port mapping.
	//
	// Protocol is a required field
	Protocol PortProtocol `locationName:"protocol" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s PortMapping) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortMapping) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PortMapping"}

	if s.Port == nil {
		invalidParams.Add(aws.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Port", 1))
	}
	if len(s.Protocol) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Protocol"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PortMapping) MarshalFields(e protocol.FieldEncoder) error {
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "port", protocol.Int64Value(v), metadata)
	}
	if len(s.Protocol) > 0 {
		v := s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "protocol", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object representing metadata for a resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ResourceMetadata
type ResourceMetadata struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the resource.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The unique identifier for the resource.
	//
	// Uid is a required field
	Uid *string `locationName:"uid" type:"string" required:"true"`

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time that they're updated.
	//
	// Version is a required field
	Version *int64 `locationName:"version" type:"long" required:"true"`
}

// String returns the string representation
func (s ResourceMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.LastUpdatedAt != nil {
		v := *s.LastUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Uid != nil {
		v := *s.Uid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "uid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An object representing a route returned by a describe operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/RouteData
type RouteData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh that the route resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The associated metadata for the route.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// The name of the route.
	//
	// RouteName is a required field
	RouteName *string `locationName:"routeName" min:"1" type:"string" required:"true"`

	// The specifications of the route.
	//
	// Spec is a required field
	Spec *RouteSpec `locationName:"spec" type:"structure" required:"true"`

	// The status of the route.
	//
	// Status is a required field
	Status *RouteStatus `locationName:"status" type:"structure" required:"true"`

	// The virtual router that the route is associated with.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RouteData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RouteData) MarshalFields(e protocol.FieldEncoder) error {
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Metadata != nil {
		v := s.Metadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "metadata", v, metadata)
	}
	if s.RouteName != nil {
		v := *s.RouteName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "routeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Spec != nil {
		v := s.Spec

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spec", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "status", v, metadata)
	}
	if s.VirtualRouterName != nil {
		v := *s.VirtualRouterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualRouterName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing a route returned by a list operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/RouteRef
type RouteRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the route.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the service mesh that the route resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the route.
	//
	// RouteName is a required field
	RouteName *string `locationName:"routeName" min:"1" type:"string" required:"true"`

	// The virtual router that the route is associated with.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RouteRef) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RouteRef) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RouteName != nil {
		v := *s.RouteName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "routeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VirtualRouterName != nil {
		v := *s.VirtualRouterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualRouterName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing the specification of a route.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/RouteSpec
type RouteSpec struct {
	_ struct{} `type:"structure"`

	// The HTTP routing information for the route.
	HttpRoute *HttpRoute `locationName:"httpRoute" type:"structure"`

	// The TCP routing information for the route.
	TcpRoute *TcpRoute `locationName:"tcpRoute" type:"structure"`
}

// String returns the string representation
func (s RouteSpec) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RouteSpec) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RouteSpec"}
	if s.HttpRoute != nil {
		if err := s.HttpRoute.Validate(); err != nil {
			invalidParams.AddNested("HttpRoute", err.(aws.ErrInvalidParams))
		}
	}
	if s.TcpRoute != nil {
		if err := s.TcpRoute.Validate(); err != nil {
			invalidParams.AddNested("TcpRoute", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RouteSpec) MarshalFields(e protocol.FieldEncoder) error {
	if s.HttpRoute != nil {
		v := s.HttpRoute

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "httpRoute", v, metadata)
	}
	if s.TcpRoute != nil {
		v := s.TcpRoute

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "tcpRoute", v, metadata)
	}
	return nil
}

// An object representing the current status of a route.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/RouteStatus
type RouteStatus struct {
	_ struct{} `type:"structure"`

	// The current status for the route.
	//
	// Status is a required field
	Status RouteStatusCode `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s RouteStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RouteStatus) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object representing the service discovery information for a virtual node.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ServiceDiscovery
type ServiceDiscovery struct {
	_ struct{} `type:"structure"`

	// Specifies the DNS information for the virtual node.
	Dns *DnsServiceDiscovery `locationName:"dns" type:"structure"`
}

// String returns the string representation
func (s ServiceDiscovery) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceDiscovery) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServiceDiscovery"}
	if s.Dns != nil {
		if err := s.Dns.Validate(); err != nil {
			invalidParams.AddNested("Dns", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServiceDiscovery) MarshalFields(e protocol.FieldEncoder) error {
	if s.Dns != nil {
		v := s.Dns

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "dns", v, metadata)
	}
	return nil
}

// Optional metadata that you apply to a resource to assist with categorization
// and organization. Each tag consists of a key and an optional value, both
// of which you define. Tag keys can have a maximum character length of 128
// characters, and tag values can have a maximum length of 256 characters.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/TagRef
type TagRef struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that make up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The optional part of a key-value pair that make up a tag. A value acts as
	// a descriptor within a tag category (key).
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s TagRef) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagRef) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TagRef"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TagRef) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing the TCP routing specification for a route.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/TcpRoute
type TcpRoute struct {
	_ struct{} `type:"structure"`

	// The action to take if a match is determined.
	//
	// Action is a required field
	Action *TcpRouteAction `locationName:"action" type:"structure" required:"true"`
}

// String returns the string representation
func (s TcpRoute) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TcpRoute) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TcpRoute"}

	if s.Action == nil {
		invalidParams.Add(aws.NewErrParamRequired("Action"))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TcpRoute) MarshalFields(e protocol.FieldEncoder) error {
	if s.Action != nil {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "action", v, metadata)
	}
	return nil
}

// An object representing the traffic distribution requirements for matched
// TCP requests.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/TcpRouteAction
type TcpRouteAction struct {
	_ struct{} `type:"structure"`

	// The targets that traffic is routed to when a request matches the route. You
	// can specify one or more targets and their relative weights to distribute
	// traffic with.
	//
	// WeightedTargets is a required field
	WeightedTargets []WeightedTarget `locationName:"weightedTargets" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TcpRouteAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TcpRouteAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TcpRouteAction"}

	if s.WeightedTargets == nil {
		invalidParams.Add(aws.NewErrParamRequired("WeightedTargets"))
	}
	if s.WeightedTargets != nil && len(s.WeightedTargets) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WeightedTargets", 1))
	}
	if s.WeightedTargets != nil {
		for i, v := range s.WeightedTargets {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "WeightedTargets", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TcpRouteAction) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.WeightedTargets) > 0 {
		v := s.WeightedTargets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "weightedTargets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// An object representing a virtual node returned by a describe operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/VirtualNodeData
type VirtualNodeData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh that the virtual node resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The associated metadata for the virtual node.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// The specifications of the virtual node.
	//
	// Spec is a required field
	Spec *VirtualNodeSpec `locationName:"spec" type:"structure" required:"true"`

	// The current status for the virtual node.
	//
	// Status is a required field
	Status *VirtualNodeStatus `locationName:"status" type:"structure" required:"true"`

	// The name of the virtual node.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualNodeData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualNodeData) MarshalFields(e protocol.FieldEncoder) error {
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Metadata != nil {
		v := s.Metadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "metadata", v, metadata)
	}
	if s.Spec != nil {
		v := s.Spec

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spec", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "status", v, metadata)
	}
	if s.VirtualNodeName != nil {
		v := *s.VirtualNodeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualNodeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing a virtual node returned by a list operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/VirtualNodeRef
type VirtualNodeRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the virtual node.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the service mesh that the virtual node resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the virtual node.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualNodeRef) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualNodeRef) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VirtualNodeName != nil {
		v := *s.VirtualNodeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualNodeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing a virtual node service provider.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/VirtualNodeServiceProvider
type VirtualNodeServiceProvider struct {
	_ struct{} `type:"structure"`

	// The name of the virtual node that is acting as a service provider.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualNodeServiceProvider) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualNodeServiceProvider) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VirtualNodeServiceProvider"}

	if s.VirtualNodeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualNodeName"))
	}
	if s.VirtualNodeName != nil && len(*s.VirtualNodeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VirtualNodeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualNodeServiceProvider) MarshalFields(e protocol.FieldEncoder) error {
	if s.VirtualNodeName != nil {
		v := *s.VirtualNodeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualNodeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing the specification of a virtual node.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/VirtualNodeSpec
type VirtualNodeSpec struct {
	_ struct{} `type:"structure"`

	// The backends that the virtual node is expected to send outbound traffic to.
	Backends []Backend `locationName:"backends" type:"list"`

	// The listeners that the virtual node is expected to receive inbound traffic
	// from. Currently only one listener is supported per virtual node.
	Listeners []Listener `locationName:"listeners" type:"list"`

	// The inbound and outbound access logging information for the virtual node.
	Logging *Logging `locationName:"logging" type:"structure"`

	// The service discovery information for the virtual node. If your virtual node
	// does not expect ingress traffic, you can omit this parameter.
	ServiceDiscovery *ServiceDiscovery `locationName:"serviceDiscovery" type:"structure"`
}

// String returns the string representation
func (s VirtualNodeSpec) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualNodeSpec) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VirtualNodeSpec"}
	if s.Backends != nil {
		for i, v := range s.Backends {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Backends", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Listeners != nil {
		for i, v := range s.Listeners {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Listeners", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Logging != nil {
		if err := s.Logging.Validate(); err != nil {
			invalidParams.AddNested("Logging", err.(aws.ErrInvalidParams))
		}
	}
	if s.ServiceDiscovery != nil {
		if err := s.ServiceDiscovery.Validate(); err != nil {
			invalidParams.AddNested("ServiceDiscovery", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualNodeSpec) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Backends) > 0 {
		v := s.Backends

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "backends", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Listeners) > 0 {
		v := s.Listeners

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "listeners", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Logging != nil {
		v := s.Logging

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "logging", v, metadata)
	}
	if s.ServiceDiscovery != nil {
		v := s.ServiceDiscovery

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "serviceDiscovery", v, metadata)
	}
	return nil
}

// An object representing the current status of the virtual node.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/VirtualNodeStatus
type VirtualNodeStatus struct {
	_ struct{} `type:"structure"`

	// The current status of the virtual node.
	//
	// Status is a required field
	Status VirtualNodeStatusCode `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s VirtualNodeStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualNodeStatus) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object representing a virtual router returned by a describe operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/VirtualRouterData
type VirtualRouterData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh that the virtual router resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The associated metadata for the virtual router.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// The specifications of the virtual router.
	//
	// Spec is a required field
	Spec *VirtualRouterSpec `locationName:"spec" type:"structure" required:"true"`

	// The current status of the virtual router.
	//
	// Status is a required field
	Status *VirtualRouterStatus `locationName:"status" type:"structure" required:"true"`

	// The name of the virtual router.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualRouterData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualRouterData) MarshalFields(e protocol.FieldEncoder) error {
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Metadata != nil {
		v := s.Metadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "metadata", v, metadata)
	}
	if s.Spec != nil {
		v := s.Spec

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spec", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "status", v, metadata)
	}
	if s.VirtualRouterName != nil {
		v := *s.VirtualRouterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualRouterName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing a virtual router listener.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/VirtualRouterListener
type VirtualRouterListener struct {
	_ struct{} `type:"structure"`

	// An object representing a virtual node or virtual router listener port mapping.
	//
	// PortMapping is a required field
	PortMapping *PortMapping `locationName:"portMapping" type:"structure" required:"true"`
}

// String returns the string representation
func (s VirtualRouterListener) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualRouterListener) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VirtualRouterListener"}

	if s.PortMapping == nil {
		invalidParams.Add(aws.NewErrParamRequired("PortMapping"))
	}
	if s.PortMapping != nil {
		if err := s.PortMapping.Validate(); err != nil {
			invalidParams.AddNested("PortMapping", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualRouterListener) MarshalFields(e protocol.FieldEncoder) error {
	if s.PortMapping != nil {
		v := s.PortMapping

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "portMapping", v, metadata)
	}
	return nil
}

// An object representing a virtual router returned by a list operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/VirtualRouterRef
type VirtualRouterRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the virtual router.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the service mesh that the virtual router resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the virtual router.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualRouterRef) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualRouterRef) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VirtualRouterName != nil {
		v := *s.VirtualRouterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualRouterName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing a virtual node service provider.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/VirtualRouterServiceProvider
type VirtualRouterServiceProvider struct {
	_ struct{} `type:"structure"`

	// The name of the virtual router that is acting as a service provider.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualRouterServiceProvider) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualRouterServiceProvider) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VirtualRouterServiceProvider"}

	if s.VirtualRouterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualRouterServiceProvider) MarshalFields(e protocol.FieldEncoder) error {
	if s.VirtualRouterName != nil {
		v := *s.VirtualRouterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualRouterName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing the specification of a virtual router.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/VirtualRouterSpec
type VirtualRouterSpec struct {
	_ struct{} `type:"structure"`

	// The listeners that the virtual router is expected to receive inbound traffic
	// from. Currently only one listener is supported per virtual router.
	//
	// Listeners is a required field
	Listeners []VirtualRouterListener `locationName:"listeners" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s VirtualRouterSpec) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualRouterSpec) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VirtualRouterSpec"}

	if s.Listeners == nil {
		invalidParams.Add(aws.NewErrParamRequired("Listeners"))
	}
	if s.Listeners != nil && len(s.Listeners) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Listeners", 1))
	}
	if s.Listeners != nil {
		for i, v := range s.Listeners {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Listeners", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualRouterSpec) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Listeners) > 0 {
		v := s.Listeners

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "listeners", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// An object representing the status of a virtual router.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/VirtualRouterStatus
type VirtualRouterStatus struct {
	_ struct{} `type:"structure"`

	// The current status of the virtual router.
	//
	// Status is a required field
	Status VirtualRouterStatusCode `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s VirtualRouterStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualRouterStatus) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object representing a virtual service backend for a virtual node.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/VirtualServiceBackend
type VirtualServiceBackend struct {
	_ struct{} `type:"structure"`

	// The name of the virtual service that is acting as a virtual node backend.
	//
	// VirtualServiceName is a required field
	VirtualServiceName *string `locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualServiceBackend) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualServiceBackend) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VirtualServiceBackend"}

	if s.VirtualServiceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualServiceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualServiceBackend) MarshalFields(e protocol.FieldEncoder) error {
	if s.VirtualServiceName != nil {
		v := *s.VirtualServiceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualServiceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing a virtual service returned by a describe operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/VirtualServiceData
type VirtualServiceData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh that the virtual service resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// An object representing metadata for a resource.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// The specifications of the virtual service.
	//
	// Spec is a required field
	Spec *VirtualServiceSpec `locationName:"spec" type:"structure" required:"true"`

	// The current status of the virtual service.
	//
	// Status is a required field
	Status *VirtualServiceStatus `locationName:"status" type:"structure" required:"true"`

	// The name of the virtual service.
	//
	// VirtualServiceName is a required field
	VirtualServiceName *string `locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualServiceData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualServiceData) MarshalFields(e protocol.FieldEncoder) error {
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Metadata != nil {
		v := s.Metadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "metadata", v, metadata)
	}
	if s.Spec != nil {
		v := s.Spec

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spec", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "status", v, metadata)
	}
	if s.VirtualServiceName != nil {
		v := *s.VirtualServiceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualServiceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing the provider for a virtual service.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/VirtualServiceProvider
type VirtualServiceProvider struct {
	_ struct{} `type:"structure"`

	// The virtual node associated with a virtual service.
	VirtualNode *VirtualNodeServiceProvider `locationName:"virtualNode" type:"structure"`

	// The virtual router associated with a virtual service.
	VirtualRouter *VirtualRouterServiceProvider `locationName:"virtualRouter" type:"structure"`
}

// String returns the string representation
func (s VirtualServiceProvider) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualServiceProvider) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VirtualServiceProvider"}
	if s.VirtualNode != nil {
		if err := s.VirtualNode.Validate(); err != nil {
			invalidParams.AddNested("VirtualNode", err.(aws.ErrInvalidParams))
		}
	}
	if s.VirtualRouter != nil {
		if err := s.VirtualRouter.Validate(); err != nil {
			invalidParams.AddNested("VirtualRouter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualServiceProvider) MarshalFields(e protocol.FieldEncoder) error {
	if s.VirtualNode != nil {
		v := s.VirtualNode

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "virtualNode", v, metadata)
	}
	if s.VirtualRouter != nil {
		v := s.VirtualRouter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "virtualRouter", v, metadata)
	}
	return nil
}

// An object representing a virtual service returned by a list operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/VirtualServiceRef
type VirtualServiceRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the virtual service.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the service mesh that the virtual service resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the virtual service.
	//
	// VirtualServiceName is a required field
	VirtualServiceName *string `locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualServiceRef) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualServiceRef) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VirtualServiceName != nil {
		v := *s.VirtualServiceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualServiceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing the specification of a virtual service.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/VirtualServiceSpec
type VirtualServiceSpec struct {
	_ struct{} `type:"structure"`

	// The App Mesh object that is acting as the provider for a virtual service.
	// You can specify a single virtual node or virtual router.
	Provider *VirtualServiceProvider `locationName:"provider" type:"structure"`
}

// String returns the string representation
func (s VirtualServiceSpec) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualServiceSpec) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VirtualServiceSpec"}
	if s.Provider != nil {
		if err := s.Provider.Validate(); err != nil {
			invalidParams.AddNested("Provider", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualServiceSpec) MarshalFields(e protocol.FieldEncoder) error {
	if s.Provider != nil {
		v := s.Provider

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "provider", v, metadata)
	}
	return nil
}

// An object representing the status of a virtual service.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/VirtualServiceStatus
type VirtualServiceStatus struct {
	_ struct{} `type:"structure"`

	// The current status of the virtual service.
	//
	// Status is a required field
	Status VirtualServiceStatusCode `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s VirtualServiceStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualServiceStatus) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object representing a target and its relative weight. Traffic is distributed
// across targets according to their relative weight. For example, a weighted
// target with a relative weight of 50 receives five times as much traffic as
// one with a relative weight of 10.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/WeightedTarget
type WeightedTarget struct {
	_ struct{} `type:"structure"`

	// The virtual node to associate with the weighted target.
	//
	// VirtualNode is a required field
	VirtualNode *string `locationName:"virtualNode" min:"1" type:"string" required:"true"`

	// The relative weight of the weighted target.
	//
	// Weight is a required field
	Weight *int64 `locationName:"weight" type:"integer" required:"true"`
}

// String returns the string representation
func (s WeightedTarget) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WeightedTarget) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WeightedTarget"}

	if s.VirtualNode == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualNode"))
	}
	if s.VirtualNode != nil && len(*s.VirtualNode) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VirtualNode", 1))
	}

	if s.Weight == nil {
		invalidParams.Add(aws.NewErrParamRequired("Weight"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WeightedTarget) MarshalFields(e protocol.FieldEncoder) error {
	if s.VirtualNode != nil {
		v := *s.VirtualNode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualNode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Weight != nil {
		v := *s.Weight

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "weight", protocol.Int64Value(v), metadata)
	}
	return nil
}
