// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateApiMappingRequest
type CreateApiMappingInput struct {
	_ struct{} `type:"structure"`

	// The identifier.
	//
	// ApiId is a required field
	ApiId *string `locationName:"apiId" type:"string" required:"true"`

	// After evaulating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	ApiMappingKey *string `locationName:"apiMappingKey" type:"string"`

	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domainName" type:"string" required:"true"`

	// A string with a length between [1-128].
	//
	// Stage is a required field
	Stage *string `locationName:"stage" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateApiMappingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApiMappingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateApiMappingInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}

	if s.Stage == nil {
		invalidParams.Add(aws.NewErrParamRequired("Stage"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateApiMappingInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApiMappingKey != nil {
		v := *s.ApiMappingKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiMappingKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Stage != nil {
		v := *s.Stage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "domainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateApiMappingResponse
type CreateApiMappingOutput struct {
	_ struct{} `type:"structure"`

	// The identifier.
	ApiId *string `locationName:"apiId" type:"string"`

	// The identifier.
	ApiMappingId *string `locationName:"apiMappingId" type:"string"`

	// After evaulating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	ApiMappingKey *string `locationName:"apiMappingKey" type:"string"`

	// A string with a length between [1-128].
	Stage *string `locationName:"stage" type:"string"`
}

// String returns the string representation
func (s CreateApiMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateApiMappingOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApiMappingId != nil {
		v := *s.ApiMappingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiMappingId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApiMappingKey != nil {
		v := *s.ApiMappingKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiMappingKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Stage != nil {
		v := *s.Stage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateApiMapping = "CreateApiMapping"

// CreateApiMappingRequest returns a request value for making API operation for
// AmazonApiGatewayV2.
//
// Creates an API mapping.
//
//    // Example sending a request using CreateApiMappingRequest.
//    req := client.CreateApiMappingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateApiMapping
func (c *Client) CreateApiMappingRequest(input *CreateApiMappingInput) CreateApiMappingRequest {
	op := &aws.Operation{
		Name:       opCreateApiMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domainnames/{domainName}/apimappings",
	}

	if input == nil {
		input = &CreateApiMappingInput{}
	}

	req := c.newRequest(op, input, &CreateApiMappingOutput{})
	return CreateApiMappingRequest{Request: req, Input: input, Copy: c.CreateApiMappingRequest}
}

// CreateApiMappingRequest is the request type for the
// CreateApiMapping API operation.
type CreateApiMappingRequest struct {
	*aws.Request
	Input *CreateApiMappingInput
	Copy  func(*CreateApiMappingInput) CreateApiMappingRequest
}

// Send marshals and sends the CreateApiMapping API request.
func (r CreateApiMappingRequest) Send(ctx context.Context) (*CreateApiMappingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateApiMappingResponse{
		CreateApiMappingOutput: r.Request.Data.(*CreateApiMappingOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateApiMappingResponse is the response type for the
// CreateApiMapping API operation.
type CreateApiMappingResponse struct {
	*CreateApiMappingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateApiMapping request.
func (r *CreateApiMappingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
