// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Represents a delete integration response request.
type DeleteIntegrationResponseInput struct {
	_ struct{} `type:"structure"`

	// [Required] Specifies a delete integration response request's HTTP method.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// [Required] Specifies a delete integration response request's resource identifier.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// [Required] Specifies a delete integration response request's status code.
	//
	// StatusCode is a required field
	StatusCode *string `location:"uri" locationName:"status_code" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIntegrationResponseInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIntegrationResponseInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteIntegrationResponseInput"}

	if s.HttpMethod == nil {
		invalidParams.Add(aws.NewErrParamRequired("HttpMethod"))
	}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}

	if s.RestApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RestApiId"))
	}

	if s.StatusCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("StatusCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteIntegrationResponseInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.HttpMethod != nil {
		v := *s.HttpMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "http_method", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceId != nil {
		v := *s.ResourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "resource_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RestApiId != nil {
		v := *s.RestApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "restapi_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StatusCode != nil {
		v := *s.StatusCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "status_code", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteIntegrationResponseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIntegrationResponseOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteIntegrationResponseOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteIntegrationResponse = "DeleteIntegrationResponse"

// DeleteIntegrationResponseRequest returns a request value for making API operation for
// Amazon API Gateway.
//
// Represents a delete integration response.
//
//    // Example sending a request using DeleteIntegrationResponseRequest.
//    req := client.DeleteIntegrationResponseRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteIntegrationResponseRequest(input *DeleteIntegrationResponseInput) DeleteIntegrationResponseRequest {
	op := &aws.Operation{
		Name:       opDeleteIntegrationResponse,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}",
	}

	if input == nil {
		input = &DeleteIntegrationResponseInput{}
	}

	req := c.newRequest(op, input, &DeleteIntegrationResponseOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteIntegrationResponseRequest{Request: req, Input: input, Copy: c.DeleteIntegrationResponseRequest}
}

// DeleteIntegrationResponseRequest is the request type for the
// DeleteIntegrationResponse API operation.
type DeleteIntegrationResponseRequest struct {
	*aws.Request
	Input *DeleteIntegrationResponseInput
	Copy  func(*DeleteIntegrationResponseInput) DeleteIntegrationResponseRequest
}

// Send marshals and sends the DeleteIntegrationResponse API request.
func (r DeleteIntegrationResponseRequest) Send(ctx context.Context) (*DeleteIntegrationResponseResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteIntegrationResponseResponse{
		DeleteIntegrationResponseOutput: r.Request.Data.(*DeleteIntegrationResponseOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteIntegrationResponseResponse is the response type for the
// DeleteIntegrationResponse API operation.
type DeleteIntegrationResponseResponse struct {
	*DeleteIntegrationResponseOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteIntegrationResponse request.
func (r *DeleteIntegrationResponseResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
