// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewayGroupsRequest
type ListGatewayGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of gateway group summaries to return. The default is 50.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token used to paginate though multiple pages of gateway group summaries.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGatewayGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGatewayGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListGatewayGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewayGroupsResponse
type ListGatewayGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The gateway groups in the list.
	GatewayGroups []GatewayGroupSummary `type:"list"`

	// The token used to paginate though multiple pages of gateway group summaries.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGatewayGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListGatewayGroups = "ListGatewayGroups"

// ListGatewayGroupsRequest returns a request value for making API operation for
// Alexa For Business.
//
// Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve
// details of a specific gateway group.
//
//    // Example sending a request using ListGatewayGroupsRequest.
//    req := client.ListGatewayGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewayGroups
func (c *Client) ListGatewayGroupsRequest(input *ListGatewayGroupsInput) ListGatewayGroupsRequest {
	op := &aws.Operation{
		Name:       opListGatewayGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGatewayGroupsInput{}
	}

	req := c.newRequest(op, input, &ListGatewayGroupsOutput{})
	return ListGatewayGroupsRequest{Request: req, Input: input, Copy: c.ListGatewayGroupsRequest}
}

// ListGatewayGroupsRequest is the request type for the
// ListGatewayGroups API operation.
type ListGatewayGroupsRequest struct {
	*aws.Request
	Input *ListGatewayGroupsInput
	Copy  func(*ListGatewayGroupsInput) ListGatewayGroupsRequest
}

// Send marshals and sends the ListGatewayGroups API request.
func (r ListGatewayGroupsRequest) Send(ctx context.Context) (*ListGatewayGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListGatewayGroupsResponse{
		ListGatewayGroupsOutput: r.Request.Data.(*ListGatewayGroupsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListGatewayGroupsRequestPaginator returns a paginator for ListGatewayGroups.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListGatewayGroupsRequest(input)
//   p := alexaforbusiness.NewListGatewayGroupsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListGatewayGroupsPaginator(req ListGatewayGroupsRequest) ListGatewayGroupsPaginator {
	return ListGatewayGroupsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListGatewayGroupsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListGatewayGroupsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListGatewayGroupsPaginator struct {
	aws.Pager
}

func (p *ListGatewayGroupsPaginator) CurrentPage() *ListGatewayGroupsOutput {
	return p.Pager.CurrentPage().(*ListGatewayGroupsOutput)
}

// ListGatewayGroupsResponse is the response type for the
// ListGatewayGroups API operation.
type ListGatewayGroupsResponse struct {
	*ListGatewayGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListGatewayGroups request.
func (r *ListGatewayGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
