// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListBusinessReportSchedulesRequest
type ListBusinessReportSchedulesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of schedules listed in the call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token used to list the remaining schedules from the previous API call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListBusinessReportSchedulesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBusinessReportSchedulesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListBusinessReportSchedulesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListBusinessReportSchedulesResponse
type ListBusinessReportSchedulesOutput struct {
	_ struct{} `type:"structure"`

	// The schedule of the reports.
	BusinessReportSchedules []BusinessReportSchedule `type:"list"`

	// The token used to list the remaining schedules from the previous API call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListBusinessReportSchedulesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListBusinessReportSchedules = "ListBusinessReportSchedules"

// ListBusinessReportSchedulesRequest returns a request value for making API operation for
// Alexa For Business.
//
// Lists the details of the schedules that a user configured.
//
//    // Example sending a request using ListBusinessReportSchedulesRequest.
//    req := client.ListBusinessReportSchedulesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListBusinessReportSchedules
func (c *Client) ListBusinessReportSchedulesRequest(input *ListBusinessReportSchedulesInput) ListBusinessReportSchedulesRequest {
	op := &aws.Operation{
		Name:       opListBusinessReportSchedules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBusinessReportSchedulesInput{}
	}

	req := c.newRequest(op, input, &ListBusinessReportSchedulesOutput{})
	return ListBusinessReportSchedulesRequest{Request: req, Input: input, Copy: c.ListBusinessReportSchedulesRequest}
}

// ListBusinessReportSchedulesRequest is the request type for the
// ListBusinessReportSchedules API operation.
type ListBusinessReportSchedulesRequest struct {
	*aws.Request
	Input *ListBusinessReportSchedulesInput
	Copy  func(*ListBusinessReportSchedulesInput) ListBusinessReportSchedulesRequest
}

// Send marshals and sends the ListBusinessReportSchedules API request.
func (r ListBusinessReportSchedulesRequest) Send(ctx context.Context) (*ListBusinessReportSchedulesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListBusinessReportSchedulesResponse{
		ListBusinessReportSchedulesOutput: r.Request.Data.(*ListBusinessReportSchedulesOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListBusinessReportSchedulesRequestPaginator returns a paginator for ListBusinessReportSchedules.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListBusinessReportSchedulesRequest(input)
//   p := alexaforbusiness.NewListBusinessReportSchedulesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListBusinessReportSchedulesPaginator(req ListBusinessReportSchedulesRequest) ListBusinessReportSchedulesPaginator {
	return ListBusinessReportSchedulesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListBusinessReportSchedulesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListBusinessReportSchedulesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListBusinessReportSchedulesPaginator struct {
	aws.Pager
}

func (p *ListBusinessReportSchedulesPaginator) CurrentPage() *ListBusinessReportSchedulesOutput {
	return p.Pager.CurrentPage().(*ListBusinessReportSchedulesOutput)
}

// ListBusinessReportSchedulesResponse is the response type for the
// ListBusinessReportSchedules API operation.
type ListBusinessReportSchedulesResponse struct {
	*ListBusinessReportSchedulesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListBusinessReportSchedules request.
func (r *ListBusinessReportSchedulesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
