// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/apps/drive/labels/v2beta/common.proto

package labels

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	color "google.golang.org/genproto/googleapis/type/color"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The state of the object associated with this lifecycle.
type Lifecycle_State int32

const (
	// Unknown State.
	Lifecycle_STATE_UNSPECIFIED Lifecycle_State = 0
	// The initial state of an object. Once published, the object can never
	// return to this state. Once an object is published, certain kinds of
	// changes are no longer permitted.
	Lifecycle_UNPUBLISHED_DRAFT Lifecycle_State = 1
	// The object has been published. The object might have unpublished draft
	// changes as indicated by `has_unpublished_changes`.
	Lifecycle_PUBLISHED Lifecycle_State = 2
	// The object has been published and has since been disabled. The object
	// might have unpublished draft changes as indicated by
	// `has_unpublished_changes`.
	Lifecycle_DISABLED Lifecycle_State = 3
	// The object has been deleted.
	Lifecycle_DELETED Lifecycle_State = 4
)

// Enum value maps for Lifecycle_State.
var (
	Lifecycle_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "UNPUBLISHED_DRAFT",
		2: "PUBLISHED",
		3: "DISABLED",
		4: "DELETED",
	}
	Lifecycle_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"UNPUBLISHED_DRAFT": 1,
		"PUBLISHED":         2,
		"DISABLED":          3,
		"DELETED":           4,
	}
)

func (x Lifecycle_State) Enum() *Lifecycle_State {
	p := new(Lifecycle_State)
	*p = x
	return p
}

func (x Lifecycle_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Lifecycle_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_labels_v2beta_common_proto_enumTypes[0].Descriptor()
}

func (Lifecycle_State) Type() protoreflect.EnumType {
	return &file_google_apps_drive_labels_v2beta_common_proto_enumTypes[0]
}

func (x Lifecycle_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Lifecycle_State.Descriptor instead.
func (Lifecycle_State) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_common_proto_rawDescGZIP(), []int{0, 0}
}

// The lifecycle state of an object, such as label, field, or choice. The
// lifecycle enforces the following transitions:
//
// * `UNPUBLISHED_DRAFT` (starting state)
// * `UNPUBLISHED_DRAFT` -> `PUBLISHED`
// * `UNPUBLISHED_DRAFT` -> (Deleted)
// * `PUBLISHED` -> `DISABLED`
// * `DISABLED` -> `PUBLISHED`
// * `DISABLED` -> (Deleted)
//
// The published and disabled states have some distinct characteristics:
//
//   - Published—Some kinds of changes might be made to an object in this state,
//     in which case `has_unpublished_changes` will be true. Also, some kinds of
//     changes are not permitted. Generally, any change that would invalidate or
//     cause new restrictions on existing metadata related to the label are
//     rejected.
//   - Disabled—When disabled, the configured `DisabledPolicy` takes effect.
type Lifecycle struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The state of the object associated with this lifecycle.
	State Lifecycle_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.apps.drive.labels.v2beta.Lifecycle_State" json:"state,omitempty"`
	// Output only. Whether the object associated with this lifecycle has
	// unpublished changes.
	HasUnpublishedChanges bool `protobuf:"varint,2,opt,name=has_unpublished_changes,json=hasUnpublishedChanges,proto3" json:"has_unpublished_changes,omitempty"`
	// The policy that governs how to show a disabled label, field, or selection
	// choice.
	DisabledPolicy *Lifecycle_DisabledPolicy `protobuf:"bytes,3,opt,name=disabled_policy,json=disabledPolicy,proto3" json:"disabled_policy,omitempty"`
}

func (x *Lifecycle) Reset() {
	*x = Lifecycle{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Lifecycle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Lifecycle) ProtoMessage() {}

func (x *Lifecycle) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Lifecycle.ProtoReflect.Descriptor instead.
func (*Lifecycle) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_common_proto_rawDescGZIP(), []int{0}
}

func (x *Lifecycle) GetState() Lifecycle_State {
	if x != nil {
		return x.State
	}
	return Lifecycle_STATE_UNSPECIFIED
}

func (x *Lifecycle) GetHasUnpublishedChanges() bool {
	if x != nil {
		return x.HasUnpublishedChanges
	}
	return false
}

func (x *Lifecycle) GetDisabledPolicy() *Lifecycle_DisabledPolicy {
	if x != nil {
		return x.DisabledPolicy
	}
	return nil
}

// Information about a user.
type UserInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifier for this user that can be used with the People API to get
	// more information.
	// For example, people/12345678.
	Person string `protobuf:"bytes,1,opt,name=person,proto3" json:"person,omitempty"`
}

func (x *UserInfo) Reset() {
	*x = UserInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_common_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserInfo) ProtoMessage() {}

func (x *UserInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_common_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserInfo.ProtoReflect.Descriptor instead.
func (*UserInfo) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_common_proto_rawDescGZIP(), []int{1}
}

func (x *UserInfo) GetPerson() string {
	if x != nil {
		return x.Person
	}
	return ""
}

// Badge status of the label.
type BadgeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The color of the badge. When not specified, no badge is rendered.
	// The background, foreground, and solo (light and dark mode) colors set here
	// are changed in the Drive UI into the closest recommended supported color.
	Color *color.Color `protobuf:"bytes,1,opt,name=color,proto3" json:"color,omitempty"`
	// Override the default global priority of this badge.
	// When set to 0, the default priority heuristic is used.
	PriorityOverride int64 `protobuf:"varint,2,opt,name=priority_override,json=priorityOverride,proto3" json:"priority_override,omitempty"`
}

func (x *BadgeConfig) Reset() {
	*x = BadgeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_common_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BadgeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BadgeConfig) ProtoMessage() {}

func (x *BadgeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_common_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BadgeConfig.ProtoReflect.Descriptor instead.
func (*BadgeConfig) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_common_proto_rawDescGZIP(), []int{2}
}

func (x *BadgeConfig) GetColor() *color.Color {
	if x != nil {
		return x.Color
	}
	return nil
}

func (x *BadgeConfig) GetPriorityOverride() int64 {
	if x != nil {
		return x.PriorityOverride
	}
	return 0
}

// The color derived from BadgeConfig and changed to the closest recommended
// supported color.
type BadgeColors struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Badge background that pairs with the foreground.
	BackgroundColor *color.Color `protobuf:"bytes,1,opt,name=background_color,json=backgroundColor,proto3" json:"background_color,omitempty"`
	// Output only. Badge foreground that pairs with the background.
	ForegroundColor *color.Color `protobuf:"bytes,2,opt,name=foreground_color,json=foregroundColor,proto3" json:"foreground_color,omitempty"`
	// Output only. Color that can be used for text without a background.
	SoloColor *color.Color `protobuf:"bytes,3,opt,name=solo_color,json=soloColor,proto3" json:"solo_color,omitempty"`
}

func (x *BadgeColors) Reset() {
	*x = BadgeColors{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_common_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BadgeColors) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BadgeColors) ProtoMessage() {}

func (x *BadgeColors) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_common_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BadgeColors.ProtoReflect.Descriptor instead.
func (*BadgeColors) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_common_proto_rawDescGZIP(), []int{3}
}

func (x *BadgeColors) GetBackgroundColor() *color.Color {
	if x != nil {
		return x.BackgroundColor
	}
	return nil
}

func (x *BadgeColors) GetForegroundColor() *color.Color {
	if x != nil {
		return x.ForegroundColor
	}
	return nil
}

func (x *BadgeColors) GetSoloColor() *color.Color {
	if x != nil {
		return x.SoloColor
	}
	return nil
}

// Contains information about whether a label component should be considered
// locked.
type LockStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Indicates whether this label component is the (direct) target
	// of a LabelLock.  A label component can be implicitly locked even if it's
	// not the direct target of a LabelLock, in which case this field is set to
	// false.
	Locked bool `protobuf:"varint,1,opt,name=locked,proto3" json:"locked,omitempty"`
}

func (x *LockStatus) Reset() {
	*x = LockStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_common_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LockStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LockStatus) ProtoMessage() {}

func (x *LockStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_common_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LockStatus.ProtoReflect.Descriptor instead.
func (*LockStatus) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_common_proto_rawDescGZIP(), []int{4}
}

func (x *LockStatus) GetLocked() bool {
	if x != nil {
		return x.Locked
	}
	return false
}

// The policy that governs how to treat a disabled label, field, or selection
// choice in different contexts.
type Lifecycle_DisabledPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to hide this disabled object in the search menu for Drive items.
	//
	// * When `false`, the object is generally shown in the UI as disabled but
	// it appears in the search results when searching for Drive items.
	//   - When `true`, the object is generally hidden in the UI when
	//     searching for Drive items.
	HideInSearch bool `protobuf:"varint,1,opt,name=hide_in_search,json=hideInSearch,proto3" json:"hide_in_search,omitempty"`
	// Whether to show this disabled object in the apply menu on Drive items.
	//
	//   - When `true`, the object is generally shown in the UI as disabled
	//     and is unselectable.
	//   - When `false`, the object is generally hidden in the UI.
	ShowInApply bool `protobuf:"varint,2,opt,name=show_in_apply,json=showInApply,proto3" json:"show_in_apply,omitempty"`
}

func (x *Lifecycle_DisabledPolicy) Reset() {
	*x = Lifecycle_DisabledPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_common_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Lifecycle_DisabledPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Lifecycle_DisabledPolicy) ProtoMessage() {}

func (x *Lifecycle_DisabledPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_common_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Lifecycle_DisabledPolicy.ProtoReflect.Descriptor instead.
func (*Lifecycle_DisabledPolicy) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_common_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Lifecycle_DisabledPolicy) GetHideInSearch() bool {
	if x != nil {
		return x.HideInSearch
	}
	return false
}

func (x *Lifecycle_DisabledPolicy) GetShowInApply() bool {
	if x != nil {
		return x.ShowInApply
	}
	return false
}

var File_google_apps_drive_labels_v2beta_common_proto protoreflect.FileDescriptor

var file_google_apps_drive_labels_v2beta_common_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb8, 0x03, 0x0a, 0x09, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63,
	0x6c, 0x65, 0x12, 0x4c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x3c, 0x0a, 0x17, 0x68, 0x61, 0x73, 0x5f, 0x75, 0x6e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x15, 0x68, 0x61, 0x73, 0x55, 0x6e, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x62,
	0x0a, 0x0f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79,
	0x63, 0x6c, 0x65, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x1a, 0x5a, 0x0a, 0x0e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x24, 0x0a, 0x0e, 0x68, 0x69, 0x64, 0x65, 0x5f, 0x69, 0x6e, 0x5f,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x68, 0x69,
	0x64, 0x65, 0x49, 0x6e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x22, 0x0a, 0x0d, 0x73, 0x68,
	0x6f, 0x77, 0x5f, 0x69, 0x6e, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0b, 0x73, 0x68, 0x6f, 0x77, 0x49, 0x6e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x22, 0x5f,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15,
	0x0a, 0x11, 0x55, 0x4e, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x45, 0x44, 0x5f, 0x44, 0x52,
	0x41, 0x46, 0x54, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44,
	0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x04, 0x22,
	0x45, 0x0a, 0x08, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x39, 0x0a, 0x06, 0x70,
	0x65, 0x72, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xfa, 0x41, 0x1e,
	0x0a, 0x1c, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x22, 0x64, 0x0a, 0x0b, 0x42, 0x61, 0x64, 0x67, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28, 0x0a, 0x05, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x52, 0x05, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x12,
	0x2b, 0x0a, 0x11, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x70, 0x72, 0x69, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x22, 0xd0, 0x01, 0x0a,
	0x0b, 0x42, 0x61, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x12, 0x43, 0x0a, 0x10,
	0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03,
	0x52, 0x0f, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6f, 0x6c, 0x6f,
	0x72, 0x12, 0x43, 0x0a, 0x10, 0x66, 0x6f, 0x72, 0x65, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x5f,
	0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x42,
	0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x0f, 0x66, 0x6f, 0x72, 0x65, 0x67, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x37, 0x0a, 0x0a, 0x73, 0x6f, 0x6c, 0x6f, 0x5f, 0x63,
	0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x42, 0x04,
	0xe2, 0x41, 0x01, 0x03, 0x52, 0x09, 0x73, 0x6f, 0x6c, 0x6f, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x22,
	0x2a, 0x0a, 0x0a, 0x4c, 0x6f, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1c, 0x0a,
	0x06, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x04, 0xe2,
	0x41, 0x01, 0x03, 0x52, 0x06, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x42, 0xb5, 0x01, 0x0a, 0x23,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x42, 0x0b, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64,
	0x72, 0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x3b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0xa2, 0x02, 0x04, 0x44, 0x4c, 0x42, 0x4c,
	0xea, 0x41, 0x30, 0x0a, 0x1c, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x65, 0x72, 0x73, 0x6f,
	0x6e, 0x12, 0x10, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x70, 0x65, 0x72, 0x73,
	0x6f, 0x6e, 0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_apps_drive_labels_v2beta_common_proto_rawDescOnce sync.Once
	file_google_apps_drive_labels_v2beta_common_proto_rawDescData = file_google_apps_drive_labels_v2beta_common_proto_rawDesc
)

func file_google_apps_drive_labels_v2beta_common_proto_rawDescGZIP() []byte {
	file_google_apps_drive_labels_v2beta_common_proto_rawDescOnce.Do(func() {
		file_google_apps_drive_labels_v2beta_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_apps_drive_labels_v2beta_common_proto_rawDescData)
	})
	return file_google_apps_drive_labels_v2beta_common_proto_rawDescData
}

var file_google_apps_drive_labels_v2beta_common_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_apps_drive_labels_v2beta_common_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_apps_drive_labels_v2beta_common_proto_goTypes = []interface{}{
	(Lifecycle_State)(0),             // 0: google.apps.drive.labels.v2beta.Lifecycle.State
	(*Lifecycle)(nil),                // 1: google.apps.drive.labels.v2beta.Lifecycle
	(*UserInfo)(nil),                 // 2: google.apps.drive.labels.v2beta.UserInfo
	(*BadgeConfig)(nil),              // 3: google.apps.drive.labels.v2beta.BadgeConfig
	(*BadgeColors)(nil),              // 4: google.apps.drive.labels.v2beta.BadgeColors
	(*LockStatus)(nil),               // 5: google.apps.drive.labels.v2beta.LockStatus
	(*Lifecycle_DisabledPolicy)(nil), // 6: google.apps.drive.labels.v2beta.Lifecycle.DisabledPolicy
	(*color.Color)(nil),              // 7: google.type.Color
}
var file_google_apps_drive_labels_v2beta_common_proto_depIdxs = []int32{
	0, // 0: google.apps.drive.labels.v2beta.Lifecycle.state:type_name -> google.apps.drive.labels.v2beta.Lifecycle.State
	6, // 1: google.apps.drive.labels.v2beta.Lifecycle.disabled_policy:type_name -> google.apps.drive.labels.v2beta.Lifecycle.DisabledPolicy
	7, // 2: google.apps.drive.labels.v2beta.BadgeConfig.color:type_name -> google.type.Color
	7, // 3: google.apps.drive.labels.v2beta.BadgeColors.background_color:type_name -> google.type.Color
	7, // 4: google.apps.drive.labels.v2beta.BadgeColors.foreground_color:type_name -> google.type.Color
	7, // 5: google.apps.drive.labels.v2beta.BadgeColors.solo_color:type_name -> google.type.Color
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_apps_drive_labels_v2beta_common_proto_init() }
func file_google_apps_drive_labels_v2beta_common_proto_init() {
	if File_google_apps_drive_labels_v2beta_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_apps_drive_labels_v2beta_common_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Lifecycle); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_common_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_common_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BadgeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_common_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BadgeColors); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_common_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LockStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_common_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Lifecycle_DisabledPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_apps_drive_labels_v2beta_common_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_apps_drive_labels_v2beta_common_proto_goTypes,
		DependencyIndexes: file_google_apps_drive_labels_v2beta_common_proto_depIdxs,
		EnumInfos:         file_google_apps_drive_labels_v2beta_common_proto_enumTypes,
		MessageInfos:      file_google_apps_drive_labels_v2beta_common_proto_msgTypes,
	}.Build()
	File_google_apps_drive_labels_v2beta_common_proto = out.File
	file_google_apps_drive_labels_v2beta_common_proto_rawDesc = nil
	file_google_apps_drive_labels_v2beta_common_proto_goTypes = nil
	file_google_apps_drive_labels_v2beta_common_proto_depIdxs = nil
}
