// DO NOT EDIT: This file is autogenerated via the builtin command.

package schema

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 74,
					Line:   144,
				},
				File:   "schema.flux",
				Source: "package schema\n\n\n// fieldsAsCols is a special application of the pivot() function that pivots\n// on _field and _time columns to aligns fields within each input table that have the same timestamp.\n//\n// ## Examples\n// ```\n// import \"influxdata/influxdb/schema\"\n//\n// from(bucket:\"example-bucket\")\n//   |> range(start: -1h)\n//   |> filter(fn: (r) => r._measurement == \"cpu\")\n//   |> schema.fieldsAsCols()\n//   |> keep(columns: [\"_time\", \"cpu\", \"usage_idle\", \"usage_user\"])\n// ```\n//\nfieldsAsCols = (tables=<-) => tables\n    |> pivot(rowKey: [\"_time\"], columnKey: [\"_field\"], valueColumn: \"_value\")\n\n// tagValues returns a list of unique values for a given tag. The return value is always a single table with a single column, _value.\n//\n// ## Parameters\n// - `bucket` is the bucket to return unique tag values from.\n// - `tag` is the tag to return unique values from\n// - `predicate` is the predicate function that filters tag values. Defaults to (r) => true.\n// - `start` Oldest time to include in results. Defaults to -30d.\n//\n//      Relative start times are defined using negative durations. Negative durations are relative to now.\n//      Absolute start times are defined using time values.\n//\n// ## Examples\n// ```\n// import \"influxdata/influxdb/schema\"\n//\n// schema.tagValues(\n//    bucket: \"my-bucket\",\n//    tag: \"host\",\n//  )\n// ```\n//\ntagValues = (bucket, tag, predicate=(r) => true, start=-30d) => from(bucket: bucket)\n    |> range(start: start)\n    |> filter(fn: predicate)\n    |> keep(columns: [tag])\n    |> group()\n    |> distinct(column: tag)\n\n// tagKeys returns a list of tag keys for all series that match the predicate. The return value is always a single table with a single column, _value.\n//\n// ## Parameters\n// - `bucket` is the bucket to return tag keys from.\n// - `predicate` is the predicate function that filters tag keys. Defaults to (r) => true.\n// - `start` Oldest time to include in results. Defaults to -30d.\n//\n//      Relative start times are defined using negative durations. Negative durations are relative to now.\n//      Absolute start times are defined using time values.\n//\n// ## Examples\n// ```\n// import \"influxdata/influxdb/schema\"\n//\n// schema.tagKeys(bucket: \"my-bucket\")\n// ```\n//\n// The return value is always a single table with a single column \"_value\".\n//\ntagKeys = (bucket, predicate=(r) => true, start=-30d) => from(bucket: bucket)\n    |> range(start: start)\n    |> filter(fn: predicate)\n    |> keys()\n    |> keep(columns: [\"_value\"])\n    |> distinct()\n\n// measurementTagValues returns a list of tag values for a specific measurement. The return value is always a single table with a single column, _value.\n//\n// ## Parameters\n// - `bucket` is the bucket to return tag values from for a specific measurement.\n// - `measurement` is the measurement to return tag values from.\n// - `tag` is the tag to return all unique values from.\n//\n// The return value is always a single table with a single column \"_value\".\nmeasurementTagValues = (bucket, measurement, tag) => tagValues(bucket: bucket, tag: tag, predicate: (r) => r._measurement == measurement)\n\n// MeasurementTagKeys returns the list of tag keys for a specific measurement.\n//\n// ## Parameters\n// - `bucket` is the bucket to return tag keys from for a specific measurement.\n// - `measurement` is the measurement to return tag keys from.\n//\nmeasurementTagKeys = (bucket, measurement) => tagKeys(bucket: bucket, predicate: (r) => r._measurement == measurement)\n\n// fieldKeys returns field keys in a bucket. The return value is always a single table with a single column, _value.\n//\n// ## Parameters\n// - `bucket` is the bucket to list field keys from.\n// - `predicate` is the predicate function that filters field keys. Defaults to (r) => true.\n// - `start` Oldest time to include in results. Defaults to -30d.\n//\n//      Relative start times are defined using negative durations. Negative durations are relative to now.\n//      Absolute start times are defined using time values.\n//\n// ## Examples\n// ```\n// import \"influxdata/influxdb/schema\"\n//\n// schema.fieldKeys(bucket: \"my-bucket\")\n// ```\n//\n// FieldKeys is a special application of tagValues that returns field keys in a given bucket.\n//\nfieldKeys = (bucket, predicate=(r) => true, start=-30d) => tagValues(bucket: bucket, tag: \"_field\", predicate: predicate, start: start)\n\n// measurementFieldKeys returns a list of fields in a measurement.\n// The return value is always a single table with a single column, \"_value\".\n//\n// ## Parameters\n// - `bucket` is the bucket to retrieve field keys from.\n// - `measurement` is the measurement to list field keys from.\n// - `start` Oldest time to include in results. Defaults to -30d.\n//\n//      Relative start times are defined using negative durations. Negative durations are relative to now.\n//      Absolute start times are defined using time values.\n//\n// ## Examples\n// ```\n// import \"influxdata/influxdb/schema\"\n//\n// schema.measurementFieldKeys(\n//   bucket: \"telegraf\",\n//   measurement: \"cpu\",\n// )\n// ```\n//\nmeasurementFieldKeys = (bucket, measurement, start=-30d) => fieldKeys(bucket: bucket, predicate: (r) => r._measurement == measurement, start: start)\n\n// measurements returns a list of measurements in a specific bucket.\n// The return value is always a single table with a single column, _value.\n//\n// ## Parameters\n// - `bucket` is the bucket to retrieve field keys from.\n//\nmeasurements = (bucket) => tagValues(bucket: bucket, tag: \"_measurement\")",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 78,
						Line:   20,
					},
					File:   "schema.flux",
					Source: "fieldsAsCols = (tables=<-) => tables\n    |> pivot(rowKey: [\"_time\"], columnKey: [\"_field\"], valueColumn: \"_value\")",
					Start: ast.Position{
						Column: 1,
						Line:   19,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// fieldsAsCols is a special application of the pivot() function that pivots\n"}, ast.Comment{Text: "// on _field and _time columns to aligns fields within each input table that have the same timestamp.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Examples\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"influxdata/influxdb/schema\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// from(bucket:\"example-bucket\")\n"}, ast.Comment{Text: "//   |> range(start: -1h)\n"}, ast.Comment{Text: "//   |> filter(fn: (r) => r._measurement == \"cpu\")\n"}, ast.Comment{Text: "//   |> schema.fieldsAsCols()\n"}, ast.Comment{Text: "//   |> keep(columns: [\"_time\", \"cpu\", \"usage_idle\", \"usage_user\"])\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   19,
						},
						File:   "schema.flux",
						Source: "fieldsAsCols",
						Start: ast.Position{
							Column: 1,
							Line:   19,
						},
					},
				},
				Name: "fieldsAsCols",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 78,
							Line:   20,
						},
						File:   "schema.flux",
						Source: "(tables=<-) => tables\n    |> pivot(rowKey: [\"_time\"], columnKey: [\"_field\"], valueColumn: \"_value\")",
						Start: ast.Position{
							Column: 16,
							Line:   19,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   19,
								},
								File:   "schema.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 31,
									Line:   19,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 78,
								Line:   20,
							},
							File:   "schema.flux",
							Source: "tables\n    |> pivot(rowKey: [\"_time\"], columnKey: [\"_field\"], valueColumn: \"_value\")",
							Start: ast.Position{
								Column: 31,
								Line:   19,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 77,
										Line:   20,
									},
									File:   "schema.flux",
									Source: "rowKey: [\"_time\"], columnKey: [\"_field\"], valueColumn: \"_value\"",
									Start: ast.Position{
										Column: 14,
										Line:   20,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   20,
										},
										File:   "schema.flux",
										Source: "rowKey: [\"_time\"]",
										Start: ast.Position{
											Column: 14,
											Line:   20,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   20,
											},
											File:   "schema.flux",
											Source: "rowKey",
											Start: ast.Position{
												Column: 14,
												Line:   20,
											},
										},
									},
									Name: "rowKey",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   20,
											},
											File:   "schema.flux",
											Source: "[\"_time\"]",
											Start: ast.Position{
												Column: 22,
												Line:   20,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   20,
												},
												File:   "schema.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 23,
													Line:   20,
												},
											},
										},
										Value: "_time",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   20,
										},
										File:   "schema.flux",
										Source: "columnKey: [\"_field\"]",
										Start: ast.Position{
											Column: 33,
											Line:   20,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   20,
											},
											File:   "schema.flux",
											Source: "columnKey",
											Start: ast.Position{
												Column: 33,
												Line:   20,
											},
										},
									},
									Name: "columnKey",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   20,
											},
											File:   "schema.flux",
											Source: "[\"_field\"]",
											Start: ast.Position{
												Column: 44,
												Line:   20,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   20,
												},
												File:   "schema.flux",
												Source: "\"_field\"",
												Start: ast.Position{
													Column: 45,
													Line:   20,
												},
											},
										},
										Value: "_field",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   20,
										},
										File:   "schema.flux",
										Source: "valueColumn: \"_value\"",
										Start: ast.Position{
											Column: 56,
											Line:   20,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   20,
											},
											File:   "schema.flux",
											Source: "valueColumn",
											Start: ast.Position{
												Column: 56,
												Line:   20,
											},
										},
									},
									Name: "valueColumn",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   20,
											},
											File:   "schema.flux",
											Source: "\"_value\"",
											Start: ast.Position{
												Column: 69,
												Line:   20,
											},
										},
									},
									Value: "_value",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   20,
								},
								File:   "schema.flux",
								Source: "pivot(rowKey: [\"_time\"], columnKey: [\"_field\"], valueColumn: \"_value\")",
								Start: ast.Position{
									Column: 8,
									Line:   20,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   20,
									},
									File:   "schema.flux",
									Source: "pivot",
									Start: ast.Position{
										Column: 8,
										Line:   20,
									},
								},
							},
							Name: "pivot",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   19,
							},
							File:   "schema.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   19,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   19,
								},
								File:   "schema.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   19,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   19,
							},
							File:   "schema.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   19,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 29,
						Line:   48,
					},
					File:   "schema.flux",
					Source: "tagValues = (bucket, tag, predicate=(r) => true, start=-30d) => from(bucket: bucket)\n    |> range(start: start)\n    |> filter(fn: predicate)\n    |> keep(columns: [tag])\n    |> group()\n    |> distinct(column: tag)",
					Start: ast.Position{
						Column: 1,
						Line:   43,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// tagValues returns a list of unique values for a given tag. The return value is always a single table with a single column, _value.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `bucket` is the bucket to return unique tag values from.\n"}, ast.Comment{Text: "// - `tag` is the tag to return unique values from\n"}, ast.Comment{Text: "// - `predicate` is the predicate function that filters tag values. Defaults to (r) => true.\n"}, ast.Comment{Text: "// - `start` Oldest time to include in results. Defaults to -30d.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Relative start times are defined using negative durations. Negative durations are relative to now.\n"}, ast.Comment{Text: "//      Absolute start times are defined using time values.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Examples\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"influxdata/influxdb/schema\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// schema.tagValues(\n"}, ast.Comment{Text: "//    bucket: \"my-bucket\",\n"}, ast.Comment{Text: "//    tag: \"host\",\n"}, ast.Comment{Text: "//  )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   43,
						},
						File:   "schema.flux",
						Source: "tagValues",
						Start: ast.Position{
							Column: 1,
							Line:   43,
						},
					},
				},
				Name: "tagValues",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 29,
							Line:   48,
						},
						File:   "schema.flux",
						Source: "(bucket, tag, predicate=(r) => true, start=-30d) => from(bucket: bucket)\n    |> range(start: start)\n    |> filter(fn: predicate)\n    |> keep(columns: [tag])\n    |> group()\n    |> distinct(column: tag)",
						Start: ast.Position{
							Column: 13,
							Line:   43,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 84,
														Line:   43,
													},
													File:   "schema.flux",
													Source: "bucket: bucket",
													Start: ast.Position{
														Column: 70,
														Line:   43,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 84,
															Line:   43,
														},
														File:   "schema.flux",
														Source: "bucket: bucket",
														Start: ast.Position{
															Column: 70,
															Line:   43,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 76,
																Line:   43,
															},
															File:   "schema.flux",
															Source: "bucket",
															Start: ast.Position{
																Column: 70,
																Line:   43,
															},
														},
													},
													Name: "bucket",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 84,
																Line:   43,
															},
															File:   "schema.flux",
															Source: "bucket",
															Start: ast.Position{
																Column: 78,
																Line:   43,
															},
														},
													},
													Name: "bucket",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 85,
													Line:   43,
												},
												File:   "schema.flux",
												Source: "from(bucket: bucket)",
												Start: ast.Position{
													Column: 65,
													Line:   43,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   43,
													},
													File:   "schema.flux",
													Source: "from",
													Start: ast.Position{
														Column: 65,
														Line:   43,
													},
												},
											},
											Name: "from",
										},
										Lparen: nil,
										Rparen: nil,
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   44,
											},
											File:   "schema.flux",
											Source: "from(bucket: bucket)\n    |> range(start: start)",
											Start: ast.Position{
												Column: 65,
												Line:   43,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   44,
													},
													File:   "schema.flux",
													Source: "start: start",
													Start: ast.Position{
														Column: 14,
														Line:   44,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   44,
														},
														File:   "schema.flux",
														Source: "start: start",
														Start: ast.Position{
															Column: 14,
															Line:   44,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 19,
																Line:   44,
															},
															File:   "schema.flux",
															Source: "start",
															Start: ast.Position{
																Column: 14,
																Line:   44,
															},
														},
													},
													Name: "start",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   44,
															},
															File:   "schema.flux",
															Source: "start",
															Start: ast.Position{
																Column: 21,
																Line:   44,
															},
														},
													},
													Name: "start",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   44,
												},
												File:   "schema.flux",
												Source: "range(start: start)",
												Start: ast.Position{
													Column: 8,
													Line:   44,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 13,
														Line:   44,
													},
													File:   "schema.flux",
													Source: "range",
													Start: ast.Position{
														Column: 8,
														Line:   44,
													},
												},
											},
											Name: "range",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   45,
										},
										File:   "schema.flux",
										Source: "from(bucket: bucket)\n    |> range(start: start)\n    |> filter(fn: predicate)",
										Start: ast.Position{
											Column: 65,
											Line:   43,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   45,
												},
												File:   "schema.flux",
												Source: "fn: predicate",
												Start: ast.Position{
													Column: 15,
													Line:   45,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   45,
													},
													File:   "schema.flux",
													Source: "fn: predicate",
													Start: ast.Position{
														Column: 15,
														Line:   45,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   45,
														},
														File:   "schema.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 15,
															Line:   45,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   45,
														},
														File:   "schema.flux",
														Source: "predicate",
														Start: ast.Position{
															Column: 19,
															Line:   45,
														},
													},
												},
												Name: "predicate",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   45,
											},
											File:   "schema.flux",
											Source: "filter(fn: predicate)",
											Start: ast.Position{
												Column: 8,
												Line:   45,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   45,
												},
												File:   "schema.flux",
												Source: "filter",
												Start: ast.Position{
													Column: 8,
													Line:   45,
												},
											},
										},
										Name: "filter",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   46,
									},
									File:   "schema.flux",
									Source: "from(bucket: bucket)\n    |> range(start: start)\n    |> filter(fn: predicate)\n    |> keep(columns: [tag])",
									Start: ast.Position{
										Column: 65,
										Line:   43,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   46,
											},
											File:   "schema.flux",
											Source: "columns: [tag]",
											Start: ast.Position{
												Column: 13,
												Line:   46,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   46,
												},
												File:   "schema.flux",
												Source: "columns: [tag]",
												Start: ast.Position{
													Column: 13,
													Line:   46,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   46,
													},
													File:   "schema.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 13,
														Line:   46,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   46,
													},
													File:   "schema.flux",
													Source: "[tag]",
													Start: ast.Position{
														Column: 22,
														Line:   46,
													},
												},
											},
											Elements: []ast.Expression{&ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   46,
														},
														File:   "schema.flux",
														Source: "tag",
														Start: ast.Position{
															Column: 23,
															Line:   46,
														},
													},
												},
												Name: "tag",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   46,
										},
										File:   "schema.flux",
										Source: "keep(columns: [tag])",
										Start: ast.Position{
											Column: 8,
											Line:   46,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   46,
											},
											File:   "schema.flux",
											Source: "keep",
											Start: ast.Position{
												Column: 8,
												Line:   46,
											},
										},
									},
									Name: "keep",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   47,
								},
								File:   "schema.flux",
								Source: "from(bucket: bucket)\n    |> range(start: start)\n    |> filter(fn: predicate)\n    |> keep(columns: [tag])\n    |> group()",
								Start: ast.Position{
									Column: 65,
									Line:   43,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   47,
									},
									File:   "schema.flux",
									Source: "group()",
									Start: ast.Position{
										Column: 8,
										Line:   47,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   47,
										},
										File:   "schema.flux",
										Source: "group",
										Start: ast.Position{
											Column: 8,
											Line:   47,
										},
									},
								},
								Name: "group",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   48,
							},
							File:   "schema.flux",
							Source: "from(bucket: bucket)\n    |> range(start: start)\n    |> filter(fn: predicate)\n    |> keep(columns: [tag])\n    |> group()\n    |> distinct(column: tag)",
							Start: ast.Position{
								Column: 65,
								Line:   43,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   48,
									},
									File:   "schema.flux",
									Source: "column: tag",
									Start: ast.Position{
										Column: 17,
										Line:   48,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   48,
										},
										File:   "schema.flux",
										Source: "column: tag",
										Start: ast.Position{
											Column: 17,
											Line:   48,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   48,
											},
											File:   "schema.flux",
											Source: "column",
											Start: ast.Position{
												Column: 17,
												Line:   48,
											},
										},
									},
									Name: "column",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   48,
											},
											File:   "schema.flux",
											Source: "tag",
											Start: ast.Position{
												Column: 25,
												Line:   48,
											},
										},
									},
									Name: "tag",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   48,
								},
								File:   "schema.flux",
								Source: "distinct(column: tag)",
								Start: ast.Position{
									Column: 8,
									Line:   48,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   48,
									},
									File:   "schema.flux",
									Source: "distinct",
									Start: ast.Position{
										Column: 8,
										Line:   48,
									},
								},
							},
							Name: "distinct",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   43,
							},
							File:   "schema.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 14,
								Line:   43,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   43,
								},
								File:   "schema.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 14,
									Line:   43,
								},
							},
						},
						Name: "bucket",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   43,
							},
							File:   "schema.flux",
							Source: "tag",
							Start: ast.Position{
								Column: 22,
								Line:   43,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   43,
								},
								File:   "schema.flux",
								Source: "tag",
								Start: ast.Position{
									Column: 22,
									Line:   43,
								},
							},
						},
						Name: "tag",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   43,
							},
							File:   "schema.flux",
							Source: "predicate=(r) => true",
							Start: ast.Position{
								Column: 27,
								Line:   43,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   43,
								},
								File:   "schema.flux",
								Source: "predicate",
								Start: ast.Position{
									Column: 27,
									Line:   43,
								},
							},
						},
						Name: "predicate",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   43,
								},
								File:   "schema.flux",
								Source: "(r) => true",
								Start: ast.Position{
									Column: 37,
									Line:   43,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   43,
									},
									File:   "schema.flux",
									Source: "true",
									Start: ast.Position{
										Column: 44,
										Line:   43,
									},
								},
							},
							Name: "true",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   43,
									},
									File:   "schema.flux",
									Source: "r",
									Start: ast.Position{
										Column: 38,
										Line:   43,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   43,
										},
										File:   "schema.flux",
										Source: "r",
										Start: ast.Position{
											Column: 38,
											Line:   43,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 60,
								Line:   43,
							},
							File:   "schema.flux",
							Source: "start=-30d",
							Start: ast.Position{
								Column: 50,
								Line:   43,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   43,
								},
								File:   "schema.flux",
								Source: "start",
								Start: ast.Position{
									Column: 50,
									Line:   43,
								},
							},
						},
						Name: "start",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.DurationLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   43,
									},
									File:   "schema.flux",
									Source: "30d",
									Start: ast.Position{
										Column: 57,
										Line:   43,
									},
								},
							},
							Values: []ast.Duration{ast.Duration{
								Magnitude: int64(30),
								Unit:      "d",
							}},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   43,
								},
								File:   "schema.flux",
								Source: "-30d",
								Start: ast.Position{
									Column: 56,
									Line:   43,
								},
							},
						},
						Operator: 6,
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   74,
					},
					File:   "schema.flux",
					Source: "tagKeys = (bucket, predicate=(r) => true, start=-30d) => from(bucket: bucket)\n    |> range(start: start)\n    |> filter(fn: predicate)\n    |> keys()\n    |> keep(columns: [\"_value\"])\n    |> distinct()",
					Start: ast.Position{
						Column: 1,
						Line:   69,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// tagKeys returns a list of tag keys for all series that match the predicate. The return value is always a single table with a single column, _value.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `bucket` is the bucket to return tag keys from.\n"}, ast.Comment{Text: "// - `predicate` is the predicate function that filters tag keys. Defaults to (r) => true.\n"}, ast.Comment{Text: "// - `start` Oldest time to include in results. Defaults to -30d.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Relative start times are defined using negative durations. Negative durations are relative to now.\n"}, ast.Comment{Text: "//      Absolute start times are defined using time values.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Examples\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"influxdata/influxdb/schema\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// schema.tagKeys(bucket: \"my-bucket\")\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// The return value is always a single table with a single column \"_value\".\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   69,
						},
						File:   "schema.flux",
						Source: "tagKeys",
						Start: ast.Position{
							Column: 1,
							Line:   69,
						},
					},
				},
				Name: "tagKeys",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   74,
						},
						File:   "schema.flux",
						Source: "(bucket, predicate=(r) => true, start=-30d) => from(bucket: bucket)\n    |> range(start: start)\n    |> filter(fn: predicate)\n    |> keys()\n    |> keep(columns: [\"_value\"])\n    |> distinct()",
						Start: ast.Position{
							Column: 11,
							Line:   69,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 77,
														Line:   69,
													},
													File:   "schema.flux",
													Source: "bucket: bucket",
													Start: ast.Position{
														Column: 63,
														Line:   69,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   69,
														},
														File:   "schema.flux",
														Source: "bucket: bucket",
														Start: ast.Position{
															Column: 63,
															Line:   69,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   69,
															},
															File:   "schema.flux",
															Source: "bucket",
															Start: ast.Position{
																Column: 63,
																Line:   69,
															},
														},
													},
													Name: "bucket",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   69,
															},
															File:   "schema.flux",
															Source: "bucket",
															Start: ast.Position{
																Column: 71,
																Line:   69,
															},
														},
													},
													Name: "bucket",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 78,
													Line:   69,
												},
												File:   "schema.flux",
												Source: "from(bucket: bucket)",
												Start: ast.Position{
													Column: 58,
													Line:   69,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 62,
														Line:   69,
													},
													File:   "schema.flux",
													Source: "from",
													Start: ast.Position{
														Column: 58,
														Line:   69,
													},
												},
											},
											Name: "from",
										},
										Lparen: nil,
										Rparen: nil,
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   70,
											},
											File:   "schema.flux",
											Source: "from(bucket: bucket)\n    |> range(start: start)",
											Start: ast.Position{
												Column: 58,
												Line:   69,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   70,
													},
													File:   "schema.flux",
													Source: "start: start",
													Start: ast.Position{
														Column: 14,
														Line:   70,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   70,
														},
														File:   "schema.flux",
														Source: "start: start",
														Start: ast.Position{
															Column: 14,
															Line:   70,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 19,
																Line:   70,
															},
															File:   "schema.flux",
															Source: "start",
															Start: ast.Position{
																Column: 14,
																Line:   70,
															},
														},
													},
													Name: "start",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   70,
															},
															File:   "schema.flux",
															Source: "start",
															Start: ast.Position{
																Column: 21,
																Line:   70,
															},
														},
													},
													Name: "start",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   70,
												},
												File:   "schema.flux",
												Source: "range(start: start)",
												Start: ast.Position{
													Column: 8,
													Line:   70,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 13,
														Line:   70,
													},
													File:   "schema.flux",
													Source: "range",
													Start: ast.Position{
														Column: 8,
														Line:   70,
													},
												},
											},
											Name: "range",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   71,
										},
										File:   "schema.flux",
										Source: "from(bucket: bucket)\n    |> range(start: start)\n    |> filter(fn: predicate)",
										Start: ast.Position{
											Column: 58,
											Line:   69,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   71,
												},
												File:   "schema.flux",
												Source: "fn: predicate",
												Start: ast.Position{
													Column: 15,
													Line:   71,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   71,
													},
													File:   "schema.flux",
													Source: "fn: predicate",
													Start: ast.Position{
														Column: 15,
														Line:   71,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   71,
														},
														File:   "schema.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 15,
															Line:   71,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   71,
														},
														File:   "schema.flux",
														Source: "predicate",
														Start: ast.Position{
															Column: 19,
															Line:   71,
														},
													},
												},
												Name: "predicate",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   71,
											},
											File:   "schema.flux",
											Source: "filter(fn: predicate)",
											Start: ast.Position{
												Column: 8,
												Line:   71,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   71,
												},
												File:   "schema.flux",
												Source: "filter",
												Start: ast.Position{
													Column: 8,
													Line:   71,
												},
											},
										},
										Name: "filter",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   72,
									},
									File:   "schema.flux",
									Source: "from(bucket: bucket)\n    |> range(start: start)\n    |> filter(fn: predicate)\n    |> keys()",
									Start: ast.Position{
										Column: 58,
										Line:   69,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   72,
										},
										File:   "schema.flux",
										Source: "keys()",
										Start: ast.Position{
											Column: 8,
											Line:   72,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   72,
											},
											File:   "schema.flux",
											Source: "keys",
											Start: ast.Position{
												Column: 8,
												Line:   72,
											},
										},
									},
									Name: "keys",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   73,
								},
								File:   "schema.flux",
								Source: "from(bucket: bucket)\n    |> range(start: start)\n    |> filter(fn: predicate)\n    |> keys()\n    |> keep(columns: [\"_value\"])",
								Start: ast.Position{
									Column: 58,
									Line:   69,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   73,
										},
										File:   "schema.flux",
										Source: "columns: [\"_value\"]",
										Start: ast.Position{
											Column: 13,
											Line:   73,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   73,
											},
											File:   "schema.flux",
											Source: "columns: [\"_value\"]",
											Start: ast.Position{
												Column: 13,
												Line:   73,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   73,
												},
												File:   "schema.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 13,
													Line:   73,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   73,
												},
												File:   "schema.flux",
												Source: "[\"_value\"]",
												Start: ast.Position{
													Column: 22,
													Line:   73,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   73,
													},
													File:   "schema.flux",
													Source: "\"_value\"",
													Start: ast.Position{
														Column: 23,
														Line:   73,
													},
												},
											},
											Value: "_value",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   73,
									},
									File:   "schema.flux",
									Source: "keep(columns: [\"_value\"])",
									Start: ast.Position{
										Column: 8,
										Line:   73,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   73,
										},
										File:   "schema.flux",
										Source: "keep",
										Start: ast.Position{
											Column: 8,
											Line:   73,
										},
									},
								},
								Name: "keep",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   74,
							},
							File:   "schema.flux",
							Source: "from(bucket: bucket)\n    |> range(start: start)\n    |> filter(fn: predicate)\n    |> keys()\n    |> keep(columns: [\"_value\"])\n    |> distinct()",
							Start: ast.Position{
								Column: 58,
								Line:   69,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   74,
								},
								File:   "schema.flux",
								Source: "distinct()",
								Start: ast.Position{
									Column: 8,
									Line:   74,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   74,
									},
									File:   "schema.flux",
									Source: "distinct",
									Start: ast.Position{
										Column: 8,
										Line:   74,
									},
								},
							},
							Name: "distinct",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   69,
							},
							File:   "schema.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 12,
								Line:   69,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   69,
								},
								File:   "schema.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 12,
									Line:   69,
								},
							},
						},
						Name: "bucket",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 41,
								Line:   69,
							},
							File:   "schema.flux",
							Source: "predicate=(r) => true",
							Start: ast.Position{
								Column: 20,
								Line:   69,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   69,
								},
								File:   "schema.flux",
								Source: "predicate",
								Start: ast.Position{
									Column: 20,
									Line:   69,
								},
							},
						},
						Name: "predicate",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   69,
								},
								File:   "schema.flux",
								Source: "(r) => true",
								Start: ast.Position{
									Column: 30,
									Line:   69,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   69,
									},
									File:   "schema.flux",
									Source: "true",
									Start: ast.Position{
										Column: 37,
										Line:   69,
									},
								},
							},
							Name: "true",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   69,
									},
									File:   "schema.flux",
									Source: "r",
									Start: ast.Position{
										Column: 31,
										Line:   69,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   69,
										},
										File:   "schema.flux",
										Source: "r",
										Start: ast.Position{
											Column: 31,
											Line:   69,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   69,
							},
							File:   "schema.flux",
							Source: "start=-30d",
							Start: ast.Position{
								Column: 43,
								Line:   69,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   69,
								},
								File:   "schema.flux",
								Source: "start",
								Start: ast.Position{
									Column: 43,
									Line:   69,
								},
							},
						},
						Name: "start",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.DurationLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   69,
									},
									File:   "schema.flux",
									Source: "30d",
									Start: ast.Position{
										Column: 50,
										Line:   69,
									},
								},
							},
							Values: []ast.Duration{ast.Duration{
								Magnitude: int64(30),
								Unit:      "d",
							}},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   69,
								},
								File:   "schema.flux",
								Source: "-30d",
								Start: ast.Position{
									Column: 49,
									Line:   69,
								},
							},
						},
						Operator: 6,
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 138,
						Line:   84,
					},
					File:   "schema.flux",
					Source: "measurementTagValues = (bucket, measurement, tag) => tagValues(bucket: bucket, tag: tag, predicate: (r) => r._measurement == measurement)",
					Start: ast.Position{
						Column: 1,
						Line:   84,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// measurementTagValues returns a list of tag values for a specific measurement. The return value is always a single table with a single column, _value.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `bucket` is the bucket to return tag values from for a specific measurement.\n"}, ast.Comment{Text: "// - `measurement` is the measurement to return tag values from.\n"}, ast.Comment{Text: "// - `tag` is the tag to return all unique values from.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// The return value is always a single table with a single column \"_value\".\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   84,
						},
						File:   "schema.flux",
						Source: "measurementTagValues",
						Start: ast.Position{
							Column: 1,
							Line:   84,
						},
					},
				},
				Name: "measurementTagValues",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 138,
							Line:   84,
						},
						File:   "schema.flux",
						Source: "(bucket, measurement, tag) => tagValues(bucket: bucket, tag: tag, predicate: (r) => r._measurement == measurement)",
						Start: ast.Position{
							Column: 24,
							Line:   84,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 137,
									Line:   84,
								},
								File:   "schema.flux",
								Source: "bucket: bucket, tag: tag, predicate: (r) => r._measurement == measurement",
								Start: ast.Position{
									Column: 64,
									Line:   84,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   84,
									},
									File:   "schema.flux",
									Source: "bucket: bucket",
									Start: ast.Position{
										Column: 64,
										Line:   84,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   84,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 64,
											Line:   84,
										},
									},
								},
								Name: "bucket",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   84,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 72,
											Line:   84,
										},
									},
								},
								Name: "bucket",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   84,
									},
									File:   "schema.flux",
									Source: "tag: tag",
									Start: ast.Position{
										Column: 80,
										Line:   84,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 83,
											Line:   84,
										},
										File:   "schema.flux",
										Source: "tag",
										Start: ast.Position{
											Column: 80,
											Line:   84,
										},
									},
								},
								Name: "tag",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   84,
										},
										File:   "schema.flux",
										Source: "tag",
										Start: ast.Position{
											Column: 85,
											Line:   84,
										},
									},
								},
								Name: "tag",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 137,
										Line:   84,
									},
									File:   "schema.flux",
									Source: "predicate: (r) => r._measurement == measurement",
									Start: ast.Position{
										Column: 90,
										Line:   84,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 99,
											Line:   84,
										},
										File:   "schema.flux",
										Source: "predicate",
										Start: ast.Position{
											Column: 90,
											Line:   84,
										},
									},
								},
								Name: "predicate",
							},
							Separator: nil,
							Value: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 137,
											Line:   84,
										},
										File:   "schema.flux",
										Source: "(r) => r._measurement == measurement",
										Start: ast.Position{
											Column: 101,
											Line:   84,
										},
									},
								},
								Body: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 137,
												Line:   84,
											},
											File:   "schema.flux",
											Source: "r._measurement == measurement",
											Start: ast.Position{
												Column: 108,
												Line:   84,
											},
										},
									},
									Left: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 122,
													Line:   84,
												},
												File:   "schema.flux",
												Source: "r._measurement",
												Start: ast.Position{
													Column: 108,
													Line:   84,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 109,
														Line:   84,
													},
													File:   "schema.flux",
													Source: "r",
													Start: ast.Position{
														Column: 108,
														Line:   84,
													},
												},
											},
											Name: "r",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 122,
														Line:   84,
													},
													File:   "schema.flux",
													Source: "_measurement",
													Start: ast.Position{
														Column: 110,
														Line:   84,
													},
												},
											},
											Name: "_measurement",
										},
										Rbrack: nil,
									},
									Operator: 17,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 137,
													Line:   84,
												},
												File:   "schema.flux",
												Source: "measurement",
												Start: ast.Position{
													Column: 126,
													Line:   84,
												},
											},
										},
										Name: "measurement",
									},
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 103,
												Line:   84,
											},
											File:   "schema.flux",
											Source: "r",
											Start: ast.Position{
												Column: 102,
												Line:   84,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 103,
													Line:   84,
												},
												File:   "schema.flux",
												Source: "r",
												Start: ast.Position{
													Column: 102,
													Line:   84,
												},
											},
										},
										Name: "r",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 138,
								Line:   84,
							},
							File:   "schema.flux",
							Source: "tagValues(bucket: bucket, tag: tag, predicate: (r) => r._measurement == measurement)",
							Start: ast.Position{
								Column: 54,
								Line:   84,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   84,
								},
								File:   "schema.flux",
								Source: "tagValues",
								Start: ast.Position{
									Column: 54,
									Line:   84,
								},
							},
						},
						Name: "tagValues",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   84,
							},
							File:   "schema.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 25,
								Line:   84,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   84,
								},
								File:   "schema.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 25,
									Line:   84,
								},
							},
						},
						Name: "bucket",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   84,
							},
							File:   "schema.flux",
							Source: "measurement",
							Start: ast.Position{
								Column: 33,
								Line:   84,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   84,
								},
								File:   "schema.flux",
								Source: "measurement",
								Start: ast.Position{
									Column: 33,
									Line:   84,
								},
							},
						},
						Name: "measurement",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   84,
							},
							File:   "schema.flux",
							Source: "tag",
							Start: ast.Position{
								Column: 46,
								Line:   84,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   84,
								},
								File:   "schema.flux",
								Source: "tag",
								Start: ast.Position{
									Column: 46,
									Line:   84,
								},
							},
						},
						Name: "tag",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 119,
						Line:   92,
					},
					File:   "schema.flux",
					Source: "measurementTagKeys = (bucket, measurement) => tagKeys(bucket: bucket, predicate: (r) => r._measurement == measurement)",
					Start: ast.Position{
						Column: 1,
						Line:   92,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// MeasurementTagKeys returns the list of tag keys for a specific measurement.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `bucket` is the bucket to return tag keys from for a specific measurement.\n"}, ast.Comment{Text: "// - `measurement` is the measurement to return tag keys from.\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   92,
						},
						File:   "schema.flux",
						Source: "measurementTagKeys",
						Start: ast.Position{
							Column: 1,
							Line:   92,
						},
					},
				},
				Name: "measurementTagKeys",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 119,
							Line:   92,
						},
						File:   "schema.flux",
						Source: "(bucket, measurement) => tagKeys(bucket: bucket, predicate: (r) => r._measurement == measurement)",
						Start: ast.Position{
							Column: 22,
							Line:   92,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 118,
									Line:   92,
								},
								File:   "schema.flux",
								Source: "bucket: bucket, predicate: (r) => r._measurement == measurement",
								Start: ast.Position{
									Column: 55,
									Line:   92,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   92,
									},
									File:   "schema.flux",
									Source: "bucket: bucket",
									Start: ast.Position{
										Column: 55,
										Line:   92,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   92,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 55,
											Line:   92,
										},
									},
								},
								Name: "bucket",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   92,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 63,
											Line:   92,
										},
									},
								},
								Name: "bucket",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 118,
										Line:   92,
									},
									File:   "schema.flux",
									Source: "predicate: (r) => r._measurement == measurement",
									Start: ast.Position{
										Column: 71,
										Line:   92,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   92,
										},
										File:   "schema.flux",
										Source: "predicate",
										Start: ast.Position{
											Column: 71,
											Line:   92,
										},
									},
								},
								Name: "predicate",
							},
							Separator: nil,
							Value: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 118,
											Line:   92,
										},
										File:   "schema.flux",
										Source: "(r) => r._measurement == measurement",
										Start: ast.Position{
											Column: 82,
											Line:   92,
										},
									},
								},
								Body: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 118,
												Line:   92,
											},
											File:   "schema.flux",
											Source: "r._measurement == measurement",
											Start: ast.Position{
												Column: 89,
												Line:   92,
											},
										},
									},
									Left: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 103,
													Line:   92,
												},
												File:   "schema.flux",
												Source: "r._measurement",
												Start: ast.Position{
													Column: 89,
													Line:   92,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 90,
														Line:   92,
													},
													File:   "schema.flux",
													Source: "r",
													Start: ast.Position{
														Column: 89,
														Line:   92,
													},
												},
											},
											Name: "r",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 103,
														Line:   92,
													},
													File:   "schema.flux",
													Source: "_measurement",
													Start: ast.Position{
														Column: 91,
														Line:   92,
													},
												},
											},
											Name: "_measurement",
										},
										Rbrack: nil,
									},
									Operator: 17,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 118,
													Line:   92,
												},
												File:   "schema.flux",
												Source: "measurement",
												Start: ast.Position{
													Column: 107,
													Line:   92,
												},
											},
										},
										Name: "measurement",
									},
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   92,
											},
											File:   "schema.flux",
											Source: "r",
											Start: ast.Position{
												Column: 83,
												Line:   92,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 84,
													Line:   92,
												},
												File:   "schema.flux",
												Source: "r",
												Start: ast.Position{
													Column: 83,
													Line:   92,
												},
											},
										},
										Name: "r",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 119,
								Line:   92,
							},
							File:   "schema.flux",
							Source: "tagKeys(bucket: bucket, predicate: (r) => r._measurement == measurement)",
							Start: ast.Position{
								Column: 47,
								Line:   92,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   92,
								},
								File:   "schema.flux",
								Source: "tagKeys",
								Start: ast.Position{
									Column: 47,
									Line:   92,
								},
							},
						},
						Name: "tagKeys",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   92,
							},
							File:   "schema.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 23,
								Line:   92,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   92,
								},
								File:   "schema.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 23,
									Line:   92,
								},
							},
						},
						Name: "bucket",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   92,
							},
							File:   "schema.flux",
							Source: "measurement",
							Start: ast.Position{
								Column: 31,
								Line:   92,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   92,
								},
								File:   "schema.flux",
								Source: "measurement",
								Start: ast.Position{
									Column: 31,
									Line:   92,
								},
							},
						},
						Name: "measurement",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 136,
						Line:   113,
					},
					File:   "schema.flux",
					Source: "fieldKeys = (bucket, predicate=(r) => true, start=-30d) => tagValues(bucket: bucket, tag: \"_field\", predicate: predicate, start: start)",
					Start: ast.Position{
						Column: 1,
						Line:   113,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// fieldKeys returns field keys in a bucket. The return value is always a single table with a single column, _value.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `bucket` is the bucket to list field keys from.\n"}, ast.Comment{Text: "// - `predicate` is the predicate function that filters field keys. Defaults to (r) => true.\n"}, ast.Comment{Text: "// - `start` Oldest time to include in results. Defaults to -30d.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Relative start times are defined using negative durations. Negative durations are relative to now.\n"}, ast.Comment{Text: "//      Absolute start times are defined using time values.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Examples\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"influxdata/influxdb/schema\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// schema.fieldKeys(bucket: \"my-bucket\")\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// FieldKeys is a special application of tagValues that returns field keys in a given bucket.\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   113,
						},
						File:   "schema.flux",
						Source: "fieldKeys",
						Start: ast.Position{
							Column: 1,
							Line:   113,
						},
					},
				},
				Name: "fieldKeys",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 136,
							Line:   113,
						},
						File:   "schema.flux",
						Source: "(bucket, predicate=(r) => true, start=-30d) => tagValues(bucket: bucket, tag: \"_field\", predicate: predicate, start: start)",
						Start: ast.Position{
							Column: 13,
							Line:   113,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 135,
									Line:   113,
								},
								File:   "schema.flux",
								Source: "bucket: bucket, tag: \"_field\", predicate: predicate, start: start",
								Start: ast.Position{
									Column: 70,
									Line:   113,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   113,
									},
									File:   "schema.flux",
									Source: "bucket: bucket",
									Start: ast.Position{
										Column: 70,
										Line:   113,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 76,
											Line:   113,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 70,
											Line:   113,
										},
									},
								},
								Name: "bucket",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 84,
											Line:   113,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 78,
											Line:   113,
										},
									},
								},
								Name: "bucket",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   113,
									},
									File:   "schema.flux",
									Source: "tag: \"_field\"",
									Start: ast.Position{
										Column: 86,
										Line:   113,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 89,
											Line:   113,
										},
										File:   "schema.flux",
										Source: "tag",
										Start: ast.Position{
											Column: 86,
											Line:   113,
										},
									},
								},
								Name: "tag",
							},
							Separator: nil,
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 99,
											Line:   113,
										},
										File:   "schema.flux",
										Source: "\"_field\"",
										Start: ast.Position{
											Column: 91,
											Line:   113,
										},
									},
								},
								Value: "_field",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 121,
										Line:   113,
									},
									File:   "schema.flux",
									Source: "predicate: predicate",
									Start: ast.Position{
										Column: 101,
										Line:   113,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 110,
											Line:   113,
										},
										File:   "schema.flux",
										Source: "predicate",
										Start: ast.Position{
											Column: 101,
											Line:   113,
										},
									},
								},
								Name: "predicate",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 121,
											Line:   113,
										},
										File:   "schema.flux",
										Source: "predicate",
										Start: ast.Position{
											Column: 112,
											Line:   113,
										},
									},
								},
								Name: "predicate",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 135,
										Line:   113,
									},
									File:   "schema.flux",
									Source: "start: start",
									Start: ast.Position{
										Column: 123,
										Line:   113,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 128,
											Line:   113,
										},
										File:   "schema.flux",
										Source: "start",
										Start: ast.Position{
											Column: 123,
											Line:   113,
										},
									},
								},
								Name: "start",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 135,
											Line:   113,
										},
										File:   "schema.flux",
										Source: "start",
										Start: ast.Position{
											Column: 130,
											Line:   113,
										},
									},
								},
								Name: "start",
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 136,
								Line:   113,
							},
							File:   "schema.flux",
							Source: "tagValues(bucket: bucket, tag: \"_field\", predicate: predicate, start: start)",
							Start: ast.Position{
								Column: 60,
								Line:   113,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   113,
								},
								File:   "schema.flux",
								Source: "tagValues",
								Start: ast.Position{
									Column: 60,
									Line:   113,
								},
							},
						},
						Name: "tagValues",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   113,
							},
							File:   "schema.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 14,
								Line:   113,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   113,
								},
								File:   "schema.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 14,
									Line:   113,
								},
							},
						},
						Name: "bucket",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   113,
							},
							File:   "schema.flux",
							Source: "predicate=(r) => true",
							Start: ast.Position{
								Column: 22,
								Line:   113,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   113,
								},
								File:   "schema.flux",
								Source: "predicate",
								Start: ast.Position{
									Column: 22,
									Line:   113,
								},
							},
						},
						Name: "predicate",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   113,
								},
								File:   "schema.flux",
								Source: "(r) => true",
								Start: ast.Position{
									Column: 32,
									Line:   113,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   113,
									},
									File:   "schema.flux",
									Source: "true",
									Start: ast.Position{
										Column: 39,
										Line:   113,
									},
								},
							},
							Name: "true",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   113,
									},
									File:   "schema.flux",
									Source: "r",
									Start: ast.Position{
										Column: 33,
										Line:   113,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   113,
										},
										File:   "schema.flux",
										Source: "r",
										Start: ast.Position{
											Column: 33,
											Line:   113,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   113,
							},
							File:   "schema.flux",
							Source: "start=-30d",
							Start: ast.Position{
								Column: 45,
								Line:   113,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   113,
								},
								File:   "schema.flux",
								Source: "start",
								Start: ast.Position{
									Column: 45,
									Line:   113,
								},
							},
						},
						Name: "start",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.DurationLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   113,
									},
									File:   "schema.flux",
									Source: "30d",
									Start: ast.Position{
										Column: 52,
										Line:   113,
									},
								},
							},
							Values: []ast.Duration{ast.Duration{
								Magnitude: int64(30),
								Unit:      "d",
							}},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   113,
								},
								File:   "schema.flux",
								Source: "-30d",
								Start: ast.Position{
									Column: 51,
									Line:   113,
								},
							},
						},
						Operator: 6,
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 149,
						Line:   136,
					},
					File:   "schema.flux",
					Source: "measurementFieldKeys = (bucket, measurement, start=-30d) => fieldKeys(bucket: bucket, predicate: (r) => r._measurement == measurement, start: start)",
					Start: ast.Position{
						Column: 1,
						Line:   136,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// measurementFieldKeys returns a list of fields in a measurement.\n"}, ast.Comment{Text: "// The return value is always a single table with a single column, \"_value\".\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `bucket` is the bucket to retrieve field keys from.\n"}, ast.Comment{Text: "// - `measurement` is the measurement to list field keys from.\n"}, ast.Comment{Text: "// - `start` Oldest time to include in results. Defaults to -30d.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Relative start times are defined using negative durations. Negative durations are relative to now.\n"}, ast.Comment{Text: "//      Absolute start times are defined using time values.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Examples\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"influxdata/influxdb/schema\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// schema.measurementFieldKeys(\n"}, ast.Comment{Text: "//   bucket: \"telegraf\",\n"}, ast.Comment{Text: "//   measurement: \"cpu\",\n"}, ast.Comment{Text: "// )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   136,
						},
						File:   "schema.flux",
						Source: "measurementFieldKeys",
						Start: ast.Position{
							Column: 1,
							Line:   136,
						},
					},
				},
				Name: "measurementFieldKeys",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 149,
							Line:   136,
						},
						File:   "schema.flux",
						Source: "(bucket, measurement, start=-30d) => fieldKeys(bucket: bucket, predicate: (r) => r._measurement == measurement, start: start)",
						Start: ast.Position{
							Column: 24,
							Line:   136,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 148,
									Line:   136,
								},
								File:   "schema.flux",
								Source: "bucket: bucket, predicate: (r) => r._measurement == measurement, start: start",
								Start: ast.Position{
									Column: 71,
									Line:   136,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 85,
										Line:   136,
									},
									File:   "schema.flux",
									Source: "bucket: bucket",
									Start: ast.Position{
										Column: 71,
										Line:   136,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   136,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 71,
											Line:   136,
										},
									},
								},
								Name: "bucket",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   136,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 79,
											Line:   136,
										},
									},
								},
								Name: "bucket",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 134,
										Line:   136,
									},
									File:   "schema.flux",
									Source: "predicate: (r) => r._measurement == measurement",
									Start: ast.Position{
										Column: 87,
										Line:   136,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 96,
											Line:   136,
										},
										File:   "schema.flux",
										Source: "predicate",
										Start: ast.Position{
											Column: 87,
											Line:   136,
										},
									},
								},
								Name: "predicate",
							},
							Separator: nil,
							Value: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 134,
											Line:   136,
										},
										File:   "schema.flux",
										Source: "(r) => r._measurement == measurement",
										Start: ast.Position{
											Column: 98,
											Line:   136,
										},
									},
								},
								Body: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 134,
												Line:   136,
											},
											File:   "schema.flux",
											Source: "r._measurement == measurement",
											Start: ast.Position{
												Column: 105,
												Line:   136,
											},
										},
									},
									Left: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 119,
													Line:   136,
												},
												File:   "schema.flux",
												Source: "r._measurement",
												Start: ast.Position{
													Column: 105,
													Line:   136,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 106,
														Line:   136,
													},
													File:   "schema.flux",
													Source: "r",
													Start: ast.Position{
														Column: 105,
														Line:   136,
													},
												},
											},
											Name: "r",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 119,
														Line:   136,
													},
													File:   "schema.flux",
													Source: "_measurement",
													Start: ast.Position{
														Column: 107,
														Line:   136,
													},
												},
											},
											Name: "_measurement",
										},
										Rbrack: nil,
									},
									Operator: 17,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 134,
													Line:   136,
												},
												File:   "schema.flux",
												Source: "measurement",
												Start: ast.Position{
													Column: 123,
													Line:   136,
												},
											},
										},
										Name: "measurement",
									},
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 100,
												Line:   136,
											},
											File:   "schema.flux",
											Source: "r",
											Start: ast.Position{
												Column: 99,
												Line:   136,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 100,
													Line:   136,
												},
												File:   "schema.flux",
												Source: "r",
												Start: ast.Position{
													Column: 99,
													Line:   136,
												},
											},
										},
										Name: "r",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 148,
										Line:   136,
									},
									File:   "schema.flux",
									Source: "start: start",
									Start: ast.Position{
										Column: 136,
										Line:   136,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 141,
											Line:   136,
										},
										File:   "schema.flux",
										Source: "start",
										Start: ast.Position{
											Column: 136,
											Line:   136,
										},
									},
								},
								Name: "start",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 148,
											Line:   136,
										},
										File:   "schema.flux",
										Source: "start",
										Start: ast.Position{
											Column: 143,
											Line:   136,
										},
									},
								},
								Name: "start",
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 149,
								Line:   136,
							},
							File:   "schema.flux",
							Source: "fieldKeys(bucket: bucket, predicate: (r) => r._measurement == measurement, start: start)",
							Start: ast.Position{
								Column: 61,
								Line:   136,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   136,
								},
								File:   "schema.flux",
								Source: "fieldKeys",
								Start: ast.Position{
									Column: 61,
									Line:   136,
								},
							},
						},
						Name: "fieldKeys",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   136,
							},
							File:   "schema.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 25,
								Line:   136,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   136,
								},
								File:   "schema.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 25,
									Line:   136,
								},
							},
						},
						Name: "bucket",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   136,
							},
							File:   "schema.flux",
							Source: "measurement",
							Start: ast.Position{
								Column: 33,
								Line:   136,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   136,
								},
								File:   "schema.flux",
								Source: "measurement",
								Start: ast.Position{
									Column: 33,
									Line:   136,
								},
							},
						},
						Name: "measurement",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   136,
							},
							File:   "schema.flux",
							Source: "start=-30d",
							Start: ast.Position{
								Column: 46,
								Line:   136,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   136,
								},
								File:   "schema.flux",
								Source: "start",
								Start: ast.Position{
									Column: 46,
									Line:   136,
								},
							},
						},
						Name: "start",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.DurationLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   136,
									},
									File:   "schema.flux",
									Source: "30d",
									Start: ast.Position{
										Column: 53,
										Line:   136,
									},
								},
							},
							Values: []ast.Duration{ast.Duration{
								Magnitude: int64(30),
								Unit:      "d",
							}},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   136,
								},
								File:   "schema.flux",
								Source: "-30d",
								Start: ast.Position{
									Column: 52,
									Line:   136,
								},
							},
						},
						Operator: 6,
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 74,
						Line:   144,
					},
					File:   "schema.flux",
					Source: "measurements = (bucket) => tagValues(bucket: bucket, tag: \"_measurement\")",
					Start: ast.Position{
						Column: 1,
						Line:   144,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// measurements returns a list of measurements in a specific bucket.\n"}, ast.Comment{Text: "// The return value is always a single table with a single column, _value.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `bucket` is the bucket to retrieve field keys from.\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   144,
						},
						File:   "schema.flux",
						Source: "measurements",
						Start: ast.Position{
							Column: 1,
							Line:   144,
						},
					},
				},
				Name: "measurements",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 74,
							Line:   144,
						},
						File:   "schema.flux",
						Source: "(bucket) => tagValues(bucket: bucket, tag: \"_measurement\")",
						Start: ast.Position{
							Column: 16,
							Line:   144,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   144,
								},
								File:   "schema.flux",
								Source: "bucket: bucket, tag: \"_measurement\"",
								Start: ast.Position{
									Column: 38,
									Line:   144,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 52,
										Line:   144,
									},
									File:   "schema.flux",
									Source: "bucket: bucket",
									Start: ast.Position{
										Column: 38,
										Line:   144,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   144,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 38,
											Line:   144,
										},
									},
								},
								Name: "bucket",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   144,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 46,
											Line:   144,
										},
									},
								},
								Name: "bucket",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 73,
										Line:   144,
									},
									File:   "schema.flux",
									Source: "tag: \"_measurement\"",
									Start: ast.Position{
										Column: 54,
										Line:   144,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   144,
										},
										File:   "schema.flux",
										Source: "tag",
										Start: ast.Position{
											Column: 54,
											Line:   144,
										},
									},
								},
								Name: "tag",
							},
							Separator: nil,
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 73,
											Line:   144,
										},
										File:   "schema.flux",
										Source: "\"_measurement\"",
										Start: ast.Position{
											Column: 59,
											Line:   144,
										},
									},
								},
								Value: "_measurement",
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 74,
								Line:   144,
							},
							File:   "schema.flux",
							Source: "tagValues(bucket: bucket, tag: \"_measurement\")",
							Start: ast.Position{
								Column: 28,
								Line:   144,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   144,
								},
								File:   "schema.flux",
								Source: "tagValues",
								Start: ast.Position{
									Column: 28,
									Line:   144,
								},
							},
						},
						Name: "tagValues",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   144,
							},
							File:   "schema.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 17,
								Line:   144,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   144,
								},
								File:   "schema.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 17,
									Line:   144,
								},
							},
						},
						Name: "bucket",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}},
		Eof:      nil,
		Imports:  nil,
		Metadata: "parser-type=rust",
		Name:     "schema.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Package schema provides functions for exploring your InfluxDB data schema.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   2,
					},
					File:   "schema.flux",
					Source: "package schema",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   2,
						},
						File:   "schema.flux",
						Source: "schema",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "schema",
			},
		},
	}},
	Package: "schema",
	Path:    "influxdata/influxdb/schema",
}
