// DO NOT EDIT: This file is autogenerated via the builtin command.

package tickscript

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   72,
				},
				File:   "alert_test.flux",
				Source: "package tickscript_test\n\n\nimport \"testing\"\nimport \"csv\"\nimport \"contrib/bonitoo-io/tickscript\"\nimport \"influxdata/influxdb/monitor\"\nimport \"influxdata/influxdb/schema\"\n\noption now = () => 2020-11-25T14:05:30Z\n\n// overwrite as buckets are not avail in Flux tests\noption monitor.write = (tables=<-) => tables\noption monitor.log = (tables=<-) => tables\n\ninData = \"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"\noutData = \"\n#group,false,false,false,true,true,true,true,false,true,false,true,false,true,false,true\n#datatype,string,long,double,string,string,string,string,string,string,long,string,string,string,string,string\n#default,_result,,,,,,,,,,,,,,\n,result,table,KafkaMsgRate,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,details,host,id,realm\n,,0,1.819231109049999,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.819231109049999,testm,1606313103477635916,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,0,1.635878190200181,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.635878190200181,testm,1606313104541635074,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,0,1.33716449678206,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.33716449678206,testm,1606313108868317091,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,1,39.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 39.33716449678206,testm,1606313105623191313,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,1,26.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 26.33716449678206,testm,1606313106696061106,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,2,8.33716449678206,rate-check,Rate Check,warn,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: warn - 8.33716449678206,testm,1606313107768317097,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n\"\ncheck = {\n    _check_id: \"rate-check\",\n    _check_name: \"Rate Check\",\n    // tickscript?\n    _type: \"custom\",\n    tags: {},\n}\nmetric_type = \"kafka_message_in_rate\"\ntier = \"ft\"\nh_threshold = 10\nw_threshold = 5\nl_threshold = 0.002\ntickscript_alert = (table=<-) => table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n    )\n    |> drop(columns: [\"_time\"])\n\ntest _tickscript_alert = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_alert,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   10,
						},
						File:   "alert_test.flux",
						Source: "now = () => 2020-11-25T14:05:30Z",
						Start: ast.Position{
							Column: 8,
							Line:   10,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   10,
							},
							File:   "alert_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   10,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   10,
							},
							File:   "alert_test.flux",
							Source: "() => 2020-11-25T14:05:30Z",
							Start: ast.Position{
								Column: 14,
								Line:   10,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   10,
								},
								File:   "alert_test.flux",
								Source: "2020-11-25T14:05:30Z",
								Start: ast.Position{
									Column: 20,
									Line:   10,
								},
							},
						},
						Value: parser.MustParseTime("2020-11-25T14:05:30Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   10,
					},
					File:   "alert_test.flux",
					Source: "option now = () => 2020-11-25T14:05:30Z",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 45,
							Line:   13,
						},
						File:   "alert_test.flux",
						Source: "monitor.write = (tables=<-) => tables",
						Start: ast.Position{
							Column: 8,
							Line:   13,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   13,
							},
							File:   "alert_test.flux",
							Source: "(tables=<-) => tables",
							Start: ast.Position{
								Column: 24,
								Line:   13,
							},
						},
					},
					Body: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   13,
								},
								File:   "alert_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 39,
									Line:   13,
								},
							},
						},
						Name: "tables",
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   13,
								},
								File:   "alert_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 25,
									Line:   13,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   13,
									},
									File:   "alert_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   13,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   13,
								},
								File:   "alert_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 32,
									Line:   13,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   13,
							},
							File:   "alert_test.flux",
							Source: "monitor.write",
							Start: ast.Position{
								Column: 8,
								Line:   13,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   13,
								},
								File:   "alert_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   13,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   13,
								},
								File:   "alert_test.flux",
								Source: "write",
								Start: ast.Position{
									Column: 16,
									Line:   13,
								},
							},
						},
						Name: "write",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// overwrite as buckets are not avail in Flux tests\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 45,
						Line:   13,
					},
					File:   "alert_test.flux",
					Source: "option monitor.write = (tables=<-) => tables",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 43,
							Line:   14,
						},
						File:   "alert_test.flux",
						Source: "monitor.log = (tables=<-) => tables",
						Start: ast.Position{
							Column: 8,
							Line:   14,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   14,
							},
							File:   "alert_test.flux",
							Source: "(tables=<-) => tables",
							Start: ast.Position{
								Column: 22,
								Line:   14,
							},
						},
					},
					Body: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   14,
								},
								File:   "alert_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 37,
									Line:   14,
								},
							},
						},
						Name: "tables",
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   14,
								},
								File:   "alert_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 23,
									Line:   14,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   14,
									},
									File:   "alert_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 23,
										Line:   14,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   14,
								},
								File:   "alert_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 30,
									Line:   14,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   14,
							},
							File:   "alert_test.flux",
							Source: "monitor.log",
							Start: ast.Position{
								Column: 8,
								Line:   14,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   14,
								},
								File:   "alert_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   14,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   14,
								},
								File:   "alert_test.flux",
								Source: "log",
								Start: ast.Position{
									Column: 16,
									Line:   14,
								},
							},
						},
						Name: "log",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 43,
						Line:   14,
					},
					File:   "alert_test.flux",
					Source: "option monitor.log = (tables=<-) => tables",
					Start: ast.Position{
						Column: 1,
						Line:   14,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   27,
					},
					File:   "alert_test.flux",
					Source: "inData = \"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   16,
						},
						File:   "alert_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   16,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   27,
						},
						File:   "alert_test.flux",
						Source: "\"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   16,
						},
					},
				},
				Value: "\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   39,
					},
					File:   "alert_test.flux",
					Source: "outData = \"\n#group,false,false,false,true,true,true,true,false,true,false,true,false,true,false,true\n#datatype,string,long,double,string,string,string,string,string,string,long,string,string,string,string,string\n#default,_result,,,,,,,,,,,,,,\n,result,table,KafkaMsgRate,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,details,host,id,realm\n,,0,1.819231109049999,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.819231109049999,testm,1606313103477635916,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,0,1.635878190200181,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.635878190200181,testm,1606313104541635074,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,0,1.33716449678206,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.33716449678206,testm,1606313108868317091,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,1,39.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 39.33716449678206,testm,1606313105623191313,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,1,26.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 26.33716449678206,testm,1606313106696061106,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,2,8.33716449678206,rate-check,Rate Check,warn,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: warn - 8.33716449678206,testm,1606313107768317097,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   28,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   28,
						},
						File:   "alert_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   28,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   39,
						},
						File:   "alert_test.flux",
						Source: "\"\n#group,false,false,false,true,true,true,true,false,true,false,true,false,true,false,true\n#datatype,string,long,double,string,string,string,string,string,string,long,string,string,string,string,string\n#default,_result,,,,,,,,,,,,,,\n,result,table,KafkaMsgRate,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,details,host,id,realm\n,,0,1.819231109049999,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.819231109049999,testm,1606313103477635916,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,0,1.635878190200181,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.635878190200181,testm,1606313104541635074,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,0,1.33716449678206,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.33716449678206,testm,1606313108868317091,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,1,39.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 39.33716449678206,testm,1606313105623191313,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,1,26.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 26.33716449678206,testm,1606313106696061106,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,2,8.33716449678206,rate-check,Rate Check,warn,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: warn - 8.33716449678206,testm,1606313107768317097,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   28,
						},
					},
				},
				Value: "\n#group,false,false,false,true,true,true,true,false,true,false,true,false,true,false,true\n#datatype,string,long,double,string,string,string,string,string,string,long,string,string,string,string,string\n#default,_result,,,,,,,,,,,,,,\n,result,table,KafkaMsgRate,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,details,host,id,realm\n,,0,1.819231109049999,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.819231109049999,testm,1606313103477635916,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,0,1.635878190200181,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.635878190200181,testm,1606313104541635074,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,0,1.33716449678206,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.33716449678206,testm,1606313108868317091,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,1,39.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 39.33716449678206,testm,1606313105623191313,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,1,26.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 26.33716449678206,testm,1606313106696061106,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n,,2,8.33716449678206,rate-check,Rate Check,warn,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: warn - 8.33716449678206,testm,1606313107768317097,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   46,
					},
					File:   "alert_test.flux",
					Source: "check = {\n    _check_id: \"rate-check\",\n    _check_name: \"Rate Check\",\n    // tickscript?\n    _type: \"custom\",\n    tags: {},\n}",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   40,
						},
						File:   "alert_test.flux",
						Source: "check",
						Start: ast.Position{
							Column: 1,
							Line:   40,
						},
					},
				},
				Name: "check",
			},
			Init: &ast.ObjectExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   46,
						},
						File:   "alert_test.flux",
						Source: "{\n    _check_id: \"rate-check\",\n    _check_name: \"Rate Check\",\n    // tickscript?\n    _type: \"custom\",\n    tags: {},\n}",
						Start: ast.Position{
							Column: 9,
							Line:   40,
						},
					},
				},
				Lbrace: nil,
				Properties: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   41,
							},
							File:   "alert_test.flux",
							Source: "_check_id: \"rate-check\"",
							Start: ast.Position{
								Column: 5,
								Line:   41,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   41,
								},
								File:   "alert_test.flux",
								Source: "_check_id",
								Start: ast.Position{
									Column: 5,
									Line:   41,
								},
							},
						},
						Name: "_check_id",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   41,
								},
								File:   "alert_test.flux",
								Source: "\"rate-check\"",
								Start: ast.Position{
									Column: 16,
									Line:   41,
								},
							},
						},
						Value: "rate-check",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   42,
							},
							File:   "alert_test.flux",
							Source: "_check_name: \"Rate Check\"",
							Start: ast.Position{
								Column: 5,
								Line:   42,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   42,
								},
								File:   "alert_test.flux",
								Source: "_check_name",
								Start: ast.Position{
									Column: 5,
									Line:   42,
								},
							},
						},
						Name: "_check_name",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   42,
								},
								File:   "alert_test.flux",
								Source: "\"Rate Check\"",
								Start: ast.Position{
									Column: 18,
									Line:   42,
								},
							},
						},
						Value: "Rate Check",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   44,
							},
							File:   "alert_test.flux",
							Source: "_type: \"custom\"",
							Start: ast.Position{
								Column: 5,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: []ast.Comment{ast.Comment{Text: "// tickscript?\n"}},
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   44,
								},
								File:   "alert_test.flux",
								Source: "_type",
								Start: ast.Position{
									Column: 5,
									Line:   44,
								},
							},
						},
						Name: "_type",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   44,
								},
								File:   "alert_test.flux",
								Source: "\"custom\"",
								Start: ast.Position{
									Column: 12,
									Line:   44,
								},
							},
						},
						Value: "custom",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   45,
							},
							File:   "alert_test.flux",
							Source: "tags: {}",
							Start: ast.Position{
								Column: 5,
								Line:   45,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   45,
								},
								File:   "alert_test.flux",
								Source: "tags",
								Start: ast.Position{
									Column: 5,
									Line:   45,
								},
							},
						},
						Name: "tags",
					},
					Separator: nil,
					Value: &ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   45,
								},
								File:   "alert_test.flux",
								Source: "{}",
								Start: ast.Position{
									Column: 11,
									Line:   45,
								},
							},
						},
						Lbrace:     nil,
						Properties: []*ast.Property{},
						Rbrace:     nil,
						With:       nil,
					},
				}},
				Rbrace: nil,
				With:   nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 38,
						Line:   47,
					},
					File:   "alert_test.flux",
					Source: "metric_type = \"kafka_message_in_rate\"",
					Start: ast.Position{
						Column: 1,
						Line:   47,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   47,
						},
						File:   "alert_test.flux",
						Source: "metric_type",
						Start: ast.Position{
							Column: 1,
							Line:   47,
						},
					},
				},
				Name: "metric_type",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 38,
							Line:   47,
						},
						File:   "alert_test.flux",
						Source: "\"kafka_message_in_rate\"",
						Start: ast.Position{
							Column: 15,
							Line:   47,
						},
					},
				},
				Value: "kafka_message_in_rate",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   48,
					},
					File:   "alert_test.flux",
					Source: "tier = \"ft\"",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   48,
						},
						File:   "alert_test.flux",
						Source: "tier",
						Start: ast.Position{
							Column: 1,
							Line:   48,
						},
					},
				},
				Name: "tier",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   48,
						},
						File:   "alert_test.flux",
						Source: "\"ft\"",
						Start: ast.Position{
							Column: 8,
							Line:   48,
						},
					},
				},
				Value: "ft",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   49,
					},
					File:   "alert_test.flux",
					Source: "h_threshold = 10",
					Start: ast.Position{
						Column: 1,
						Line:   49,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   49,
						},
						File:   "alert_test.flux",
						Source: "h_threshold",
						Start: ast.Position{
							Column: 1,
							Line:   49,
						},
					},
				},
				Name: "h_threshold",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   49,
						},
						File:   "alert_test.flux",
						Source: "10",
						Start: ast.Position{
							Column: 15,
							Line:   49,
						},
					},
				},
				Value: int64(10),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   50,
					},
					File:   "alert_test.flux",
					Source: "w_threshold = 5",
					Start: ast.Position{
						Column: 1,
						Line:   50,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   50,
						},
						File:   "alert_test.flux",
						Source: "w_threshold",
						Start: ast.Position{
							Column: 1,
							Line:   50,
						},
					},
				},
				Name: "w_threshold",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   50,
						},
						File:   "alert_test.flux",
						Source: "5",
						Start: ast.Position{
							Column: 15,
							Line:   50,
						},
					},
				},
				Value: int64(5),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   51,
					},
					File:   "alert_test.flux",
					Source: "l_threshold = 0.002",
					Start: ast.Position{
						Column: 1,
						Line:   51,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   51,
						},
						File:   "alert_test.flux",
						Source: "l_threshold",
						Start: ast.Position{
							Column: 1,
							Line:   51,
						},
					},
				},
				Name: "l_threshold",
			},
			Init: &ast.FloatLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   51,
						},
						File:   "alert_test.flux",
						Source: "0.002",
						Start: ast.Position{
							Column: 15,
							Line:   51,
						},
					},
				},
				Value: 0.002,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   66,
					},
					File:   "alert_test.flux",
					Source: "tickscript_alert = (table=<-) => table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n    )\n    |> drop(columns: [\"_time\"])",
					Start: ast.Position{
						Column: 1,
						Line:   52,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   52,
						},
						File:   "alert_test.flux",
						Source: "tickscript_alert",
						Start: ast.Position{
							Column: 1,
							Line:   52,
						},
					},
				},
				Name: "tickscript_alert",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   66,
						},
						File:   "alert_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n    )\n    |> drop(columns: [\"_time\"])",
						Start: ast.Position{
							Column: 20,
							Line:   52,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   52,
														},
														File:   "alert_test.flux",
														Source: "table",
														Start: ast.Position{
															Column: 34,
															Line:   52,
														},
													},
												},
												Name: "table",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   53,
													},
													File:   "alert_test.flux",
													Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)",
													Start: ast.Position{
														Column: 34,
														Line:   52,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   53,
															},
															File:   "alert_test.flux",
															Source: "start: 2020-11-25T14:05:00Z",
															Start: ast.Position{
																Column: 14,
																Line:   53,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   53,
																},
																File:   "alert_test.flux",
																Source: "start: 2020-11-25T14:05:00Z",
																Start: ast.Position{
																	Column: 14,
																	Line:   53,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 19,
																		Line:   53,
																	},
																	File:   "alert_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 14,
																		Line:   53,
																	},
																},
															},
															Name: "start",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   53,
																	},
																	File:   "alert_test.flux",
																	Source: "2020-11-25T14:05:00Z",
																	Start: ast.Position{
																		Column: 21,
																		Line:   53,
																	},
																},
															},
															Value: parser.MustParseTime("2020-11-25T14:05:00Z"),
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   53,
														},
														File:   "alert_test.flux",
														Source: "range(start: 2020-11-25T14:05:00Z)",
														Start: ast.Position{
															Column: 8,
															Line:   53,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 13,
																Line:   53,
															},
															File:   "alert_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 8,
																Line:   53,
															},
														},
													},
													Name: "range",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   54,
												},
												File:   "alert_test.flux",
												Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)",
												Start: ast.Position{
													Column: 34,
													Line:   52,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   54,
														},
														File:   "alert_test.flux",
														Source: "fn: (r) => r._field == metric_type and r.realm == tier",
														Start: ast.Position{
															Column: 15,
															Line:   54,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   54,
															},
															File:   "alert_test.flux",
															Source: "fn: (r) => r._field == metric_type and r.realm == tier",
															Start: ast.Position{
																Column: 15,
																Line:   54,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 17,
																	Line:   54,
																},
																File:   "alert_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 15,
																	Line:   54,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.FunctionExpression{
														Arrow: nil,
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   54,
																},
																File:   "alert_test.flux",
																Source: "(r) => r._field == metric_type and r.realm == tier",
																Start: ast.Position{
																	Column: 19,
																	Line:   54,
																},
															},
														},
														Body: &ast.LogicalExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 69,
																		Line:   54,
																	},
																	File:   "alert_test.flux",
																	Source: "r._field == metric_type and r.realm == tier",
																	Start: ast.Position{
																		Column: 26,
																		Line:   54,
																	},
																},
															},
															Left: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   54,
																		},
																		File:   "alert_test.flux",
																		Source: "r._field == metric_type",
																		Start: ast.Position{
																			Column: 26,
																			Line:   54,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 34,
																				Line:   54,
																			},
																			File:   "alert_test.flux",
																			Source: "r._field",
																			Start: ast.Position{
																				Column: 26,
																				Line:   54,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 27,
																					Line:   54,
																				},
																				File:   "alert_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 26,
																					Line:   54,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 34,
																					Line:   54,
																				},
																				File:   "alert_test.flux",
																				Source: "_field",
																				Start: ast.Position{
																					Column: 28,
																					Line:   54,
																				},
																			},
																		},
																		Name: "_field",
																	},
																	Rbrack: nil,
																},
																Operator: 17,
																Right: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 49,
																				Line:   54,
																			},
																			File:   "alert_test.flux",
																			Source: "metric_type",
																			Start: ast.Position{
																				Column: 38,
																				Line:   54,
																			},
																		},
																	},
																	Name: "metric_type",
																},
															},
															Operator: 1,
															Right: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 69,
																			Line:   54,
																		},
																		File:   "alert_test.flux",
																		Source: "r.realm == tier",
																		Start: ast.Position{
																			Column: 54,
																			Line:   54,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 61,
																				Line:   54,
																			},
																			File:   "alert_test.flux",
																			Source: "r.realm",
																			Start: ast.Position{
																				Column: 54,
																				Line:   54,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 55,
																					Line:   54,
																				},
																				File:   "alert_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 54,
																					Line:   54,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 61,
																					Line:   54,
																				},
																				File:   "alert_test.flux",
																				Source: "realm",
																				Start: ast.Position{
																					Column: 56,
																					Line:   54,
																				},
																			},
																		},
																		Name: "realm",
																	},
																	Rbrack: nil,
																},
																Operator: 17,
																Right: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 69,
																				Line:   54,
																			},
																			File:   "alert_test.flux",
																			Source: "tier",
																			Start: ast.Position{
																				Column: 65,
																				Line:   54,
																			},
																		},
																	},
																	Name: "tier",
																},
															},
														},
														Lparen: nil,
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   54,
																	},
																	File:   "alert_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 20,
																		Line:   54,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   54,
																		},
																		File:   "alert_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 20,
																			Line:   54,
																		},
																	},
																},
																Name: "r",
															},
															Separator: nil,
															Value:     nil,
														}},
														Rparan: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   54,
													},
													File:   "alert_test.flux",
													Source: "filter(fn: (r) => r._field == metric_type and r.realm == tier)",
													Start: ast.Position{
														Column: 8,
														Line:   54,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   54,
														},
														File:   "alert_test.flux",
														Source: "filter",
														Start: ast.Position{
															Column: 8,
															Line:   54,
														},
													},
												},
												Name: "filter",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   55,
											},
											File:   "alert_test.flux",
											Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()",
											Start: ast.Position{
												Column: 34,
												Line:   52,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   55,
												},
												File:   "alert_test.flux",
												Source: "schema.fieldsAsCols()",
												Start: ast.Position{
													Column: 8,
													Line:   55,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   55,
													},
													File:   "alert_test.flux",
													Source: "schema.fieldsAsCols",
													Start: ast.Position{
														Column: 8,
														Line:   55,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   55,
														},
														File:   "alert_test.flux",
														Source: "schema",
														Start: ast.Position{
															Column: 8,
															Line:   55,
														},
													},
												},
												Name: "schema",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   55,
														},
														File:   "alert_test.flux",
														Source: "fieldsAsCols",
														Start: ast.Position{
															Column: 15,
															Line:   55,
														},
													},
												},
												Name: "fieldsAsCols",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   56,
										},
										File:   "alert_test.flux",
										Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")",
										Start: ast.Position{
											Column: 34,
											Line:   52,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   56,
												},
												File:   "alert_test.flux",
												Source: "column: metric_type, as: \"KafkaMsgRate\"",
												Start: ast.Position{
													Column: 26,
													Line:   56,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   56,
													},
													File:   "alert_test.flux",
													Source: "column: metric_type",
													Start: ast.Position{
														Column: 26,
														Line:   56,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   56,
														},
														File:   "alert_test.flux",
														Source: "column",
														Start: ast.Position{
															Column: 26,
															Line:   56,
														},
													},
												},
												Name: "column",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   56,
														},
														File:   "alert_test.flux",
														Source: "metric_type",
														Start: ast.Position{
															Column: 34,
															Line:   56,
														},
													},
												},
												Name: "metric_type",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 65,
														Line:   56,
													},
													File:   "alert_test.flux",
													Source: "as: \"KafkaMsgRate\"",
													Start: ast.Position{
														Column: 47,
														Line:   56,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   56,
														},
														File:   "alert_test.flux",
														Source: "as",
														Start: ast.Position{
															Column: 47,
															Line:   56,
														},
													},
												},
												Name: "as",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   56,
														},
														File:   "alert_test.flux",
														Source: "\"KafkaMsgRate\"",
														Start: ast.Position{
															Column: 51,
															Line:   56,
														},
													},
												},
												Value: "KafkaMsgRate",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   56,
											},
											File:   "alert_test.flux",
											Source: "tickscript.select(column: metric_type, as: \"KafkaMsgRate\")",
											Start: ast.Position{
												Column: 8,
												Line:   56,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   56,
												},
												File:   "alert_test.flux",
												Source: "tickscript.select",
												Start: ast.Position{
													Column: 8,
													Line:   56,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   56,
													},
													File:   "alert_test.flux",
													Source: "tickscript",
													Start: ast.Position{
														Column: 8,
														Line:   56,
													},
												},
											},
											Name: "tickscript",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   56,
													},
													File:   "alert_test.flux",
													Source: "select",
													Start: ast.Position{
														Column: 19,
														Line:   56,
													},
												},
											},
											Name: "select",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   57,
									},
									File:   "alert_test.flux",
									Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])",
									Start: ast.Position{
										Column: 34,
										Line:   52,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   57,
											},
											File:   "alert_test.flux",
											Source: "columns: [\"host\", \"realm\"]",
											Start: ast.Position{
												Column: 27,
												Line:   57,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   57,
												},
												File:   "alert_test.flux",
												Source: "columns: [\"host\", \"realm\"]",
												Start: ast.Position{
													Column: 27,
													Line:   57,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   57,
													},
													File:   "alert_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 27,
														Line:   57,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   57,
													},
													File:   "alert_test.flux",
													Source: "[\"host\", \"realm\"]",
													Start: ast.Position{
														Column: 36,
														Line:   57,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   57,
														},
														File:   "alert_test.flux",
														Source: "\"host\"",
														Start: ast.Position{
															Column: 37,
															Line:   57,
														},
													},
												},
												Value: "host",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   57,
														},
														File:   "alert_test.flux",
														Source: "\"realm\"",
														Start: ast.Position{
															Column: 45,
															Line:   57,
														},
													},
												},
												Value: "realm",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   57,
										},
										File:   "alert_test.flux",
										Source: "tickscript.groupBy(columns: [\"host\", \"realm\"])",
										Start: ast.Position{
											Column: 8,
											Line:   57,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   57,
											},
											File:   "alert_test.flux",
											Source: "tickscript.groupBy",
											Start: ast.Position{
												Column: 8,
												Line:   57,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   57,
												},
												File:   "alert_test.flux",
												Source: "tickscript",
												Start: ast.Position{
													Column: 8,
													Line:   57,
												},
											},
										},
										Name: "tickscript",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   57,
												},
												File:   "alert_test.flux",
												Source: "groupBy",
												Start: ast.Position{
													Column: 19,
													Line:   57,
												},
											},
										},
										Name: "groupBy",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   65,
								},
								File:   "alert_test.flux",
								Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n    )",
								Start: ast.Position{
									Column: 34,
									Line:   52,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 82,
											Line:   64,
										},
										File:   "alert_test.flux",
										Source: "check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold",
										Start: ast.Position{
											Column: 9,
											Line:   59,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   59,
											},
											File:   "alert_test.flux",
											Source: "check: check",
											Start: ast.Position{
												Column: 9,
												Line:   59,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   59,
												},
												File:   "alert_test.flux",
												Source: "check",
												Start: ast.Position{
													Column: 9,
													Line:   59,
												},
											},
										},
										Name: "check",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   59,
												},
												File:   "alert_test.flux",
												Source: "check",
												Start: ast.Position{
													Column: 16,
													Line:   59,
												},
											},
										},
										Name: "check",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 102,
												Line:   60,
											},
											File:   "alert_test.flux",
											Source: "id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\"",
											Start: ast.Position{
												Column: 9,
												Line:   60,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   60,
												},
												File:   "alert_test.flux",
												Source: "id",
												Start: ast.Position{
													Column: 9,
													Line:   60,
												},
											},
										},
										Name: "id",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 102,
													Line:   60,
												},
												File:   "alert_test.flux",
												Source: "(r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\"",
												Start: ast.Position{
													Column: 13,
													Line:   60,
												},
											},
										},
										Body: &ast.StringExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 102,
														Line:   60,
													},
													File:   "alert_test.flux",
													Source: "\"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\"",
													Start: ast.Position{
														Column: 20,
														Line:   60,
													},
												},
											},
											Parts: []ast.StringExpressionPart{&ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   60,
														},
														File:   "alert_test.flux",
														Source: "Realm: ",
														Start: ast.Position{
															Column: 21,
															Line:   60,
														},
													},
												},
												Value: "Realm: ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   60,
														},
														File:   "alert_test.flux",
														Source: "${r.realm}",
														Start: ast.Position{
															Column: 28,
															Line:   60,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   60,
															},
															File:   "alert_test.flux",
															Source: "r.realm",
															Start: ast.Position{
																Column: 30,
																Line:   60,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   60,
																},
																File:   "alert_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 30,
																	Line:   60,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   60,
																},
																File:   "alert_test.flux",
																Source: "realm",
																Start: ast.Position{
																	Column: 32,
																	Line:   60,
																},
															},
														},
														Name: "realm",
													},
													Rbrack: nil,
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 51,
															Line:   60,
														},
														File:   "alert_test.flux",
														Source: " - Hostname: ",
														Start: ast.Position{
															Column: 38,
															Line:   60,
														},
													},
												},
												Value: " - Hostname: ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   60,
														},
														File:   "alert_test.flux",
														Source: "${r.host}",
														Start: ast.Position{
															Column: 51,
															Line:   60,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 59,
																Line:   60,
															},
															File:   "alert_test.flux",
															Source: "r.host",
															Start: ast.Position{
																Column: 53,
																Line:   60,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 54,
																	Line:   60,
																},
																File:   "alert_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 53,
																	Line:   60,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 59,
																	Line:   60,
																},
																File:   "alert_test.flux",
																Source: "host",
																Start: ast.Position{
																	Column: 55,
																	Line:   60,
																},
															},
														},
														Name: "host",
													},
													Rbrack: nil,
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   60,
														},
														File:   "alert_test.flux",
														Source: " / Metric: ",
														Start: ast.Position{
															Column: 60,
															Line:   60,
														},
													},
												},
												Value: " / Metric: ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 85,
															Line:   60,
														},
														File:   "alert_test.flux",
														Source: "${metric_type}",
														Start: ast.Position{
															Column: 71,
															Line:   60,
														},
													},
												},
												Expression: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 84,
																Line:   60,
															},
															File:   "alert_test.flux",
															Source: "metric_type",
															Start: ast.Position{
																Column: 73,
																Line:   60,
															},
														},
													},
													Name: "metric_type",
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 101,
															Line:   60,
														},
														File:   "alert_test.flux",
														Source: " threshold alert",
														Start: ast.Position{
															Column: 85,
															Line:   60,
														},
													},
												},
												Value: " threshold alert",
											}},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   60,
													},
													File:   "alert_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 14,
														Line:   60,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   60,
														},
														File:   "alert_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   60,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   61,
											},
											File:   "alert_test.flux",
											Source: "message: (r) => \"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\"",
											Start: ast.Position{
												Column: 9,
												Line:   61,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   61,
												},
												File:   "alert_test.flux",
												Source: "message",
												Start: ast.Position{
													Column: 9,
													Line:   61,
												},
											},
										},
										Name: "message",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 78,
													Line:   61,
												},
												File:   "alert_test.flux",
												Source: "(r) => \"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\"",
												Start: ast.Position{
													Column: 18,
													Line:   61,
												},
											},
										},
										Body: &ast.StringExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   61,
													},
													File:   "alert_test.flux",
													Source: "\"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\"",
													Start: ast.Position{
														Column: 25,
														Line:   61,
													},
												},
											},
											Parts: []ast.StringExpressionPart{&ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   61,
														},
														File:   "alert_test.flux",
														Source: "${r.id}",
														Start: ast.Position{
															Column: 26,
															Line:   61,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 32,
																Line:   61,
															},
															File:   "alert_test.flux",
															Source: "r.id",
															Start: ast.Position{
																Column: 28,
																Line:   61,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 29,
																	Line:   61,
																},
																File:   "alert_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 28,
																	Line:   61,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 32,
																	Line:   61,
																},
																File:   "alert_test.flux",
																Source: "id",
																Start: ast.Position{
																	Column: 30,
																	Line:   61,
																},
															},
														},
														Name: "id",
													},
													Rbrack: nil,
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   61,
														},
														File:   "alert_test.flux",
														Source: ": ",
														Start: ast.Position{
															Column: 33,
															Line:   61,
														},
													},
												},
												Value: ": ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   61,
														},
														File:   "alert_test.flux",
														Source: "${r._level}",
														Start: ast.Position{
															Column: 35,
															Line:   61,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   61,
															},
															File:   "alert_test.flux",
															Source: "r._level",
															Start: ast.Position{
																Column: 37,
																Line:   61,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   61,
																},
																File:   "alert_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 37,
																	Line:   61,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   61,
																},
																File:   "alert_test.flux",
																Source: "_level",
																Start: ast.Position{
																	Column: 39,
																	Line:   61,
																},
															},
														},
														Name: "_level",
													},
													Rbrack: nil,
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   61,
														},
														File:   "alert_test.flux",
														Source: " - ",
														Start: ast.Position{
															Column: 46,
															Line:   61,
														},
													},
												},
												Value: " - ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   61,
														},
														File:   "alert_test.flux",
														Source: "${string(v: r.KafkaMsgRate)}",
														Start: ast.Position{
															Column: 49,
															Line:   61,
														},
													},
												},
												Expression: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 75,
																	Line:   61,
																},
																File:   "alert_test.flux",
																Source: "v: r.KafkaMsgRate",
																Start: ast.Position{
																	Column: 58,
																	Line:   61,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 75,
																		Line:   61,
																	},
																	File:   "alert_test.flux",
																	Source: "v: r.KafkaMsgRate",
																	Start: ast.Position{
																		Column: 58,
																		Line:   61,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 59,
																			Line:   61,
																		},
																		File:   "alert_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 58,
																			Line:   61,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 75,
																			Line:   61,
																		},
																		File:   "alert_test.flux",
																		Source: "r.KafkaMsgRate",
																		Start: ast.Position{
																			Column: 61,
																			Line:   61,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 62,
																				Line:   61,
																			},
																			File:   "alert_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 61,
																				Line:   61,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 75,
																				Line:   61,
																			},
																			File:   "alert_test.flux",
																			Source: "KafkaMsgRate",
																			Start: ast.Position{
																				Column: 63,
																				Line:   61,
																			},
																		},
																	},
																	Name: "KafkaMsgRate",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 76,
																Line:   61,
															},
															File:   "alert_test.flux",
															Source: "string(v: r.KafkaMsgRate)",
															Start: ast.Position{
																Column: 51,
																Line:   61,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 57,
																	Line:   61,
																},
																File:   "alert_test.flux",
																Source: "string",
																Start: ast.Position{
																	Column: 51,
																	Line:   61,
																},
															},
														},
														Name: "string",
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   61,
													},
													File:   "alert_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 19,
														Line:   61,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   61,
														},
														File:   "alert_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 19,
															Line:   61,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   62,
											},
											File:   "alert_test.flux",
											Source: "details: (r) => \"some detail: myrealm=${r.realm}\"",
											Start: ast.Position{
												Column: 9,
												Line:   62,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   62,
												},
												File:   "alert_test.flux",
												Source: "details",
												Start: ast.Position{
													Column: 9,
													Line:   62,
												},
											},
										},
										Name: "details",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   62,
												},
												File:   "alert_test.flux",
												Source: "(r) => \"some detail: myrealm=${r.realm}\"",
												Start: ast.Position{
													Column: 18,
													Line:   62,
												},
											},
										},
										Body: &ast.StringExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   62,
													},
													File:   "alert_test.flux",
													Source: "\"some detail: myrealm=${r.realm}\"",
													Start: ast.Position{
														Column: 25,
														Line:   62,
													},
												},
											},
											Parts: []ast.StringExpressionPart{&ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   62,
														},
														File:   "alert_test.flux",
														Source: "some detail: myrealm=",
														Start: ast.Position{
															Column: 26,
															Line:   62,
														},
													},
												},
												Value: "some detail: myrealm=",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 57,
															Line:   62,
														},
														File:   "alert_test.flux",
														Source: "${r.realm}",
														Start: ast.Position{
															Column: 47,
															Line:   62,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   62,
															},
															File:   "alert_test.flux",
															Source: "r.realm",
															Start: ast.Position{
																Column: 49,
																Line:   62,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 50,
																	Line:   62,
																},
																File:   "alert_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 49,
																	Line:   62,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   62,
																},
																File:   "alert_test.flux",
																Source: "realm",
																Start: ast.Position{
																	Column: 51,
																	Line:   62,
																},
															},
														},
														Name: "realm",
													},
													Rbrack: nil,
												},
											}},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   62,
													},
													File:   "alert_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 19,
														Line:   62,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   62,
														},
														File:   "alert_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 19,
															Line:   62,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 82,
												Line:   63,
											},
											File:   "alert_test.flux",
											Source: "crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold",
											Start: ast.Position{
												Column: 9,
												Line:   63,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   63,
												},
												File:   "alert_test.flux",
												Source: "crit",
												Start: ast.Position{
													Column: 9,
													Line:   63,
												},
											},
										},
										Name: "crit",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 82,
													Line:   63,
												},
												File:   "alert_test.flux",
												Source: "(r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold",
												Start: ast.Position{
													Column: 15,
													Line:   63,
												},
											},
										},
										Body: &ast.LogicalExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 82,
														Line:   63,
													},
													File:   "alert_test.flux",
													Source: "r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold",
													Start: ast.Position{
														Column: 22,
														Line:   63,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   63,
														},
														File:   "alert_test.flux",
														Source: "r.KafkaMsgRate > h_threshold",
														Start: ast.Position{
															Column: 22,
															Line:   63,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   63,
															},
															File:   "alert_test.flux",
															Source: "r.KafkaMsgRate",
															Start: ast.Position{
																Column: 22,
																Line:   63,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   63,
																},
																File:   "alert_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 22,
																	Line:   63,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   63,
																},
																File:   "alert_test.flux",
																Source: "KafkaMsgRate",
																Start: ast.Position{
																	Column: 24,
																	Line:   63,
																},
															},
														},
														Name: "KafkaMsgRate",
													},
													Rbrack: nil,
												},
												Operator: 10,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 50,
																Line:   63,
															},
															File:   "alert_test.flux",
															Source: "h_threshold",
															Start: ast.Position{
																Column: 39,
																Line:   63,
															},
														},
													},
													Name: "h_threshold",
												},
											},
											Operator: 2,
											Right: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   63,
														},
														File:   "alert_test.flux",
														Source: "r.KafkaMsgRate < l_threshold",
														Start: ast.Position{
															Column: 54,
															Line:   63,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   63,
															},
															File:   "alert_test.flux",
															Source: "r.KafkaMsgRate",
															Start: ast.Position{
																Column: 54,
																Line:   63,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   63,
																},
																File:   "alert_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 54,
																	Line:   63,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   63,
																},
																File:   "alert_test.flux",
																Source: "KafkaMsgRate",
																Start: ast.Position{
																	Column: 56,
																	Line:   63,
																},
															},
														},
														Name: "KafkaMsgRate",
													},
													Rbrack: nil,
												},
												Operator: 8,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 82,
																Line:   63,
															},
															File:   "alert_test.flux",
															Source: "l_threshold",
															Start: ast.Position{
																Column: 71,
																Line:   63,
															},
														},
													},
													Name: "l_threshold",
												},
											},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   63,
													},
													File:   "alert_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 16,
														Line:   63,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   63,
														},
														File:   "alert_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 16,
															Line:   63,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 82,
												Line:   64,
											},
											File:   "alert_test.flux",
											Source: "warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold",
											Start: ast.Position{
												Column: 9,
												Line:   64,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   64,
												},
												File:   "alert_test.flux",
												Source: "warn",
												Start: ast.Position{
													Column: 9,
													Line:   64,
												},
											},
										},
										Name: "warn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 82,
													Line:   64,
												},
												File:   "alert_test.flux",
												Source: "(r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold",
												Start: ast.Position{
													Column: 15,
													Line:   64,
												},
											},
										},
										Body: &ast.LogicalExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 82,
														Line:   64,
													},
													File:   "alert_test.flux",
													Source: "r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold",
													Start: ast.Position{
														Column: 22,
														Line:   64,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   64,
														},
														File:   "alert_test.flux",
														Source: "r.KafkaMsgRate > w_threshold",
														Start: ast.Position{
															Column: 22,
															Line:   64,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   64,
															},
															File:   "alert_test.flux",
															Source: "r.KafkaMsgRate",
															Start: ast.Position{
																Column: 22,
																Line:   64,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   64,
																},
																File:   "alert_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 22,
																	Line:   64,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   64,
																},
																File:   "alert_test.flux",
																Source: "KafkaMsgRate",
																Start: ast.Position{
																	Column: 24,
																	Line:   64,
																},
															},
														},
														Name: "KafkaMsgRate",
													},
													Rbrack: nil,
												},
												Operator: 10,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 50,
																Line:   64,
															},
															File:   "alert_test.flux",
															Source: "w_threshold",
															Start: ast.Position{
																Column: 39,
																Line:   64,
															},
														},
													},
													Name: "w_threshold",
												},
											},
											Operator: 2,
											Right: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   64,
														},
														File:   "alert_test.flux",
														Source: "r.KafkaMsgRate < l_threshold",
														Start: ast.Position{
															Column: 54,
															Line:   64,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   64,
															},
															File:   "alert_test.flux",
															Source: "r.KafkaMsgRate",
															Start: ast.Position{
																Column: 54,
																Line:   64,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   64,
																},
																File:   "alert_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 54,
																	Line:   64,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   64,
																},
																File:   "alert_test.flux",
																Source: "KafkaMsgRate",
																Start: ast.Position{
																	Column: 56,
																	Line:   64,
																},
															},
														},
														Name: "KafkaMsgRate",
													},
													Rbrack: nil,
												},
												Operator: 8,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 82,
																Line:   64,
															},
															File:   "alert_test.flux",
															Source: "l_threshold",
															Start: ast.Position{
																Column: 71,
																Line:   64,
															},
														},
													},
													Name: "l_threshold",
												},
											},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   64,
													},
													File:   "alert_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 16,
														Line:   64,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   64,
														},
														File:   "alert_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 16,
															Line:   64,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   65,
									},
									File:   "alert_test.flux",
									Source: "tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n    )",
									Start: ast.Position{
										Column: 8,
										Line:   58,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   58,
										},
										File:   "alert_test.flux",
										Source: "tickscript.alert",
										Start: ast.Position{
											Column: 8,
											Line:   58,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   58,
											},
											File:   "alert_test.flux",
											Source: "tickscript",
											Start: ast.Position{
												Column: 8,
												Line:   58,
											},
										},
									},
									Name: "tickscript",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   58,
											},
											File:   "alert_test.flux",
											Source: "alert",
											Start: ast.Position{
												Column: 19,
												Line:   58,
											},
										},
									},
									Name: "alert",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   66,
							},
							File:   "alert_test.flux",
							Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n    )\n    |> drop(columns: [\"_time\"])",
							Start: ast.Position{
								Column: 34,
								Line:   52,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   66,
									},
									File:   "alert_test.flux",
									Source: "columns: [\"_time\"]",
									Start: ast.Position{
										Column: 13,
										Line:   66,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   66,
										},
										File:   "alert_test.flux",
										Source: "columns: [\"_time\"]",
										Start: ast.Position{
											Column: 13,
											Line:   66,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   66,
											},
											File:   "alert_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   66,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   66,
											},
											File:   "alert_test.flux",
											Source: "[\"_time\"]",
											Start: ast.Position{
												Column: 22,
												Line:   66,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   66,
												},
												File:   "alert_test.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 23,
													Line:   66,
												},
											},
										},
										Value: "_time",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   66,
								},
								File:   "alert_test.flux",
								Source: "drop(columns: [\"_time\"])",
								Start: ast.Position{
									Column: 8,
									Line:   66,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   66,
									},
									File:   "alert_test.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 8,
										Line:   66,
									},
								},
							},
							Name: "drop",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   52,
							},
							File:   "alert_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   52,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   52,
								},
								File:   "alert_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   52,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   52,
							},
							File:   "alert_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   52,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   72,
						},
						File:   "alert_test.flux",
						Source: "_tickscript_alert = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_alert,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   68,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   68,
							},
							File:   "alert_test.flux",
							Source: "_tickscript_alert",
							Start: ast.Position{
								Column: 6,
								Line:   68,
							},
						},
					},
					Name: "_tickscript_alert",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   72,
							},
							File:   "alert_test.flux",
							Source: "() => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_alert,\n})",
							Start: ast.Position{
								Column: 26,
								Line:   68,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   72,
								},
								File:   "alert_test.flux",
								Source: "({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_alert,\n})",
								Start: ast.Position{
									Column: 32,
									Line:   68,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   72,
									},
									File:   "alert_test.flux",
									Source: "{\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_alert,\n}",
									Start: ast.Position{
										Column: 33,
										Line:   68,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   69,
										},
										File:   "alert_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 5,
											Line:   69,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   69,
											},
											File:   "alert_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 5,
												Line:   69,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   69,
												},
												File:   "alert_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 32,
													Line:   69,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   69,
													},
													File:   "alert_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 32,
														Line:   69,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   69,
														},
														File:   "alert_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 32,
															Line:   69,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   69,
														},
														File:   "alert_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 37,
															Line:   69,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   69,
											},
											File:   "alert_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 12,
												Line:   69,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   69,
												},
												File:   "alert_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 12,
													Line:   69,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   69,
													},
													File:   "alert_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 12,
														Line:   69,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   69,
													},
													File:   "alert_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 20,
														Line:   69,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   70,
										},
										File:   "alert_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 5,
											Line:   70,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   70,
											},
											File:   "alert_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 5,
												Line:   70,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   70,
												},
												File:   "alert_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 27,
													Line:   70,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   70,
													},
													File:   "alert_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 27,
														Line:   70,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   70,
														},
														File:   "alert_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   70,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   70,
														},
														File:   "alert_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 32,
															Line:   70,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   70,
											},
											File:   "alert_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 11,
												Line:   70,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   70,
												},
												File:   "alert_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   70,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   70,
													},
													File:   "alert_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   70,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   70,
													},
													File:   "alert_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   70,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   71,
										},
										File:   "alert_test.flux",
										Source: "fn: tickscript_alert",
										Start: ast.Position{
											Column: 5,
											Line:   71,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   71,
											},
											File:   "alert_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 5,
												Line:   71,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   71,
											},
											File:   "alert_test.flux",
											Source: "tickscript_alert",
											Start: ast.Position{
												Column: 9,
												Line:   71,
											},
										},
									},
									Name: "tickscript_alert",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   72,
					},
					File:   "alert_test.flux",
					Source: "test _tickscript_alert = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_alert,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   68,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "alert_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "alert_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   5,
					},
					File:   "alert_test.flux",
					Source: "import \"csv\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   5,
						},
						File:   "alert_test.flux",
						Source: "\"csv\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "csv",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 39,
						Line:   6,
					},
					File:   "alert_test.flux",
					Source: "import \"contrib/bonitoo-io/tickscript\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 39,
							Line:   6,
						},
						File:   "alert_test.flux",
						Source: "\"contrib/bonitoo-io/tickscript\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "contrib/bonitoo-io/tickscript",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   7,
					},
					File:   "alert_test.flux",
					Source: "import \"influxdata/influxdb/monitor\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   7,
						},
						File:   "alert_test.flux",
						Source: "\"influxdata/influxdb/monitor\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "influxdata/influxdb/monitor",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 36,
						Line:   8,
					},
					File:   "alert_test.flux",
					Source: "import \"influxdata/influxdb/schema\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   8,
						},
						File:   "alert_test.flux",
						Source: "\"influxdata/influxdb/schema\"",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				Value: "influxdata/influxdb/schema",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "alert_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   1,
					},
					File:   "alert_test.flux",
					Source: "package tickscript_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   1,
						},
						File:   "alert_test.flux",
						Source: "tickscript_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "tickscript_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   73,
				},
				File:   "alert_with_topic_test.flux",
				Source: "package tickscript_test\n\n\nimport \"testing\"\nimport \"csv\"\nimport \"contrib/bonitoo-io/tickscript\"\nimport \"influxdata/influxdb/monitor\"\nimport \"influxdata/influxdb/schema\"\n\noption now = () => 2020-11-25T14:05:30Z\n\n// overwrite as buckets are not avail in Flux tests\noption monitor.write = (tables=<-) => tables\noption monitor.log = (tables=<-) => tables\n\ninData = \"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"\noutData = \"\n#group,false,false,false,true,true,true,true,false,true,false,true,false,true,false,true,true\n#datatype,string,long,double,string,string,string,string,string,string,long,string,string,string,string,string,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,KafkaMsgRate,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,details,host,id,realm,_topic\n,,0,1.819231109049999,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.819231109049999,testm,1606313103477635916,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,0,1.635878190200181,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.635878190200181,testm,1606313104541635074,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,0,1.33716449678206,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.33716449678206,testm,1606313108868317091,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,1,39.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 39.33716449678206,testm,1606313105623191313,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,1,26.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 26.33716449678206,testm,1606313106696061106,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,2,8.33716449678206,rate-check,Rate Check,warn,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: warn - 8.33716449678206,testm,1606313107768317097,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n\"\ncheck = {\n    _check_id: \"rate-check\",\n    _check_name: \"Rate Check\",\n    // tickscript?\n    _type: \"custom\",\n    tags: {},\n}\nmetric_type = \"kafka_message_in_rate\"\ntier = \"ft\"\nh_threshold = 10\nw_threshold = 5\nl_threshold = 0.002\ntickscript_alert = (table=<-) => table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n        topic: \"TESTING\",\n    )\n    |> drop(columns: [\"_time\"])\n\ntest _tickscript_alert = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_alert,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   10,
						},
						File:   "alert_with_topic_test.flux",
						Source: "now = () => 2020-11-25T14:05:30Z",
						Start: ast.Position{
							Column: 8,
							Line:   10,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   10,
							},
							File:   "alert_with_topic_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   10,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   10,
							},
							File:   "alert_with_topic_test.flux",
							Source: "() => 2020-11-25T14:05:30Z",
							Start: ast.Position{
								Column: 14,
								Line:   10,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   10,
								},
								File:   "alert_with_topic_test.flux",
								Source: "2020-11-25T14:05:30Z",
								Start: ast.Position{
									Column: 20,
									Line:   10,
								},
							},
						},
						Value: parser.MustParseTime("2020-11-25T14:05:30Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   10,
					},
					File:   "alert_with_topic_test.flux",
					Source: "option now = () => 2020-11-25T14:05:30Z",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 45,
							Line:   13,
						},
						File:   "alert_with_topic_test.flux",
						Source: "monitor.write = (tables=<-) => tables",
						Start: ast.Position{
							Column: 8,
							Line:   13,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   13,
							},
							File:   "alert_with_topic_test.flux",
							Source: "(tables=<-) => tables",
							Start: ast.Position{
								Column: 24,
								Line:   13,
							},
						},
					},
					Body: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   13,
								},
								File:   "alert_with_topic_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 39,
									Line:   13,
								},
							},
						},
						Name: "tables",
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   13,
								},
								File:   "alert_with_topic_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 25,
									Line:   13,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   13,
									},
									File:   "alert_with_topic_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   13,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   13,
								},
								File:   "alert_with_topic_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 32,
									Line:   13,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   13,
							},
							File:   "alert_with_topic_test.flux",
							Source: "monitor.write",
							Start: ast.Position{
								Column: 8,
								Line:   13,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   13,
								},
								File:   "alert_with_topic_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   13,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   13,
								},
								File:   "alert_with_topic_test.flux",
								Source: "write",
								Start: ast.Position{
									Column: 16,
									Line:   13,
								},
							},
						},
						Name: "write",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// overwrite as buckets are not avail in Flux tests\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 45,
						Line:   13,
					},
					File:   "alert_with_topic_test.flux",
					Source: "option monitor.write = (tables=<-) => tables",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 43,
							Line:   14,
						},
						File:   "alert_with_topic_test.flux",
						Source: "monitor.log = (tables=<-) => tables",
						Start: ast.Position{
							Column: 8,
							Line:   14,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   14,
							},
							File:   "alert_with_topic_test.flux",
							Source: "(tables=<-) => tables",
							Start: ast.Position{
								Column: 22,
								Line:   14,
							},
						},
					},
					Body: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   14,
								},
								File:   "alert_with_topic_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 37,
									Line:   14,
								},
							},
						},
						Name: "tables",
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   14,
								},
								File:   "alert_with_topic_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 23,
									Line:   14,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   14,
									},
									File:   "alert_with_topic_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 23,
										Line:   14,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   14,
								},
								File:   "alert_with_topic_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 30,
									Line:   14,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   14,
							},
							File:   "alert_with_topic_test.flux",
							Source: "monitor.log",
							Start: ast.Position{
								Column: 8,
								Line:   14,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   14,
								},
								File:   "alert_with_topic_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   14,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   14,
								},
								File:   "alert_with_topic_test.flux",
								Source: "log",
								Start: ast.Position{
									Column: 16,
									Line:   14,
								},
							},
						},
						Name: "log",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 43,
						Line:   14,
					},
					File:   "alert_with_topic_test.flux",
					Source: "option monitor.log = (tables=<-) => tables",
					Start: ast.Position{
						Column: 1,
						Line:   14,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   27,
					},
					File:   "alert_with_topic_test.flux",
					Source: "inData = \"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   16,
						},
						File:   "alert_with_topic_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   16,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   27,
						},
						File:   "alert_with_topic_test.flux",
						Source: "\"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   16,
						},
					},
				},
				Value: "\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   39,
					},
					File:   "alert_with_topic_test.flux",
					Source: "outData = \"\n#group,false,false,false,true,true,true,true,false,true,false,true,false,true,false,true,true\n#datatype,string,long,double,string,string,string,string,string,string,long,string,string,string,string,string,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,KafkaMsgRate,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,details,host,id,realm,_topic\n,,0,1.819231109049999,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.819231109049999,testm,1606313103477635916,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,0,1.635878190200181,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.635878190200181,testm,1606313104541635074,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,0,1.33716449678206,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.33716449678206,testm,1606313108868317091,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,1,39.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 39.33716449678206,testm,1606313105623191313,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,1,26.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 26.33716449678206,testm,1606313106696061106,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,2,8.33716449678206,rate-check,Rate Check,warn,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: warn - 8.33716449678206,testm,1606313107768317097,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   28,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   28,
						},
						File:   "alert_with_topic_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   28,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   39,
						},
						File:   "alert_with_topic_test.flux",
						Source: "\"\n#group,false,false,false,true,true,true,true,false,true,false,true,false,true,false,true,true\n#datatype,string,long,double,string,string,string,string,string,string,long,string,string,string,string,string,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,KafkaMsgRate,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,details,host,id,realm,_topic\n,,0,1.819231109049999,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.819231109049999,testm,1606313103477635916,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,0,1.635878190200181,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.635878190200181,testm,1606313104541635074,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,0,1.33716449678206,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.33716449678206,testm,1606313108868317091,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,1,39.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 39.33716449678206,testm,1606313105623191313,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,1,26.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 26.33716449678206,testm,1606313106696061106,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,2,8.33716449678206,rate-check,Rate Check,warn,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: warn - 8.33716449678206,testm,1606313107768317097,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   28,
						},
					},
				},
				Value: "\n#group,false,false,false,true,true,true,true,false,true,false,true,false,true,false,true,true\n#datatype,string,long,double,string,string,string,string,string,string,long,string,string,string,string,string,string\n#default,_result,,,,,,,,,,,,,,,\n,result,table,KafkaMsgRate,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,details,host,id,realm,_topic\n,,0,1.819231109049999,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.819231109049999,testm,1606313103477635916,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,0,1.635878190200181,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.635878190200181,testm,1606313104541635074,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,0,1.33716449678206,rate-check,Rate Check,ok,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: ok - 1.33716449678206,testm,1606313108868317091,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,1,39.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 39.33716449678206,testm,1606313105623191313,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,1,26.33716449678206,rate-check,Rate Check,crit,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: crit - 26.33716449678206,testm,1606313106696061106,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n,,2,8.33716449678206,rate-check,Rate Check,warn,statuses,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert: warn - 8.33716449678206,testm,1606313107768317097,custom,some detail: myrealm=ft,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate threshold alert,ft,TESTING\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   46,
					},
					File:   "alert_with_topic_test.flux",
					Source: "check = {\n    _check_id: \"rate-check\",\n    _check_name: \"Rate Check\",\n    // tickscript?\n    _type: \"custom\",\n    tags: {},\n}",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   40,
						},
						File:   "alert_with_topic_test.flux",
						Source: "check",
						Start: ast.Position{
							Column: 1,
							Line:   40,
						},
					},
				},
				Name: "check",
			},
			Init: &ast.ObjectExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   46,
						},
						File:   "alert_with_topic_test.flux",
						Source: "{\n    _check_id: \"rate-check\",\n    _check_name: \"Rate Check\",\n    // tickscript?\n    _type: \"custom\",\n    tags: {},\n}",
						Start: ast.Position{
							Column: 9,
							Line:   40,
						},
					},
				},
				Lbrace: nil,
				Properties: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   41,
							},
							File:   "alert_with_topic_test.flux",
							Source: "_check_id: \"rate-check\"",
							Start: ast.Position{
								Column: 5,
								Line:   41,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   41,
								},
								File:   "alert_with_topic_test.flux",
								Source: "_check_id",
								Start: ast.Position{
									Column: 5,
									Line:   41,
								},
							},
						},
						Name: "_check_id",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   41,
								},
								File:   "alert_with_topic_test.flux",
								Source: "\"rate-check\"",
								Start: ast.Position{
									Column: 16,
									Line:   41,
								},
							},
						},
						Value: "rate-check",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   42,
							},
							File:   "alert_with_topic_test.flux",
							Source: "_check_name: \"Rate Check\"",
							Start: ast.Position{
								Column: 5,
								Line:   42,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   42,
								},
								File:   "alert_with_topic_test.flux",
								Source: "_check_name",
								Start: ast.Position{
									Column: 5,
									Line:   42,
								},
							},
						},
						Name: "_check_name",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   42,
								},
								File:   "alert_with_topic_test.flux",
								Source: "\"Rate Check\"",
								Start: ast.Position{
									Column: 18,
									Line:   42,
								},
							},
						},
						Value: "Rate Check",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   44,
							},
							File:   "alert_with_topic_test.flux",
							Source: "_type: \"custom\"",
							Start: ast.Position{
								Column: 5,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: []ast.Comment{ast.Comment{Text: "// tickscript?\n"}},
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   44,
								},
								File:   "alert_with_topic_test.flux",
								Source: "_type",
								Start: ast.Position{
									Column: 5,
									Line:   44,
								},
							},
						},
						Name: "_type",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   44,
								},
								File:   "alert_with_topic_test.flux",
								Source: "\"custom\"",
								Start: ast.Position{
									Column: 12,
									Line:   44,
								},
							},
						},
						Value: "custom",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   45,
							},
							File:   "alert_with_topic_test.flux",
							Source: "tags: {}",
							Start: ast.Position{
								Column: 5,
								Line:   45,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   45,
								},
								File:   "alert_with_topic_test.flux",
								Source: "tags",
								Start: ast.Position{
									Column: 5,
									Line:   45,
								},
							},
						},
						Name: "tags",
					},
					Separator: nil,
					Value: &ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   45,
								},
								File:   "alert_with_topic_test.flux",
								Source: "{}",
								Start: ast.Position{
									Column: 11,
									Line:   45,
								},
							},
						},
						Lbrace:     nil,
						Properties: []*ast.Property{},
						Rbrace:     nil,
						With:       nil,
					},
				}},
				Rbrace: nil,
				With:   nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 38,
						Line:   47,
					},
					File:   "alert_with_topic_test.flux",
					Source: "metric_type = \"kafka_message_in_rate\"",
					Start: ast.Position{
						Column: 1,
						Line:   47,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   47,
						},
						File:   "alert_with_topic_test.flux",
						Source: "metric_type",
						Start: ast.Position{
							Column: 1,
							Line:   47,
						},
					},
				},
				Name: "metric_type",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 38,
							Line:   47,
						},
						File:   "alert_with_topic_test.flux",
						Source: "\"kafka_message_in_rate\"",
						Start: ast.Position{
							Column: 15,
							Line:   47,
						},
					},
				},
				Value: "kafka_message_in_rate",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   48,
					},
					File:   "alert_with_topic_test.flux",
					Source: "tier = \"ft\"",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   48,
						},
						File:   "alert_with_topic_test.flux",
						Source: "tier",
						Start: ast.Position{
							Column: 1,
							Line:   48,
						},
					},
				},
				Name: "tier",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   48,
						},
						File:   "alert_with_topic_test.flux",
						Source: "\"ft\"",
						Start: ast.Position{
							Column: 8,
							Line:   48,
						},
					},
				},
				Value: "ft",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   49,
					},
					File:   "alert_with_topic_test.flux",
					Source: "h_threshold = 10",
					Start: ast.Position{
						Column: 1,
						Line:   49,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   49,
						},
						File:   "alert_with_topic_test.flux",
						Source: "h_threshold",
						Start: ast.Position{
							Column: 1,
							Line:   49,
						},
					},
				},
				Name: "h_threshold",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   49,
						},
						File:   "alert_with_topic_test.flux",
						Source: "10",
						Start: ast.Position{
							Column: 15,
							Line:   49,
						},
					},
				},
				Value: int64(10),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   50,
					},
					File:   "alert_with_topic_test.flux",
					Source: "w_threshold = 5",
					Start: ast.Position{
						Column: 1,
						Line:   50,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   50,
						},
						File:   "alert_with_topic_test.flux",
						Source: "w_threshold",
						Start: ast.Position{
							Column: 1,
							Line:   50,
						},
					},
				},
				Name: "w_threshold",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   50,
						},
						File:   "alert_with_topic_test.flux",
						Source: "5",
						Start: ast.Position{
							Column: 15,
							Line:   50,
						},
					},
				},
				Value: int64(5),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   51,
					},
					File:   "alert_with_topic_test.flux",
					Source: "l_threshold = 0.002",
					Start: ast.Position{
						Column: 1,
						Line:   51,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   51,
						},
						File:   "alert_with_topic_test.flux",
						Source: "l_threshold",
						Start: ast.Position{
							Column: 1,
							Line:   51,
						},
					},
				},
				Name: "l_threshold",
			},
			Init: &ast.FloatLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   51,
						},
						File:   "alert_with_topic_test.flux",
						Source: "0.002",
						Start: ast.Position{
							Column: 15,
							Line:   51,
						},
					},
				},
				Value: 0.002,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   67,
					},
					File:   "alert_with_topic_test.flux",
					Source: "tickscript_alert = (table=<-) => table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n        topic: \"TESTING\",\n    )\n    |> drop(columns: [\"_time\"])",
					Start: ast.Position{
						Column: 1,
						Line:   52,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   52,
						},
						File:   "alert_with_topic_test.flux",
						Source: "tickscript_alert",
						Start: ast.Position{
							Column: 1,
							Line:   52,
						},
					},
				},
				Name: "tickscript_alert",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   67,
						},
						File:   "alert_with_topic_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n        topic: \"TESTING\",\n    )\n    |> drop(columns: [\"_time\"])",
						Start: ast.Position{
							Column: 20,
							Line:   52,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   52,
														},
														File:   "alert_with_topic_test.flux",
														Source: "table",
														Start: ast.Position{
															Column: 34,
															Line:   52,
														},
													},
												},
												Name: "table",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   53,
													},
													File:   "alert_with_topic_test.flux",
													Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)",
													Start: ast.Position{
														Column: 34,
														Line:   52,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   53,
															},
															File:   "alert_with_topic_test.flux",
															Source: "start: 2020-11-25T14:05:00Z",
															Start: ast.Position{
																Column: 14,
																Line:   53,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   53,
																},
																File:   "alert_with_topic_test.flux",
																Source: "start: 2020-11-25T14:05:00Z",
																Start: ast.Position{
																	Column: 14,
																	Line:   53,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 19,
																		Line:   53,
																	},
																	File:   "alert_with_topic_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 14,
																		Line:   53,
																	},
																},
															},
															Name: "start",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   53,
																	},
																	File:   "alert_with_topic_test.flux",
																	Source: "2020-11-25T14:05:00Z",
																	Start: ast.Position{
																		Column: 21,
																		Line:   53,
																	},
																},
															},
															Value: parser.MustParseTime("2020-11-25T14:05:00Z"),
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   53,
														},
														File:   "alert_with_topic_test.flux",
														Source: "range(start: 2020-11-25T14:05:00Z)",
														Start: ast.Position{
															Column: 8,
															Line:   53,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 13,
																Line:   53,
															},
															File:   "alert_with_topic_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 8,
																Line:   53,
															},
														},
													},
													Name: "range",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   54,
												},
												File:   "alert_with_topic_test.flux",
												Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)",
												Start: ast.Position{
													Column: 34,
													Line:   52,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   54,
														},
														File:   "alert_with_topic_test.flux",
														Source: "fn: (r) => r._field == metric_type and r.realm == tier",
														Start: ast.Position{
															Column: 15,
															Line:   54,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   54,
															},
															File:   "alert_with_topic_test.flux",
															Source: "fn: (r) => r._field == metric_type and r.realm == tier",
															Start: ast.Position{
																Column: 15,
																Line:   54,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 17,
																	Line:   54,
																},
																File:   "alert_with_topic_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 15,
																	Line:   54,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.FunctionExpression{
														Arrow: nil,
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   54,
																},
																File:   "alert_with_topic_test.flux",
																Source: "(r) => r._field == metric_type and r.realm == tier",
																Start: ast.Position{
																	Column: 19,
																	Line:   54,
																},
															},
														},
														Body: &ast.LogicalExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 69,
																		Line:   54,
																	},
																	File:   "alert_with_topic_test.flux",
																	Source: "r._field == metric_type and r.realm == tier",
																	Start: ast.Position{
																		Column: 26,
																		Line:   54,
																	},
																},
															},
															Left: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   54,
																		},
																		File:   "alert_with_topic_test.flux",
																		Source: "r._field == metric_type",
																		Start: ast.Position{
																			Column: 26,
																			Line:   54,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 34,
																				Line:   54,
																			},
																			File:   "alert_with_topic_test.flux",
																			Source: "r._field",
																			Start: ast.Position{
																				Column: 26,
																				Line:   54,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 27,
																					Line:   54,
																				},
																				File:   "alert_with_topic_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 26,
																					Line:   54,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 34,
																					Line:   54,
																				},
																				File:   "alert_with_topic_test.flux",
																				Source: "_field",
																				Start: ast.Position{
																					Column: 28,
																					Line:   54,
																				},
																			},
																		},
																		Name: "_field",
																	},
																	Rbrack: nil,
																},
																Operator: 17,
																Right: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 49,
																				Line:   54,
																			},
																			File:   "alert_with_topic_test.flux",
																			Source: "metric_type",
																			Start: ast.Position{
																				Column: 38,
																				Line:   54,
																			},
																		},
																	},
																	Name: "metric_type",
																},
															},
															Operator: 1,
															Right: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 69,
																			Line:   54,
																		},
																		File:   "alert_with_topic_test.flux",
																		Source: "r.realm == tier",
																		Start: ast.Position{
																			Column: 54,
																			Line:   54,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 61,
																				Line:   54,
																			},
																			File:   "alert_with_topic_test.flux",
																			Source: "r.realm",
																			Start: ast.Position{
																				Column: 54,
																				Line:   54,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 55,
																					Line:   54,
																				},
																				File:   "alert_with_topic_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 54,
																					Line:   54,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 61,
																					Line:   54,
																				},
																				File:   "alert_with_topic_test.flux",
																				Source: "realm",
																				Start: ast.Position{
																					Column: 56,
																					Line:   54,
																				},
																			},
																		},
																		Name: "realm",
																	},
																	Rbrack: nil,
																},
																Operator: 17,
																Right: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 69,
																				Line:   54,
																			},
																			File:   "alert_with_topic_test.flux",
																			Source: "tier",
																			Start: ast.Position{
																				Column: 65,
																				Line:   54,
																			},
																		},
																	},
																	Name: "tier",
																},
															},
														},
														Lparen: nil,
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   54,
																	},
																	File:   "alert_with_topic_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 20,
																		Line:   54,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   54,
																		},
																		File:   "alert_with_topic_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 20,
																			Line:   54,
																		},
																	},
																},
																Name: "r",
															},
															Separator: nil,
															Value:     nil,
														}},
														Rparan: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   54,
													},
													File:   "alert_with_topic_test.flux",
													Source: "filter(fn: (r) => r._field == metric_type and r.realm == tier)",
													Start: ast.Position{
														Column: 8,
														Line:   54,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   54,
														},
														File:   "alert_with_topic_test.flux",
														Source: "filter",
														Start: ast.Position{
															Column: 8,
															Line:   54,
														},
													},
												},
												Name: "filter",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   55,
											},
											File:   "alert_with_topic_test.flux",
											Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()",
											Start: ast.Position{
												Column: 34,
												Line:   52,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   55,
												},
												File:   "alert_with_topic_test.flux",
												Source: "schema.fieldsAsCols()",
												Start: ast.Position{
													Column: 8,
													Line:   55,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   55,
													},
													File:   "alert_with_topic_test.flux",
													Source: "schema.fieldsAsCols",
													Start: ast.Position{
														Column: 8,
														Line:   55,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   55,
														},
														File:   "alert_with_topic_test.flux",
														Source: "schema",
														Start: ast.Position{
															Column: 8,
															Line:   55,
														},
													},
												},
												Name: "schema",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   55,
														},
														File:   "alert_with_topic_test.flux",
														Source: "fieldsAsCols",
														Start: ast.Position{
															Column: 15,
															Line:   55,
														},
													},
												},
												Name: "fieldsAsCols",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   56,
										},
										File:   "alert_with_topic_test.flux",
										Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")",
										Start: ast.Position{
											Column: 34,
											Line:   52,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   56,
												},
												File:   "alert_with_topic_test.flux",
												Source: "column: metric_type, as: \"KafkaMsgRate\"",
												Start: ast.Position{
													Column: 26,
													Line:   56,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   56,
													},
													File:   "alert_with_topic_test.flux",
													Source: "column: metric_type",
													Start: ast.Position{
														Column: 26,
														Line:   56,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   56,
														},
														File:   "alert_with_topic_test.flux",
														Source: "column",
														Start: ast.Position{
															Column: 26,
															Line:   56,
														},
													},
												},
												Name: "column",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   56,
														},
														File:   "alert_with_topic_test.flux",
														Source: "metric_type",
														Start: ast.Position{
															Column: 34,
															Line:   56,
														},
													},
												},
												Name: "metric_type",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 65,
														Line:   56,
													},
													File:   "alert_with_topic_test.flux",
													Source: "as: \"KafkaMsgRate\"",
													Start: ast.Position{
														Column: 47,
														Line:   56,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   56,
														},
														File:   "alert_with_topic_test.flux",
														Source: "as",
														Start: ast.Position{
															Column: 47,
															Line:   56,
														},
													},
												},
												Name: "as",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   56,
														},
														File:   "alert_with_topic_test.flux",
														Source: "\"KafkaMsgRate\"",
														Start: ast.Position{
															Column: 51,
															Line:   56,
														},
													},
												},
												Value: "KafkaMsgRate",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   56,
											},
											File:   "alert_with_topic_test.flux",
											Source: "tickscript.select(column: metric_type, as: \"KafkaMsgRate\")",
											Start: ast.Position{
												Column: 8,
												Line:   56,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   56,
												},
												File:   "alert_with_topic_test.flux",
												Source: "tickscript.select",
												Start: ast.Position{
													Column: 8,
													Line:   56,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   56,
													},
													File:   "alert_with_topic_test.flux",
													Source: "tickscript",
													Start: ast.Position{
														Column: 8,
														Line:   56,
													},
												},
											},
											Name: "tickscript",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   56,
													},
													File:   "alert_with_topic_test.flux",
													Source: "select",
													Start: ast.Position{
														Column: 19,
														Line:   56,
													},
												},
											},
											Name: "select",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   57,
									},
									File:   "alert_with_topic_test.flux",
									Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])",
									Start: ast.Position{
										Column: 34,
										Line:   52,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   57,
											},
											File:   "alert_with_topic_test.flux",
											Source: "columns: [\"host\", \"realm\"]",
											Start: ast.Position{
												Column: 27,
												Line:   57,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   57,
												},
												File:   "alert_with_topic_test.flux",
												Source: "columns: [\"host\", \"realm\"]",
												Start: ast.Position{
													Column: 27,
													Line:   57,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   57,
													},
													File:   "alert_with_topic_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 27,
														Line:   57,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   57,
													},
													File:   "alert_with_topic_test.flux",
													Source: "[\"host\", \"realm\"]",
													Start: ast.Position{
														Column: 36,
														Line:   57,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   57,
														},
														File:   "alert_with_topic_test.flux",
														Source: "\"host\"",
														Start: ast.Position{
															Column: 37,
															Line:   57,
														},
													},
												},
												Value: "host",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   57,
														},
														File:   "alert_with_topic_test.flux",
														Source: "\"realm\"",
														Start: ast.Position{
															Column: 45,
															Line:   57,
														},
													},
												},
												Value: "realm",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   57,
										},
										File:   "alert_with_topic_test.flux",
										Source: "tickscript.groupBy(columns: [\"host\", \"realm\"])",
										Start: ast.Position{
											Column: 8,
											Line:   57,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   57,
											},
											File:   "alert_with_topic_test.flux",
											Source: "tickscript.groupBy",
											Start: ast.Position{
												Column: 8,
												Line:   57,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   57,
												},
												File:   "alert_with_topic_test.flux",
												Source: "tickscript",
												Start: ast.Position{
													Column: 8,
													Line:   57,
												},
											},
										},
										Name: "tickscript",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   57,
												},
												File:   "alert_with_topic_test.flux",
												Source: "groupBy",
												Start: ast.Position{
													Column: 19,
													Line:   57,
												},
											},
										},
										Name: "groupBy",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   66,
								},
								File:   "alert_with_topic_test.flux",
								Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n        topic: \"TESTING\",\n    )",
								Start: ast.Position{
									Column: 34,
									Line:   52,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   65,
										},
										File:   "alert_with_topic_test.flux",
										Source: "check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n        topic: \"TESTING\"",
										Start: ast.Position{
											Column: 9,
											Line:   59,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   59,
											},
											File:   "alert_with_topic_test.flux",
											Source: "check: check",
											Start: ast.Position{
												Column: 9,
												Line:   59,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   59,
												},
												File:   "alert_with_topic_test.flux",
												Source: "check",
												Start: ast.Position{
													Column: 9,
													Line:   59,
												},
											},
										},
										Name: "check",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   59,
												},
												File:   "alert_with_topic_test.flux",
												Source: "check",
												Start: ast.Position{
													Column: 16,
													Line:   59,
												},
											},
										},
										Name: "check",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 102,
												Line:   60,
											},
											File:   "alert_with_topic_test.flux",
											Source: "id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\"",
											Start: ast.Position{
												Column: 9,
												Line:   60,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   60,
												},
												File:   "alert_with_topic_test.flux",
												Source: "id",
												Start: ast.Position{
													Column: 9,
													Line:   60,
												},
											},
										},
										Name: "id",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 102,
													Line:   60,
												},
												File:   "alert_with_topic_test.flux",
												Source: "(r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\"",
												Start: ast.Position{
													Column: 13,
													Line:   60,
												},
											},
										},
										Body: &ast.StringExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 102,
														Line:   60,
													},
													File:   "alert_with_topic_test.flux",
													Source: "\"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\"",
													Start: ast.Position{
														Column: 20,
														Line:   60,
													},
												},
											},
											Parts: []ast.StringExpressionPart{&ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   60,
														},
														File:   "alert_with_topic_test.flux",
														Source: "Realm: ",
														Start: ast.Position{
															Column: 21,
															Line:   60,
														},
													},
												},
												Value: "Realm: ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   60,
														},
														File:   "alert_with_topic_test.flux",
														Source: "${r.realm}",
														Start: ast.Position{
															Column: 28,
															Line:   60,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   60,
															},
															File:   "alert_with_topic_test.flux",
															Source: "r.realm",
															Start: ast.Position{
																Column: 30,
																Line:   60,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   60,
																},
																File:   "alert_with_topic_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 30,
																	Line:   60,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   60,
																},
																File:   "alert_with_topic_test.flux",
																Source: "realm",
																Start: ast.Position{
																	Column: 32,
																	Line:   60,
																},
															},
														},
														Name: "realm",
													},
													Rbrack: nil,
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 51,
															Line:   60,
														},
														File:   "alert_with_topic_test.flux",
														Source: " - Hostname: ",
														Start: ast.Position{
															Column: 38,
															Line:   60,
														},
													},
												},
												Value: " - Hostname: ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   60,
														},
														File:   "alert_with_topic_test.flux",
														Source: "${r.host}",
														Start: ast.Position{
															Column: 51,
															Line:   60,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 59,
																Line:   60,
															},
															File:   "alert_with_topic_test.flux",
															Source: "r.host",
															Start: ast.Position{
																Column: 53,
																Line:   60,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 54,
																	Line:   60,
																},
																File:   "alert_with_topic_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 53,
																	Line:   60,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 59,
																	Line:   60,
																},
																File:   "alert_with_topic_test.flux",
																Source: "host",
																Start: ast.Position{
																	Column: 55,
																	Line:   60,
																},
															},
														},
														Name: "host",
													},
													Rbrack: nil,
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   60,
														},
														File:   "alert_with_topic_test.flux",
														Source: " / Metric: ",
														Start: ast.Position{
															Column: 60,
															Line:   60,
														},
													},
												},
												Value: " / Metric: ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 85,
															Line:   60,
														},
														File:   "alert_with_topic_test.flux",
														Source: "${metric_type}",
														Start: ast.Position{
															Column: 71,
															Line:   60,
														},
													},
												},
												Expression: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 84,
																Line:   60,
															},
															File:   "alert_with_topic_test.flux",
															Source: "metric_type",
															Start: ast.Position{
																Column: 73,
																Line:   60,
															},
														},
													},
													Name: "metric_type",
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 101,
															Line:   60,
														},
														File:   "alert_with_topic_test.flux",
														Source: " threshold alert",
														Start: ast.Position{
															Column: 85,
															Line:   60,
														},
													},
												},
												Value: " threshold alert",
											}},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   60,
													},
													File:   "alert_with_topic_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 14,
														Line:   60,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   60,
														},
														File:   "alert_with_topic_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   60,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   61,
											},
											File:   "alert_with_topic_test.flux",
											Source: "message: (r) => \"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\"",
											Start: ast.Position{
												Column: 9,
												Line:   61,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   61,
												},
												File:   "alert_with_topic_test.flux",
												Source: "message",
												Start: ast.Position{
													Column: 9,
													Line:   61,
												},
											},
										},
										Name: "message",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 78,
													Line:   61,
												},
												File:   "alert_with_topic_test.flux",
												Source: "(r) => \"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\"",
												Start: ast.Position{
													Column: 18,
													Line:   61,
												},
											},
										},
										Body: &ast.StringExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   61,
													},
													File:   "alert_with_topic_test.flux",
													Source: "\"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\"",
													Start: ast.Position{
														Column: 25,
														Line:   61,
													},
												},
											},
											Parts: []ast.StringExpressionPart{&ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   61,
														},
														File:   "alert_with_topic_test.flux",
														Source: "${r.id}",
														Start: ast.Position{
															Column: 26,
															Line:   61,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 32,
																Line:   61,
															},
															File:   "alert_with_topic_test.flux",
															Source: "r.id",
															Start: ast.Position{
																Column: 28,
																Line:   61,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 29,
																	Line:   61,
																},
																File:   "alert_with_topic_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 28,
																	Line:   61,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 32,
																	Line:   61,
																},
																File:   "alert_with_topic_test.flux",
																Source: "id",
																Start: ast.Position{
																	Column: 30,
																	Line:   61,
																},
															},
														},
														Name: "id",
													},
													Rbrack: nil,
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   61,
														},
														File:   "alert_with_topic_test.flux",
														Source: ": ",
														Start: ast.Position{
															Column: 33,
															Line:   61,
														},
													},
												},
												Value: ": ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   61,
														},
														File:   "alert_with_topic_test.flux",
														Source: "${r._level}",
														Start: ast.Position{
															Column: 35,
															Line:   61,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   61,
															},
															File:   "alert_with_topic_test.flux",
															Source: "r._level",
															Start: ast.Position{
																Column: 37,
																Line:   61,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   61,
																},
																File:   "alert_with_topic_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 37,
																	Line:   61,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   61,
																},
																File:   "alert_with_topic_test.flux",
																Source: "_level",
																Start: ast.Position{
																	Column: 39,
																	Line:   61,
																},
															},
														},
														Name: "_level",
													},
													Rbrack: nil,
												},
											}, &ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   61,
														},
														File:   "alert_with_topic_test.flux",
														Source: " - ",
														Start: ast.Position{
															Column: 46,
															Line:   61,
														},
													},
												},
												Value: " - ",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   61,
														},
														File:   "alert_with_topic_test.flux",
														Source: "${string(v: r.KafkaMsgRate)}",
														Start: ast.Position{
															Column: 49,
															Line:   61,
														},
													},
												},
												Expression: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 75,
																	Line:   61,
																},
																File:   "alert_with_topic_test.flux",
																Source: "v: r.KafkaMsgRate",
																Start: ast.Position{
																	Column: 58,
																	Line:   61,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 75,
																		Line:   61,
																	},
																	File:   "alert_with_topic_test.flux",
																	Source: "v: r.KafkaMsgRate",
																	Start: ast.Position{
																		Column: 58,
																		Line:   61,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 59,
																			Line:   61,
																		},
																		File:   "alert_with_topic_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 58,
																			Line:   61,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 75,
																			Line:   61,
																		},
																		File:   "alert_with_topic_test.flux",
																		Source: "r.KafkaMsgRate",
																		Start: ast.Position{
																			Column: 61,
																			Line:   61,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 62,
																				Line:   61,
																			},
																			File:   "alert_with_topic_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 61,
																				Line:   61,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 75,
																				Line:   61,
																			},
																			File:   "alert_with_topic_test.flux",
																			Source: "KafkaMsgRate",
																			Start: ast.Position{
																				Column: 63,
																				Line:   61,
																			},
																		},
																	},
																	Name: "KafkaMsgRate",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 76,
																Line:   61,
															},
															File:   "alert_with_topic_test.flux",
															Source: "string(v: r.KafkaMsgRate)",
															Start: ast.Position{
																Column: 51,
																Line:   61,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 57,
																	Line:   61,
																},
																File:   "alert_with_topic_test.flux",
																Source: "string",
																Start: ast.Position{
																	Column: 51,
																	Line:   61,
																},
															},
														},
														Name: "string",
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   61,
													},
													File:   "alert_with_topic_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 19,
														Line:   61,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   61,
														},
														File:   "alert_with_topic_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 19,
															Line:   61,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   62,
											},
											File:   "alert_with_topic_test.flux",
											Source: "details: (r) => \"some detail: myrealm=${r.realm}\"",
											Start: ast.Position{
												Column: 9,
												Line:   62,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   62,
												},
												File:   "alert_with_topic_test.flux",
												Source: "details",
												Start: ast.Position{
													Column: 9,
													Line:   62,
												},
											},
										},
										Name: "details",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   62,
												},
												File:   "alert_with_topic_test.flux",
												Source: "(r) => \"some detail: myrealm=${r.realm}\"",
												Start: ast.Position{
													Column: 18,
													Line:   62,
												},
											},
										},
										Body: &ast.StringExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   62,
													},
													File:   "alert_with_topic_test.flux",
													Source: "\"some detail: myrealm=${r.realm}\"",
													Start: ast.Position{
														Column: 25,
														Line:   62,
													},
												},
											},
											Parts: []ast.StringExpressionPart{&ast.TextPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   62,
														},
														File:   "alert_with_topic_test.flux",
														Source: "some detail: myrealm=",
														Start: ast.Position{
															Column: 26,
															Line:   62,
														},
													},
												},
												Value: "some detail: myrealm=",
											}, &ast.InterpolatedPart{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 57,
															Line:   62,
														},
														File:   "alert_with_topic_test.flux",
														Source: "${r.realm}",
														Start: ast.Position{
															Column: 47,
															Line:   62,
														},
													},
												},
												Expression: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   62,
															},
															File:   "alert_with_topic_test.flux",
															Source: "r.realm",
															Start: ast.Position{
																Column: 49,
																Line:   62,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 50,
																	Line:   62,
																},
																File:   "alert_with_topic_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 49,
																	Line:   62,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   62,
																},
																File:   "alert_with_topic_test.flux",
																Source: "realm",
																Start: ast.Position{
																	Column: 51,
																	Line:   62,
																},
															},
														},
														Name: "realm",
													},
													Rbrack: nil,
												},
											}},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   62,
													},
													File:   "alert_with_topic_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 19,
														Line:   62,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   62,
														},
														File:   "alert_with_topic_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 19,
															Line:   62,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 82,
												Line:   63,
											},
											File:   "alert_with_topic_test.flux",
											Source: "crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold",
											Start: ast.Position{
												Column: 9,
												Line:   63,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   63,
												},
												File:   "alert_with_topic_test.flux",
												Source: "crit",
												Start: ast.Position{
													Column: 9,
													Line:   63,
												},
											},
										},
										Name: "crit",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 82,
													Line:   63,
												},
												File:   "alert_with_topic_test.flux",
												Source: "(r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold",
												Start: ast.Position{
													Column: 15,
													Line:   63,
												},
											},
										},
										Body: &ast.LogicalExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 82,
														Line:   63,
													},
													File:   "alert_with_topic_test.flux",
													Source: "r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold",
													Start: ast.Position{
														Column: 22,
														Line:   63,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   63,
														},
														File:   "alert_with_topic_test.flux",
														Source: "r.KafkaMsgRate > h_threshold",
														Start: ast.Position{
															Column: 22,
															Line:   63,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   63,
															},
															File:   "alert_with_topic_test.flux",
															Source: "r.KafkaMsgRate",
															Start: ast.Position{
																Column: 22,
																Line:   63,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   63,
																},
																File:   "alert_with_topic_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 22,
																	Line:   63,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   63,
																},
																File:   "alert_with_topic_test.flux",
																Source: "KafkaMsgRate",
																Start: ast.Position{
																	Column: 24,
																	Line:   63,
																},
															},
														},
														Name: "KafkaMsgRate",
													},
													Rbrack: nil,
												},
												Operator: 10,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 50,
																Line:   63,
															},
															File:   "alert_with_topic_test.flux",
															Source: "h_threshold",
															Start: ast.Position{
																Column: 39,
																Line:   63,
															},
														},
													},
													Name: "h_threshold",
												},
											},
											Operator: 2,
											Right: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   63,
														},
														File:   "alert_with_topic_test.flux",
														Source: "r.KafkaMsgRate < l_threshold",
														Start: ast.Position{
															Column: 54,
															Line:   63,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   63,
															},
															File:   "alert_with_topic_test.flux",
															Source: "r.KafkaMsgRate",
															Start: ast.Position{
																Column: 54,
																Line:   63,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   63,
																},
																File:   "alert_with_topic_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 54,
																	Line:   63,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   63,
																},
																File:   "alert_with_topic_test.flux",
																Source: "KafkaMsgRate",
																Start: ast.Position{
																	Column: 56,
																	Line:   63,
																},
															},
														},
														Name: "KafkaMsgRate",
													},
													Rbrack: nil,
												},
												Operator: 8,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 82,
																Line:   63,
															},
															File:   "alert_with_topic_test.flux",
															Source: "l_threshold",
															Start: ast.Position{
																Column: 71,
																Line:   63,
															},
														},
													},
													Name: "l_threshold",
												},
											},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   63,
													},
													File:   "alert_with_topic_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 16,
														Line:   63,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   63,
														},
														File:   "alert_with_topic_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 16,
															Line:   63,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 82,
												Line:   64,
											},
											File:   "alert_with_topic_test.flux",
											Source: "warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold",
											Start: ast.Position{
												Column: 9,
												Line:   64,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   64,
												},
												File:   "alert_with_topic_test.flux",
												Source: "warn",
												Start: ast.Position{
													Column: 9,
													Line:   64,
												},
											},
										},
										Name: "warn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 82,
													Line:   64,
												},
												File:   "alert_with_topic_test.flux",
												Source: "(r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold",
												Start: ast.Position{
													Column: 15,
													Line:   64,
												},
											},
										},
										Body: &ast.LogicalExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 82,
														Line:   64,
													},
													File:   "alert_with_topic_test.flux",
													Source: "r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold",
													Start: ast.Position{
														Column: 22,
														Line:   64,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   64,
														},
														File:   "alert_with_topic_test.flux",
														Source: "r.KafkaMsgRate > w_threshold",
														Start: ast.Position{
															Column: 22,
															Line:   64,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   64,
															},
															File:   "alert_with_topic_test.flux",
															Source: "r.KafkaMsgRate",
															Start: ast.Position{
																Column: 22,
																Line:   64,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   64,
																},
																File:   "alert_with_topic_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 22,
																	Line:   64,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   64,
																},
																File:   "alert_with_topic_test.flux",
																Source: "KafkaMsgRate",
																Start: ast.Position{
																	Column: 24,
																	Line:   64,
																},
															},
														},
														Name: "KafkaMsgRate",
													},
													Rbrack: nil,
												},
												Operator: 10,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 50,
																Line:   64,
															},
															File:   "alert_with_topic_test.flux",
															Source: "w_threshold",
															Start: ast.Position{
																Column: 39,
																Line:   64,
															},
														},
													},
													Name: "w_threshold",
												},
											},
											Operator: 2,
											Right: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   64,
														},
														File:   "alert_with_topic_test.flux",
														Source: "r.KafkaMsgRate < l_threshold",
														Start: ast.Position{
															Column: 54,
															Line:   64,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   64,
															},
															File:   "alert_with_topic_test.flux",
															Source: "r.KafkaMsgRate",
															Start: ast.Position{
																Column: 54,
																Line:   64,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   64,
																},
																File:   "alert_with_topic_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 54,
																	Line:   64,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   64,
																},
																File:   "alert_with_topic_test.flux",
																Source: "KafkaMsgRate",
																Start: ast.Position{
																	Column: 56,
																	Line:   64,
																},
															},
														},
														Name: "KafkaMsgRate",
													},
													Rbrack: nil,
												},
												Operator: 8,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 82,
																Line:   64,
															},
															File:   "alert_with_topic_test.flux",
															Source: "l_threshold",
															Start: ast.Position{
																Column: 71,
																Line:   64,
															},
														},
													},
													Name: "l_threshold",
												},
											},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   64,
													},
													File:   "alert_with_topic_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 16,
														Line:   64,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   64,
														},
														File:   "alert_with_topic_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 16,
															Line:   64,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   65,
											},
											File:   "alert_with_topic_test.flux",
											Source: "topic: \"TESTING\"",
											Start: ast.Position{
												Column: 9,
												Line:   65,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   65,
												},
												File:   "alert_with_topic_test.flux",
												Source: "topic",
												Start: ast.Position{
													Column: 9,
													Line:   65,
												},
											},
										},
										Name: "topic",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   65,
												},
												File:   "alert_with_topic_test.flux",
												Source: "\"TESTING\"",
												Start: ast.Position{
													Column: 16,
													Line:   65,
												},
											},
										},
										Value: "TESTING",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   66,
									},
									File:   "alert_with_topic_test.flux",
									Source: "tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n        topic: \"TESTING\",\n    )",
									Start: ast.Position{
										Column: 8,
										Line:   58,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   58,
										},
										File:   "alert_with_topic_test.flux",
										Source: "tickscript.alert",
										Start: ast.Position{
											Column: 8,
											Line:   58,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   58,
											},
											File:   "alert_with_topic_test.flux",
											Source: "tickscript",
											Start: ast.Position{
												Column: 8,
												Line:   58,
											},
										},
									},
									Name: "tickscript",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   58,
											},
											File:   "alert_with_topic_test.flux",
											Source: "alert",
											Start: ast.Position{
												Column: 19,
												Line:   58,
											},
										},
									},
									Name: "alert",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   67,
							},
							File:   "alert_with_topic_test.flux",
							Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.select(column: metric_type, as: \"KafkaMsgRate\")\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.alert(\n        check: check,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} threshold alert\",\n        message: (r) => \"${r.id}: ${r._level} - ${string(v: r.KafkaMsgRate)}\",\n        details: (r) => \"some detail: myrealm=${r.realm}\",\n        crit: (r) => r.KafkaMsgRate > h_threshold or r.KafkaMsgRate < l_threshold,\n        warn: (r) => r.KafkaMsgRate > w_threshold or r.KafkaMsgRate < l_threshold,\n        topic: \"TESTING\",\n    )\n    |> drop(columns: [\"_time\"])",
							Start: ast.Position{
								Column: 34,
								Line:   52,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   67,
									},
									File:   "alert_with_topic_test.flux",
									Source: "columns: [\"_time\"]",
									Start: ast.Position{
										Column: 13,
										Line:   67,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   67,
										},
										File:   "alert_with_topic_test.flux",
										Source: "columns: [\"_time\"]",
										Start: ast.Position{
											Column: 13,
											Line:   67,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   67,
											},
											File:   "alert_with_topic_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   67,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   67,
											},
											File:   "alert_with_topic_test.flux",
											Source: "[\"_time\"]",
											Start: ast.Position{
												Column: 22,
												Line:   67,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   67,
												},
												File:   "alert_with_topic_test.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 23,
													Line:   67,
												},
											},
										},
										Value: "_time",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   67,
								},
								File:   "alert_with_topic_test.flux",
								Source: "drop(columns: [\"_time\"])",
								Start: ast.Position{
									Column: 8,
									Line:   67,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   67,
									},
									File:   "alert_with_topic_test.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 8,
										Line:   67,
									},
								},
							},
							Name: "drop",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   52,
							},
							File:   "alert_with_topic_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   52,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   52,
								},
								File:   "alert_with_topic_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   52,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   52,
							},
							File:   "alert_with_topic_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   52,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   73,
						},
						File:   "alert_with_topic_test.flux",
						Source: "_tickscript_alert = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_alert,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   69,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   69,
							},
							File:   "alert_with_topic_test.flux",
							Source: "_tickscript_alert",
							Start: ast.Position{
								Column: 6,
								Line:   69,
							},
						},
					},
					Name: "_tickscript_alert",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   73,
							},
							File:   "alert_with_topic_test.flux",
							Source: "() => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_alert,\n})",
							Start: ast.Position{
								Column: 26,
								Line:   69,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   73,
								},
								File:   "alert_with_topic_test.flux",
								Source: "({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_alert,\n})",
								Start: ast.Position{
									Column: 32,
									Line:   69,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   73,
									},
									File:   "alert_with_topic_test.flux",
									Source: "{\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_alert,\n}",
									Start: ast.Position{
										Column: 33,
										Line:   69,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   70,
										},
										File:   "alert_with_topic_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 5,
											Line:   70,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   70,
											},
											File:   "alert_with_topic_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 5,
												Line:   70,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   70,
												},
												File:   "alert_with_topic_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 32,
													Line:   70,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   70,
													},
													File:   "alert_with_topic_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 32,
														Line:   70,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   70,
														},
														File:   "alert_with_topic_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 32,
															Line:   70,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   70,
														},
														File:   "alert_with_topic_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 37,
															Line:   70,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   70,
											},
											File:   "alert_with_topic_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 12,
												Line:   70,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   70,
												},
												File:   "alert_with_topic_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 12,
													Line:   70,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   70,
													},
													File:   "alert_with_topic_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 12,
														Line:   70,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   70,
													},
													File:   "alert_with_topic_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 20,
														Line:   70,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   71,
										},
										File:   "alert_with_topic_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 5,
											Line:   71,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   71,
											},
											File:   "alert_with_topic_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 5,
												Line:   71,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   71,
												},
												File:   "alert_with_topic_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 27,
													Line:   71,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   71,
													},
													File:   "alert_with_topic_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 27,
														Line:   71,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   71,
														},
														File:   "alert_with_topic_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   71,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   71,
														},
														File:   "alert_with_topic_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 32,
															Line:   71,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   71,
											},
											File:   "alert_with_topic_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 11,
												Line:   71,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   71,
												},
												File:   "alert_with_topic_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   71,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   71,
													},
													File:   "alert_with_topic_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   71,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   71,
													},
													File:   "alert_with_topic_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   71,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   72,
										},
										File:   "alert_with_topic_test.flux",
										Source: "fn: tickscript_alert",
										Start: ast.Position{
											Column: 5,
											Line:   72,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   72,
											},
											File:   "alert_with_topic_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 5,
												Line:   72,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   72,
											},
											File:   "alert_with_topic_test.flux",
											Source: "tickscript_alert",
											Start: ast.Position{
												Column: 9,
												Line:   72,
											},
										},
									},
									Name: "tickscript_alert",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   73,
					},
					File:   "alert_with_topic_test.flux",
					Source: "test _tickscript_alert = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_alert,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   69,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "alert_with_topic_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "alert_with_topic_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   5,
					},
					File:   "alert_with_topic_test.flux",
					Source: "import \"csv\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   5,
						},
						File:   "alert_with_topic_test.flux",
						Source: "\"csv\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "csv",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 39,
						Line:   6,
					},
					File:   "alert_with_topic_test.flux",
					Source: "import \"contrib/bonitoo-io/tickscript\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 39,
							Line:   6,
						},
						File:   "alert_with_topic_test.flux",
						Source: "\"contrib/bonitoo-io/tickscript\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "contrib/bonitoo-io/tickscript",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   7,
					},
					File:   "alert_with_topic_test.flux",
					Source: "import \"influxdata/influxdb/monitor\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   7,
						},
						File:   "alert_with_topic_test.flux",
						Source: "\"influxdata/influxdb/monitor\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "influxdata/influxdb/monitor",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 36,
						Line:   8,
					},
					File:   "alert_with_topic_test.flux",
					Source: "import \"influxdata/influxdb/schema\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   8,
						},
						File:   "alert_with_topic_test.flux",
						Source: "\"influxdata/influxdb/schema\"",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				Value: "influxdata/influxdb/schema",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "alert_with_topic_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   1,
					},
					File:   "alert_with_topic_test.flux",
					Source: "package tickscript_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   1,
						},
						File:   "alert_with_topic_test.flux",
						Source: "tickscript_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "tickscript_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   63,
				},
				File:   "deadman_empty_test.flux",
				Source: "package tickscript_test\n\n\nimport \"testing\"\nimport \"csv\"\nimport \"contrib/bonitoo-io/tickscript\"\nimport \"influxdata/influxdb/monitor\"\nimport \"influxdata/influxdb/schema\"\n\noption now = () => 2020-11-25T14:05:30Z\n\n// overwrite as buckets are not avail in Flux tests\noption monitor.write = (tables=<-) => tables\noption monitor.log = (tables=<-) => tables\n\ninData = \"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,true,false,true,false,false\n#datatype,string,long,string,string,string,string,string,string,long,string,boolean,string\n#default,_result,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,dead,id\n,,0,rate-check,Rate Check,crit,statuses,Deadman Check: Rate Check is: dead,testm,1606313130000000000,deadman,true,Realm: ft - Hostname: unknown / Metric: kafka_message_in_rate deadman alert\n\"\ncheck = {\n    _check_id: \"rate-check\",\n    _check_name: \"Rate Check\",\n    // tickscript?\n    _type: \"deadman\",\n    tags: {},\n}\nmetric_type = \"kafka_message_in_rate\"\ntier = \"ft\"\ntickscript_deadman = (table=<-) => table\n    |> range(start: 2020-11-25T14:05:15Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\",\n    )\n    // to avoid issue with validation\n    |> drop(columns: [\"details\"])\n    |> drop(columns: [\"_time\"])\n\ntest _tickscript_deadman = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_deadman,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   10,
						},
						File:   "deadman_empty_test.flux",
						Source: "now = () => 2020-11-25T14:05:30Z",
						Start: ast.Position{
							Column: 8,
							Line:   10,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   10,
							},
							File:   "deadman_empty_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   10,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   10,
							},
							File:   "deadman_empty_test.flux",
							Source: "() => 2020-11-25T14:05:30Z",
							Start: ast.Position{
								Column: 14,
								Line:   10,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   10,
								},
								File:   "deadman_empty_test.flux",
								Source: "2020-11-25T14:05:30Z",
								Start: ast.Position{
									Column: 20,
									Line:   10,
								},
							},
						},
						Value: parser.MustParseTime("2020-11-25T14:05:30Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   10,
					},
					File:   "deadman_empty_test.flux",
					Source: "option now = () => 2020-11-25T14:05:30Z",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 45,
							Line:   13,
						},
						File:   "deadman_empty_test.flux",
						Source: "monitor.write = (tables=<-) => tables",
						Start: ast.Position{
							Column: 8,
							Line:   13,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   13,
							},
							File:   "deadman_empty_test.flux",
							Source: "(tables=<-) => tables",
							Start: ast.Position{
								Column: 24,
								Line:   13,
							},
						},
					},
					Body: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   13,
								},
								File:   "deadman_empty_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 39,
									Line:   13,
								},
							},
						},
						Name: "tables",
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   13,
								},
								File:   "deadman_empty_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 25,
									Line:   13,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   13,
									},
									File:   "deadman_empty_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   13,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   13,
								},
								File:   "deadman_empty_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 32,
									Line:   13,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   13,
							},
							File:   "deadman_empty_test.flux",
							Source: "monitor.write",
							Start: ast.Position{
								Column: 8,
								Line:   13,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   13,
								},
								File:   "deadman_empty_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   13,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   13,
								},
								File:   "deadman_empty_test.flux",
								Source: "write",
								Start: ast.Position{
									Column: 16,
									Line:   13,
								},
							},
						},
						Name: "write",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// overwrite as buckets are not avail in Flux tests\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 45,
						Line:   13,
					},
					File:   "deadman_empty_test.flux",
					Source: "option monitor.write = (tables=<-) => tables",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 43,
							Line:   14,
						},
						File:   "deadman_empty_test.flux",
						Source: "monitor.log = (tables=<-) => tables",
						Start: ast.Position{
							Column: 8,
							Line:   14,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   14,
							},
							File:   "deadman_empty_test.flux",
							Source: "(tables=<-) => tables",
							Start: ast.Position{
								Column: 22,
								Line:   14,
							},
						},
					},
					Body: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   14,
								},
								File:   "deadman_empty_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 37,
									Line:   14,
								},
							},
						},
						Name: "tables",
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   14,
								},
								File:   "deadman_empty_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 23,
									Line:   14,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   14,
									},
									File:   "deadman_empty_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 23,
										Line:   14,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   14,
								},
								File:   "deadman_empty_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 30,
									Line:   14,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   14,
							},
							File:   "deadman_empty_test.flux",
							Source: "monitor.log",
							Start: ast.Position{
								Column: 8,
								Line:   14,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   14,
								},
								File:   "deadman_empty_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   14,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   14,
								},
								File:   "deadman_empty_test.flux",
								Source: "log",
								Start: ast.Position{
									Column: 16,
									Line:   14,
								},
							},
						},
						Name: "log",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 43,
						Line:   14,
					},
					File:   "deadman_empty_test.flux",
					Source: "option monitor.log = (tables=<-) => tables",
					Start: ast.Position{
						Column: 1,
						Line:   14,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   27,
					},
					File:   "deadman_empty_test.flux",
					Source: "inData = \"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   16,
						},
						File:   "deadman_empty_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   16,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   27,
						},
						File:   "deadman_empty_test.flux",
						Source: "\"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   16,
						},
					},
				},
				Value: "\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   34,
					},
					File:   "deadman_empty_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,true,false,true,false,false\n#datatype,string,long,string,string,string,string,string,string,long,string,boolean,string\n#default,_result,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,dead,id\n,,0,rate-check,Rate Check,crit,statuses,Deadman Check: Rate Check is: dead,testm,1606313130000000000,deadman,true,Realm: ft - Hostname: unknown / Metric: kafka_message_in_rate deadman alert\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   28,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   28,
						},
						File:   "deadman_empty_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   28,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   34,
						},
						File:   "deadman_empty_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,true,false,true,false,false\n#datatype,string,long,string,string,string,string,string,string,long,string,boolean,string\n#default,_result,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,dead,id\n,,0,rate-check,Rate Check,crit,statuses,Deadman Check: Rate Check is: dead,testm,1606313130000000000,deadman,true,Realm: ft - Hostname: unknown / Metric: kafka_message_in_rate deadman alert\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   28,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,true,false,true,false,false\n#datatype,string,long,string,string,string,string,string,string,long,string,boolean,string\n#default,_result,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,dead,id\n,,0,rate-check,Rate Check,crit,statuses,Deadman Check: Rate Check is: dead,testm,1606313130000000000,deadman,true,Realm: ft - Hostname: unknown / Metric: kafka_message_in_rate deadman alert\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   41,
					},
					File:   "deadman_empty_test.flux",
					Source: "check = {\n    _check_id: \"rate-check\",\n    _check_name: \"Rate Check\",\n    // tickscript?\n    _type: \"deadman\",\n    tags: {},\n}",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   35,
						},
						File:   "deadman_empty_test.flux",
						Source: "check",
						Start: ast.Position{
							Column: 1,
							Line:   35,
						},
					},
				},
				Name: "check",
			},
			Init: &ast.ObjectExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   41,
						},
						File:   "deadman_empty_test.flux",
						Source: "{\n    _check_id: \"rate-check\",\n    _check_name: \"Rate Check\",\n    // tickscript?\n    _type: \"deadman\",\n    tags: {},\n}",
						Start: ast.Position{
							Column: 9,
							Line:   35,
						},
					},
				},
				Lbrace: nil,
				Properties: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   36,
							},
							File:   "deadman_empty_test.flux",
							Source: "_check_id: \"rate-check\"",
							Start: ast.Position{
								Column: 5,
								Line:   36,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   36,
								},
								File:   "deadman_empty_test.flux",
								Source: "_check_id",
								Start: ast.Position{
									Column: 5,
									Line:   36,
								},
							},
						},
						Name: "_check_id",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   36,
								},
								File:   "deadman_empty_test.flux",
								Source: "\"rate-check\"",
								Start: ast.Position{
									Column: 16,
									Line:   36,
								},
							},
						},
						Value: "rate-check",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   37,
							},
							File:   "deadman_empty_test.flux",
							Source: "_check_name: \"Rate Check\"",
							Start: ast.Position{
								Column: 5,
								Line:   37,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   37,
								},
								File:   "deadman_empty_test.flux",
								Source: "_check_name",
								Start: ast.Position{
									Column: 5,
									Line:   37,
								},
							},
						},
						Name: "_check_name",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   37,
								},
								File:   "deadman_empty_test.flux",
								Source: "\"Rate Check\"",
								Start: ast.Position{
									Column: 18,
									Line:   37,
								},
							},
						},
						Value: "Rate Check",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   39,
							},
							File:   "deadman_empty_test.flux",
							Source: "_type: \"deadman\"",
							Start: ast.Position{
								Column: 5,
								Line:   39,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: []ast.Comment{ast.Comment{Text: "// tickscript?\n"}},
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   39,
								},
								File:   "deadman_empty_test.flux",
								Source: "_type",
								Start: ast.Position{
									Column: 5,
									Line:   39,
								},
							},
						},
						Name: "_type",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   39,
								},
								File:   "deadman_empty_test.flux",
								Source: "\"deadman\"",
								Start: ast.Position{
									Column: 12,
									Line:   39,
								},
							},
						},
						Value: "deadman",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   40,
							},
							File:   "deadman_empty_test.flux",
							Source: "tags: {}",
							Start: ast.Position{
								Column: 5,
								Line:   40,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   40,
								},
								File:   "deadman_empty_test.flux",
								Source: "tags",
								Start: ast.Position{
									Column: 5,
									Line:   40,
								},
							},
						},
						Name: "tags",
					},
					Separator: nil,
					Value: &ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   40,
								},
								File:   "deadman_empty_test.flux",
								Source: "{}",
								Start: ast.Position{
									Column: 11,
									Line:   40,
								},
							},
						},
						Lbrace:     nil,
						Properties: []*ast.Property{},
						Rbrace:     nil,
						With:       nil,
					},
				}},
				Rbrace: nil,
				With:   nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 38,
						Line:   42,
					},
					File:   "deadman_empty_test.flux",
					Source: "metric_type = \"kafka_message_in_rate\"",
					Start: ast.Position{
						Column: 1,
						Line:   42,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   42,
						},
						File:   "deadman_empty_test.flux",
						Source: "metric_type",
						Start: ast.Position{
							Column: 1,
							Line:   42,
						},
					},
				},
				Name: "metric_type",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 38,
							Line:   42,
						},
						File:   "deadman_empty_test.flux",
						Source: "\"kafka_message_in_rate\"",
						Start: ast.Position{
							Column: 15,
							Line:   42,
						},
					},
				},
				Value: "kafka_message_in_rate",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   43,
					},
					File:   "deadman_empty_test.flux",
					Source: "tier = \"ft\"",
					Start: ast.Position{
						Column: 1,
						Line:   43,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   43,
						},
						File:   "deadman_empty_test.flux",
						Source: "tier",
						Start: ast.Position{
							Column: 1,
							Line:   43,
						},
					},
				},
				Name: "tier",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   43,
						},
						File:   "deadman_empty_test.flux",
						Source: "\"ft\"",
						Start: ast.Position{
							Column: 8,
							Line:   43,
						},
					},
				},
				Value: "ft",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   57,
					},
					File:   "deadman_empty_test.flux",
					Source: "tickscript_deadman = (table=<-) => table\n    |> range(start: 2020-11-25T14:05:15Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\",\n    )\n    // to avoid issue with validation\n    |> drop(columns: [\"details\"])\n    |> drop(columns: [\"_time\"])",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   44,
						},
						File:   "deadman_empty_test.flux",
						Source: "tickscript_deadman",
						Start: ast.Position{
							Column: 1,
							Line:   44,
						},
					},
				},
				Name: "tickscript_deadman",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   57,
						},
						File:   "deadman_empty_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2020-11-25T14:05:15Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\",\n    )\n    // to avoid issue with validation\n    |> drop(columns: [\"details\"])\n    |> drop(columns: [\"_time\"])",
						Start: ast.Position{
							Column: 22,
							Line:   44,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   44,
														},
														File:   "deadman_empty_test.flux",
														Source: "table",
														Start: ast.Position{
															Column: 36,
															Line:   44,
														},
													},
												},
												Name: "table",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   45,
													},
													File:   "deadman_empty_test.flux",
													Source: "table\n    |> range(start: 2020-11-25T14:05:15Z)",
													Start: ast.Position{
														Column: 36,
														Line:   44,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   45,
															},
															File:   "deadman_empty_test.flux",
															Source: "start: 2020-11-25T14:05:15Z",
															Start: ast.Position{
																Column: 14,
																Line:   45,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   45,
																},
																File:   "deadman_empty_test.flux",
																Source: "start: 2020-11-25T14:05:15Z",
																Start: ast.Position{
																	Column: 14,
																	Line:   45,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 19,
																		Line:   45,
																	},
																	File:   "deadman_empty_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 14,
																		Line:   45,
																	},
																},
															},
															Name: "start",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   45,
																	},
																	File:   "deadman_empty_test.flux",
																	Source: "2020-11-25T14:05:15Z",
																	Start: ast.Position{
																		Column: 21,
																		Line:   45,
																	},
																},
															},
															Value: parser.MustParseTime("2020-11-25T14:05:15Z"),
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   45,
														},
														File:   "deadman_empty_test.flux",
														Source: "range(start: 2020-11-25T14:05:15Z)",
														Start: ast.Position{
															Column: 8,
															Line:   45,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 13,
																Line:   45,
															},
															File:   "deadman_empty_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 8,
																Line:   45,
															},
														},
													},
													Name: "range",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 100,
													Line:   46,
												},
												File:   "deadman_empty_test.flux",
												Source: "table\n    |> range(start: 2020-11-25T14:05:15Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)",
												Start: ast.Position{
													Column: 36,
													Line:   44,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 99,
															Line:   46,
														},
														File:   "deadman_empty_test.flux",
														Source: "fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier",
														Start: ast.Position{
															Column: 15,
															Line:   46,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 99,
																Line:   46,
															},
															File:   "deadman_empty_test.flux",
															Source: "fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier",
															Start: ast.Position{
																Column: 15,
																Line:   46,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 17,
																	Line:   46,
																},
																File:   "deadman_empty_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 15,
																	Line:   46,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.FunctionExpression{
														Arrow: nil,
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 99,
																	Line:   46,
																},
																File:   "deadman_empty_test.flux",
																Source: "(r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier",
																Start: ast.Position{
																	Column: 19,
																	Line:   46,
																},
															},
														},
														Body: &ast.LogicalExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 99,
																		Line:   46,
																	},
																	File:   "deadman_empty_test.flux",
																	Source: "r._measurement == \"testm\" and r._field == metric_type and r.realm == tier",
																	Start: ast.Position{
																		Column: 26,
																		Line:   46,
																	},
																},
															},
															Left: &ast.LogicalExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 79,
																			Line:   46,
																		},
																		File:   "deadman_empty_test.flux",
																		Source: "r._measurement == \"testm\" and r._field == metric_type",
																		Start: ast.Position{
																			Column: 26,
																			Line:   46,
																		},
																	},
																},
																Left: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 51,
																				Line:   46,
																			},
																			File:   "deadman_empty_test.flux",
																			Source: "r._measurement == \"testm\"",
																			Start: ast.Position{
																				Column: 26,
																				Line:   46,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 40,
																					Line:   46,
																				},
																				File:   "deadman_empty_test.flux",
																				Source: "r._measurement",
																				Start: ast.Position{
																					Column: 26,
																					Line:   46,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 27,
																						Line:   46,
																					},
																					File:   "deadman_empty_test.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 26,
																						Line:   46,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 40,
																						Line:   46,
																					},
																					File:   "deadman_empty_test.flux",
																					Source: "_measurement",
																					Start: ast.Position{
																						Column: 28,
																						Line:   46,
																					},
																				},
																			},
																			Name: "_measurement",
																		},
																		Rbrack: nil,
																	},
																	Operator: 17,
																	Right: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 51,
																					Line:   46,
																				},
																				File:   "deadman_empty_test.flux",
																				Source: "\"testm\"",
																				Start: ast.Position{
																					Column: 44,
																					Line:   46,
																				},
																			},
																		},
																		Value: "testm",
																	},
																},
																Operator: 1,
																Right: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 79,
																				Line:   46,
																			},
																			File:   "deadman_empty_test.flux",
																			Source: "r._field == metric_type",
																			Start: ast.Position{
																				Column: 56,
																				Line:   46,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 64,
																					Line:   46,
																				},
																				File:   "deadman_empty_test.flux",
																				Source: "r._field",
																				Start: ast.Position{
																					Column: 56,
																					Line:   46,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 57,
																						Line:   46,
																					},
																					File:   "deadman_empty_test.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 56,
																						Line:   46,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 64,
																						Line:   46,
																					},
																					File:   "deadman_empty_test.flux",
																					Source: "_field",
																					Start: ast.Position{
																						Column: 58,
																						Line:   46,
																					},
																				},
																			},
																			Name: "_field",
																		},
																		Rbrack: nil,
																	},
																	Operator: 17,
																	Right: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 79,
																					Line:   46,
																				},
																				File:   "deadman_empty_test.flux",
																				Source: "metric_type",
																				Start: ast.Position{
																					Column: 68,
																					Line:   46,
																				},
																			},
																		},
																		Name: "metric_type",
																	},
																},
															},
															Operator: 1,
															Right: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 99,
																			Line:   46,
																		},
																		File:   "deadman_empty_test.flux",
																		Source: "r.realm == tier",
																		Start: ast.Position{
																			Column: 84,
																			Line:   46,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 91,
																				Line:   46,
																			},
																			File:   "deadman_empty_test.flux",
																			Source: "r.realm",
																			Start: ast.Position{
																				Column: 84,
																				Line:   46,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 85,
																					Line:   46,
																				},
																				File:   "deadman_empty_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 84,
																					Line:   46,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 91,
																					Line:   46,
																				},
																				File:   "deadman_empty_test.flux",
																				Source: "realm",
																				Start: ast.Position{
																					Column: 86,
																					Line:   46,
																				},
																			},
																		},
																		Name: "realm",
																	},
																	Rbrack: nil,
																},
																Operator: 17,
																Right: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 99,
																				Line:   46,
																			},
																			File:   "deadman_empty_test.flux",
																			Source: "tier",
																			Start: ast.Position{
																				Column: 95,
																				Line:   46,
																			},
																		},
																	},
																	Name: "tier",
																},
															},
														},
														Lparen: nil,
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   46,
																	},
																	File:   "deadman_empty_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 20,
																		Line:   46,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   46,
																		},
																		File:   "deadman_empty_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 20,
																			Line:   46,
																		},
																	},
																},
																Name: "r",
															},
															Separator: nil,
															Value:     nil,
														}},
														Rparan: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 100,
														Line:   46,
													},
													File:   "deadman_empty_test.flux",
													Source: "filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)",
													Start: ast.Position{
														Column: 8,
														Line:   46,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   46,
														},
														File:   "deadman_empty_test.flux",
														Source: "filter",
														Start: ast.Position{
															Column: 8,
															Line:   46,
														},
													},
												},
												Name: "filter",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   47,
											},
											File:   "deadman_empty_test.flux",
											Source: "table\n    |> range(start: 2020-11-25T14:05:15Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()",
											Start: ast.Position{
												Column: 36,
												Line:   44,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   47,
												},
												File:   "deadman_empty_test.flux",
												Source: "schema.fieldsAsCols()",
												Start: ast.Position{
													Column: 8,
													Line:   47,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   47,
													},
													File:   "deadman_empty_test.flux",
													Source: "schema.fieldsAsCols",
													Start: ast.Position{
														Column: 8,
														Line:   47,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   47,
														},
														File:   "deadman_empty_test.flux",
														Source: "schema",
														Start: ast.Position{
															Column: 8,
															Line:   47,
														},
													},
												},
												Name: "schema",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   47,
														},
														File:   "deadman_empty_test.flux",
														Source: "fieldsAsCols",
														Start: ast.Position{
															Column: 15,
															Line:   47,
														},
													},
												},
												Name: "fieldsAsCols",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   48,
										},
										File:   "deadman_empty_test.flux",
										Source: "table\n    |> range(start: 2020-11-25T14:05:15Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])",
										Start: ast.Position{
											Column: 36,
											Line:   44,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   48,
												},
												File:   "deadman_empty_test.flux",
												Source: "columns: [\"host\", \"realm\"]",
												Start: ast.Position{
													Column: 27,
													Line:   48,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   48,
													},
													File:   "deadman_empty_test.flux",
													Source: "columns: [\"host\", \"realm\"]",
													Start: ast.Position{
														Column: 27,
														Line:   48,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   48,
														},
														File:   "deadman_empty_test.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 27,
															Line:   48,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 53,
															Line:   48,
														},
														File:   "deadman_empty_test.flux",
														Source: "[\"host\", \"realm\"]",
														Start: ast.Position{
															Column: 36,
															Line:   48,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 43,
																Line:   48,
															},
															File:   "deadman_empty_test.flux",
															Source: "\"host\"",
															Start: ast.Position{
																Column: 37,
																Line:   48,
															},
														},
													},
													Value: "host",
												}, &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 52,
																Line:   48,
															},
															File:   "deadman_empty_test.flux",
															Source: "\"realm\"",
															Start: ast.Position{
																Column: 45,
																Line:   48,
															},
														},
													},
													Value: "realm",
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   48,
											},
											File:   "deadman_empty_test.flux",
											Source: "tickscript.groupBy(columns: [\"host\", \"realm\"])",
											Start: ast.Position{
												Column: 8,
												Line:   48,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   48,
												},
												File:   "deadman_empty_test.flux",
												Source: "tickscript.groupBy",
												Start: ast.Position{
													Column: 8,
													Line:   48,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   48,
													},
													File:   "deadman_empty_test.flux",
													Source: "tickscript",
													Start: ast.Position{
														Column: 8,
														Line:   48,
													},
												},
											},
											Name: "tickscript",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   48,
													},
													File:   "deadman_empty_test.flux",
													Source: "groupBy",
													Start: ast.Position{
														Column: 19,
														Line:   48,
													},
												},
											},
											Name: "groupBy",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   54,
									},
									File:   "deadman_empty_test.flux",
									Source: "table\n    |> range(start: 2020-11-25T14:05:15Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\",\n    )",
									Start: ast.Position{
										Column: 36,
										Line:   44,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 95,
												Line:   53,
											},
											File:   "deadman_empty_test.flux",
											Source: "check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\"",
											Start: ast.Position{
												Column: 9,
												Line:   50,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   50,
												},
												File:   "deadman_empty_test.flux",
												Source: "check: check",
												Start: ast.Position{
													Column: 9,
													Line:   50,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   50,
													},
													File:   "deadman_empty_test.flux",
													Source: "check",
													Start: ast.Position{
														Column: 9,
														Line:   50,
													},
												},
											},
											Name: "check",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   50,
													},
													File:   "deadman_empty_test.flux",
													Source: "check",
													Start: ast.Position{
														Column: 16,
														Line:   50,
													},
												},
											},
											Name: "check",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   51,
												},
												File:   "deadman_empty_test.flux",
												Source: "measurement: \"testm\"",
												Start: ast.Position{
													Column: 9,
													Line:   51,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   51,
													},
													File:   "deadman_empty_test.flux",
													Source: "measurement",
													Start: ast.Position{
														Column: 9,
														Line:   51,
													},
												},
											},
											Name: "measurement",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   51,
													},
													File:   "deadman_empty_test.flux",
													Source: "\"testm\"",
													Start: ast.Position{
														Column: 22,
														Line:   51,
													},
												},
											},
											Value: "testm",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   52,
												},
												File:   "deadman_empty_test.flux",
												Source: "threshold: 10",
												Start: ast.Position{
													Column: 9,
													Line:   52,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   52,
													},
													File:   "deadman_empty_test.flux",
													Source: "threshold",
													Start: ast.Position{
														Column: 9,
														Line:   52,
													},
												},
											},
											Name: "threshold",
										},
										Separator: nil,
										Value: &ast.IntegerLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   52,
													},
													File:   "deadman_empty_test.flux",
													Source: "10",
													Start: ast.Position{
														Column: 20,
														Line:   52,
													},
												},
											},
											Value: int64(10),
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 95,
													Line:   53,
												},
												File:   "deadman_empty_test.flux",
												Source: "id: (r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\"",
												Start: ast.Position{
													Column: 9,
													Line:   53,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   53,
													},
													File:   "deadman_empty_test.flux",
													Source: "id",
													Start: ast.Position{
														Column: 9,
														Line:   53,
													},
												},
											},
											Name: "id",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 95,
														Line:   53,
													},
													File:   "deadman_empty_test.flux",
													Source: "(r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\"",
													Start: ast.Position{
														Column: 13,
														Line:   53,
													},
												},
											},
											Body: &ast.StringExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 95,
															Line:   53,
														},
														File:   "deadman_empty_test.flux",
														Source: "\"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\"",
														Start: ast.Position{
															Column: 20,
															Line:   53,
														},
													},
												},
												Parts: []ast.StringExpressionPart{&ast.TextPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   53,
															},
															File:   "deadman_empty_test.flux",
															Source: "Realm: ",
															Start: ast.Position{
																Column: 21,
																Line:   53,
															},
														},
													},
													Value: "Realm: ",
												}, &ast.InterpolatedPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   53,
															},
															File:   "deadman_empty_test.flux",
															Source: "${tier}",
															Start: ast.Position{
																Column: 28,
																Line:   53,
															},
														},
													},
													Expression: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   53,
																},
																File:   "deadman_empty_test.flux",
																Source: "tier",
																Start: ast.Position{
																	Column: 30,
																	Line:   53,
																},
															},
														},
														Name: "tier",
													},
												}, &ast.TextPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 66,
																Line:   53,
															},
															File:   "deadman_empty_test.flux",
															Source: " - Hostname: unknown / Metric: ",
															Start: ast.Position{
																Column: 35,
																Line:   53,
															},
														},
													},
													Value: " - Hostname: unknown / Metric: ",
												}, &ast.InterpolatedPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 80,
																Line:   53,
															},
															File:   "deadman_empty_test.flux",
															Source: "${metric_type}",
															Start: ast.Position{
																Column: 66,
																Line:   53,
															},
														},
													},
													Expression: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 79,
																	Line:   53,
																},
																File:   "deadman_empty_test.flux",
																Source: "metric_type",
																Start: ast.Position{
																	Column: 68,
																	Line:   53,
																},
															},
														},
														Name: "metric_type",
													},
												}, &ast.TextPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 94,
																Line:   53,
															},
															File:   "deadman_empty_test.flux",
															Source: " deadman alert",
															Start: ast.Position{
																Column: 80,
																Line:   53,
															},
														},
													},
													Value: " deadman alert",
												}},
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   53,
														},
														File:   "deadman_empty_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   53,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   53,
															},
															File:   "deadman_empty_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   53,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   54,
										},
										File:   "deadman_empty_test.flux",
										Source: "tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\",\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   49,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   49,
											},
											File:   "deadman_empty_test.flux",
											Source: "tickscript.deadman",
											Start: ast.Position{
												Column: 8,
												Line:   49,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   49,
												},
												File:   "deadman_empty_test.flux",
												Source: "tickscript",
												Start: ast.Position{
													Column: 8,
													Line:   49,
												},
											},
										},
										Name: "tickscript",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   49,
												},
												File:   "deadman_empty_test.flux",
												Source: "deadman",
												Start: ast.Position{
													Column: 19,
													Line:   49,
												},
											},
										},
										Name: "deadman",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: []ast.Comment{ast.Comment{Text: "// to avoid issue with validation\n"}},
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   56,
								},
								File:   "deadman_empty_test.flux",
								Source: "table\n    |> range(start: 2020-11-25T14:05:15Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\",\n    )\n    // to avoid issue with validation\n    |> drop(columns: [\"details\"])",
								Start: ast.Position{
									Column: 36,
									Line:   44,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   56,
										},
										File:   "deadman_empty_test.flux",
										Source: "columns: [\"details\"]",
										Start: ast.Position{
											Column: 13,
											Line:   56,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   56,
											},
											File:   "deadman_empty_test.flux",
											Source: "columns: [\"details\"]",
											Start: ast.Position{
												Column: 13,
												Line:   56,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   56,
												},
												File:   "deadman_empty_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 13,
													Line:   56,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   56,
												},
												File:   "deadman_empty_test.flux",
												Source: "[\"details\"]",
												Start: ast.Position{
													Column: 22,
													Line:   56,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   56,
													},
													File:   "deadman_empty_test.flux",
													Source: "\"details\"",
													Start: ast.Position{
														Column: 23,
														Line:   56,
													},
												},
											},
											Value: "details",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   56,
									},
									File:   "deadman_empty_test.flux",
									Source: "drop(columns: [\"details\"])",
									Start: ast.Position{
										Column: 8,
										Line:   56,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   56,
										},
										File:   "deadman_empty_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 8,
											Line:   56,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   57,
							},
							File:   "deadman_empty_test.flux",
							Source: "table\n    |> range(start: 2020-11-25T14:05:15Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${tier} - Hostname: unknown / Metric: ${metric_type} deadman alert\",\n    )\n    // to avoid issue with validation\n    |> drop(columns: [\"details\"])\n    |> drop(columns: [\"_time\"])",
							Start: ast.Position{
								Column: 36,
								Line:   44,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   57,
									},
									File:   "deadman_empty_test.flux",
									Source: "columns: [\"_time\"]",
									Start: ast.Position{
										Column: 13,
										Line:   57,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   57,
										},
										File:   "deadman_empty_test.flux",
										Source: "columns: [\"_time\"]",
										Start: ast.Position{
											Column: 13,
											Line:   57,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   57,
											},
											File:   "deadman_empty_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   57,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   57,
											},
											File:   "deadman_empty_test.flux",
											Source: "[\"_time\"]",
											Start: ast.Position{
												Column: 22,
												Line:   57,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   57,
												},
												File:   "deadman_empty_test.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 23,
													Line:   57,
												},
											},
										},
										Value: "_time",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   57,
								},
								File:   "deadman_empty_test.flux",
								Source: "drop(columns: [\"_time\"])",
								Start: ast.Position{
									Column: 8,
									Line:   57,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   57,
									},
									File:   "deadman_empty_test.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 8,
										Line:   57,
									},
								},
							},
							Name: "drop",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   44,
							},
							File:   "deadman_empty_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 23,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   44,
								},
								File:   "deadman_empty_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 23,
									Line:   44,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   44,
							},
							File:   "deadman_empty_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 29,
								Line:   44,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   63,
						},
						File:   "deadman_empty_test.flux",
						Source: "_tickscript_deadman = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_deadman,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   59,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   59,
							},
							File:   "deadman_empty_test.flux",
							Source: "_tickscript_deadman",
							Start: ast.Position{
								Column: 6,
								Line:   59,
							},
						},
					},
					Name: "_tickscript_deadman",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   63,
							},
							File:   "deadman_empty_test.flux",
							Source: "() => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_deadman,\n})",
							Start: ast.Position{
								Column: 28,
								Line:   59,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   63,
								},
								File:   "deadman_empty_test.flux",
								Source: "({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_deadman,\n})",
								Start: ast.Position{
									Column: 34,
									Line:   59,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   63,
									},
									File:   "deadman_empty_test.flux",
									Source: "{\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_deadman,\n}",
									Start: ast.Position{
										Column: 35,
										Line:   59,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   60,
										},
										File:   "deadman_empty_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 5,
											Line:   60,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   60,
											},
											File:   "deadman_empty_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 5,
												Line:   60,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   60,
												},
												File:   "deadman_empty_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 32,
													Line:   60,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   60,
													},
													File:   "deadman_empty_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 32,
														Line:   60,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   60,
														},
														File:   "deadman_empty_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 32,
															Line:   60,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   60,
														},
														File:   "deadman_empty_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 37,
															Line:   60,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   60,
											},
											File:   "deadman_empty_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 12,
												Line:   60,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   60,
												},
												File:   "deadman_empty_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 12,
													Line:   60,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   60,
													},
													File:   "deadman_empty_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 12,
														Line:   60,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   60,
													},
													File:   "deadman_empty_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 20,
														Line:   60,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   61,
										},
										File:   "deadman_empty_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 5,
											Line:   61,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   61,
											},
											File:   "deadman_empty_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 5,
												Line:   61,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   61,
												},
												File:   "deadman_empty_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 27,
													Line:   61,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   61,
													},
													File:   "deadman_empty_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 27,
														Line:   61,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   61,
														},
														File:   "deadman_empty_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   61,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   61,
														},
														File:   "deadman_empty_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 32,
															Line:   61,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   61,
											},
											File:   "deadman_empty_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 11,
												Line:   61,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   61,
												},
												File:   "deadman_empty_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   61,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   61,
													},
													File:   "deadman_empty_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   61,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   61,
													},
													File:   "deadman_empty_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   61,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   62,
										},
										File:   "deadman_empty_test.flux",
										Source: "fn: tickscript_deadman",
										Start: ast.Position{
											Column: 5,
											Line:   62,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   62,
											},
											File:   "deadman_empty_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 5,
												Line:   62,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   62,
											},
											File:   "deadman_empty_test.flux",
											Source: "tickscript_deadman",
											Start: ast.Position{
												Column: 9,
												Line:   62,
											},
										},
									},
									Name: "tickscript_deadman",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   63,
					},
					File:   "deadman_empty_test.flux",
					Source: "test _tickscript_deadman = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_deadman,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   59,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "deadman_empty_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "deadman_empty_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   5,
					},
					File:   "deadman_empty_test.flux",
					Source: "import \"csv\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   5,
						},
						File:   "deadman_empty_test.flux",
						Source: "\"csv\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "csv",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 39,
						Line:   6,
					},
					File:   "deadman_empty_test.flux",
					Source: "import \"contrib/bonitoo-io/tickscript\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 39,
							Line:   6,
						},
						File:   "deadman_empty_test.flux",
						Source: "\"contrib/bonitoo-io/tickscript\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "contrib/bonitoo-io/tickscript",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   7,
					},
					File:   "deadman_empty_test.flux",
					Source: "import \"influxdata/influxdb/monitor\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   7,
						},
						File:   "deadman_empty_test.flux",
						Source: "\"influxdata/influxdb/monitor\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "influxdata/influxdb/monitor",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 36,
						Line:   8,
					},
					File:   "deadman_empty_test.flux",
					Source: "import \"influxdata/influxdb/schema\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   8,
						},
						File:   "deadman_empty_test.flux",
						Source: "\"influxdata/influxdb/schema\"",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				Value: "influxdata/influxdb/schema",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "deadman_empty_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   1,
					},
					File:   "deadman_empty_test.flux",
					Source: "package tickscript_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   1,
						},
						File:   "deadman_empty_test.flux",
						Source: "tickscript_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "tickscript_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   63,
				},
				File:   "deadman_threshold_test.flux",
				Source: "package tickscript_test\n\n\nimport \"testing\"\nimport \"csv\"\nimport \"contrib/bonitoo-io/tickscript\"\nimport \"influxdata/influxdb/monitor\"\nimport \"influxdata/influxdb/schema\"\n\noption now = () => 2020-11-25T14:05:30Z\n\n// overwrite as buckets are not avail in Flux tests\noption monitor.write = (tables=<-) => tables\noption monitor.log = (tables=<-) => tables\n\ninData = \"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,true,false,true,false,true,false,true\n#datatype,string,long,string,string,string,string,string,string,long,string,boolean,string,string,string\n#default,_result,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,dead,host,id,realm\n,,0,rate-check,Rate Check,crit,statuses,Deadman Check: Rate Check is: dead,testm,1606313130000000000,deadman,true,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate deadman alert,ft\n\"\ncheck = {\n    _check_id: \"rate-check\",\n    _check_name: \"Rate Check\",\n    // tickscript?\n    _type: \"deadman\",\n    tags: {},\n}\nmetric_type = \"kafka_message_in_rate\"\ntier = \"ft\"\ntickscript_deadman = (table=<-) => table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\",\n    )\n    // to avoid issue with validation\n    |> drop(columns: [\"details\"])\n    |> drop(columns: [\"_time\"])\n\ntest _tickscript_deadman = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_deadman,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   10,
						},
						File:   "deadman_threshold_test.flux",
						Source: "now = () => 2020-11-25T14:05:30Z",
						Start: ast.Position{
							Column: 8,
							Line:   10,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   10,
							},
							File:   "deadman_threshold_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   10,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   10,
							},
							File:   "deadman_threshold_test.flux",
							Source: "() => 2020-11-25T14:05:30Z",
							Start: ast.Position{
								Column: 14,
								Line:   10,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   10,
								},
								File:   "deadman_threshold_test.flux",
								Source: "2020-11-25T14:05:30Z",
								Start: ast.Position{
									Column: 20,
									Line:   10,
								},
							},
						},
						Value: parser.MustParseTime("2020-11-25T14:05:30Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   10,
					},
					File:   "deadman_threshold_test.flux",
					Source: "option now = () => 2020-11-25T14:05:30Z",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 45,
							Line:   13,
						},
						File:   "deadman_threshold_test.flux",
						Source: "monitor.write = (tables=<-) => tables",
						Start: ast.Position{
							Column: 8,
							Line:   13,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   13,
							},
							File:   "deadman_threshold_test.flux",
							Source: "(tables=<-) => tables",
							Start: ast.Position{
								Column: 24,
								Line:   13,
							},
						},
					},
					Body: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   13,
								},
								File:   "deadman_threshold_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 39,
									Line:   13,
								},
							},
						},
						Name: "tables",
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   13,
								},
								File:   "deadman_threshold_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 25,
									Line:   13,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   13,
									},
									File:   "deadman_threshold_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   13,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   13,
								},
								File:   "deadman_threshold_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 32,
									Line:   13,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   13,
							},
							File:   "deadman_threshold_test.flux",
							Source: "monitor.write",
							Start: ast.Position{
								Column: 8,
								Line:   13,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   13,
								},
								File:   "deadman_threshold_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   13,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   13,
								},
								File:   "deadman_threshold_test.flux",
								Source: "write",
								Start: ast.Position{
									Column: 16,
									Line:   13,
								},
							},
						},
						Name: "write",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// overwrite as buckets are not avail in Flux tests\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 45,
						Line:   13,
					},
					File:   "deadman_threshold_test.flux",
					Source: "option monitor.write = (tables=<-) => tables",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 43,
							Line:   14,
						},
						File:   "deadman_threshold_test.flux",
						Source: "monitor.log = (tables=<-) => tables",
						Start: ast.Position{
							Column: 8,
							Line:   14,
						},
					},
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   14,
							},
							File:   "deadman_threshold_test.flux",
							Source: "(tables=<-) => tables",
							Start: ast.Position{
								Column: 22,
								Line:   14,
							},
						},
					},
					Body: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   14,
								},
								File:   "deadman_threshold_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 37,
									Line:   14,
								},
							},
						},
						Name: "tables",
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   14,
								},
								File:   "deadman_threshold_test.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 23,
									Line:   14,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   14,
									},
									File:   "deadman_threshold_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 23,
										Line:   14,
									},
								},
							},
							Name: "tables",
						},
						Separator: nil,
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   14,
								},
								File:   "deadman_threshold_test.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 30,
									Line:   14,
								},
							},
						}},
					}},
					Rparan: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   14,
							},
							File:   "deadman_threshold_test.flux",
							Source: "monitor.log",
							Start: ast.Position{
								Column: 8,
								Line:   14,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   14,
								},
								File:   "deadman_threshold_test.flux",
								Source: "monitor",
								Start: ast.Position{
									Column: 8,
									Line:   14,
								},
							},
						},
						Name: "monitor",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   14,
								},
								File:   "deadman_threshold_test.flux",
								Source: "log",
								Start: ast.Position{
									Column: 16,
									Line:   14,
								},
							},
						},
						Name: "log",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 43,
						Line:   14,
					},
					File:   "deadman_threshold_test.flux",
					Source: "option monitor.log = (tables=<-) => tables",
					Start: ast.Position{
						Column: 1,
						Line:   14,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   27,
					},
					File:   "deadman_threshold_test.flux",
					Source: "inData = \"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   16,
						},
						File:   "deadman_threshold_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   16,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   27,
						},
						File:   "deadman_threshold_test.flux",
						Source: "\"\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   16,
						},
					},
				},
				Value: "\n#group,false,false,false,false,true,true,true,true\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,realm\n,,0,2020-11-25T14:05:03.477635916Z,1.819231109049999,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:04.541635074Z,1.635878190200181,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:05.623191313Z,39.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:06.696061106Z,26.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:07.768317097Z,8.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n,,0,2020-11-25T14:05:08.868317091Z,1.33716449678206,kafka_message_in_rate,testm,kafka07,ft\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   34,
					},
					File:   "deadman_threshold_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,true,false,true,false,true,false,true\n#datatype,string,long,string,string,string,string,string,string,long,string,boolean,string,string,string\n#default,_result,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,dead,host,id,realm\n,,0,rate-check,Rate Check,crit,statuses,Deadman Check: Rate Check is: dead,testm,1606313130000000000,deadman,true,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate deadman alert,ft\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   28,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   28,
						},
						File:   "deadman_threshold_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   28,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   34,
						},
						File:   "deadman_threshold_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,true,false,true,false,true,false,true\n#datatype,string,long,string,string,string,string,string,string,long,string,boolean,string,string,string\n#default,_result,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,dead,host,id,realm\n,,0,rate-check,Rate Check,crit,statuses,Deadman Check: Rate Check is: dead,testm,1606313130000000000,deadman,true,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate deadman alert,ft\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   28,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,true,false,true,false,true,false,true\n#datatype,string,long,string,string,string,string,string,string,long,string,boolean,string,string,string\n#default,_result,,,,,,,,,,,,,\n,result,table,_check_id,_check_name,_level,_measurement,_message,_source_measurement,_source_timestamp,_type,dead,host,id,realm\n,,0,rate-check,Rate Check,crit,statuses,Deadman Check: Rate Check is: dead,testm,1606313130000000000,deadman,true,kafka07,Realm: ft - Hostname: kafka07 / Metric: kafka_message_in_rate deadman alert,ft\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   41,
					},
					File:   "deadman_threshold_test.flux",
					Source: "check = {\n    _check_id: \"rate-check\",\n    _check_name: \"Rate Check\",\n    // tickscript?\n    _type: \"deadman\",\n    tags: {},\n}",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   35,
						},
						File:   "deadman_threshold_test.flux",
						Source: "check",
						Start: ast.Position{
							Column: 1,
							Line:   35,
						},
					},
				},
				Name: "check",
			},
			Init: &ast.ObjectExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   41,
						},
						File:   "deadman_threshold_test.flux",
						Source: "{\n    _check_id: \"rate-check\",\n    _check_name: \"Rate Check\",\n    // tickscript?\n    _type: \"deadman\",\n    tags: {},\n}",
						Start: ast.Position{
							Column: 9,
							Line:   35,
						},
					},
				},
				Lbrace: nil,
				Properties: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   36,
							},
							File:   "deadman_threshold_test.flux",
							Source: "_check_id: \"rate-check\"",
							Start: ast.Position{
								Column: 5,
								Line:   36,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   36,
								},
								File:   "deadman_threshold_test.flux",
								Source: "_check_id",
								Start: ast.Position{
									Column: 5,
									Line:   36,
								},
							},
						},
						Name: "_check_id",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   36,
								},
								File:   "deadman_threshold_test.flux",
								Source: "\"rate-check\"",
								Start: ast.Position{
									Column: 16,
									Line:   36,
								},
							},
						},
						Value: "rate-check",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   37,
							},
							File:   "deadman_threshold_test.flux",
							Source: "_check_name: \"Rate Check\"",
							Start: ast.Position{
								Column: 5,
								Line:   37,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   37,
								},
								File:   "deadman_threshold_test.flux",
								Source: "_check_name",
								Start: ast.Position{
									Column: 5,
									Line:   37,
								},
							},
						},
						Name: "_check_name",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   37,
								},
								File:   "deadman_threshold_test.flux",
								Source: "\"Rate Check\"",
								Start: ast.Position{
									Column: 18,
									Line:   37,
								},
							},
						},
						Value: "Rate Check",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   39,
							},
							File:   "deadman_threshold_test.flux",
							Source: "_type: \"deadman\"",
							Start: ast.Position{
								Column: 5,
								Line:   39,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: []ast.Comment{ast.Comment{Text: "// tickscript?\n"}},
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   39,
								},
								File:   "deadman_threshold_test.flux",
								Source: "_type",
								Start: ast.Position{
									Column: 5,
									Line:   39,
								},
							},
						},
						Name: "_type",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   39,
								},
								File:   "deadman_threshold_test.flux",
								Source: "\"deadman\"",
								Start: ast.Position{
									Column: 12,
									Line:   39,
								},
							},
						},
						Value: "deadman",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   40,
							},
							File:   "deadman_threshold_test.flux",
							Source: "tags: {}",
							Start: ast.Position{
								Column: 5,
								Line:   40,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   40,
								},
								File:   "deadman_threshold_test.flux",
								Source: "tags",
								Start: ast.Position{
									Column: 5,
									Line:   40,
								},
							},
						},
						Name: "tags",
					},
					Separator: nil,
					Value: &ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   40,
								},
								File:   "deadman_threshold_test.flux",
								Source: "{}",
								Start: ast.Position{
									Column: 11,
									Line:   40,
								},
							},
						},
						Lbrace:     nil,
						Properties: []*ast.Property{},
						Rbrace:     nil,
						With:       nil,
					},
				}},
				Rbrace: nil,
				With:   nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 38,
						Line:   42,
					},
					File:   "deadman_threshold_test.flux",
					Source: "metric_type = \"kafka_message_in_rate\"",
					Start: ast.Position{
						Column: 1,
						Line:   42,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   42,
						},
						File:   "deadman_threshold_test.flux",
						Source: "metric_type",
						Start: ast.Position{
							Column: 1,
							Line:   42,
						},
					},
				},
				Name: "metric_type",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 38,
							Line:   42,
						},
						File:   "deadman_threshold_test.flux",
						Source: "\"kafka_message_in_rate\"",
						Start: ast.Position{
							Column: 15,
							Line:   42,
						},
					},
				},
				Value: "kafka_message_in_rate",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   43,
					},
					File:   "deadman_threshold_test.flux",
					Source: "tier = \"ft\"",
					Start: ast.Position{
						Column: 1,
						Line:   43,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   43,
						},
						File:   "deadman_threshold_test.flux",
						Source: "tier",
						Start: ast.Position{
							Column: 1,
							Line:   43,
						},
					},
				},
				Name: "tier",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   43,
						},
						File:   "deadman_threshold_test.flux",
						Source: "\"ft\"",
						Start: ast.Position{
							Column: 8,
							Line:   43,
						},
					},
				},
				Value: "ft",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   57,
					},
					File:   "deadman_threshold_test.flux",
					Source: "tickscript_deadman = (table=<-) => table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\",\n    )\n    // to avoid issue with validation\n    |> drop(columns: [\"details\"])\n    |> drop(columns: [\"_time\"])",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   44,
						},
						File:   "deadman_threshold_test.flux",
						Source: "tickscript_deadman",
						Start: ast.Position{
							Column: 1,
							Line:   44,
						},
					},
				},
				Name: "tickscript_deadman",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   57,
						},
						File:   "deadman_threshold_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\",\n    )\n    // to avoid issue with validation\n    |> drop(columns: [\"details\"])\n    |> drop(columns: [\"_time\"])",
						Start: ast.Position{
							Column: 22,
							Line:   44,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   44,
														},
														File:   "deadman_threshold_test.flux",
														Source: "table",
														Start: ast.Position{
															Column: 36,
															Line:   44,
														},
													},
												},
												Name: "table",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   45,
													},
													File:   "deadman_threshold_test.flux",
													Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)",
													Start: ast.Position{
														Column: 36,
														Line:   44,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   45,
															},
															File:   "deadman_threshold_test.flux",
															Source: "start: 2020-11-25T14:05:00Z",
															Start: ast.Position{
																Column: 14,
																Line:   45,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   45,
																},
																File:   "deadman_threshold_test.flux",
																Source: "start: 2020-11-25T14:05:00Z",
																Start: ast.Position{
																	Column: 14,
																	Line:   45,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 19,
																		Line:   45,
																	},
																	File:   "deadman_threshold_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 14,
																		Line:   45,
																	},
																},
															},
															Name: "start",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   45,
																	},
																	File:   "deadman_threshold_test.flux",
																	Source: "2020-11-25T14:05:00Z",
																	Start: ast.Position{
																		Column: 21,
																		Line:   45,
																	},
																},
															},
															Value: parser.MustParseTime("2020-11-25T14:05:00Z"),
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   45,
														},
														File:   "deadman_threshold_test.flux",
														Source: "range(start: 2020-11-25T14:05:00Z)",
														Start: ast.Position{
															Column: 8,
															Line:   45,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 13,
																Line:   45,
															},
															File:   "deadman_threshold_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 8,
																Line:   45,
															},
														},
													},
													Name: "range",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 100,
													Line:   46,
												},
												File:   "deadman_threshold_test.flux",
												Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)",
												Start: ast.Position{
													Column: 36,
													Line:   44,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 99,
															Line:   46,
														},
														File:   "deadman_threshold_test.flux",
														Source: "fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier",
														Start: ast.Position{
															Column: 15,
															Line:   46,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 99,
																Line:   46,
															},
															File:   "deadman_threshold_test.flux",
															Source: "fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier",
															Start: ast.Position{
																Column: 15,
																Line:   46,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 17,
																	Line:   46,
																},
																File:   "deadman_threshold_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 15,
																	Line:   46,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.FunctionExpression{
														Arrow: nil,
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 99,
																	Line:   46,
																},
																File:   "deadman_threshold_test.flux",
																Source: "(r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier",
																Start: ast.Position{
																	Column: 19,
																	Line:   46,
																},
															},
														},
														Body: &ast.LogicalExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 99,
																		Line:   46,
																	},
																	File:   "deadman_threshold_test.flux",
																	Source: "r._measurement == \"testm\" and r._field == metric_type and r.realm == tier",
																	Start: ast.Position{
																		Column: 26,
																		Line:   46,
																	},
																},
															},
															Left: &ast.LogicalExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 79,
																			Line:   46,
																		},
																		File:   "deadman_threshold_test.flux",
																		Source: "r._measurement == \"testm\" and r._field == metric_type",
																		Start: ast.Position{
																			Column: 26,
																			Line:   46,
																		},
																	},
																},
																Left: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 51,
																				Line:   46,
																			},
																			File:   "deadman_threshold_test.flux",
																			Source: "r._measurement == \"testm\"",
																			Start: ast.Position{
																				Column: 26,
																				Line:   46,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 40,
																					Line:   46,
																				},
																				File:   "deadman_threshold_test.flux",
																				Source: "r._measurement",
																				Start: ast.Position{
																					Column: 26,
																					Line:   46,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 27,
																						Line:   46,
																					},
																					File:   "deadman_threshold_test.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 26,
																						Line:   46,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 40,
																						Line:   46,
																					},
																					File:   "deadman_threshold_test.flux",
																					Source: "_measurement",
																					Start: ast.Position{
																						Column: 28,
																						Line:   46,
																					},
																				},
																			},
																			Name: "_measurement",
																		},
																		Rbrack: nil,
																	},
																	Operator: 17,
																	Right: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 51,
																					Line:   46,
																				},
																				File:   "deadman_threshold_test.flux",
																				Source: "\"testm\"",
																				Start: ast.Position{
																					Column: 44,
																					Line:   46,
																				},
																			},
																		},
																		Value: "testm",
																	},
																},
																Operator: 1,
																Right: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 79,
																				Line:   46,
																			},
																			File:   "deadman_threshold_test.flux",
																			Source: "r._field == metric_type",
																			Start: ast.Position{
																				Column: 56,
																				Line:   46,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 64,
																					Line:   46,
																				},
																				File:   "deadman_threshold_test.flux",
																				Source: "r._field",
																				Start: ast.Position{
																					Column: 56,
																					Line:   46,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 57,
																						Line:   46,
																					},
																					File:   "deadman_threshold_test.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 56,
																						Line:   46,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 64,
																						Line:   46,
																					},
																					File:   "deadman_threshold_test.flux",
																					Source: "_field",
																					Start: ast.Position{
																						Column: 58,
																						Line:   46,
																					},
																				},
																			},
																			Name: "_field",
																		},
																		Rbrack: nil,
																	},
																	Operator: 17,
																	Right: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 79,
																					Line:   46,
																				},
																				File:   "deadman_threshold_test.flux",
																				Source: "metric_type",
																				Start: ast.Position{
																					Column: 68,
																					Line:   46,
																				},
																			},
																		},
																		Name: "metric_type",
																	},
																},
															},
															Operator: 1,
															Right: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 99,
																			Line:   46,
																		},
																		File:   "deadman_threshold_test.flux",
																		Source: "r.realm == tier",
																		Start: ast.Position{
																			Column: 84,
																			Line:   46,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 91,
																				Line:   46,
																			},
																			File:   "deadman_threshold_test.flux",
																			Source: "r.realm",
																			Start: ast.Position{
																				Column: 84,
																				Line:   46,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 85,
																					Line:   46,
																				},
																				File:   "deadman_threshold_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 84,
																					Line:   46,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 91,
																					Line:   46,
																				},
																				File:   "deadman_threshold_test.flux",
																				Source: "realm",
																				Start: ast.Position{
																					Column: 86,
																					Line:   46,
																				},
																			},
																		},
																		Name: "realm",
																	},
																	Rbrack: nil,
																},
																Operator: 17,
																Right: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 99,
																				Line:   46,
																			},
																			File:   "deadman_threshold_test.flux",
																			Source: "tier",
																			Start: ast.Position{
																				Column: 95,
																				Line:   46,
																			},
																		},
																	},
																	Name: "tier",
																},
															},
														},
														Lparen: nil,
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   46,
																	},
																	File:   "deadman_threshold_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 20,
																		Line:   46,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   46,
																		},
																		File:   "deadman_threshold_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 20,
																			Line:   46,
																		},
																	},
																},
																Name: "r",
															},
															Separator: nil,
															Value:     nil,
														}},
														Rparan: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 100,
														Line:   46,
													},
													File:   "deadman_threshold_test.flux",
													Source: "filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)",
													Start: ast.Position{
														Column: 8,
														Line:   46,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   46,
														},
														File:   "deadman_threshold_test.flux",
														Source: "filter",
														Start: ast.Position{
															Column: 8,
															Line:   46,
														},
													},
												},
												Name: "filter",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   47,
											},
											File:   "deadman_threshold_test.flux",
											Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()",
											Start: ast.Position{
												Column: 36,
												Line:   44,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   47,
												},
												File:   "deadman_threshold_test.flux",
												Source: "schema.fieldsAsCols()",
												Start: ast.Position{
													Column: 8,
													Line:   47,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   47,
													},
													File:   "deadman_threshold_test.flux",
													Source: "schema.fieldsAsCols",
													Start: ast.Position{
														Column: 8,
														Line:   47,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   47,
														},
														File:   "deadman_threshold_test.flux",
														Source: "schema",
														Start: ast.Position{
															Column: 8,
															Line:   47,
														},
													},
												},
												Name: "schema",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   47,
														},
														File:   "deadman_threshold_test.flux",
														Source: "fieldsAsCols",
														Start: ast.Position{
															Column: 15,
															Line:   47,
														},
													},
												},
												Name: "fieldsAsCols",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   48,
										},
										File:   "deadman_threshold_test.flux",
										Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])",
										Start: ast.Position{
											Column: 36,
											Line:   44,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   48,
												},
												File:   "deadman_threshold_test.flux",
												Source: "columns: [\"host\", \"realm\"]",
												Start: ast.Position{
													Column: 27,
													Line:   48,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   48,
													},
													File:   "deadman_threshold_test.flux",
													Source: "columns: [\"host\", \"realm\"]",
													Start: ast.Position{
														Column: 27,
														Line:   48,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   48,
														},
														File:   "deadman_threshold_test.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 27,
															Line:   48,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 53,
															Line:   48,
														},
														File:   "deadman_threshold_test.flux",
														Source: "[\"host\", \"realm\"]",
														Start: ast.Position{
															Column: 36,
															Line:   48,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 43,
																Line:   48,
															},
															File:   "deadman_threshold_test.flux",
															Source: "\"host\"",
															Start: ast.Position{
																Column: 37,
																Line:   48,
															},
														},
													},
													Value: "host",
												}, &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 52,
																Line:   48,
															},
															File:   "deadman_threshold_test.flux",
															Source: "\"realm\"",
															Start: ast.Position{
																Column: 45,
																Line:   48,
															},
														},
													},
													Value: "realm",
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   48,
											},
											File:   "deadman_threshold_test.flux",
											Source: "tickscript.groupBy(columns: [\"host\", \"realm\"])",
											Start: ast.Position{
												Column: 8,
												Line:   48,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   48,
												},
												File:   "deadman_threshold_test.flux",
												Source: "tickscript.groupBy",
												Start: ast.Position{
													Column: 8,
													Line:   48,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   48,
													},
													File:   "deadman_threshold_test.flux",
													Source: "tickscript",
													Start: ast.Position{
														Column: 8,
														Line:   48,
													},
												},
											},
											Name: "tickscript",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   48,
													},
													File:   "deadman_threshold_test.flux",
													Source: "groupBy",
													Start: ast.Position{
														Column: 19,
														Line:   48,
													},
												},
											},
											Name: "groupBy",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   54,
									},
									File:   "deadman_threshold_test.flux",
									Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\",\n    )",
									Start: ast.Position{
										Column: 36,
										Line:   44,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 100,
												Line:   53,
											},
											File:   "deadman_threshold_test.flux",
											Source: "check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\"",
											Start: ast.Position{
												Column: 9,
												Line:   50,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   50,
												},
												File:   "deadman_threshold_test.flux",
												Source: "check: check",
												Start: ast.Position{
													Column: 9,
													Line:   50,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   50,
													},
													File:   "deadman_threshold_test.flux",
													Source: "check",
													Start: ast.Position{
														Column: 9,
														Line:   50,
													},
												},
											},
											Name: "check",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   50,
													},
													File:   "deadman_threshold_test.flux",
													Source: "check",
													Start: ast.Position{
														Column: 16,
														Line:   50,
													},
												},
											},
											Name: "check",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   51,
												},
												File:   "deadman_threshold_test.flux",
												Source: "measurement: \"testm\"",
												Start: ast.Position{
													Column: 9,
													Line:   51,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   51,
													},
													File:   "deadman_threshold_test.flux",
													Source: "measurement",
													Start: ast.Position{
														Column: 9,
														Line:   51,
													},
												},
											},
											Name: "measurement",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   51,
													},
													File:   "deadman_threshold_test.flux",
													Source: "\"testm\"",
													Start: ast.Position{
														Column: 22,
														Line:   51,
													},
												},
											},
											Value: "testm",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   52,
												},
												File:   "deadman_threshold_test.flux",
												Source: "threshold: 10",
												Start: ast.Position{
													Column: 9,
													Line:   52,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   52,
													},
													File:   "deadman_threshold_test.flux",
													Source: "threshold",
													Start: ast.Position{
														Column: 9,
														Line:   52,
													},
												},
											},
											Name: "threshold",
										},
										Separator: nil,
										Value: &ast.IntegerLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   52,
													},
													File:   "deadman_threshold_test.flux",
													Source: "10",
													Start: ast.Position{
														Column: 20,
														Line:   52,
													},
												},
											},
											Value: int64(10),
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 100,
													Line:   53,
												},
												File:   "deadman_threshold_test.flux",
												Source: "id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\"",
												Start: ast.Position{
													Column: 9,
													Line:   53,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   53,
													},
													File:   "deadman_threshold_test.flux",
													Source: "id",
													Start: ast.Position{
														Column: 9,
														Line:   53,
													},
												},
											},
											Name: "id",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 100,
														Line:   53,
													},
													File:   "deadman_threshold_test.flux",
													Source: "(r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\"",
													Start: ast.Position{
														Column: 13,
														Line:   53,
													},
												},
											},
											Body: &ast.StringExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 100,
															Line:   53,
														},
														File:   "deadman_threshold_test.flux",
														Source: "\"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\"",
														Start: ast.Position{
															Column: 20,
															Line:   53,
														},
													},
												},
												Parts: []ast.StringExpressionPart{&ast.TextPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   53,
															},
															File:   "deadman_threshold_test.flux",
															Source: "Realm: ",
															Start: ast.Position{
																Column: 21,
																Line:   53,
															},
														},
													},
													Value: "Realm: ",
												}, &ast.InterpolatedPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   53,
															},
															File:   "deadman_threshold_test.flux",
															Source: "${r.realm}",
															Start: ast.Position{
																Column: 28,
																Line:   53,
															},
														},
													},
													Expression: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   53,
																},
																File:   "deadman_threshold_test.flux",
																Source: "r.realm",
																Start: ast.Position{
																	Column: 30,
																	Line:   53,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 31,
																		Line:   53,
																	},
																	File:   "deadman_threshold_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 30,
																		Line:   53,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 37,
																		Line:   53,
																	},
																	File:   "deadman_threshold_test.flux",
																	Source: "realm",
																	Start: ast.Position{
																		Column: 32,
																		Line:   53,
																	},
																},
															},
															Name: "realm",
														},
														Rbrack: nil,
													},
												}, &ast.TextPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 51,
																Line:   53,
															},
															File:   "deadman_threshold_test.flux",
															Source: " - Hostname: ",
															Start: ast.Position{
																Column: 38,
																Line:   53,
															},
														},
													},
													Value: " - Hostname: ",
												}, &ast.InterpolatedPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 60,
																Line:   53,
															},
															File:   "deadman_threshold_test.flux",
															Source: "${r.host}",
															Start: ast.Position{
																Column: 51,
																Line:   53,
															},
														},
													},
													Expression: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 59,
																	Line:   53,
																},
																File:   "deadman_threshold_test.flux",
																Source: "r.host",
																Start: ast.Position{
																	Column: 53,
																	Line:   53,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 54,
																		Line:   53,
																	},
																	File:   "deadman_threshold_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 53,
																		Line:   53,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 59,
																		Line:   53,
																	},
																	File:   "deadman_threshold_test.flux",
																	Source: "host",
																	Start: ast.Position{
																		Column: 55,
																		Line:   53,
																	},
																},
															},
															Name: "host",
														},
														Rbrack: nil,
													},
												}, &ast.TextPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 71,
																Line:   53,
															},
															File:   "deadman_threshold_test.flux",
															Source: " / Metric: ",
															Start: ast.Position{
																Column: 60,
																Line:   53,
															},
														},
													},
													Value: " / Metric: ",
												}, &ast.InterpolatedPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 85,
																Line:   53,
															},
															File:   "deadman_threshold_test.flux",
															Source: "${metric_type}",
															Start: ast.Position{
																Column: 71,
																Line:   53,
															},
														},
													},
													Expression: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 84,
																	Line:   53,
																},
																File:   "deadman_threshold_test.flux",
																Source: "metric_type",
																Start: ast.Position{
																	Column: 73,
																	Line:   53,
																},
															},
														},
														Name: "metric_type",
													},
												}, &ast.TextPart{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 99,
																Line:   53,
															},
															File:   "deadman_threshold_test.flux",
															Source: " deadman alert",
															Start: ast.Position{
																Column: 85,
																Line:   53,
															},
														},
													},
													Value: " deadman alert",
												}},
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   53,
														},
														File:   "deadman_threshold_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   53,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   53,
															},
															File:   "deadman_threshold_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   53,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   54,
										},
										File:   "deadman_threshold_test.flux",
										Source: "tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\",\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   49,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   49,
											},
											File:   "deadman_threshold_test.flux",
											Source: "tickscript.deadman",
											Start: ast.Position{
												Column: 8,
												Line:   49,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   49,
												},
												File:   "deadman_threshold_test.flux",
												Source: "tickscript",
												Start: ast.Position{
													Column: 8,
													Line:   49,
												},
											},
										},
										Name: "tickscript",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   49,
												},
												File:   "deadman_threshold_test.flux",
												Source: "deadman",
												Start: ast.Position{
													Column: 19,
													Line:   49,
												},
											},
										},
										Name: "deadman",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: []ast.Comment{ast.Comment{Text: "// to avoid issue with validation\n"}},
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   56,
								},
								File:   "deadman_threshold_test.flux",
								Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\",\n    )\n    // to avoid issue with validation\n    |> drop(columns: [\"details\"])",
								Start: ast.Position{
									Column: 36,
									Line:   44,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   56,
										},
										File:   "deadman_threshold_test.flux",
										Source: "columns: [\"details\"]",
										Start: ast.Position{
											Column: 13,
											Line:   56,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   56,
											},
											File:   "deadman_threshold_test.flux",
											Source: "columns: [\"details\"]",
											Start: ast.Position{
												Column: 13,
												Line:   56,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   56,
												},
												File:   "deadman_threshold_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 13,
													Line:   56,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   56,
												},
												File:   "deadman_threshold_test.flux",
												Source: "[\"details\"]",
												Start: ast.Position{
													Column: 22,
													Line:   56,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   56,
													},
													File:   "deadman_threshold_test.flux",
													Source: "\"details\"",
													Start: ast.Position{
														Column: 23,
														Line:   56,
													},
												},
											},
											Value: "details",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   56,
									},
									File:   "deadman_threshold_test.flux",
									Source: "drop(columns: [\"details\"])",
									Start: ast.Position{
										Column: 8,
										Line:   56,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   56,
										},
										File:   "deadman_threshold_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 8,
											Line:   56,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   57,
							},
							File:   "deadman_threshold_test.flux",
							Source: "table\n    |> range(start: 2020-11-25T14:05:00Z)\n    |> filter(fn: (r) => r._measurement == \"testm\" and r._field == metric_type and r.realm == tier)\n    |> schema.fieldsAsCols()\n    |> tickscript.groupBy(columns: [\"host\", \"realm\"])\n    |> tickscript.deadman(\n        check: check,\n        measurement: \"testm\",\n        threshold: 10,\n        id: (r) => \"Realm: ${r.realm} - Hostname: ${r.host} / Metric: ${metric_type} deadman alert\",\n    )\n    // to avoid issue with validation\n    |> drop(columns: [\"details\"])\n    |> drop(columns: [\"_time\"])",
							Start: ast.Position{
								Column: 36,
								Line:   44,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   57,
									},
									File:   "deadman_threshold_test.flux",
									Source: "columns: [\"_time\"]",
									Start: ast.Position{
										Column: 13,
										Line:   57,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   57,
										},
										File:   "deadman_threshold_test.flux",
										Source: "columns: [\"_time\"]",
										Start: ast.Position{
											Column: 13,
											Line:   57,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   57,
											},
											File:   "deadman_threshold_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   57,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   57,
											},
											File:   "deadman_threshold_test.flux",
											Source: "[\"_time\"]",
											Start: ast.Position{
												Column: 22,
												Line:   57,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   57,
												},
												File:   "deadman_threshold_test.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 23,
													Line:   57,
												},
											},
										},
										Value: "_time",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   57,
								},
								File:   "deadman_threshold_test.flux",
								Source: "drop(columns: [\"_time\"])",
								Start: ast.Position{
									Column: 8,
									Line:   57,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   57,
									},
									File:   "deadman_threshold_test.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 8,
										Line:   57,
									},
								},
							},
							Name: "drop",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   44,
							},
							File:   "deadman_threshold_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 23,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   44,
								},
								File:   "deadman_threshold_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 23,
									Line:   44,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   44,
							},
							File:   "deadman_threshold_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 29,
								Line:   44,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   63,
						},
						File:   "deadman_threshold_test.flux",
						Source: "_tickscript_deadman = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_deadman,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   59,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   59,
							},
							File:   "deadman_threshold_test.flux",
							Source: "_tickscript_deadman",
							Start: ast.Position{
								Column: 6,
								Line:   59,
							},
						},
					},
					Name: "_tickscript_deadman",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   63,
							},
							File:   "deadman_threshold_test.flux",
							Source: "() => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_deadman,\n})",
							Start: ast.Position{
								Column: 28,
								Line:   59,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   63,
								},
								File:   "deadman_threshold_test.flux",
								Source: "({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_deadman,\n})",
								Start: ast.Position{
									Column: 34,
									Line:   59,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   63,
									},
									File:   "deadman_threshold_test.flux",
									Source: "{\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_deadman,\n}",
									Start: ast.Position{
										Column: 35,
										Line:   59,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   60,
										},
										File:   "deadman_threshold_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 5,
											Line:   60,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   60,
											},
											File:   "deadman_threshold_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 5,
												Line:   60,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   60,
												},
												File:   "deadman_threshold_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 32,
													Line:   60,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   60,
													},
													File:   "deadman_threshold_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 32,
														Line:   60,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   60,
														},
														File:   "deadman_threshold_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 32,
															Line:   60,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   60,
														},
														File:   "deadman_threshold_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 37,
															Line:   60,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   60,
											},
											File:   "deadman_threshold_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 12,
												Line:   60,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   60,
												},
												File:   "deadman_threshold_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 12,
													Line:   60,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   60,
													},
													File:   "deadman_threshold_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 12,
														Line:   60,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   60,
													},
													File:   "deadman_threshold_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 20,
														Line:   60,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   61,
										},
										File:   "deadman_threshold_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 5,
											Line:   61,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   61,
											},
											File:   "deadman_threshold_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 5,
												Line:   61,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   61,
												},
												File:   "deadman_threshold_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 27,
													Line:   61,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   61,
													},
													File:   "deadman_threshold_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 27,
														Line:   61,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   61,
														},
														File:   "deadman_threshold_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   61,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   61,
														},
														File:   "deadman_threshold_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 32,
															Line:   61,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   61,
											},
											File:   "deadman_threshold_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 11,
												Line:   61,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   61,
												},
												File:   "deadman_threshold_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   61,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   61,
													},
													File:   "deadman_threshold_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   61,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   61,
													},
													File:   "deadman_threshold_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   61,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   62,
										},
										File:   "deadman_threshold_test.flux",
										Source: "fn: tickscript_deadman",
										Start: ast.Position{
											Column: 5,
											Line:   62,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   62,
											},
											File:   "deadman_threshold_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 5,
												Line:   62,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   62,
											},
											File:   "deadman_threshold_test.flux",
											Source: "tickscript_deadman",
											Start: ast.Position{
												Column: 9,
												Line:   62,
											},
										},
									},
									Name: "tickscript_deadman",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   63,
					},
					File:   "deadman_threshold_test.flux",
					Source: "test _tickscript_deadman = () => ({\n    input: testing.loadStorage(csv: inData),\n    want: testing.loadMem(csv: outData),\n    fn: tickscript_deadman,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   59,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "deadman_threshold_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "deadman_threshold_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   5,
					},
					File:   "deadman_threshold_test.flux",
					Source: "import \"csv\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   5,
						},
						File:   "deadman_threshold_test.flux",
						Source: "\"csv\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "csv",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 39,
						Line:   6,
					},
					File:   "deadman_threshold_test.flux",
					Source: "import \"contrib/bonitoo-io/tickscript\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 39,
							Line:   6,
						},
						File:   "deadman_threshold_test.flux",
						Source: "\"contrib/bonitoo-io/tickscript\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "contrib/bonitoo-io/tickscript",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   7,
					},
					File:   "deadman_threshold_test.flux",
					Source: "import \"influxdata/influxdb/monitor\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   7,
						},
						File:   "deadman_threshold_test.flux",
						Source: "\"influxdata/influxdb/monitor\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "influxdata/influxdb/monitor",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 36,
						Line:   8,
					},
					File:   "deadman_threshold_test.flux",
					Source: "import \"influxdata/influxdb/schema\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   8,
						},
						File:   "deadman_threshold_test.flux",
						Source: "\"influxdata/influxdb/schema\"",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				Value: "influxdata/influxdb/schema",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "deadman_threshold_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   1,
					},
					File:   "deadman_threshold_test.flux",
					Source: "package tickscript_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   1,
						},
						File:   "deadman_threshold_test.flux",
						Source: "tickscript_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "tickscript_test",
			},
		},
	}},
	Package: "tickscript_test",
	Path:    "contrib/bonitoo-io/tickscript",
}}
