// DO NOT EDIT: This file is autogenerated via the builtin command.

package array

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 13,
					Line:   41,
				},
				File:   "array.flux",
				Source: "package array\n\n\n// from constructs a table from an array of records.\n//\n// Each record in the array is converted into an output row or record. All\n// records must have the same keys and data types.\n//\n// ## Parameters\n// - `rows` is the array of records to construct a table with.\n//\n// ## Build an arbitrary table\n//\n// ```\n// import \"array\"\n//\n// rows = [\n//   {foo: \"bar\", baz: 21.2},\n//   {foo: \"bar\", baz: 23.8}\n// ]\n//\n// array.from(rows: rows)\n// ```\n//\n// ## Union custom rows with query results\n//\n// ```\n// import \"influxdata/influxdb/v1\"\n// import \"array\"\n//\n// tags = v1.tagValues(\n//   bucket: \"example-bucket\",\n//   tag: \"host\"\n// )\n//\n// wildcard_tag = array.from(rows: [{_value: \"*\"}])\n//\n// union(tables: [tags, wildcard_tag])\n// ```\nbuiltin from",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// from constructs a table from an array of records.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Each record in the array is converted into an output row or record. All\n"}, ast.Comment{Text: "// records must have the same keys and data types.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `rows` is the array of records to construct a table with.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Build an arbitrary table\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"array\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// rows = [\n"}, ast.Comment{Text: "//   {foo: \"bar\", baz: 21.2},\n"}, ast.Comment{Text: "//   {foo: \"bar\", baz: 23.8}\n"}, ast.Comment{Text: "// ]\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// array.from(rows: rows)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Union custom rows with query results\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"influxdata/influxdb/v1\"\n"}, ast.Comment{Text: "// import \"array\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// tags = v1.tagValues(\n"}, ast.Comment{Text: "//   bucket: \"example-bucket\",\n"}, ast.Comment{Text: "//   tag: \"host\"\n"}, ast.Comment{Text: "// )\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// wildcard_tag = array.from(rows: [{_value: \"*\"}])\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// union(tables: [tags, wildcard_tag])\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   41,
					},
					File:   "array.flux",
					Source: "builtin from",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   41,
						},
						File:   "array.flux",
						Source: "from",
						Start: ast.Position{
							Column: 9,
							Line:   41,
						},
					},
				},
				Name: "from",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 50,
							Line:   41,
						},
						File:   "array.flux",
						Source: "(rows: [A]) => [A] where A: Record",
						Start: ast.Position{
							Column: 16,
							Line:   41,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   41,
							},
							File:   "array.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 41,
								Line:   41,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   41,
								},
								File:   "array.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 44,
									Line:   41,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   41,
								},
								File:   "array.flux",
								Source: "A",
								Start: ast.Position{
									Column: 41,
									Line:   41,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   41,
							},
							File:   "array.flux",
							Source: "(rows: [A]) => [A]",
							Start: ast.Position{
								Column: 16,
								Line:   41,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   41,
								},
								File:   "array.flux",
								Source: "rows: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   41,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   41,
									},
									File:   "array.flux",
									Source: "rows",
									Start: ast.Position{
										Column: 17,
										Line:   41,
									},
								},
							},
							Name: "rows",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   41,
									},
									File:   "array.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 23,
										Line:   41,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   41,
										},
										File:   "array.flux",
										Source: "A",
										Start: ast.Position{
											Column: 24,
											Line:   41,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   41,
											},
											File:   "array.flux",
											Source: "A",
											Start: ast.Position{
												Column: 24,
												Line:   41,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   41,
								},
								File:   "array.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 31,
									Line:   41,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   41,
									},
									File:   "array.flux",
									Source: "A",
									Start: ast.Position{
										Column: 32,
										Line:   41,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   41,
										},
										File:   "array.flux",
										Source: "A",
										Start: ast.Position{
											Column: 32,
											Line:   41,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}},
		Eof:      nil,
		Imports:  nil,
		Metadata: "parser-type=rust",
		Name:     "array.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Package array provides functions for building tables from flux arrays.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   2,
					},
					File:   "array.flux",
					Source: "package array",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   2,
						},
						File:   "array.flux",
						Source: "array",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "array",
			},
		},
	}},
	Package: "array",
	Path:    "array",
}
