// Generated by tmpl
// https://github.com/benbjohnson/tmpl
//
// DO NOT EDIT!
// Source: iterator.gen_test.go.tmpl

package arrowutil_test

import (
	"math/rand"
	"testing"

	"github.com/apache/arrow/go/arrow/memory"
	"github.com/google/go-cmp/cmp"
	"github.com/influxdata/flux/array"
	"github.com/influxdata/flux/internal/arrowutil"
)

func TestIterateInts(t *testing.T) {
	arrs := make([]array.Interface, 0, 3)
	for i := 0; i < 3; i++ {
		b := arrowutil.NewIntBuilder(memory.DefaultAllocator)
		for j := 0; j < 100; j++ {
			if 0.05 > rand.Float64() {
				b.AppendNull()
				continue
			}
			v := generateInt()
			b.Append(v)
		}
		arrs = append(arrs, b.NewArray())
	}

	itr := arrowutil.IterateInts(arrs)
	for i := 0; i < 300; i++ {
		if !itr.Next() {
			t.Fatalf("expected next value, but got false at index %d", i)
		}

		arr := arrs[i/100].(*array.Int)
		if want, got := arr.IsValid(i%100), itr.IsValid(); !cmp.Equal(want, got) {
			t.Fatalf("unexpected valid value at index %d -want/+got:\n%s", i, cmp.Diff(want, got))
		} else if want && got {
			if want, got := arr.Value(i%100), itr.Value(); !cmp.Equal(want, got) {
				t.Fatalf("unexpected value at index %d -want/+got:\n%s", i, cmp.Diff(want, got))
			}
		}
		if want, got := arr.IsNull(i%100), itr.IsNull(); !cmp.Equal(want, got) {
			t.Fatalf("unexpected null value at index %d -want/+got:\n%s", i, cmp.Diff(want, got))
		}
	}
}

func TestIterateUints(t *testing.T) {
	arrs := make([]array.Interface, 0, 3)
	for i := 0; i < 3; i++ {
		b := arrowutil.NewUintBuilder(memory.DefaultAllocator)
		for j := 0; j < 100; j++ {
			if 0.05 > rand.Float64() {
				b.AppendNull()
				continue
			}
			v := generateUint()
			b.Append(v)
		}
		arrs = append(arrs, b.NewArray())
	}

	itr := arrowutil.IterateUints(arrs)
	for i := 0; i < 300; i++ {
		if !itr.Next() {
			t.Fatalf("expected next value, but got false at index %d", i)
		}

		arr := arrs[i/100].(*array.Uint)
		if want, got := arr.IsValid(i%100), itr.IsValid(); !cmp.Equal(want, got) {
			t.Fatalf("unexpected valid value at index %d -want/+got:\n%s", i, cmp.Diff(want, got))
		} else if want && got {
			if want, got := arr.Value(i%100), itr.Value(); !cmp.Equal(want, got) {
				t.Fatalf("unexpected value at index %d -want/+got:\n%s", i, cmp.Diff(want, got))
			}
		}
		if want, got := arr.IsNull(i%100), itr.IsNull(); !cmp.Equal(want, got) {
			t.Fatalf("unexpected null value at index %d -want/+got:\n%s", i, cmp.Diff(want, got))
		}
	}
}

func TestIterateFloats(t *testing.T) {
	arrs := make([]array.Interface, 0, 3)
	for i := 0; i < 3; i++ {
		b := arrowutil.NewFloatBuilder(memory.DefaultAllocator)
		for j := 0; j < 100; j++ {
			if 0.05 > rand.Float64() {
				b.AppendNull()
				continue
			}
			v := generateFloat()
			b.Append(v)
		}
		arrs = append(arrs, b.NewArray())
	}

	itr := arrowutil.IterateFloats(arrs)
	for i := 0; i < 300; i++ {
		if !itr.Next() {
			t.Fatalf("expected next value, but got false at index %d", i)
		}

		arr := arrs[i/100].(*array.Float)
		if want, got := arr.IsValid(i%100), itr.IsValid(); !cmp.Equal(want, got) {
			t.Fatalf("unexpected valid value at index %d -want/+got:\n%s", i, cmp.Diff(want, got))
		} else if want && got {
			if want, got := arr.Value(i%100), itr.Value(); !cmp.Equal(want, got) {
				t.Fatalf("unexpected value at index %d -want/+got:\n%s", i, cmp.Diff(want, got))
			}
		}
		if want, got := arr.IsNull(i%100), itr.IsNull(); !cmp.Equal(want, got) {
			t.Fatalf("unexpected null value at index %d -want/+got:\n%s", i, cmp.Diff(want, got))
		}
	}
}

func TestIterateBooleans(t *testing.T) {
	arrs := make([]array.Interface, 0, 3)
	for i := 0; i < 3; i++ {
		b := arrowutil.NewBooleanBuilder(memory.DefaultAllocator)
		for j := 0; j < 100; j++ {
			if 0.05 > rand.Float64() {
				b.AppendNull()
				continue
			}
			v := generateBoolean()
			b.Append(v)
		}
		arrs = append(arrs, b.NewArray())
	}

	itr := arrowutil.IterateBooleans(arrs)
	for i := 0; i < 300; i++ {
		if !itr.Next() {
			t.Fatalf("expected next value, but got false at index %d", i)
		}

		arr := arrs[i/100].(*array.Boolean)
		if want, got := arr.IsValid(i%100), itr.IsValid(); !cmp.Equal(want, got) {
			t.Fatalf("unexpected valid value at index %d -want/+got:\n%s", i, cmp.Diff(want, got))
		} else if want && got {
			if want, got := arr.Value(i%100), itr.Value(); !cmp.Equal(want, got) {
				t.Fatalf("unexpected value at index %d -want/+got:\n%s", i, cmp.Diff(want, got))
			}
		}
		if want, got := arr.IsNull(i%100), itr.IsNull(); !cmp.Equal(want, got) {
			t.Fatalf("unexpected null value at index %d -want/+got:\n%s", i, cmp.Diff(want, got))
		}
	}
}

func TestIterateStrings(t *testing.T) {
	arrs := make([]array.Interface, 0, 3)
	for i := 0; i < 3; i++ {
		b := arrowutil.NewStringBuilder(memory.DefaultAllocator)
		for j := 0; j < 100; j++ {
			if 0.05 > rand.Float64() {
				b.AppendNull()
				continue
			}
			v := generateString()
			b.Append(v)
		}
		arrs = append(arrs, b.NewArray())
	}

	itr := arrowutil.IterateStrings(arrs)
	for i := 0; i < 300; i++ {
		if !itr.Next() {
			t.Fatalf("expected next value, but got false at index %d", i)
		}

		arr := arrs[i/100].(*array.String)
		if want, got := arr.IsValid(i%100), itr.IsValid(); !cmp.Equal(want, got) {
			t.Fatalf("unexpected valid value at index %d -want/+got:\n%s", i, cmp.Diff(want, got))
		} else if want && got {
			if want, got := arr.Value(i%100), itr.Value(); !cmp.Equal(want, got) {
				t.Fatalf("unexpected value at index %d -want/+got:\n%s", i, cmp.Diff(want, got))
			}
		}
		if want, got := arr.IsNull(i%100), itr.IsNull(); !cmp.Equal(want, got) {
			t.Fatalf("unexpected null value at index %d -want/+got:\n%s", i, cmp.Diff(want, got))
		}
	}
}
