//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/monitor/armmonitor"
	"net/http"
	"net/url"
	"regexp"
)

// PrivateLinkScopedResourcesServer is a fake server for instances of the armmonitor.PrivateLinkScopedResourcesClient type.
type PrivateLinkScopedResourcesServer struct {
	// BeginCreateOrUpdate is the fake for method PrivateLinkScopedResourcesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, scopeName string, name string, parameters armmonitor.ScopedResource, options *armmonitor.PrivateLinkScopedResourcesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armmonitor.PrivateLinkScopedResourcesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method PrivateLinkScopedResourcesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, scopeName string, name string, options *armmonitor.PrivateLinkScopedResourcesClientBeginDeleteOptions) (resp azfake.PollerResponder[armmonitor.PrivateLinkScopedResourcesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method PrivateLinkScopedResourcesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, scopeName string, name string, options *armmonitor.PrivateLinkScopedResourcesClientGetOptions) (resp azfake.Responder[armmonitor.PrivateLinkScopedResourcesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByPrivateLinkScopePager is the fake for method PrivateLinkScopedResourcesClient.NewListByPrivateLinkScopePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByPrivateLinkScopePager func(resourceGroupName string, scopeName string, options *armmonitor.PrivateLinkScopedResourcesClientListByPrivateLinkScopeOptions) (resp azfake.PagerResponder[armmonitor.PrivateLinkScopedResourcesClientListByPrivateLinkScopeResponse])
}

// NewPrivateLinkScopedResourcesServerTransport creates a new instance of PrivateLinkScopedResourcesServerTransport with the provided implementation.
// The returned PrivateLinkScopedResourcesServerTransport instance is connected to an instance of armmonitor.PrivateLinkScopedResourcesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPrivateLinkScopedResourcesServerTransport(srv *PrivateLinkScopedResourcesServer) *PrivateLinkScopedResourcesServerTransport {
	return &PrivateLinkScopedResourcesServerTransport{
		srv:                            srv,
		beginCreateOrUpdate:            newTracker[azfake.PollerResponder[armmonitor.PrivateLinkScopedResourcesClientCreateOrUpdateResponse]](),
		beginDelete:                    newTracker[azfake.PollerResponder[armmonitor.PrivateLinkScopedResourcesClientDeleteResponse]](),
		newListByPrivateLinkScopePager: newTracker[azfake.PagerResponder[armmonitor.PrivateLinkScopedResourcesClientListByPrivateLinkScopeResponse]](),
	}
}

// PrivateLinkScopedResourcesServerTransport connects instances of armmonitor.PrivateLinkScopedResourcesClient to instances of PrivateLinkScopedResourcesServer.
// Don't use this type directly, use NewPrivateLinkScopedResourcesServerTransport instead.
type PrivateLinkScopedResourcesServerTransport struct {
	srv                            *PrivateLinkScopedResourcesServer
	beginCreateOrUpdate            *tracker[azfake.PollerResponder[armmonitor.PrivateLinkScopedResourcesClientCreateOrUpdateResponse]]
	beginDelete                    *tracker[azfake.PollerResponder[armmonitor.PrivateLinkScopedResourcesClientDeleteResponse]]
	newListByPrivateLinkScopePager *tracker[azfake.PagerResponder[armmonitor.PrivateLinkScopedResourcesClientListByPrivateLinkScopeResponse]]
}

// Do implements the policy.Transporter interface for PrivateLinkScopedResourcesServerTransport.
func (p *PrivateLinkScopedResourcesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PrivateLinkScopedResourcesClient.BeginCreateOrUpdate":
		resp, err = p.dispatchBeginCreateOrUpdate(req)
	case "PrivateLinkScopedResourcesClient.BeginDelete":
		resp, err = p.dispatchBeginDelete(req)
	case "PrivateLinkScopedResourcesClient.Get":
		resp, err = p.dispatchGet(req)
	case "PrivateLinkScopedResourcesClient.NewListByPrivateLinkScopePager":
		resp, err = p.dispatchNewListByPrivateLinkScopePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PrivateLinkScopedResourcesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := p.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/privateLinkScopes/(?P<scopeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scopedResources/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmonitor.ScopedResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		scopeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scopeName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, scopeNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		p.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		p.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		p.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (p *PrivateLinkScopedResourcesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if p.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := p.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/privateLinkScopes/(?P<scopeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scopedResources/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		scopeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scopeName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginDelete(req.Context(), resourceGroupNameParam, scopeNameParam, nameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		p.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		p.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		p.beginDelete.remove(req)
	}

	return resp, nil
}

func (p *PrivateLinkScopedResourcesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/privateLinkScopes/(?P<scopeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scopedResources/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	scopeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scopeName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, scopeNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ScopedResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateLinkScopedResourcesServerTransport) dispatchNewListByPrivateLinkScopePager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByPrivateLinkScopePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByPrivateLinkScopePager not implemented")}
	}
	newListByPrivateLinkScopePager := p.newListByPrivateLinkScopePager.get(req)
	if newListByPrivateLinkScopePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/privateLinkScopes/(?P<scopeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scopedResources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		scopeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scopeName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListByPrivateLinkScopePager(resourceGroupNameParam, scopeNameParam, nil)
		newListByPrivateLinkScopePager = &resp
		p.newListByPrivateLinkScopePager.add(req, newListByPrivateLinkScopePager)
		server.PagerResponderInjectNextLinks(newListByPrivateLinkScopePager, req, func(page *armmonitor.PrivateLinkScopedResourcesClientListByPrivateLinkScopeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByPrivateLinkScopePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByPrivateLinkScopePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByPrivateLinkScopePager) {
		p.newListByPrivateLinkScopePager.remove(req)
	}
	return resp, nil
}
