//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/monitor/armmonitor"
	"net/http"
	"net/url"
	"regexp"
)

// MetricAlertsStatusServer is a fake server for instances of the armmonitor.MetricAlertsStatusClient type.
type MetricAlertsStatusServer struct {
	// List is the fake for method MetricAlertsStatusClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, resourceGroupName string, ruleName string, options *armmonitor.MetricAlertsStatusClientListOptions) (resp azfake.Responder[armmonitor.MetricAlertsStatusClientListResponse], errResp azfake.ErrorResponder)

	// ListByName is the fake for method MetricAlertsStatusClient.ListByName
	// HTTP status codes to indicate success: http.StatusOK
	ListByName func(ctx context.Context, resourceGroupName string, ruleName string, statusName string, options *armmonitor.MetricAlertsStatusClientListByNameOptions) (resp azfake.Responder[armmonitor.MetricAlertsStatusClientListByNameResponse], errResp azfake.ErrorResponder)
}

// NewMetricAlertsStatusServerTransport creates a new instance of MetricAlertsStatusServerTransport with the provided implementation.
// The returned MetricAlertsStatusServerTransport instance is connected to an instance of armmonitor.MetricAlertsStatusClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMetricAlertsStatusServerTransport(srv *MetricAlertsStatusServer) *MetricAlertsStatusServerTransport {
	return &MetricAlertsStatusServerTransport{srv: srv}
}

// MetricAlertsStatusServerTransport connects instances of armmonitor.MetricAlertsStatusClient to instances of MetricAlertsStatusServer.
// Don't use this type directly, use NewMetricAlertsStatusServerTransport instead.
type MetricAlertsStatusServerTransport struct {
	srv *MetricAlertsStatusServer
}

// Do implements the policy.Transporter interface for MetricAlertsStatusServerTransport.
func (m *MetricAlertsStatusServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MetricAlertsStatusClient.List":
		resp, err = m.dispatchList(req)
	case "MetricAlertsStatusClient.ListByName":
		resp, err = m.dispatchListByName(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MetricAlertsStatusServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if m.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/metricAlerts/(?P<ruleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/status`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	ruleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.List(req.Context(), resourceGroupNameParam, ruleNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MetricAlertStatusCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MetricAlertsStatusServerTransport) dispatchListByName(req *http.Request) (*http.Response, error) {
	if m.srv.ListByName == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListByName not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/metricAlerts/(?P<ruleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/status/(?P<statusName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	ruleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleName")])
	if err != nil {
		return nil, err
	}
	statusNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("statusName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.ListByName(req.Context(), resourceGroupNameParam, ruleNameParam, statusNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MetricAlertStatusCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
