//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/monitor/armmonitor"
	"net/http"
	"net/url"
	"regexp"
)

// DiagnosticSettingsCategoryServer is a fake server for instances of the armmonitor.DiagnosticSettingsCategoryClient type.
type DiagnosticSettingsCategoryServer struct {
	// Get is the fake for method DiagnosticSettingsCategoryClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceURI string, name string, options *armmonitor.DiagnosticSettingsCategoryClientGetOptions) (resp azfake.Responder[armmonitor.DiagnosticSettingsCategoryClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method DiagnosticSettingsCategoryClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceURI string, options *armmonitor.DiagnosticSettingsCategoryClientListOptions) (resp azfake.PagerResponder[armmonitor.DiagnosticSettingsCategoryClientListResponse])
}

// NewDiagnosticSettingsCategoryServerTransport creates a new instance of DiagnosticSettingsCategoryServerTransport with the provided implementation.
// The returned DiagnosticSettingsCategoryServerTransport instance is connected to an instance of armmonitor.DiagnosticSettingsCategoryClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDiagnosticSettingsCategoryServerTransport(srv *DiagnosticSettingsCategoryServer) *DiagnosticSettingsCategoryServerTransport {
	return &DiagnosticSettingsCategoryServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armmonitor.DiagnosticSettingsCategoryClientListResponse]](),
	}
}

// DiagnosticSettingsCategoryServerTransport connects instances of armmonitor.DiagnosticSettingsCategoryClient to instances of DiagnosticSettingsCategoryServer.
// Don't use this type directly, use NewDiagnosticSettingsCategoryServerTransport instead.
type DiagnosticSettingsCategoryServerTransport struct {
	srv          *DiagnosticSettingsCategoryServer
	newListPager *tracker[azfake.PagerResponder[armmonitor.DiagnosticSettingsCategoryClientListResponse]]
}

// Do implements the policy.Transporter interface for DiagnosticSettingsCategoryServerTransport.
func (d *DiagnosticSettingsCategoryServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DiagnosticSettingsCategoryClient.Get":
		resp, err = d.dispatchGet(req)
	case "DiagnosticSettingsCategoryClient.NewListPager":
		resp, err = d.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DiagnosticSettingsCategoryServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/diagnosticSettingsCategories/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceURIParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DiagnosticSettingsCategoryResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DiagnosticSettingsCategoryServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := d.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/diagnosticSettingsCategories`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListPager(resourceURIParam, nil)
		newListPager = &resp
		d.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		d.newListPager.remove(req)
	}
	return resp, nil
}
