/* Copyright 2017 - 2021 R. Thomas
 * Copyright 2017 - 2021 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_PE_ADVAPI32_DLL_LOOKUP_H_
#define LIEF_PE_ADVAPI32_DLL_LOOKUP_H_

#include <map>

namespace LIEF {
namespace PE {

static const std::map<uint32_t, const char*> advapi32_dll_lookup {
    { 0x0002, "A_SHAFinal"                                       },
    { 0x0003, "A_SHAInit"                                        },
    { 0x0004, "A_SHAUpdate"                                      },
    { 0x0005, "AbortSystemShutdownA"                             },
    { 0x0006, "AbortSystemShutdownW"                             },
    { 0x0007, "AccessCheck"                                      },
    { 0x0008, "AccessCheckAndAuditAlarmA"                        },
    { 0x0009, "AccessCheckAndAuditAlarmW"                        },
    { 0x000a, "AccessCheckByType"                                },
    { 0x000b, "AccessCheckByTypeAndAuditAlarmA"                  },
    { 0x000c, "AccessCheckByTypeAndAuditAlarmW"                  },
    { 0x000d, "AccessCheckByTypeResultList"                      },
    { 0x000e, "AccessCheckByTypeResultListAndAuditAlarmA"        },
    { 0x000f, "AccessCheckByTypeResultListAndAuditAlarmByHandleA" },
    { 0x0010, "AccessCheckByTypeResultListAndAuditAlarmByHandleW" },
    { 0x0011, "AccessCheckByTypeResultListAndAuditAlarmW"        },
    { 0x0012, "AddAccessAllowedAce"                              },
    { 0x0013, "AddAccessAllowedAceEx"                            },
    { 0x0014, "AddAccessAllowedObjectAce"                        },
    { 0x0015, "AddAccessDeniedAce"                               },
    { 0x0016, "AddAccessDeniedAceEx"                             },
    { 0x0017, "AddAccessDeniedObjectAce"                         },
    { 0x0018, "AddAce"                                           },
    { 0x0019, "AddAuditAccessAce"                                },
    { 0x001a, "AddAuditAccessAceEx"                              },
    { 0x001b, "AddAuditAccessObjectAce"                          },
    { 0x001c, "AddUsersToEncryptedFile"                          },
    { 0x001d, "AdjustTokenGroups"                                },
    { 0x001e, "AdjustTokenPrivileges"                            },
    { 0x001f, "AllocateAndInitializeSid"                         },
    { 0x0020, "AllocateLocallyUniqueId"                          },
    { 0x0021, "AreAllAccessesGranted"                            },
    { 0x0022, "AreAnyAccessesGranted"                            },
    { 0x0023, "BackupEventLogA"                                  },
    { 0x0024, "BackupEventLogW"                                  },
    { 0x0025, "BuildExplicitAccessWithNameA"                     },
    { 0x0026, "BuildExplicitAccessWithNameW"                     },
    { 0x0027, "BuildImpersonateExplicitAccessWithNameA"          },
    { 0x0028, "BuildImpersonateExplicitAccessWithNameW"          },
    { 0x0029, "BuildImpersonateTrusteeA"                         },
    { 0x002a, "BuildImpersonateTrusteeW"                         },
    { 0x002b, "BuildSecurityDescriptorA"                         },
    { 0x002c, "BuildSecurityDescriptorW"                         },
    { 0x002d, "BuildTrusteeWithNameA"                            },
    { 0x002e, "BuildTrusteeWithNameW"                            },
    { 0x002f, "BuildTrusteeWithObjectsAndNameA"                  },
    { 0x0030, "BuildTrusteeWithObjectsAndNameW"                  },
    { 0x0031, "BuildTrusteeWithObjectsAndSidA"                   },
    { 0x0032, "BuildTrusteeWithObjectsAndSidW"                   },
    { 0x0033, "BuildTrusteeWithSidA"                             },
    { 0x0034, "BuildTrusteeWithSidW"                             },
    { 0x0035, "CancelOverlappedAccess"                           },
    { 0x0036, "ChangeServiceConfig2A"                            },
    { 0x0037, "ChangeServiceConfig2W"                            },
    { 0x0038, "ChangeServiceConfigA"                             },
    { 0x0039, "ChangeServiceConfigW"                             },
    { 0x003a, "CheckTokenMembership"                             },
    { 0x003b, "ClearEventLogA"                                   },
    { 0x003c, "ClearEventLogW"                                   },
    { 0x003d, "CloseCodeAuthzLevel"                              },
    { 0x003e, "CloseEncryptedFileRaw"                            },
    { 0x003f, "CloseEventLog"                                    },
    { 0x0040, "CloseServiceHandle"                               },
    { 0x0041, "CloseTrace"                                       },
    { 0x0042, "CommandLineFromMsiDescriptor"                     },
    { 0x0043, "ComputeAccessTokenFromCodeAuthzLevel"             },
    { 0x0044, "ControlService"                                   },
    { 0x0045, "ControlTraceA"                                    },
    { 0x0046, "ControlTraceW"                                    },
    { 0x0047, "ConvertAccessToSecurityDescriptorA"               },
    { 0x0048, "ConvertAccessToSecurityDescriptorW"               },
    { 0x0049, "ConvertSDToStringSDRootDomainA"                   },
    { 0x004a, "ConvertSDToStringSDRootDomainW"                   },
    { 0x004b, "ConvertSecurityDescriptorToAccessA"               },
    { 0x004c, "ConvertSecurityDescriptorToAccessNamedA"          },
    { 0x004d, "ConvertSecurityDescriptorToAccessNamedW"          },
    { 0x004e, "ConvertSecurityDescriptorToAccessW"               },
    { 0x004f, "ConvertSecurityDescriptorToStringSecurityDescriptorA" },
    { 0x0050, "ConvertSecurityDescriptorToStringSecurityDescriptorW" },
    { 0x0051, "ConvertSidToStringSidA"                           },
    { 0x0052, "ConvertSidToStringSidW"                           },
    { 0x0053, "ConvertStringSDToSDDomainA"                       },
    { 0x0054, "ConvertStringSDToSDDomainW"                       },
    { 0x0055, "ConvertStringSDToSDRootDomainA"                   },
    { 0x0056, "ConvertStringSDToSDRootDomainW"                   },
    { 0x0057, "ConvertStringSecurityDescriptorToSecurityDescriptorA" },
    { 0x0058, "ConvertStringSecurityDescriptorToSecurityDescriptorW" },
    { 0x0059, "ConvertStringSidToSidA"                           },
    { 0x005a, "ConvertStringSidToSidW"                           },
    { 0x005b, "ConvertToAutoInheritPrivateObjectSecurity"        },
    { 0x005c, "CopySid"                                          },
    { 0x005d, "CreateCodeAuthzLevel"                             },
    { 0x005e, "CreatePrivateObjectSecurity"                      },
    { 0x005f, "CreatePrivateObjectSecurityEx"                    },
    { 0x0060, "CreatePrivateObjectSecurityWithMultipleInheritance" },
    { 0x0061, "CreateProcessAsUserA"                             },
    { 0x0062, "CreateProcessAsUserSecure"                        },
    { 0x0063, "CreateProcessAsUserW"                             },
    { 0x0064, "CreateProcessWithLogonW"                          },
    { 0x0065, "CreateRestrictedToken"                            },
    { 0x0066, "CreateServiceA"                                   },
    { 0x0067, "CreateServiceW"                                   },
    { 0x0068, "CreateTraceInstanceId"                            },
    { 0x0069, "CreateWellKnownSid"                               },
    { 0x006a, "CredDeleteA"                                      },
    { 0x006b, "CredDeleteW"                                      },
    { 0x006c, "CredEnumerateA"                                   },
    { 0x006d, "CredEnumerateW"                                   },
    { 0x006e, "CredFree"                                         },
    { 0x006f, "CredGetSessionTypes"                              },
    { 0x0070, "CredGetTargetInfoA"                               },
    { 0x0071, "CredGetTargetInfoW"                               },
    { 0x0072, "CredIsMarshaledCredentialA"                       },
    { 0x0073, "CredIsMarshaledCredentialW"                       },
    { 0x0074, "CredMarshalCredentialA"                           },
    { 0x0075, "CredMarshalCredentialW"                           },
    { 0x0076, "CredProfileLoaded"                                },
    { 0x0077, "CredReadA"                                        },
    { 0x0078, "CredReadDomainCredentialsA"                       },
    { 0x0079, "CredReadDomainCredentialsW"                       },
    { 0x007a, "CredReadW"                                        },
    { 0x007b, "CredRenameA"                                      },
    { 0x007c, "CredRenameW"                                      },
    { 0x007d, "CredUnmarshalCredentialA"                         },
    { 0x007e, "CredUnmarshalCredentialW"                         },
    { 0x007f, "CredWriteA"                                       },
    { 0x0080, "CredWriteDomainCredentialsA"                      },
    { 0x0081, "CredWriteDomainCredentialsW"                      },
    { 0x0082, "CredWriteW"                                       },
    { 0x0083, "CredpConvertCredential"                           },
    { 0x0084, "CredpConvertTargetInfo"                           },
    { 0x0085, "CredpDecodeCredential"                            },
    { 0x0086, "CredpEncodeCredential"                            },
    { 0x0087, "CryptAcquireContextA"                             },
    { 0x0088, "CryptAcquireContextW"                             },
    { 0x0089, "CryptContextAddRef"                               },
    { 0x008a, "CryptCreateHash"                                  },
    { 0x008b, "CryptDecrypt"                                     },
    { 0x008c, "CryptDeriveKey"                                   },
    { 0x008d, "CryptDestroyHash"                                 },
    { 0x008e, "CryptDestroyKey"                                  },
    { 0x008f, "CryptDuplicateHash"                               },
    { 0x0090, "CryptDuplicateKey"                                },
    { 0x0091, "CryptEncrypt"                                     },
    { 0x0092, "CryptEnumProviderTypesA"                          },
    { 0x0093, "CryptEnumProviderTypesW"                          },
    { 0x0094, "CryptEnumProvidersA"                              },
    { 0x0095, "CryptEnumProvidersW"                              },
    { 0x0096, "CryptExportKey"                                   },
    { 0x0097, "CryptGenKey"                                      },
    { 0x0098, "CryptGenRandom"                                   },
    { 0x0099, "CryptGetDefaultProviderA"                         },
    { 0x009a, "CryptGetDefaultProviderW"                         },
    { 0x009b, "CryptGetHashParam"                                },
    { 0x009c, "CryptGetKeyParam"                                 },
    { 0x009d, "CryptGetProvParam"                                },
    { 0x009e, "CryptGetUserKey"                                  },
    { 0x009f, "CryptHashData"                                    },
    { 0x00a0, "CryptHashSessionKey"                              },
    { 0x00a1, "CryptImportKey"                                   },
    { 0x00a2, "CryptReleaseContext"                              },
    { 0x00a3, "CryptSetHashParam"                                },
    { 0x00a4, "CryptSetKeyParam"                                 },
    { 0x00a5, "CryptSetProvParam"                                },
    { 0x00a6, "CryptSetProviderA"                                },
    { 0x00a7, "CryptSetProviderExA"                              },
    { 0x00a8, "CryptSetProviderExW"                              },
    { 0x00a9, "CryptSetProviderW"                                },
    { 0x00aa, "CryptSignHashA"                                   },
    { 0x00ab, "CryptSignHashW"                                   },
    { 0x00ac, "CryptVerifySignatureA"                            },
    { 0x00ad, "CryptVerifySignatureW"                            },
    { 0x00ae, "DecryptFileA"                                     },
    { 0x00af, "DecryptFileW"                                     },
    { 0x00b0, "DeleteAce"                                        },
    { 0x00b1, "DeleteService"                                    },
    { 0x00b2, "DeregisterEventSource"                            },
    { 0x00b3, "DestroyPrivateObjectSecurity"                     },
    { 0x00b4, "DuplicateEncryptionInfoFile"                      },
    { 0x00b5, "DuplicateToken"                                   },
    { 0x00b6, "DuplicateTokenEx"                                 },
    { 0x00b7, "ElfBackupEventLogFileA"                           },
    { 0x00b8, "ElfBackupEventLogFileW"                           },
    { 0x00b9, "ElfChangeNotify"                                  },
    { 0x00ba, "ElfClearEventLogFileA"                            },
    { 0x00bb, "ElfClearEventLogFileW"                            },
    { 0x00bc, "ElfCloseEventLog"                                 },
    { 0x00bd, "ElfDeregisterEventSource"                         },
    { 0x00be, "ElfFlushEventLog"                                 },
    { 0x00bf, "ElfNumberOfRecords"                               },
    { 0x00c0, "ElfOldestRecord"                                  },
    { 0x00c1, "ElfOpenBackupEventLogA"                           },
    { 0x00c2, "ElfOpenBackupEventLogW"                           },
    { 0x00c3, "ElfOpenEventLogA"                                 },
    { 0x00c4, "ElfOpenEventLogW"                                 },
    { 0x00c5, "ElfReadEventLogA"                                 },
    { 0x00c6, "ElfReadEventLogW"                                 },
    { 0x00c7, "ElfRegisterEventSourceA"                          },
    { 0x00c8, "ElfRegisterEventSourceW"                          },
    { 0x00c9, "ElfReportEventA"                                  },
    { 0x00ca, "ElfReportEventW"                                  },
    { 0x00cb, "EnableTrace"                                      },
    { 0x00cc, "EncryptFileA"                                     },
    { 0x00cd, "EncryptFileW"                                     },
    { 0x00ce, "EncryptedFileKeyInfo"                             },
    { 0x00cf, "EncryptionDisable"                                },
    { 0x00d0, "EnumDependentServicesA"                           },
    { 0x00d1, "EnumDependentServicesW"                           },
    { 0x00d2, "EnumServiceGroupW"                                },
    { 0x00d3, "EnumServicesStatusA"                              },
    { 0x00d4, "EnumServicesStatusExA"                            },
    { 0x00d5, "EnumServicesStatusExW"                            },
    { 0x00d6, "EnumServicesStatusW"                              },
    { 0x00d7, "EnumerateTraceGuids"                              },
    { 0x00d8, "EqualDomainSid"                                   },
    { 0x00d9, "EqualPrefixSid"                                   },
    { 0x00da, "EqualSid"                                         },
    { 0x00db, "FileEncryptionStatusA"                            },
    { 0x00dc, "FileEncryptionStatusW"                            },
    { 0x00dd, "FindFirstFreeAce"                                 },
    { 0x00de, "FlushTraceA"                                      },
    { 0x00df, "FlushTraceW"                                      },
    { 0x00e0, "FreeEncryptedFileKeyInfo"                         },
    { 0x00e1, "FreeEncryptionCertificateHashList"                },
    { 0x00e2, "FreeInheritedFromArray"                           },
    { 0x00e3, "FreeSid"                                          },
    { 0x00e4, "GetAccessPermissionsForObjectA"                   },
    { 0x00e5, "GetAccessPermissionsForObjectW"                   },
    { 0x00e6, "GetAce"                                           },
    { 0x00e7, "GetAclInformation"                                },
    { 0x00e8, "GetAuditedPermissionsFromAclA"                    },
    { 0x00e9, "GetAuditedPermissionsFromAclW"                    },
    { 0x00ea, "GetCurrentHwProfileA"                             },
    { 0x00eb, "GetCurrentHwProfileW"                             },
    { 0x00ec, "GetEffectiveRightsFromAclA"                       },
    { 0x00ed, "GetEffectiveRightsFromAclW"                       },
    { 0x00ee, "GetEventLogInformation"                           },
    { 0x00ef, "GetExplicitEntriesFromAclA"                       },
    { 0x00f0, "GetExplicitEntriesFromAclW"                       },
    { 0x00f1, "GetFileSecurityA"                                 },
    { 0x00f2, "GetFileSecurityW"                                 },
    { 0x00f3, "GetInformationCodeAuthzLevelW"                    },
    { 0x00f4, "GetInformationCodeAuthzPolicyW"                   },
    { 0x00f5, "GetInheritanceSourceA"                            },
    { 0x00f6, "GetInheritanceSourceW"                            },
    { 0x00f7, "GetKernelObjectSecurity"                          },
    { 0x00f8, "GetLengthSid"                                     },
    { 0x00f9, "GetLocalManagedApplicationData"                   },
    { 0x00fa, "GetLocalManagedApplications"                      },
    { 0x00fb, "GetManagedApplicationCategories"                  },
    { 0x00fc, "GetManagedApplications"                           },
    { 0x00fd, "GetMultipleTrusteeA"                              },
    { 0x00fe, "GetMultipleTrusteeOperationA"                     },
    { 0x00ff, "GetMultipleTrusteeOperationW"                     },
    { 0x0100, "GetMultipleTrusteeW"                              },
    { 0x0101, "GetNamedSecurityInfoA"                            },
    { 0x0102, "GetNamedSecurityInfoExA"                          },
    { 0x0103, "GetNamedSecurityInfoExW"                          },
    { 0x0104, "GetNamedSecurityInfoW"                            },
    { 0x0105, "GetNumberOfEventLogRecords"                       },
    { 0x0106, "GetOldestEventLogRecord"                          },
    { 0x0107, "GetOverlappedAccessResults"                       },
    { 0x0108, "GetPrivateObjectSecurity"                         },
    { 0x0109, "GetSecurityDescriptorControl"                     },
    { 0x010a, "GetSecurityDescriptorDacl"                        },
    { 0x010b, "GetSecurityDescriptorGroup"                       },
    { 0x010c, "GetSecurityDescriptorLength"                      },
    { 0x010d, "GetSecurityDescriptorOwner"                       },
    { 0x010e, "GetSecurityDescriptorRMControl"                   },
    { 0x010f, "GetSecurityDescriptorSacl"                        },
    { 0x0110, "GetSecurityInfo"                                  },
    { 0x0111, "GetSecurityInfoExA"                               },
    { 0x0112, "GetSecurityInfoExW"                               },
    { 0x0113, "GetServiceDisplayNameA"                           },
    { 0x0114, "GetServiceDisplayNameW"                           },
    { 0x0115, "GetServiceKeyNameA"                               },
    { 0x0116, "GetServiceKeyNameW"                               },
    { 0x0117, "GetSidIdentifierAuthority"                        },
    { 0x0118, "GetSidLengthRequired"                             },
    { 0x0119, "GetSidSubAuthority"                               },
    { 0x011a, "GetSidSubAuthorityCount"                          },
    { 0x011b, "GetTokenInformation"                              },
    { 0x011c, "GetTraceEnableFlags"                              },
    { 0x011d, "GetTraceEnableLevel"                              },
    { 0x011e, "GetTraceLoggerHandle"                             },
    { 0x011f, "GetTrusteeFormA"                                  },
    { 0x0120, "GetTrusteeFormW"                                  },
    { 0x0121, "GetTrusteeNameA"                                  },
    { 0x0122, "GetTrusteeNameW"                                  },
    { 0x0123, "GetTrusteeTypeA"                                  },
    { 0x0124, "GetTrusteeTypeW"                                  },
    { 0x0125, "GetUserNameA"                                     },
    { 0x0126, "GetUserNameW"                                     },
    { 0x0127, "GetWindowsAccountDomainSid"                       },
    { 0x0001, "I_ScGetCurrentGroupStateW"                        },
    { 0x0128, "I_ScIsSecurityProcess"                            },
    { 0x0129, "I_ScPnPGetServiceName"                            },
    { 0x012a, "I_ScSendTSMessage"                                },
    { 0x012b, "I_ScSetServiceBitsA"                              },
    { 0x012c, "I_ScSetServiceBitsW"                              },
    { 0x012d, "IdentifyCodeAuthzLevelW"                          },
    { 0x012e, "ImpersonateAnonymousToken"                        },
    { 0x012f, "ImpersonateLoggedOnUser"                          },
    { 0x0130, "ImpersonateNamedPipeClient"                       },
    { 0x0131, "ImpersonateSelf"                                  },
    { 0x0132, "InitializeAcl"                                    },
    { 0x0133, "InitializeSecurityDescriptor"                     },
    { 0x0134, "InitializeSid"                                    },
    { 0x0135, "InitiateSystemShutdownA"                          },
    { 0x0136, "InitiateSystemShutdownExA"                        },
    { 0x0137, "InitiateSystemShutdownExW"                        },
    { 0x0138, "InitiateSystemShutdownW"                          },
    { 0x0139, "InstallApplication"                               },
    { 0x013a, "IsTextUnicode"                                    },
    { 0x013b, "IsTokenRestricted"                                },
    { 0x013c, "IsTokenUntrusted"                                 },
    { 0x013d, "IsValidAcl"                                       },
    { 0x013e, "IsValidSecurityDescriptor"                        },
    { 0x013f, "IsValidSid"                                       },
    { 0x0140, "IsWellKnownSid"                                   },
    { 0x0141, "LockServiceDatabase"                              },
    { 0x0142, "LogonUserA"                                       },
    { 0x0143, "LogonUserExA"                                     },
    { 0x0144, "LogonUserExW"                                     },
    { 0x0145, "LogonUserW"                                       },
    { 0x0146, "LookupAccountNameA"                               },
    { 0x0147, "LookupAccountNameW"                               },
    { 0x0148, "LookupAccountSidA"                                },
    { 0x0149, "LookupAccountSidW"                                },
    { 0x014a, "LookupPrivilegeDisplayNameA"                      },
    { 0x014b, "LookupPrivilegeDisplayNameW"                      },
    { 0x014c, "LookupPrivilegeNameA"                             },
    { 0x014d, "LookupPrivilegeNameW"                             },
    { 0x014e, "LookupPrivilegeValueA"                            },
    { 0x014f, "LookupPrivilegeValueW"                            },
    { 0x0150, "LookupSecurityDescriptorPartsA"                   },
    { 0x0151, "LookupSecurityDescriptorPartsW"                   },
    { 0x0152, "LsaAddAccountRights"                              },
    { 0x0153, "LsaAddPrivilegesToAccount"                        },
    { 0x0154, "LsaClearAuditLog"                                 },
    { 0x0155, "LsaClose"                                         },
    { 0x0156, "LsaCreateAccount"                                 },
    { 0x0157, "LsaCreateSecret"                                  },
    { 0x0158, "LsaCreateTrustedDomain"                           },
    { 0x0159, "LsaCreateTrustedDomainEx"                         },
    { 0x015a, "LsaDelete"                                        },
    { 0x015b, "LsaDeleteTrustedDomain"                           },
    { 0x015c, "LsaEnumerateAccountRights"                        },
    { 0x015d, "LsaEnumerateAccounts"                             },
    { 0x015e, "LsaEnumerateAccountsWithUserRight"                },
    { 0x015f, "LsaEnumeratePrivileges"                           },
    { 0x0160, "LsaEnumeratePrivilegesOfAccount"                  },
    { 0x0161, "LsaEnumerateTrustedDomains"                       },
    { 0x0162, "LsaEnumerateTrustedDomainsEx"                     },
    { 0x0163, "LsaFreeMemory"                                    },
    { 0x0164, "LsaGetQuotasForAccount"                           },
    { 0x0165, "LsaGetRemoteUserName"                             },
    { 0x0166, "LsaGetSystemAccessAccount"                        },
    { 0x0167, "LsaGetUserName"                                   },
    { 0x0168, "LsaICLookupNames"                                 },
    { 0x0169, "LsaICLookupNamesWithCreds"                        },
    { 0x016a, "LsaICLookupSids"                                  },
    { 0x016b, "LsaICLookupSidsWithCreds"                         },
    { 0x016d, "LsaLookupNames"                                   },
    { 0x016c, "LsaLookupNames2"                                  },
    { 0x016e, "LsaLookupPrivilegeDisplayName"                    },
    { 0x016f, "LsaLookupPrivilegeName"                           },
    { 0x0170, "LsaLookupPrivilegeValue"                          },
    { 0x0171, "LsaLookupSids"                                    },
    { 0x0172, "LsaNtStatusToWinError"                            },
    { 0x0173, "LsaOpenAccount"                                   },
    { 0x0174, "LsaOpenPolicy"                                    },
    { 0x0175, "LsaOpenPolicySce"                                 },
    { 0x0176, "LsaOpenSecret"                                    },
    { 0x0177, "LsaOpenTrustedDomain"                             },
    { 0x0178, "LsaOpenTrustedDomainByName"                       },
    { 0x0179, "LsaQueryDomainInformationPolicy"                  },
    { 0x017a, "LsaQueryForestTrustInformation"                   },
    { 0x017b, "LsaQueryInfoTrustedDomain"                        },
    { 0x017c, "LsaQueryInformationPolicy"                        },
    { 0x017d, "LsaQuerySecret"                                   },
    { 0x017e, "LsaQuerySecurityObject"                           },
    { 0x017f, "LsaQueryTrustedDomainInfo"                        },
    { 0x0180, "LsaQueryTrustedDomainInfoByName"                  },
    { 0x0181, "LsaRemoveAccountRights"                           },
    { 0x0182, "LsaRemovePrivilegesFromAccount"                   },
    { 0x0183, "LsaRetrievePrivateData"                           },
    { 0x0184, "LsaSetDomainInformationPolicy"                    },
    { 0x0185, "LsaSetForestTrustInformation"                     },
    { 0x0186, "LsaSetInformationPolicy"                          },
    { 0x0187, "LsaSetInformationTrustedDomain"                   },
    { 0x0188, "LsaSetQuotasForAccount"                           },
    { 0x0189, "LsaSetSecret"                                     },
    { 0x018a, "LsaSetSecurityObject"                             },
    { 0x018b, "LsaSetSystemAccessAccount"                        },
    { 0x018c, "LsaSetTrustedDomainInfoByName"                    },
    { 0x018d, "LsaSetTrustedDomainInformation"                   },
    { 0x018e, "LsaStorePrivateData"                              },
    { 0x018f, "MD4Final"                                         },
    { 0x0190, "MD4Init"                                          },
    { 0x0191, "MD4Update"                                        },
    { 0x0192, "MD5Final"                                         },
    { 0x0193, "MD5Init"                                          },
    { 0x0194, "MD5Update"                                        },
    { 0x0196, "MSChapSrvChangePassword"                          },
    { 0x0195, "MSChapSrvChangePassword2"                         },
    { 0x0198, "MakeAbsoluteSD"                                   },
    { 0x0197, "MakeAbsoluteSD2"                                  },
    { 0x0199, "MakeSelfRelativeSD"                               },
    { 0x019a, "MapGenericMask"                                   },
    { 0x019b, "NotifyBootConfigStatus"                           },
    { 0x019c, "NotifyChangeEventLog"                             },
    { 0x019d, "ObjectCloseAuditAlarmA"                           },
    { 0x019e, "ObjectCloseAuditAlarmW"                           },
    { 0x019f, "ObjectDeleteAuditAlarmA"                          },
    { 0x01a0, "ObjectDeleteAuditAlarmW"                          },
    { 0x01a1, "ObjectOpenAuditAlarmA"                            },
    { 0x01a2, "ObjectOpenAuditAlarmW"                            },
    { 0x01a3, "ObjectPrivilegeAuditAlarmA"                       },
    { 0x01a4, "ObjectPrivilegeAuditAlarmW"                       },
    { 0x01a5, "OpenBackupEventLogA"                              },
    { 0x01a6, "OpenBackupEventLogW"                              },
    { 0x01a7, "OpenEncryptedFileRawA"                            },
    { 0x01a8, "OpenEncryptedFileRawW"                            },
    { 0x01a9, "OpenEventLogA"                                    },
    { 0x01aa, "OpenEventLogW"                                    },
    { 0x01ab, "OpenProcessToken"                                 },
    { 0x01ac, "OpenSCManagerA"                                   },
    { 0x01ad, "OpenSCManagerW"                                   },
    { 0x01ae, "OpenServiceA"                                     },
    { 0x01af, "OpenServiceW"                                     },
    { 0x01b0, "OpenThreadToken"                                  },
    { 0x01b1, "OpenTraceA"                                       },
    { 0x01b2, "OpenTraceW"                                       },
    { 0x01b3, "PrivilegeCheck"                                   },
    { 0x01b4, "PrivilegedServiceAuditAlarmA"                     },
    { 0x01b5, "PrivilegedServiceAuditAlarmW"                     },
    { 0x01b6, "ProcessIdleTasks"                                 },
    { 0x01b7, "ProcessTrace"                                     },
    { 0x01b8, "QueryAllTracesA"                                  },
    { 0x01b9, "QueryAllTracesW"                                  },
    { 0x01ba, "QueryRecoveryAgentsOnEncryptedFile"               },
    { 0x01bb, "QueryServiceConfig2A"                             },
    { 0x01bc, "QueryServiceConfig2W"                             },
    { 0x01bd, "QueryServiceConfigA"                              },
    { 0x01be, "QueryServiceConfigW"                              },
    { 0x01bf, "QueryServiceLockStatusA"                          },
    { 0x01c0, "QueryServiceLockStatusW"                          },
    { 0x01c1, "QueryServiceObjectSecurity"                       },
    { 0x01c2, "QueryServiceStatus"                               },
    { 0x01c3, "QueryServiceStatusEx"                             },
    { 0x01c4, "QueryTraceA"                                      },
    { 0x01c5, "QueryTraceW"                                      },
    { 0x01c6, "QueryUsersOnEncryptedFile"                        },
    { 0x01c7, "QueryWindows31FilesMigration"                     },
    { 0x01c8, "ReadEncryptedFileRaw"                             },
    { 0x01c9, "ReadEventLogA"                                    },
    { 0x01ca, "ReadEventLogW"                                    },
    { 0x01cb, "RegCloseKey"                                      },
    { 0x01cc, "RegConnectRegistryA"                              },
    { 0x01cd, "RegConnectRegistryW"                              },
    { 0x01ce, "RegCreateKeyA"                                    },
    { 0x01cf, "RegCreateKeyExA"                                  },
    { 0x01d0, "RegCreateKeyExW"                                  },
    { 0x01d1, "RegCreateKeyW"                                    },
    { 0x01d2, "RegDeleteKeyA"                                    },
    { 0x01d3, "RegDeleteKeyW"                                    },
    { 0x01d4, "RegDeleteValueA"                                  },
    { 0x01d5, "RegDeleteValueW"                                  },
    { 0x01d6, "RegDisablePredefinedCache"                        },
    { 0x01d7, "RegEnumKeyA"                                      },
    { 0x01d8, "RegEnumKeyExA"                                    },
    { 0x01d9, "RegEnumKeyExW"                                    },
    { 0x01da, "RegEnumKeyW"                                      },
    { 0x01db, "RegEnumValueA"                                    },
    { 0x01dc, "RegEnumValueW"                                    },
    { 0x01dd, "RegFlushKey"                                      },
    { 0x01de, "RegGetKeySecurity"                                },
    { 0x01df, "RegLoadKeyA"                                      },
    { 0x01e0, "RegLoadKeyW"                                      },
    { 0x01e1, "RegNotifyChangeKeyValue"                          },
    { 0x01e2, "RegOpenCurrentUser"                               },
    { 0x01e3, "RegOpenKeyA"                                      },
    { 0x01e4, "RegOpenKeyExA"                                    },
    { 0x01e5, "RegOpenKeyExW"                                    },
    { 0x01e6, "RegOpenKeyW"                                      },
    { 0x01e7, "RegOpenUserClassesRoot"                           },
    { 0x01e8, "RegOverridePredefKey"                             },
    { 0x01e9, "RegQueryInfoKeyA"                                 },
    { 0x01ea, "RegQueryInfoKeyW"                                 },
    { 0x01eb, "RegQueryMultipleValuesA"                          },
    { 0x01ec, "RegQueryMultipleValuesW"                          },
    { 0x01ed, "RegQueryValueA"                                   },
    { 0x01ee, "RegQueryValueExA"                                 },
    { 0x01ef, "RegQueryValueExW"                                 },
    { 0x01f0, "RegQueryValueW"                                   },
    { 0x01f1, "RegReplaceKeyA"                                   },
    { 0x01f2, "RegReplaceKeyW"                                   },
    { 0x01f3, "RegRestoreKeyA"                                   },
    { 0x01f4, "RegRestoreKeyW"                                   },
    { 0x01f5, "RegSaveKeyA"                                      },
    { 0x01f6, "RegSaveKeyExA"                                    },
    { 0x01f7, "RegSaveKeyExW"                                    },
    { 0x01f8, "RegSaveKeyW"                                      },
    { 0x01f9, "RegSetKeySecurity"                                },
    { 0x01fa, "RegSetValueA"                                     },
    { 0x01fb, "RegSetValueExA"                                   },
    { 0x01fc, "RegSetValueExW"                                   },
    { 0x01fd, "RegSetValueW"                                     },
    { 0x01fe, "RegUnLoadKeyA"                                    },
    { 0x01ff, "RegUnLoadKeyW"                                    },
    { 0x0200, "RegisterEventSourceA"                             },
    { 0x0201, "RegisterEventSourceW"                             },
    { 0x0202, "RegisterIdleTask"                                 },
    { 0x0203, "RegisterServiceCtrlHandlerA"                      },
    { 0x0204, "RegisterServiceCtrlHandlerExA"                    },
    { 0x0205, "RegisterServiceCtrlHandlerExW"                    },
    { 0x0206, "RegisterServiceCtrlHandlerW"                      },
    { 0x0207, "RegisterTraceGuidsA"                              },
    { 0x0208, "RegisterTraceGuidsW"                              },
    { 0x0209, "RemoveTraceCallback"                              },
    { 0x020a, "RemoveUsersFromEncryptedFile"                     },
    { 0x020b, "ReportEventA"                                     },
    { 0x020c, "ReportEventW"                                     },
    { 0x020d, "RevertToSelf"                                     },
    { 0x020e, "SaferCloseLevel"                                  },
    { 0x020f, "SaferComputeTokenFromLevel"                       },
    { 0x0210, "SaferCreateLevel"                                 },
    { 0x0211, "SaferGetLevelInformation"                         },
    { 0x0212, "SaferGetPolicyInformation"                        },
    { 0x0213, "SaferIdentifyLevel"                               },
    { 0x0214, "SaferRecordEventLogEntry"                         },
    { 0x0215, "SaferSetLevelInformation"                         },
    { 0x0216, "SaferSetPolicyInformation"                        },
    { 0x0217, "SaferiChangeRegistryScope"                        },
    { 0x0218, "SaferiCompareTokenLevels"                         },
    { 0x0219, "SaferiIsExecutableFileType"                       },
    { 0x021a, "SaferiPopulateDefaultsInRegistry"                 },
    { 0x021b, "SaferiRecordEventLogEntry"                        },
    { 0x021c, "SaferiReplaceProcessThreadTokens"                 },
    { 0x021d, "SaferiSearchMatchingHashRules"                    },
    { 0x021e, "SetAclInformation"                                },
    { 0x021f, "SetEntriesInAccessListA"                          },
    { 0x0220, "SetEntriesInAccessListW"                          },
    { 0x0221, "SetEntriesInAclA"                                 },
    { 0x0222, "SetEntriesInAclW"                                 },
    { 0x0223, "SetEntriesInAuditListA"                           },
    { 0x0224, "SetEntriesInAuditListW"                           },
    { 0x0225, "SetFileSecurityA"                                 },
    { 0x0226, "SetFileSecurityW"                                 },
    { 0x0227, "SetInformationCodeAuthzLevelW"                    },
    { 0x0228, "SetInformationCodeAuthzPolicyW"                   },
    { 0x0229, "SetKernelObjectSecurity"                          },
    { 0x022a, "SetNamedSecurityInfoA"                            },
    { 0x022b, "SetNamedSecurityInfoExA"                          },
    { 0x022c, "SetNamedSecurityInfoExW"                          },
    { 0x022d, "SetNamedSecurityInfoW"                            },
    { 0x022e, "SetPrivateObjectSecurity"                         },
    { 0x022f, "SetPrivateObjectSecurityEx"                       },
    { 0x0230, "SetSecurityDescriptorControl"                     },
    { 0x0231, "SetSecurityDescriptorDacl"                        },
    { 0x0232, "SetSecurityDescriptorGroup"                       },
    { 0x0233, "SetSecurityDescriptorOwner"                       },
    { 0x0234, "SetSecurityDescriptorRMControl"                   },
    { 0x0235, "SetSecurityDescriptorSacl"                        },
    { 0x0236, "SetSecurityInfo"                                  },
    { 0x0237, "SetSecurityInfoExA"                               },
    { 0x0238, "SetSecurityInfoExW"                               },
    { 0x0239, "SetServiceBits"                                   },
    { 0x023a, "SetServiceObjectSecurity"                         },
    { 0x023b, "SetServiceStatus"                                 },
    { 0x023c, "SetThreadToken"                                   },
    { 0x023d, "SetTokenInformation"                              },
    { 0x023e, "SetTraceCallback"                                 },
    { 0x023f, "SetUserFileEncryptionKey"                         },
    { 0x0240, "StartServiceA"                                    },
    { 0x0241, "StartServiceCtrlDispatcherA"                      },
    { 0x0242, "StartServiceCtrlDispatcherW"                      },
    { 0x0243, "StartServiceW"                                    },
    { 0x0244, "StartTraceA"                                      },
    { 0x0245, "StartTraceW"                                      },
    { 0x0246, "StopTraceA"                                       },
    { 0x0247, "StopTraceW"                                       },
    { 0x0248, "SynchronizeWindows31FilesAndWindowsNTRegistry"    },
    { 0x0249, "SystemFunction001"                                },
    { 0x024a, "SystemFunction002"                                },
    { 0x024b, "SystemFunction003"                                },
    { 0x024c, "SystemFunction004"                                },
    { 0x024d, "SystemFunction005"                                },
    { 0x024e, "SystemFunction006"                                },
    { 0x024f, "SystemFunction007"                                },
    { 0x0250, "SystemFunction008"                                },
    { 0x0251, "SystemFunction009"                                },
    { 0x0252, "SystemFunction010"                                },
    { 0x0253, "SystemFunction011"                                },
    { 0x0254, "SystemFunction012"                                },
    { 0x0255, "SystemFunction013"                                },
    { 0x0256, "SystemFunction014"                                },
    { 0x0257, "SystemFunction015"                                },
    { 0x0258, "SystemFunction016"                                },
    { 0x0259, "SystemFunction017"                                },
    { 0x025a, "SystemFunction018"                                },
    { 0x025b, "SystemFunction019"                                },
    { 0x025c, "SystemFunction020"                                },
    { 0x025d, "SystemFunction021"                                },
    { 0x025e, "SystemFunction022"                                },
    { 0x025f, "SystemFunction023"                                },
    { 0x0260, "SystemFunction024"                                },
    { 0x0261, "SystemFunction025"                                },
    { 0x0262, "SystemFunction026"                                },
    { 0x0263, "SystemFunction027"                                },
    { 0x0264, "SystemFunction028"                                },
    { 0x0265, "SystemFunction029"                                },
    { 0x0266, "SystemFunction030"                                },
    { 0x0267, "SystemFunction031"                                },
    { 0x0268, "SystemFunction032"                                },
    { 0x0269, "SystemFunction033"                                },
    { 0x026a, "SystemFunction034"                                },
    { 0x026b, "SystemFunction035"                                },
    { 0x026c, "SystemFunction036"                                },
    { 0x026d, "SystemFunction040"                                },
    { 0x026e, "SystemFunction041"                                },
    { 0x026f, "TraceEvent"                                       },
    { 0x0270, "TraceEventInstance"                               },
    { 0x0271, "TraceMessage"                                     },
    { 0x0272, "TraceMessageVa"                                   },
    { 0x0273, "TreeResetNamedSecurityInfoA"                      },
    { 0x0274, "TreeResetNamedSecurityInfoW"                      },
    { 0x0275, "TrusteeAccessToObjectA"                           },
    { 0x0276, "TrusteeAccessToObjectW"                           },
    { 0x0277, "UninstallApplication"                             },
    { 0x0278, "UnlockServiceDatabase"                            },
    { 0x0279, "UnregisterIdleTask"                               },
    { 0x027a, "UnregisterTraceGuids"                             },
    { 0x027b, "UpdateTraceA"                                     },
    { 0x027c, "UpdateTraceW"                                     },
    { 0x027d, "WdmWmiServiceMain"                                },
    { 0x027e, "WmiCloseBlock"                                    },
    { 0x027f, "WmiCloseTraceWithCursor"                          },
    { 0x0280, "WmiConvertTimestamp"                              },
    { 0x0281, "WmiDevInstToInstanceNameA"                        },
    { 0x0282, "WmiDevInstToInstanceNameW"                        },
    { 0x0283, "WmiEnumerateGuids"                                },
    { 0x0284, "WmiExecuteMethodA"                                },
    { 0x0285, "WmiExecuteMethodW"                                },
    { 0x0286, "WmiFileHandleToInstanceNameA"                     },
    { 0x0287, "WmiFileHandleToInstanceNameW"                     },
    { 0x0288, "WmiFreeBuffer"                                    },
    { 0x0289, "WmiGetFirstTraceOffset"                           },
    { 0x028a, "WmiGetNextEvent"                                  },
    { 0x028b, "WmiGetTraceHeader"                                },
    { 0x028c, "WmiMofEnumerateResourcesA"                        },
    { 0x028d, "WmiMofEnumerateResourcesW"                        },
    { 0x028e, "WmiNotificationRegistrationA"                     },
    { 0x028f, "WmiNotificationRegistrationW"                     },
    { 0x0290, "WmiOpenBlock"                                     },
    { 0x0291, "WmiOpenTraceWithCursor"                           },
    { 0x0292, "WmiParseTraceEvent"                               },
    { 0x0293, "WmiQueryAllDataA"                                 },
    { 0x0294, "WmiQueryAllDataMultipleA"                         },
    { 0x0295, "WmiQueryAllDataMultipleW"                         },
    { 0x0296, "WmiQueryAllDataW"                                 },
    { 0x0297, "WmiQueryGuidInformation"                          },
    { 0x0298, "WmiQuerySingleInstanceA"                          },
    { 0x0299, "WmiQuerySingleInstanceMultipleA"                  },
    { 0x029a, "WmiQuerySingleInstanceMultipleW"                  },
    { 0x029b, "WmiQuerySingleInstanceW"                          },
    { 0x029c, "WmiReceiveNotificationsA"                         },
    { 0x029d, "WmiReceiveNotificationsW"                         },
    { 0x029e, "WmiSetSingleInstanceA"                            },
    { 0x029f, "WmiSetSingleInstanceW"                            },
    { 0x02a0, "WmiSetSingleItemA"                                },
    { 0x02a1, "WmiSetSingleItemW"                                },
    { 0x02a2, "Wow64Win32ApiEntry"                               },
    { 0x02a3, "WriteEncryptedFileRaw"                            },
};


}
}

#endif

