// This file is part of MinIO DirectPV
// Copyright (c) 2021, 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// Code generated by client-gen. DO NOT EDIT.

package v1beta3

import (
	"net/http"

	v1beta3 "github.com/minio/directpv/pkg/apis/direct.csi.min.io/v1beta3"
	"github.com/minio/directpv/pkg/clientset/scheme"
	rest "k8s.io/client-go/rest"
)

type DirectV1beta3Interface interface {
	RESTClient() rest.Interface
	DirectCSIDrivesGetter
	DirectCSIVolumesGetter
}

// DirectV1beta3Client is used to interact with features provided by the direct.csi.min.io group.
type DirectV1beta3Client struct {
	restClient rest.Interface
}

func (c *DirectV1beta3Client) DirectCSIDrives() DirectCSIDriveInterface {
	return newDirectCSIDrives(c)
}

func (c *DirectV1beta3Client) DirectCSIVolumes() DirectCSIVolumeInterface {
	return newDirectCSIVolumes(c)
}

// NewForConfig creates a new DirectV1beta3Client for the given config.
// NewForConfig is equivalent to NewForConfigAndClient(c, httpClient),
// where httpClient was generated with rest.HTTPClientFor(c).
func NewForConfig(c *rest.Config) (*DirectV1beta3Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	httpClient, err := rest.HTTPClientFor(&config)
	if err != nil {
		return nil, err
	}
	return NewForConfigAndClient(&config, httpClient)
}

// NewForConfigAndClient creates a new DirectV1beta3Client for the given config and http client.
// Note the http client provided takes precedence over the configured transport values.
func NewForConfigAndClient(c *rest.Config, h *http.Client) (*DirectV1beta3Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientForConfigAndClient(&config, h)
	if err != nil {
		return nil, err
	}
	return &DirectV1beta3Client{client}, nil
}

// NewForConfigOrDie creates a new DirectV1beta3Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *DirectV1beta3Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new DirectV1beta3Client for the given RESTClient.
func New(c rest.Interface) *DirectV1beta3Client {
	return &DirectV1beta3Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1beta3.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *DirectV1beta3Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
