// This file is part of MinIO DirectPV
// Copyright (c) 2021, 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	"time"

	v1beta1 "github.com/minio/directpv/pkg/apis/direct.csi.min.io/v1beta1"
	scheme "github.com/minio/directpv/pkg/clientset/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// DirectCSIVolumesGetter has a method to return a DirectCSIVolumeInterface.
// A group's client should implement this interface.
type DirectCSIVolumesGetter interface {
	DirectCSIVolumes() DirectCSIVolumeInterface
}

// DirectCSIVolumeInterface has methods to work with DirectCSIVolume resources.
type DirectCSIVolumeInterface interface {
	Create(ctx context.Context, directCSIVolume *v1beta1.DirectCSIVolume, opts v1.CreateOptions) (*v1beta1.DirectCSIVolume, error)
	Update(ctx context.Context, directCSIVolume *v1beta1.DirectCSIVolume, opts v1.UpdateOptions) (*v1beta1.DirectCSIVolume, error)
	UpdateStatus(ctx context.Context, directCSIVolume *v1beta1.DirectCSIVolume, opts v1.UpdateOptions) (*v1beta1.DirectCSIVolume, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.DirectCSIVolume, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.DirectCSIVolumeList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.DirectCSIVolume, err error)
	DirectCSIVolumeExpansion
}

// directCSIVolumes implements DirectCSIVolumeInterface
type directCSIVolumes struct {
	client rest.Interface
}

// newDirectCSIVolumes returns a DirectCSIVolumes
func newDirectCSIVolumes(c *DirectV1beta1Client) *directCSIVolumes {
	return &directCSIVolumes{
		client: c.RESTClient(),
	}
}

// Get takes name of the directCSIVolume, and returns the corresponding directCSIVolume object, and an error if there is any.
func (c *directCSIVolumes) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.DirectCSIVolume, err error) {
	result = &v1beta1.DirectCSIVolume{}
	err = c.client.Get().
		Resource("directcsivolumes").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of DirectCSIVolumes that match those selectors.
func (c *directCSIVolumes) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.DirectCSIVolumeList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.DirectCSIVolumeList{}
	err = c.client.Get().
		Resource("directcsivolumes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested directCSIVolumes.
func (c *directCSIVolumes) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("directcsivolumes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a directCSIVolume and creates it.  Returns the server's representation of the directCSIVolume, and an error, if there is any.
func (c *directCSIVolumes) Create(ctx context.Context, directCSIVolume *v1beta1.DirectCSIVolume, opts v1.CreateOptions) (result *v1beta1.DirectCSIVolume, err error) {
	result = &v1beta1.DirectCSIVolume{}
	err = c.client.Post().
		Resource("directcsivolumes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(directCSIVolume).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a directCSIVolume and updates it. Returns the server's representation of the directCSIVolume, and an error, if there is any.
func (c *directCSIVolumes) Update(ctx context.Context, directCSIVolume *v1beta1.DirectCSIVolume, opts v1.UpdateOptions) (result *v1beta1.DirectCSIVolume, err error) {
	result = &v1beta1.DirectCSIVolume{}
	err = c.client.Put().
		Resource("directcsivolumes").
		Name(directCSIVolume.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(directCSIVolume).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *directCSIVolumes) UpdateStatus(ctx context.Context, directCSIVolume *v1beta1.DirectCSIVolume, opts v1.UpdateOptions) (result *v1beta1.DirectCSIVolume, err error) {
	result = &v1beta1.DirectCSIVolume{}
	err = c.client.Put().
		Resource("directcsivolumes").
		Name(directCSIVolume.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(directCSIVolume).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the directCSIVolume and deletes it. Returns an error if one occurs.
func (c *directCSIVolumes) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("directcsivolumes").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *directCSIVolumes) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("directcsivolumes").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched directCSIVolume.
func (c *directCSIVolumes) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.DirectCSIVolume, err error) {
	result = &v1beta1.DirectCSIVolume{}
	err = c.client.Patch(pt).
		Resource("directcsivolumes").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
