// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const ServiceAccountCredentialsIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={"min-icon"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="clip-path">
        <rect
          id="Rectángulo_1007"
          data-name="Rectángulo 1007"
          width="256"
          height="174.517"
          fill="none"
        />
      </clipPath>
      <clipPath id="clip-New_Service_Account_Created">
        <rect width="256" height="256" />
      </clipPath>
    </defs>
    <g
      id="New_Service_Account_Created"
      data-name="New Service Account Created"
      clipPath="url(#clip-New_Service_Account_Created)"
    >
      <rect width="256" height="256" fill="#fff" />
      <g
        id="Create_Service_Account_Icon"
        data-name="Create Service Account Icon"
      >
        <rect
          id="Rectángulo_1006"
          data-name="Rectángulo 1006"
          width="256"
          height="256"
          fill="none"
        />
        <g
          id="Grupo_2394"
          data-name="Grupo 2394"
          transform="translate(0 41.709)"
        >
          <g
            id="Grupo_2393"
            data-name="Grupo 2393"
            transform="translate(0 -0.001)"
          >
            <path
              id="Trazado_7132"
              data-name="Trazado 7132"
              d="M209.54,0a46.254,46.254,0,0,0-29.083,10.24H27.839a27.482,27.482,0,0,0-10.808,2.2A28.109,28.109,0,0,0,2.2,27.269,27.507,27.507,0,0,0,0,38.078v108.6a27.507,27.507,0,0,0,2.2,10.809,28.112,28.112,0,0,0,14.834,14.834,27.5,27.5,0,0,0,10.808,2.2H195.985a27.5,27.5,0,0,0,10.808-2.2,28.11,28.11,0,0,0,14.833-14.834,27.486,27.486,0,0,0,2.2-10.809v-56A46.462,46.462,0,0,0,209.54,0m-5.828,67.986V53.635H189.362V39.283h14.351V24.933h14.351V39.283h14.351V53.635H218.064V67.985Zm-69.071,1.7h34.67a46.667,46.667,0,0,0,17.844,17.486H134.641a8.743,8.743,0,1,1,0-17.486M68.625,23.35h0c19.765,0,35.837,16.716,35.837,37.255a38.068,38.068,0,0,1-2.816,14.482,37.124,37.124,0,0,1-7.674,11.841,35.566,35.566,0,0,1-11.39,8A34.44,34.44,0,0,1,68.65,97.872h-.025C48.872,97.872,32.8,81.148,32.8,60.606S48.872,23.35,68.625,23.35m41.452,122.5a16.272,16.272,0,0,1-14.76,9.426H38.868a16.474,16.474,0,0,1-14.823-9.289,19.517,19.517,0,0,1,1.376-19.337l.013-.014c.051-.08.111-.164.162-.236l.056-.078c.24-.358.435-.637.635-.9a51.4,51.4,0,0,1,38.031-20.735c.806-.046,1.673-.07,2.578-.07v0a48.828,48.828,0,0,1,11.065,1.3,52.471,52.471,0,0,1,10.723,3.8,51.858,51.858,0,0,1,19.446,16.116,19.952,19.952,0,0,1,1.946,20.028m85.765,8.641h-61.2a8.743,8.743,0,1,1,0-17.486h61.2a8.743,8.743,0,1,1,0,17.486m0-33.223h-61.2a8.743,8.743,0,1,1,0-17.485h61.2a8.743,8.743,0,1,1,0,17.485m13.976-38.1a36.707,36.707,0,1,1,36.707-36.707,36.707,36.707,0,0,1-36.707,36.707"
              transform="translate(0 0.001)"
              fill="#4ccb92"
            />
          </g>
        </g>
      </g>
    </g>
  </svg>
);

export default ServiceAccountCredentialsIcon;
