// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import React, { SVGProps } from "react";

const S3TierIcon = (props: SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      className={`min-icon`}
      fill={"currentcolor"}
      viewBox="0 0 18.201 22"
      {...props}
    >
      <path
        id="Trazado_6934"
        data-name="Trazado 6934"
        d="M1.477,53.686,0,54.417V67.239l1.477.726.009-.011V53.7l-.009-.01"
        transform="translate(0 -49.842)"
        fill="#6b8295"
      />
      <path
        id="Trazado_6935"
        data-name="Trazado 6935"
        d="M28.526,66.1l-7.9,1.861V53.686l7.9,1.821V66.1"
        transform="translate(-19.147 -49.842)"
      />
      <path
        id="Trazado_6936"
        data-name="Trazado 6936"
        d="M81.178,120.939l3.352.427.021-.049.019-5.5-.04-.043-3.352.421v4.74"
        transform="translate(-75.415 -107.566)"
        fill="#6b8295"
      />
      <path
        id="Trazado_6937"
        data-name="Trazado 6937"
        d="M128,66.125l7.687,1.844.012-.019V53.7l-.012-.013L128,55.527v10.6"
        transform="translate(-118.959 -49.842)"
        fill="#6b8295"
      />
      <path
        id="Trazado_6938"
        data-name="Trazado 6938"
        d="M131.349,120.939l-3.353.427v-5.588l3.353.421v4.74"
        transform="translate(-118.91 -107.566)"
      />
      <path
        id="Trazado_6939"
        data-name="Trazado 6939"
        d="M87.883,78.252l-3.353.611-3.352-.611,3.348-.877,3.357.877"
        transform="translate(-75.429 -71.876)"
        fill="#5a6e7e"
      />
      <path
        id="Trazado_6940"
        data-name="Trazado 6940"
        d="M87.883,211.825l-3.353-.615-3.352.615,3.348.934,3.357-.934"
        transform="translate(-75.429 -196.201)"
        fill="#9aafbf"
      />
      <path
        id="Trazado_6941"
        data-name="Trazado 6941"
        d="M81.178,6.417l3.352-.829.027-.008V.022L84.53,0,81.178,1.676V6.417"
        transform="translate(-75.415)"
        fill="#6b8295"
      />
      <path
        id="Trazado_6942"
        data-name="Trazado 6942"
        d="M131.349,6.417,128,5.587V0l3.353,1.676V6.417"
        transform="translate(-118.91)"
      />
      <path
        id="Trazado_6943"
        data-name="Trazado 6943"
        d="M84.525,226.222l-3.352-1.676v-4.741l3.352.829.049.056-.013,5.434-.036.1"
        transform="translate(-75.411 -204.222)"
        fill="#6b8295"
      />
      <path
        id="Trazado_6944"
        data-name="Trazado 6944"
        d="M128,226.222l3.352-1.676v-4.741l-3.352.829v5.587"
        transform="translate(-118.91 -204.222)"
      />
      <path
        id="Trazado_6945"
        data-name="Trazado 6945"
        d="M235.367,53.686l1.477.731V67.239l-1.477.73V53.686"
        transform="translate(-218.643 -49.842)"
      />
    </svg>
  );
};

export default S3TierIcon;
