// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import React, { SVGProps } from "react";

const OperatorLogo = (props: SVGProps<SVGSVGElement>) => {
  return (
    <svg
      {...props}
      className={`min-icon`}
      fill={"currentcolor"}
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 606.583 134.691"
    >
      <g id="prefix__Layer_2" data-name="Layer 2">
        <g id="prefix__Layer_1-2" data-name="Layer 1">
          <path
            className="prefix__cls-1"
            d="M79.695 95.063c0 23.03-16.763 39.628-39.848 39.628C16.763 134.69 0 118.092 0 95.063s16.763-39.628 39.847-39.628c23.085 0 39.848 16.599 39.848 39.628zm-69.582 0c0 18.083 12.806 30.339 29.734 30.339 16.929 0 29.735-12.256 29.735-30.34 0-18.081-12.806-30.338-29.735-30.338-16.928 0-29.734 12.257-29.734 30.339zM106.895 102.758v30.779H97.22V56.589h29.24c17.368 0 27.206 8.685 27.206 23.084 0 14.4-9.838 23.085-27.206 23.085zm0-37.045v27.921h19.346c11.377 0 17.368-4.617 17.368-13.96 0-9.344-5.99-13.96-17.368-13.96zM224.784 133.537h-54.632V56.589h54.082v9.07h-44.409v24.567h42.98v9.124h-42.98v25.118h44.96zM275.07 56.59c17.368 0 26.931 7.804 26.931 21.82 0 13.355-10.387 21.93-26.876 21.93h-.604l27.096 33.197h-11.982l-26.437-33.198h-9.013v33.198h-9.674V56.589zm-20.885 9.069v25.886h20.665c11.322 0 17.093-4.506 17.093-13.135 0-8.52-5.935-12.751-17.093-12.751zM384.716 133.537h-10.388l-8.464-20.996h-37.32l-8.409 20.996h-10.058l31.274-76.948h12.036zm-52.49-30.174h29.955l-14.95-37.21zM445.114 65.768h-26.217v67.769h-9.673V65.768h-26.272v-9.179h62.162zM531.566 95.063c0 23.03-16.763 39.628-39.847 39.628s-39.848-16.599-39.848-39.628 16.764-39.628 39.848-39.628 39.847 16.599 39.847 39.628zm-69.582 0c0 18.083 12.807 30.339 29.735 30.339 16.928 0 29.735-12.256 29.735-30.34 0-18.081-12.807-30.338-29.735-30.338-16.928 0-29.735 12.257-29.735 30.339zM579.652 56.59c17.368 0 26.931 7.804 26.931 21.82 0 13.355-10.388 21.93-26.876 21.93h-.605l27.096 33.197h-11.981l-26.437-33.198h-9.014v33.198h-9.673V56.589zm-20.886 9.069v25.886h20.666c11.322 0 17.093-4.506 17.093-13.135 0-8.52-5.936-12.751-17.093-12.751zM72.292.762h11.75v34.419h-11.75zM58.159 1.087l-23.85 14.566a1.06 1.06 0 01-1.106 0L9.352 1.087a3.272 3.272 0 00-1.705-.48h-.03a3.27 3.27 0 00-3.27 3.27v31.304H16.09V20.327a1.175 1.175 0 011.787-1.002l13.366 8.177a4.188 4.188 0 004.304.04l14.104-8.273a1.174 1.174 0 011.769 1.013v14.9h11.742V3.876a3.27 3.27 0 00-3.27-3.27h-.03a3.266 3.266 0 00-1.703.48zM142.742.753h-11.916v15.794a1.175 1.175 0 01-1.727 1.037L98.22 1.137A3.268 3.268 0 0096.68.753h-.02a3.27 3.27 0 00-3.27 3.27v31.158h11.82V19.64a1.174 1.174 0 011.725-1.038l31.004 16.445a3.27 3.27 0 001.533.381 3.27 3.27 0 003.27-3.27V.753zM152.279 35.173V.753h5.463v34.42zM189.208 35.926c-14.545 0-24.863-6.9-24.863-17.963C164.345 6.962 174.725 0 189.208 0c14.482 0 24.924 6.899 24.924 17.963s-10.194 17.963-24.924 17.963zm0-31.327c-10.815 0-19.145 4.724-19.145 13.364 0 8.702 8.33 13.363 19.145 13.363s19.206-4.662 19.206-13.363c0-8.64-8.392-13.364-19.206-13.364z"
          />
        </g>
      </g>
    </svg>
  );
};

export default OperatorLogo;
