// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const OnlineRegistrationIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    width="32.12"
    height="25"
    {...props}
  >
    <defs>
      <clipPath id="online-registration-icn_svg__a">
        <path
          data-name="Rect\xE1ngulo 1601"
          fill="none"
          d="M0 0h256v189.799H0z"
        />
      </clipPath>
    </defs>
    <g data-name="Grupo 2523">
      <g
        data-name="Grupo 2522"
        transform="translate(0 32.999)"
        clipPath="url(#online-registration-icn_svg__a)"
        fill="#00142f"
      >
        <path
          data-name="Trazado 7258"
          d="M105.956 117.2a75.071 75.071 0 0 0 .763 10.469h12.926v-20.938h-12.926a75.072 75.072 0 0 0-.763 10.469"
        />
        <path
          data-name="Trazado 7259"
          d="M119.607 100.222V80.94a29.091 29.091 0 0 0-11.667 19.282Z"
        />
        <path
          data-name="Trazado 7260"
          d="M119.614 153.467h.008v-19.282h-11.675a29.062 29.062 0 0 0 11.667 19.282"
        />
        <path
          data-name="Trazado 7261"
          d="M155.805 100.221a37.276 37.276 0 0 0-18.1-16.993 50.754 50.754 0 0 1 6.807 16.993Z"
        />
        <path
          data-name="Trazado 7262"
          d="M99.417 117.2h.034a81.388 81.388 0 0 1 .679-10.469H87.323a36.628 36.628 0 0 0 0 20.938h12.773a82.781 82.781 0 0 1-.679-10.469"
        />
        <path
          data-name="Trazado 7263"
          d="M108.039 83.229a37.31 37.31 0 0 0-18.099 16.992h11.293a50.754 50.754 0 0 1 6.806-16.993"
        />
        <path
          data-name="Trazado 7264"
          d="M89.947 134.178a37.31 37.31 0 0 0 18.1 16.993 50.754 50.754 0 0 1-6.806-16.993Z"
        />
        <path
          data-name="Trazado 7265"
          d="M145.603 106.731a80.807 80.807 0 0 1 0 20.938h12.811a36.5 36.5 0 0 0 0-20.938Z"
        />
        <path
          data-name="Trazado 7266"
          d="M137.706 151.171a37.31 37.31 0 0 0 18.1-16.993h-11.294a50.754 50.754 0 0 1-6.806 16.993"
        />
        <path
          data-name="Trazado 7267"
          d="m230.957 100.848-.443.221-.473.16a13.816 13.816 0 0 1-4.494.748v-.023h-.671a22.917 22.917 0 0 1-9.309-2.884 4.907 4.907 0 0 0-.671-.313q-.275.114-.549.252a18.913 18.913 0 0 1-13.636 2.472l-.992-.2-.9-.443a19.76 19.76 0 0 1-9.619-10.306 5.449 5.449 0 0 0-.305-.542 5.087 5.087 0 0 0-.488-.107 19.2 19.2 0 0 1-12.5-6.4l-.61-.687-.427-.809a20.457 20.457 0 0 1-1.908-13.735 5.126 5.126 0 0 0 .046-.969 5.773 5.773 0 0 0-.443-.526 20.249 20.249 0 0 1-6.379-12.682l-.092-.832.092-.832a20.268 20.268 0 0 1 6.394-12.682 4.831 4.831 0 0 0 .427-.549 5.1 5.1 0 0 0-.069-.961 20.376 20.376 0 0 1 .992-11.552A62.2 62.2 0 0 0 60.692 61.216c0 1.351.053 2.732.168 4.2a62.2 62.2 0 0 0 1.678 124.381h120.683a62.1 62.1 0 0 0 53.886-93.717 19.522 19.522 0 0 1-6.15 4.769m-67.064 30.957a3.466 3.466 0 0 1-.2.534 43.494 43.494 0 0 1-81.645 0 2.641 2.641 0 0 1-.2-.534 42.738 42.738 0 0 1 0-29.285 2.641 2.641 0 0 1 .2-.534 43.494 43.494 0 0 1 81.645 0 2.642 2.642 0 0 1 .2.534 42.827 42.827 0 0 1 0 29.285"
        />
        <path
          data-name="Trazado 7268"
          d="M126.131 134.178v19.282a29.062 29.062 0 0 0 11.67-19.282Z"
        />
        <path
          data-name="Trazado 7269"
          d="M126.131 80.94v19.282h11.67a29.091 29.091 0 0 0-11.67-19.282"
        />
        <path data-name="Trazado 7270" d="M139.79 117.194Z" />
        <path
          data-name="Trazado 7271"
          d="M139.789 117.2a75.154 75.154 0 0 0-.763-10.469H126.1v20.93h12.926a74.96 74.96 0 0 0 .763-10.461"
        />
        <path
          data-name="Trazado 7272"
          d="m251.907 61.322-.023-.008a12.677 12.677 0 0 0 4.113-8.02 12.677 12.677 0 0 0-4.113-8.02 12.75 12.75 0 0 1-2.564-3.632 13.77 13.77 0 0 1 0-4.746 12.755 12.755 0 0 0-1.167-8.783 11.643 11.643 0 0 0-7.714-3.884 12.384 12.384 0 0 1-4.3-1.442 13.206 13.206 0 0 1-2.564-3.739 12.157 12.157 0 0 0-5.99-6.532 11.279 11.279 0 0 0-8.279 1.526 12.67 12.67 0 0 1-4.419 1.528 12.67 12.67 0 0 1-4.426-1.526 11.279 11.279 0 0 0-8.279-1.526 12.2 12.2 0 0 0-5.975 6.524 13.175 13.175 0 0 1-2.587 3.762 12.346 12.346 0 0 1-4.281 1.435 11.643 11.643 0 0 0-7.714 3.884 12.757 12.757 0 0 0-1.152 8.737 14.158 14.158 0 0 1 0 4.746 13.16 13.16 0 0 1-2.587 3.67 12.632 12.632 0 0 0-4.105 8.027 12.6 12.6 0 0 0 4.113 8.012 13.135 13.135 0 0 1 2.587 3.632 14.2 14.2 0 0 1 0 4.754 12.8 12.8 0 0 0 1.16 8.783 11.643 11.643 0 0 0 7.714 3.884 12.346 12.346 0 0 1 4.281 1.435 13.246 13.246 0 0 1 2.587 3.754 12.165 12.165 0 0 0 5.975 6.493 11.285 11.285 0 0 0 8.279-1.526 12.67 12.67 0 0 1 4.43-1.527 12.67 12.67 0 0 1 4.426 1.526 15.413 15.413 0 0 0 6.219 1.923 6.5 6.5 0 0 0 2.053-.336 12.155 12.155 0 0 0 5.975-6.516 13.246 13.246 0 0 1 2.587-3.754 12.346 12.346 0 0 1 4.281-1.435 11.643 11.643 0 0 0 7.714-3.884 12.717 12.717 0 0 0 1.167-8.828 14.158 14.158 0 0 1 0-4.746 12.834 12.834 0 0 1 2.587-3.624m-41.363 7.706L194.689 52.44l5.631-5.883 10.233 10.683 18.931-19.679 5.631 5.883Z"
        />
      </g>
    </g>
    <path data-name="Rect\xE1ngulo 1602" fill="none" d="M0 0h256v256H0z" />
  </svg>
);

export default OnlineRegistrationIcon;
