// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import React, { SVGProps } from "react";

const NewAccountIcon = (props: SVGProps<SVGSVGElement>) => {
  return (
    <svg
      {...props}
      className={`min-icon`}
      fill={"currentcolor"}
      id="Account_Icon"
      data-name="Account Icon"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 16.409 13.096"
    >
      <path
        id="Trazado_391"
        data-name="Trazado 391"
        d="M-4332.855-1143.481a3.023,3.023,0,0,0,2.958-3.078,3.023,3.023,0,0,0-2.958-3.078,3.023,3.023,0,0,0-2.958,3.078A3.023,3.023,0,0,0-4332.855-1143.481Zm0-5.194a2.078,2.078,0,0,1,2.03,2.116,2.077,2.077,0,0,1-2.03,2.116,2.075,2.075,0,0,1-2.028-2.116A2.076,2.076,0,0,1-4332.855-1148.675Z"
        transform="translate(4339.12 1149.637)"
        fill="#07193e"
      />
      <path
        id="Trazado_392"
        data-name="Trazado 392"
        d="M-4337.952-1130.053a1.374,1.374,0,0,0,1.252.775h4.993a1.354,1.354,0,0,0,1.25-.786,1.675,1.675,0,0,0-.164-1.686,4.521,4.521,0,0,0-1.7-1.405,4.361,4.361,0,0,0-2.125-.438,4.483,4.483,0,0,0-3.318,1.808c-.026.035-.051.071-.075.106A1.641,1.641,0,0,0-4337.952-1130.053Zm6.663-.437a.426.426,0,0,1-.417.25h-4.993a.453.453,0,0,1-.427-.254.64.64,0,0,1,.053-.632h0c.017-.027.037-.054.057-.08a3.539,3.539,0,0,1,2.622-1.424c.056,0,.113,0,.168,0a3.606,3.606,0,0,1,2.864,1.466A.686.686,0,0,1-4331.29-1130.49Z"
        transform="translate(4340.467 1140.236)"
        fill="#07193e"
      />
      <path
        id="Trazado_393"
        data-name="Trazado 393"
        d="M-4329.387-1146.951h-3.506a.476.476,0,0,0-.477.476.477.477,0,0,0,.477.476h3.506a1.047,1.047,0,0,1,1.046,1.045v7.99a1.047,1.047,0,0,1-1.046,1.045H-4341.8a1.047,1.047,0,0,1-1.046-1.045v-7.99A1.048,1.048,0,0,1-4341.8-1146a.476.476,0,0,0,.476-.476.476.476,0,0,0-.476-.476,2,2,0,0,0-2,2v7.99a2,2,0,0,0,2,2h12.412a2,2,0,0,0,2-2v-7.99A2,2,0,0,0-4329.387-1146.951Z"
        transform="translate(4343.797 1148.063)"
        fill="#07193e"
      />
      <rect
        id="Rectángulo_809"
        data-name="Rectángulo 809"
        width="3.266"
        height="2.781"
        rx="1.024"
        transform="translate(11.002 3.376)"
        fill="#07193e"
      />
      <rect
        id="Rectángulo_810"
        data-name="Rectángulo 810"
        width="3.266"
        height="1.336"
        rx="0.668"
        transform="translate(11.002 7.328)"
        fill="#07193e"
      />
      <rect
        id="Rectángulo_811"
        data-name="Rectángulo 811"
        width="3.266"
        height="1.336"
        rx="0.668"
        transform="translate(11.002 9.621)"
        fill="#07193e"
      />
    </svg>
  );
};

export default NewAccountIcon;
