// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const JSONIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <g data-name="JSONIcon">
        <g data-name="Grupo 2269">
          <path
            data-name="Uni\xF3n 21"
            d="M190.07 233.208a8.967 8.967 0 0 1-2.645-6.377 8.974 8.974 0 0 1 2.645-6.389 8.949 8.949 0 0 1 6.375-2.633 24.023 24.023 0 0 0 9.363-1.895 23.98 23.98 0 0 0 7.656-5.163 24.228 24.228 0 0 0 5.152-7.648 23.763 23.763 0 0 0 1.895-9.361v-47.057a26.541 26.541 0 0 1 7.129-18.122 26.567 26.567 0 0 1-7.129-18.133V63.373a23.707 23.707 0 0 0-1.895-9.351 23.978 23.978 0 0 0-5.152-7.648 23.977 23.977 0 0 0-7.656-5.162 23.815 23.815 0 0 0-9.363-1.9 8.959 8.959 0 0 1-6.375-2.644 8.95 8.95 0 0 1-2.645-6.378 8.949 8.949 0 0 1 2.645-6.377 8.959 8.959 0 0 1 6.375-2.644 42.145 42.145 0 0 1 42.109 42.1v47.057a8.636 8.636 0 0 0 8.625 8.624 8.959 8.959 0 0 1 6.375 2.644 8.967 8.967 0 0 1 2.645 6.377c0 .148 0 .307-.012.488.012.17.012.329.012.477a8.974 8.974 0 0 1-2.645 6.389 8.949 8.949 0 0 1-6.375 2.633 8.636 8.636 0 0 0-8.625 8.624v47.057a42.154 42.154 0 0 1-42.109 42.109 8.959 8.959 0 0 1-6.375-2.64ZM17.465 193.742v-47.057a8.641 8.641 0 0 0-8.625-8.624 8.981 8.981 0 0 1-6.387-2.645 8.936 8.936 0 0 1-2.633-6.377c0-.147 0-.307.012-.477-.012-.182-.012-.34-.012-.488a8.956 8.956 0 0 1 2.633-6.377 8.98 8.98 0 0 1 6.387-2.644 8.641 8.641 0 0 0 8.625-8.624V63.372a42.142 42.142 0 0 1 42.1-42.1 8.972 8.972 0 0 1 6.391 2.633 8.963 8.963 0 0 1 2.633 6.388 8.957 8.957 0 0 1-2.633 6.378 8.982 8.982 0 0 1-6.391 2.644 23.8 23.8 0 0 0-9.359 1.9 24.22 24.22 0 0 0-7.648 5.151 23.985 23.985 0 0 0-5.164 7.659 23.975 23.975 0 0 0-1.883 9.351v47.057a26.56 26.56 0 0 1-7.137 18.133 26.512 26.512 0 0 1 7.137 18.122v47.057a24.07 24.07 0 0 0 1.883 9.361 24.068 24.068 0 0 0 5.164 7.648 24.076 24.076 0 0 0 7.648 5.163 23.994 23.994 0 0 0 9.359 1.884 8.982 8.982 0 0 1 6.391 2.644 8.963 8.963 0 0 1 2.633 6.389 8.956 8.956 0 0 1-2.633 6.377 8.982 8.982 0 0 1-6.391 2.644 42.151 42.151 0 0 1-42.1-42.115ZM160 128.008a16 16 0 0 1 16-16 16.006 16.006 0 0 1 16.012 16 16.012 16.012 0 0 1-16.012 16 16.007 16.007 0 0 1-16-16Zm-48 0a16 16 0 0 1 16-16 16 16 0 0 1 16 16 16 16 0 0 1-16 16 16.01 16.01 0 0 1-16-16Zm-47 0a15.758 15.758 0 0 1 15.5-16 15.758 15.758 0 0 1 15.5 16 15.764 15.764 0 0 1-15.5 16 15.764 15.764 0 0 1-15.5-16Z"
          />
        </g>
        <path data-name="Rect\xE1ngulo 891" fill="none" d="M0 0h256v256H0z" />
      </g>
    </g>
  </svg>
);

export default JSONIcon;
