// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import React, { SVGProps } from "react";

const GoogleTierIconXs = (props: SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      className={`min-icon`}
      fill={"currentcolor"}
      viewBox="0 0 21.883 17.614"
      {...props}
    >
      <g
        id="Grupo_2504"
        data-name="Grupo 2504"
        transform="translate(-492.881 -516.58)"
      >
        <g id="google-cloud-logo-color" transform="translate(492.881 516.58)">
          <g id="Grupo_1820" data-name="Grupo 1820">
            <path
              id="Trazado_6946"
              data-name="Trazado 6946"
              d="M67.542,36.137h.667l1.9-1.9.093-.808A8.55,8.55,0,0,0,56.3,37.6a1.03,1.03,0,0,1,.667-.039l3.8-.628s.193-.321.294-.3a4.745,4.745,0,0,1,6.494-.494Z"
              transform="translate(-53.656 -31.287)"
            />
            <path
              id="Trazado_6947"
              data-name="Trazado 6947"
              d="M229.968,80.926a8.562,8.562,0,0,0-2.582-4.164l-2.669,2.669a4.746,4.746,0,0,1,1.742,3.765v.474a2.376,2.376,0,0,1,0,4.752h-4.752l-.474.481v2.85l.474.474h4.752a6.182,6.182,0,0,0,3.51-11.3Z"
              transform="translate(-210.804 -74.614)"
              fill="#6b8295"
            />
            <path
              id="Trazado_6948"
              data-name="Trazado 6948"
              d="M6.558,142.319A6.18,6.18,0,0,0,2.828,153.4l2.756-2.756A2.376,2.376,0,1,1,8.727,147.5l2.756-2.756a6.166,6.166,0,0,0-4.924-2.423Z"
              transform="translate(-0.415 -137.075)"
              fill="#9aafbf"
            />
          </g>
        </g>
      </g>
    </svg>
  );
};

export default GoogleTierIconXs;
