// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import React, { SVGProps } from "react";

const ConsoleStandard = (props: SVGProps<SVGSVGElement>) => {
  return (
    <svg
      {...props}
      className={`min-icon`}
      fill={"currentcolor"}
      xmlns="http://www.w3.org/2000/svg"
      width="113.208"
      height="29.822"
      viewBox="0 0 113.208 29.822"
    >
      <g transform="translate(-1.655)">
        <path
          d="M12.721-19.038A8.7,8.7,0,0,0,7.609-20.59c-2.992,0-5.427,1.532-5.427,4.27,0,2.424,1.866,3.51,4.209,3.794l1.319.162c2.211.274,3.4.9,3.4,2.221,0,1.6-1.664,2.465-3.783,2.465A7.586,7.586,0,0,1,2.7-9.25L1.726-7.83a9.2,9.2,0,0,0,5.6,1.846c3.073,0,5.64-1.481,5.64-4.311,0-2.505-2.059-3.479-4.463-3.773L7.254-14.22c-2.13-.264-3.215-.923-3.215-2.211,0-1.532,1.481-2.465,3.56-2.465a7.431,7.431,0,0,1,4.209,1.308Zm13.338-1.349H14.587v1.694h4.849V-6.187h1.785V-18.693h4.838Zm7.668,0H31.506l-5.772,14.2h1.856l1.552-3.875H36.03l1.562,3.875h1.917Zm-1.136,1.765,2.759,6.867H29.822Zm21.281-1.765H52.087V-9.24L43.5-20.4H41.883V-6.187h1.785l.01-11.147L52.259-6.176h1.613Zm4.047,0v14.2h5.417c4.585,0,7.526-2.779,7.526-7.1s-2.942-7.1-7.526-7.1Zm5.417,1.694c3.723,0,5.65,2.171,5.65,5.406,0,3.215-1.927,5.406-5.65,5.406H59.7V-18.693Zm16.686-1.694H77.8l-5.772,14.2h1.856l1.552-3.875h6.887l1.562,3.875H85.8Zm-1.136,1.765,2.759,6.867H76.117Zm9.291-1.765v14.2h1.785v-6.127h1.664L96.5-6.187h2.211l-5-6.127h.112c3.043,0,4.96-1.582,4.96-4.047,0-2.587-1.765-4.027-4.97-4.027Zm5.6,1.674c2.059,0,3.155.781,3.155,2.353,0,1.592-1.065,2.424-3.155,2.424H89.962v-4.777Zm8.165-1.674v14.2h5.417c4.585,0,7.526-2.779,7.526-7.1s-2.942-7.1-7.526-7.1Zm5.417,1.694c3.723,0,5.65,2.171,5.65,5.406,0,3.215-1.927,5.406-5.65,5.406h-3.631V-18.693Z"
          transform="translate(-0.021 35.806)"
        />
        <path
          d="M15.951.127h2.468V7.417H15.951Zm-2.993.1L7.949,3.288a.224.224,0,0,1-.233,0L2.707.228a.69.69,0,0,0-.359-.1H2.342a.688.688,0,0,0-.687.687V7.407H4.122V4.269a.247.247,0,0,1,.376-.21L7.305,5.777a.879.879,0,0,0,.9.009l2.963-1.738a.249.249,0,0,1,.246,0,.245.245,0,0,1,.125.212V7.406H14.01V.813a.686.686,0,0,0-.686-.687h-.006a.686.686,0,0,0-.359.1Zm17.769-.1h-2.5V3.445a.245.245,0,0,1-.12.211.248.248,0,0,1-.243.006L21.374.208a.693.693,0,0,0-.323-.08h0a.688.688,0,0,0-.687.687V7.409h2.483V4.094a.247.247,0,0,1,.362-.218L29.719,7.33a.686.686,0,0,0,.322.08h0a.688.688,0,0,0,.687-.687Zm1.941,7.289V.127h1.136V7.417Zm7.819.13c-3.056,0-5.223-1.449-5.223-3.773S37.447,0,40.488,0s5.236,1.449,5.236,3.774-2.141,3.773-5.236,3.773Zm0-6.58c-2.272,0-4.022.992-4.022,2.807s1.749,2.807,4.022,2.807,4.035-.979,4.035-2.807S42.761.967,40.488.967Z"
          transform="translate(0)"
        />
      </g>
    </svg>
  );
};

export default ConsoleStandard;
