// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import React, { SVGProps } from "react";

const ConsoleAgpl = (props: SVGProps<SVGSVGElement>) => {
  return (
    <svg
      {...props}
      className={`min-icon`}
      fill={"currentcolor"}
      viewBox="0 0 61.059 25.5334"
      xmlns="http://www.w3.org/2000/svg"
    >
      <defs />
      <g>
        <path
          d="M59.8021 17.9708C59.7771 17.9708 58.9617 18.0678 58.9617 18.0678L52.2703 18.0678C52.2563 19.0171 52.3861 19.9705 52.6582 20.8801C52.7117 21.0793 52.7558 21.2904 52.8198 21.4943C52.8596 21.6203 52.9068 21.7269 52.9491 21.8499L52.8844 21.9792C52.5505 22.4551 52.3312 22.9893 52.2379 23.5632C52.0705 22.9965 51.9455 22.4051 51.8823 21.8176C51.8632 21.6403 51.8605 21.4737 51.85 21.3004C51.7591 20.2068 51.898 19.1001 52.2703 18.0678L39.8572 18.0678L38.2409 25.0178L53.6603 25.0178C53.2607 25.012 52.8818 24.8399 52.6258 24.5329C52.5865 24.4785 52.5571 24.4322 52.5289 24.3713L52.4642 24.2097C52.4175 24.0539 52.3896 23.8872 52.3996 23.7248C52.4675 23.129 52.6951 22.5624 53.0461 22.0762C53.5355 21.353 54.1461 20.7194 54.824 20.169C54.9933 20.0275 55.1639 19.8797 55.3412 19.7487L56.02 19.2962C56.757 18.8181 57.5651 18.4622 58.4121 18.2294C57.6081 18.505 56.8157 18.8769 56.117 19.3608C56.089 19.3795 56.0796 19.4053 56.0524 19.4255C55.642 19.7086 55.2528 20.0225 54.8886 20.3629C53.7914 21.3948 53.203 22.4854 53.4663 23.1106C53.485 23.1536 53.5049 23.1686 53.531 23.2076C53.8144 23.624 54.5162 23.7218 55.4058 23.4985C55.4663 23.4832 55.5374 23.4514 55.5998 23.4339C55.9055 23.3439 56.2137 23.24 56.5049 23.1106L56.7312 23.0136L56.7312 22.9813C57.7116 22.4958 58.4752 21.9282 58.6384 21.5913C58.6741 21.5357 58.694 21.4916 58.6707 21.4297C58.5542 21.1936 57.7179 21.3573 56.7312 21.7853L56.5049 21.8822C56.5721 21.82 56.6294 21.7483 56.6989 21.6883C56.8109 21.5919 56.9308 21.4903 57.0545 21.3973C57.2411 21.2558 57.4363 21.1314 57.6363 21.0094C58.5356 20.3308 58.9919 19.6957 58.897 19.4578C58.8756 19.4101 58.8509 19.3727 58.8 19.3608C58.4738 19.3263 58.1205 19.4016 57.8303 19.5548C57.4338 19.7227 57.0583 19.8996 56.6989 20.1366L56.6342 20.2013L56.4403 20.3306L56.5696 20.1366C56.7701 19.7945 57.0094 19.4865 57.3131 19.2315C57.5681 19.0107 57.862 18.787 58.1535 18.6173C58.2656 18.5512 58.3636 18.5114 58.4768 18.4557C58.5899 18.4001 58.7188 18.3389 58.8324 18.2941C59.139 18.1481 59.4686 18.0347 59.8021 17.9708ZM43.2514 18.9406L43.8656 18.9406L42.9605 22.9166L42.4433 22.9166L42.7019 21.7529L41.0856 21.7529L39.9865 22.9166L39.4046 22.9166L43.2514 18.9406ZM44.7384 18.9729L44.7707 18.9729L46.484 18.9729C46.6016 18.966 46.7058 18.9776 46.8072 19.0376C46.8812 19.0803 46.9246 19.1809 46.9042 19.2639L46.7102 20.169L46.0961 20.169L46.29 19.2962L44.803 19.2962L44.2535 21.7206L44.0595 22.6257L45.5788 22.6257L45.5788 22.5934L45.8698 21.268L45.1586 21.268L45.2233 20.9448L46.5163 20.9448L46.1607 22.6257C46.1556 22.6493 46.1403 22.6694 46.1284 22.6904C46.0904 22.7525 46.0326 22.8208 45.9668 22.852C45.8508 22.9093 45.7405 22.9205 45.6112 22.9166L43.8979 22.9166C43.7803 22.9236 43.6761 22.912 43.5747 22.852C43.5006 22.81 43.4565 22.7082 43.4777 22.6257L44.2212 19.2639C44.2469 19.169 44.325 19.0768 44.4151 19.0376C44.5108 18.9915 44.6325 18.9774 44.7384 18.9729ZM47.4214 18.9729L49.5549 18.9729C49.6726 18.966 49.7767 18.9776 49.8782 19.0376C49.9533 19.0794 49.9956 19.1803 49.9751 19.2639L49.5872 21.0741C49.5605 21.1692 49.4844 21.2301 49.3933 21.268C49.2783 21.3257 49.1339 21.3682 49.0054 21.365L47.4537 21.365L47.1628 22.6904L47.1305 22.9166L46.5486 22.9166L46.5809 22.7227L47.4214 18.9729ZM50.363 18.9729L50.9449 18.9729L50.2661 21.9469L50.1368 22.6257L51.5268 22.6257C51.5413 22.7329 51.5731 22.8124 51.5914 22.9166L49.4903 22.9166L49.6519 22.1732L50.363 18.9729ZM47.9386 19.2962L47.5507 21.0418L49.0054 21.0418L49.3933 19.2962L47.9386 19.2962ZM43.3161 19.3608C43.1345 19.5882 42.9037 19.8565 42.6049 20.169L41.4735 21.365L42.7988 21.365L43.0251 20.3629C43.1247 19.9683 43.2267 19.625 43.3161 19.3608ZM41.4412 23.4339L42.0877 23.4339L42.0554 23.5955L41.5705 23.5955L41.5381 23.8218L41.926 23.8218L41.8937 23.9834L41.5058 23.9834L41.4088 24.3713L41.2472 24.3713L41.4412 23.4339ZM44.803 23.4339L44.8354 23.4339C44.8954 23.4324 44.9419 23.4421 44.997 23.4662C45.0449 23.4868 45.1051 23.5155 45.1263 23.5632C45.1465 23.6117 45.1372 23.6734 45.1263 23.7248L44.9647 23.7248C44.9709 23.693 44.9487 23.6557 44.9323 23.6278C44.928 23.6235 44.9374 23.5989 44.9323 23.5955C44.8992 23.5783 44.8403 23.5609 44.803 23.5632C44.7535 23.5598 44.7167 23.603 44.6737 23.6278C44.6456 23.6443 44.6178 23.661 44.6091 23.6925C44.6035 23.711 44.6286 23.7103 44.6414 23.7248C44.685 23.7505 44.7206 23.7821 44.7707 23.7894C44.8348 23.8026 44.9046 23.8283 44.9647 23.8541C45.0107 23.8748 45.0391 23.9059 45.0616 23.9511C45.0808 23.9959 45.0733 24.0331 45.0616 24.0804C45.049 24.1332 45.0334 24.2017 44.997 24.242C44.9575 24.2872 44.9232 24.3164 44.8677 24.339C44.8085 24.3636 44.7378 24.3713 44.6737 24.3713C44.6049 24.3738 44.543 24.3661 44.4798 24.339C44.4276 24.3152 44.3731 24.2623 44.3505 24.2097C44.3281 24.1547 44.3375 24.1059 44.3505 24.048L44.3505 24.0157L44.5121 24.0157L44.5121 24.048C44.5073 24.0793 44.5007 24.1156 44.5121 24.145C44.524 24.1696 44.5516 24.1668 44.5768 24.1773C44.6128 24.1934 44.6343 24.2108 44.6737 24.2097C44.7109 24.21 44.7681 24.2223 44.803 24.2097C44.8312 24.2004 44.8467 24.166 44.8677 24.145C44.8842 24.1279 44.895 24.1036 44.9 24.0804C44.905 24.0638 44.9077 24.0636 44.9 24.048C44.8868 24.0303 44.8566 24.0222 44.8354 24.0157L44.7061 23.9511C44.6498 23.9394 44.5954 23.9129 44.5444 23.8864C44.5056 23.8653 44.4653 23.8621 44.4474 23.8218C44.4321 23.7821 44.4368 23.7336 44.4474 23.6925C44.4587 23.6417 44.4773 23.5695 44.5121 23.5308C44.5503 23.4877 44.6197 23.4863 44.6737 23.4662C44.7246 23.4471 44.7488 23.4353 44.803 23.4339ZM46.3223 23.4339L46.3547 23.4339L46.4516 23.4339L46.484 23.4339L46.4193 23.5632L46.4193 23.5955L46.3547 23.5632C46.3367 23.5619 46.3057 23.5866 46.29 23.5955C46.279 23.6119 46.2607 23.6406 46.2577 23.6601L46.387 23.6601L46.3547 23.8218L46.2254 23.8218L46.0961 24.3713L45.9344 24.3713L46.0637 23.8218L45.9668 23.8218L45.9991 23.6601L46.0961 23.6601C46.1005 23.6407 46.0961 23.6278 46.0961 23.6278C46.1022 23.5924 46.1117 23.5627 46.1284 23.5308C46.1477 23.4992 46.193 23.4843 46.2254 23.4662C46.2567 23.4494 46.2868 23.4358 46.3223 23.4339ZM46.7102 23.4339L46.6779 23.6601L46.7749 23.6601L46.7426 23.8218L46.6456 23.8218L46.5486 24.1773C46.5486 24.1773 46.5486 24.2 46.5486 24.2097L46.5809 24.2097L46.6456 24.2097L46.6456 24.339L46.6456 24.3713L46.5163 24.3713C46.4809 24.3737 46.4502 24.3563 46.4193 24.339C46.3956 24.3243 46.3926 24.3016 46.387 24.2743C46.3852 24.2669 46.3872 24.2497 46.387 24.242C46.3888 24.2028 46.3774 24.1831 46.387 24.145L46.4516 23.8218L46.387 23.8218L46.4193 23.6601L46.484 23.6601L46.5163 23.5308L46.6779 23.4662L46.7102 23.4339ZM42.0554 23.6601L42.217 23.6601L42.217 23.6925C42.2244 23.6869 42.243 23.6966 42.2493 23.6925C42.2709 23.6794 42.2888 23.6631 42.314 23.6601C42.3557 23.6598 42.4096 23.6679 42.4433 23.6925L42.4756 23.7248L42.3786 23.8541L42.3463 23.8541C42.3294 23.843 42.3018 23.8219 42.2816 23.8218C42.2636 23.8223 42.2639 23.8434 42.2493 23.8541C42.2311 23.8659 42.1946 23.8672 42.1847 23.8864C42.1651 23.9234 42.1612 23.9749 42.1523 24.0157L42.0877 24.3713L41.926 24.3713L42.0554 23.6601ZM42.7988 23.6601L42.8312 23.6601C42.9134 23.6547 42.976 23.6909 43.0251 23.7571C43.0556 23.8028 43.0913 23.8638 43.0898 23.9187C43.0895 23.9565 43.0658 23.9789 43.0574 24.0157L43.0574 24.0804L42.5726 24.0804C42.5726 24.0901 42.5726 24.1037 42.5726 24.1127C42.5707 24.1426 42.5883 24.1525 42.6049 24.1773C42.6119 24.1874 42.6272 24.2026 42.6372 24.2097C42.6583 24.2225 42.6771 24.2427 42.7019 24.242C42.7348 24.2424 42.7714 24.2279 42.7988 24.2097C42.8297 24.1886 42.8452 24.1452 42.8635 24.1127L43.0574 24.1127L43.0251 24.145C42.9939 24.2103 42.9564 24.2671 42.8958 24.3067C42.8338 24.3459 42.7753 24.3723 42.7019 24.3713C42.6156 24.3783 42.5293 24.3423 42.4756 24.2743C42.4271 24.1961 42.4147 24.1032 42.4433 24.0157C42.4621 23.9143 42.4966 23.8269 42.5726 23.7571C42.6334 23.7029 42.7176 23.666 42.7988 23.6601ZM43.5423 23.6601L43.5747 23.6601C43.6569 23.6547 43.7195 23.6909 43.7686 23.7571C43.7991 23.8028 43.8348 23.8638 43.8333 23.9187C43.8329 23.9555 43.8093 23.98 43.8009 24.0157L43.8009 24.0804L43.3484 24.0804L43.3484 24.1127C43.3494 24.1357 43.3355 24.1583 43.3484 24.1773C43.3505 24.1809 43.3458 24.2065 43.3484 24.2097C43.3717 24.2333 43.4122 24.2438 43.4454 24.242C43.4783 24.2424 43.5149 24.2279 43.5423 24.2097C43.5733 24.1888 43.5888 24.1453 43.607 24.1127L43.8009 24.1127L43.7686 24.145C43.7374 24.2103 43.6999 24.2671 43.6393 24.3067C43.5772 24.3459 43.5188 24.3723 43.4454 24.3713C43.3146 24.3878 43.1709 24.3081 43.1544 24.1773C43.1529 24.162 43.1529 24.1281 43.1544 24.1127C43.1537 24.1026 43.1537 24.0904 43.1544 24.0804C43.1565 24.0552 43.1811 24.0403 43.1867 24.0157C43.2051 23.9145 43.2406 23.827 43.3161 23.7571C43.3772 23.7025 43.4606 23.6664 43.5423 23.6601ZM45.5788 23.6601L45.6112 23.6601C45.6947 23.6546 45.7855 23.6915 45.8375 23.7571C45.8868 23.8336 45.8973 23.929 45.8698 24.0157C45.8565 24.0881 45.8142 24.1488 45.7728 24.2097C45.6987 24.3091 45.5735 24.3707 45.4495 24.3713C45.3657 24.3771 45.3068 24.341 45.2556 24.2743C45.2237 24.2287 45.1889 24.1683 45.1909 24.1127C45.191 24.075 45.2147 24.0525 45.2233 24.0157C45.2425 23.9061 45.297 23.793 45.3849 23.7248C45.443 23.6818 45.5068 23.666 45.5788 23.6601ZM46.8072 23.6601L46.9689 23.6601L47.0012 24.048L47.1951 23.6601L47.3568 23.6601L47.3568 24.0804C47.3612 24.0722 47.583 23.6601 47.583 23.6601L47.7447 23.6601L47.3568 24.3713L47.2275 24.3713L47.1951 23.9834L47.0012 24.3713L46.8395 24.3713L46.8072 23.6601ZM48.1002 23.6601L48.1326 23.6601C48.1793 23.6581 48.2177 23.6771 48.2619 23.6925C48.2937 23.7033 48.3406 23.729 48.3589 23.7571C48.374 23.7837 48.36 23.7912 48.3589 23.8218L48.3589 23.9187L48.3265 24.0804C48.3114 24.1407 48.3019 24.2126 48.2942 24.2743C48.2926 24.2965 48.2879 24.3177 48.2942 24.339L48.2942 24.3713L48.1326 24.3713L48.1326 24.339C48.1308 24.3276 48.1325 24.3182 48.1326 24.3067C48.1034 24.3256 48.068 24.3264 48.0356 24.339C47.9932 24.3539 47.9512 24.3712 47.9063 24.3713C47.8434 24.3771 47.7901 24.3506 47.7447 24.3067C47.7192 24.2773 47.6785 24.2485 47.68 24.2097C47.6801 24.1933 47.7087 24.161 47.7123 24.145C47.7198 24.1101 47.7228 24.1086 47.7447 24.0804C47.7657 24.0526 47.7793 24.001 47.8093 23.9834C47.8382 23.9665 47.8738 23.9589 47.9063 23.9511L48.0033 23.9511C48.0637 23.9449 48.1386 23.9347 48.1972 23.9187C48.198 23.9153 48.196 23.8897 48.1972 23.8864C48.2046 23.866 48.2046 23.8422 48.1972 23.8218C48.1715 23.8061 48.1303 23.8192 48.1002 23.8218C48.0656 23.8195 48.034 23.8056 48.0033 23.8218C47.9762 23.8415 47.9518 23.8879 47.9386 23.9187L47.777 23.9187L47.777 23.8864C47.7941 23.8429 47.8095 23.7911 47.8416 23.7571C47.876 23.725 47.9261 23.7066 47.9709 23.6925C48.0098 23.6795 48.0593 23.6626 48.1002 23.6601ZM48.5851 23.6601L48.7468 23.6601L48.7468 23.6925C48.7678 23.6793 48.7867 23.663 48.8114 23.6601L48.8437 23.6601C48.8858 23.6598 48.9066 23.6678 48.9407 23.6925L48.973 23.7248L48.8761 23.8541C48.8596 23.843 48.8312 23.8219 48.8114 23.8218C48.7929 23.8224 48.7619 23.8435 48.7468 23.8541C48.7292 23.8662 48.724 23.8674 48.7144 23.8864C48.695 23.9234 48.6912 23.9749 48.6821 24.0157L48.5851 24.3713L48.4235 24.3713L48.5851 23.6601ZM49.2963 23.6601L49.3286 23.6601C49.4108 23.6547 49.5058 23.6909 49.5549 23.7571C49.5856 23.8027 49.589 23.8638 49.5872 23.9187C49.5866 23.9565 49.596 23.979 49.5872 24.0157L49.5549 24.0804L49.1023 24.0804C49.1023 24.0901 49.1023 24.1037 49.1023 24.1127C49.1008 24.1425 49.1183 24.1524 49.1347 24.1773C49.1373 24.1809 49.1316 24.2065 49.1347 24.2097C49.1577 24.2294 49.2014 24.2433 49.2316 24.242C49.2646 24.2424 49.2689 24.2279 49.2963 24.2097C49.327 24.1885 49.3749 24.1451 49.3933 24.1127L49.5549 24.1127L49.5549 24.145C49.5236 24.2102 49.4538 24.2671 49.3933 24.3067C49.3312 24.3459 49.2728 24.3723 49.1993 24.3713C49.1137 24.3782 49.0259 24.3421 48.973 24.2743C48.9244 24.1962 48.9129 24.1035 48.9407 24.0157C48.9589 23.9145 49.0268 23.827 49.1023 23.7571C49.1639 23.7021 49.214 23.6661 49.2963 23.6601ZM42.7988 23.7894C42.7587 23.7913 42.7325 23.8281 42.7019 23.8541C42.6761 23.8761 42.6499 23.8873 42.6372 23.9187L42.9281 23.9187C42.9293 23.8979 42.9055 23.8726 42.8958 23.8541C42.8762 23.8212 42.837 23.7863 42.7988 23.7894ZM43.5423 23.7894C43.5022 23.7913 43.476 23.8281 43.4454 23.8541C43.4197 23.8763 43.3936 23.8874 43.3807 23.9187L43.6716 23.9187C43.6748 23.8898 43.6597 23.8425 43.6393 23.8218C43.6179 23.801 43.5721 23.7878 43.5423 23.7894ZM49.3286 23.7894C49.2875 23.7908 49.2308 23.8277 49.1993 23.8541C49.1739 23.8765 49.1478 23.8875 49.1347 23.9187L49.4256 23.9187C49.4269 23.8979 49.4355 23.8725 49.4256 23.8541C49.4057 23.8214 49.3667 23.7866 49.3286 23.7894ZM45.5788 23.8218C45.5389 23.8275 45.4786 23.8261 45.4495 23.8541C45.405 23.8996 45.3952 23.9528 45.3849 24.0157C45.3786 24.0424 45.353 24.0853 45.3526 24.1127C45.348 24.1466 45.3612 24.185 45.3849 24.2097C45.4071 24.232 45.4504 24.2434 45.4819 24.242C45.5293 24.2415 45.5776 24.2108 45.6112 24.1773C45.6558 24.1308 45.6655 24.0794 45.6758 24.0157C45.6934 23.9651 45.6989 23.9025 45.6758 23.8541C45.6553 23.8223 45.6166 23.8192 45.5788 23.8218ZM48.1649 24.048C48.1188 24.0603 48.0506 24.0744 48.0033 24.0804C47.9718 24.084 47.9364 24.1029 47.9063 24.1127C47.8919 24.1188 47.8842 24.1332 47.874 24.145C47.8644 24.1556 47.8773 24.1634 47.874 24.1773C47.874 24.1796 47.874 24.2074 47.874 24.2097C47.893 24.2247 47.9146 24.2451 47.9386 24.242C47.9743 24.2426 48.0035 24.2253 48.0356 24.2097C48.0657 24.1944 48.1136 24.1729 48.1326 24.145C48.1501 24.1185 48.1578 24.0791 48.1649 24.048Z"
          fillRule="evenodd"
          opacity="1"
          stroke="none"
        />
        <path
          d="M53.6132 25.2529C53.1607 25.2456 52.734 25.0409 52.445 24.6927C52.3995 24.6299 52.3602 24.5628 52.3277 24.4925L52.268 24.3431L52.4816 24.2602L52.5372 24.4002C52.5631 24.4554 52.5941 24.5081 52.6299 24.5575C52.8767 24.8509 53.2398 25.0214 53.6233 25.0239L54.126 25.0239C54.289 25.0102 54.4511 24.9874 54.6115 24.9556C54.9321 24.891 55.2472 24.8014 55.5538 24.6878C55.8089 24.5952 56.067 24.4858 56.3206 24.3636C56.9298 24.0688 57.5101 23.7176 58.0539 23.3145C58.2406 23.1771 58.4231 23.0341 58.6014 22.8854C58.7617 22.752 58.9155 22.6163 59.0626 22.4783C59.4153 22.1526 59.7126 21.7715 59.9426 21.35C60.1121 21.0094 60.1409 20.7368 60.024 20.5825C59.931 20.4794 59.7979 20.4215 59.6591 20.4238L59.3562 20.4007L59.5993 20.218C60.4688 19.5656 60.9614 18.7928 60.7945 18.3394C60.7402 18.2012 60.6258 18.0954 60.4837 18.0522C60.4025 18.0243 60.318 18.007 60.2324 18.0007L59.9653 18.0007C59.4877 18.0486 59.0223 18.1801 58.5902 18.3891L58.4894 18.1829C58.9506 17.9606 59.4475 17.8215 59.9571 17.7721L60.2421 17.7721C60.3509 17.7793 60.4583 17.8011 60.5614 17.8367C60.7677 17.9024 60.9327 18.0586 61.0096 18.261C61.1963 18.779 60.7679 19.5588 59.9306 20.2479C60.0394 20.2851 60.1348 20.3534 60.2051 20.4444C60.3799 20.6752 60.3594 21.0236 60.1461 21.4527C59.906 21.8986 59.5937 22.3016 59.2217 22.6453C59.0704 22.7864 58.913 22.925 58.7497 23.0609C58.5682 23.2126 58.382 23.3585 58.1913 23.4987C57.6358 23.91 57.043 24.2685 56.4207 24.5694C56.1637 24.6939 55.9011 24.8048 55.633 24.9022C55.3151 25.0199 54.9886 25.1127 54.6563 25.1797C54.4842 25.2138 54.3103 25.238 54.1353 25.2521L53.6132 25.2529Z"
          fillRule="evenodd"
          opacity="1"
          stroke="none"
        />
        <path
          d="M8.15618 8.48408L7.27643 9.07687C6.70239 8.2369 5.74428 7.74207 4.72705 7.76023C3.8493 7.73512 3.00087 8.07735 2.3862 8.70446C1.77154 9.33157 1.44637 10.1867 1.48906 11.0638C1.44637 11.9408 1.77154 12.7959 2.3862 13.423C3.00087 14.0502 3.8493 14.3924 4.72705 14.3673C5.74244 14.3901 6.70017 13.8967 7.27097 13.0566L8.13235 13.6851C7.35121 14.7828 6.07371 15.4181 4.72705 15.3786C3.56744 15.423 2.44152 14.9835 1.61865 14.1653C0.795772 13.347 0.349968 12.2236 0.387884 11.0638C0.349967 9.90391 0.795772 8.78048 1.61864 7.96222C2.44152 7.14396 3.56744 6.70448 4.72705 6.74892C6.09323 6.69543 7.39008 7.35165 8.15618 8.48408ZM18.0826 11.0638C18.1206 12.2236 17.6748 13.347 16.8519 14.1653C16.029 14.9835 14.9031 15.423 13.7435 15.3786C12.5839 15.4229 11.4582 14.9833 10.6354 14.1651C9.81264 13.3469 9.3669 12.2235 9.40481 11.0638C9.36675 9.90396 9.81244 8.78052 10.6352 7.96224C11.458 7.14397 12.5839 6.70447 13.7435 6.74892C14.9031 6.70448 16.029 7.14396 16.8519 7.96222C17.6748 8.78048 18.1206 9.90391 18.0826 11.0638ZM10.506 11.0638C10.4632 11.9408 10.7882 12.7959 11.4028 13.423C12.0174 14.0501 12.8658 14.3924 13.7435 14.3673C14.6212 14.3924 15.4696 14.0501 16.0842 13.423C16.6988 12.7959 17.0238 11.9408 16.981 11.0638C17.0238 10.1867 16.6988 9.33161 16.0842 8.70448C15.4696 8.07736 14.6212 7.73511 13.7435 7.76023C12.8658 7.73511 12.0174 8.07736 11.4028 8.70448C10.7882 9.33161 10.4632 10.1867 10.506 11.0638ZM27.0628 15.2589L26.1111 15.2589L21.0471 8.67572L21.0411 15.253L19.9876 15.253L19.9876 6.86856L20.9393 6.86856L26.0083 13.4518L26.0083 6.87452L27.0618 6.87452L27.0628 15.2589ZM34.918 8.52628C34.1876 8.02402 33.3221 7.75486 32.4356 7.75427C31.2089 7.75427 30.3351 8.30486 30.3351 9.20844C30.3351 9.96854 30.9755 10.3578 32.2321 10.5132L32.9689 10.603C34.3868 10.7768 35.6002 11.3512 35.6002 12.8292C35.6002 14.4993 34.0859 15.3726 32.2738 15.3726C31.083 15.3817 29.9222 14.999 28.9703 14.2834L29.5447 13.4458C30.3277 14.0477 31.2877 14.3737 32.2753 14.3732C33.5259 14.3732 34.5094 13.8644 34.5094 12.9191C34.5094 12.1411 33.8094 11.7702 32.5047 11.6084L31.7267 11.5126C30.3445 11.3453 29.2443 10.7048 29.2443 9.27447C29.2443 7.65845 30.6806 6.75487 32.4461 6.75487C33.5227 6.73597 34.5781 7.05625 35.4626 7.67037L34.918 8.52628ZM45.6999 11.0638C45.7378 12.2236 45.292 13.347 44.4691 14.1653C43.6463 14.9835 42.5203 15.423 41.3607 15.3786C40.2012 15.4229 39.0754 14.9833 38.2526 14.1651C37.4299 13.3469 36.9841 12.2235 37.0221 11.0638C36.984 9.90396 37.4297 8.78052 38.2525 7.96224C39.0753 7.14397 40.2012 6.70447 41.3607 6.74892C42.5203 6.70448 43.6463 7.14396 44.4691 7.96222C45.292 8.78048 45.7378 9.90391 45.6999 11.0638ZM38.1232 11.0638C38.0805 11.9407 38.4056 12.7958 39.0202 13.4229C39.6348 14.0499 40.4831 14.3922 41.3607 14.3673C42.2384 14.3924 43.0868 14.0501 43.7014 13.423C44.316 12.7959 44.641 11.9408 44.5982 11.0638C44.641 10.1867 44.316 9.33161 43.7014 8.70448C43.0868 8.07736 42.2384 7.73511 41.3607 7.76023C40.4831 7.73526 39.6348 8.07756 39.0202 8.70465C38.4056 9.33174 38.0805 10.1868 38.1232 11.0638ZM53.4592 15.253L47.6058 15.253L47.6058 6.87452L48.6594 6.87452L48.6594 14.2536L53.4592 14.2536L53.4592 15.253ZM60.8383 15.253L54.8896 15.253L54.8896 6.87452L60.7787 6.87452L60.7787 7.86151L55.9431 7.86151L55.9431 10.537L60.6233 10.537L60.6233 11.5299L55.9431 11.5299L55.9431 14.265L60.8383 14.265L60.8383 15.253ZM7.78532 0.655715L9.06423 0.655715L9.06423 4.40259L7.78532 4.40259L7.78532 0.655715ZM6.24675 0.690964L3.6502 2.2767C3.61342 2.29958 3.56683 2.29958 3.53005 2.2767L0.933506 0.690964C0.877247 0.657914 0.813072 0.640755 0.747826 0.641317L0.744847 0.641317C0.54825 0.641317 0.388877 0.80069 0.388877 0.997287L0.388877 4.40507L1.6668 4.40507L1.6668 2.78806C1.66688 2.74183 1.69188 2.69922 1.7322 2.6766C1.77252 2.65397 1.8219 2.65482 1.86141 2.67884L3.31657 3.56901C3.46003 3.65676 3.64013 3.65848 3.78524 3.57348L5.32033 2.67288C5.35988 2.64981 5.40874 2.6496 5.44849 2.67234C5.48823 2.69508 5.51281 2.73731 5.51296 2.7831L5.51296 4.40507L6.79138 4.40507L6.79138 0.997287C6.79138 0.80069 6.63201 0.641317 6.43541 0.641317L6.43243 0.641317C6.36717 0.640679 6.30298 0.657844 6.24675 0.690964ZM15.4548 0.654722L14.1575 0.654722L14.1575 2.374C14.1576 2.41897 14.134 2.46065 14.0955 2.48383C14.0569 2.50701 14.0091 2.50829 13.9694 2.4872L10.6078 0.696425C10.5562 0.669136 10.4988 0.654822 10.4404 0.654722C10.2439 0.654722 10.0845 0.814095 10.0845 1.01069L10.0845 4.40259L11.3713 4.40259L11.3713 2.71061C11.3715 2.66574 11.3951 2.62421 11.4336 2.60115C11.4721 2.5781 11.5199 2.57687 11.5595 2.59791L14.9355 4.38819C14.9869 4.4154 15.0442 4.42955 15.1023 4.4294C15.1968 4.42953 15.2874 4.39207 15.3542 4.32528C15.421 4.2585 15.4584 4.16788 15.4583 4.07343L15.4583 0.654722L15.4548 0.654722ZM16.4929 4.4016L16.4929 0.654722L17.0887 0.654722L17.0887 4.4016L16.4929 4.4016ZM20.5129 4.48401C18.9296 4.48401 17.8066 3.73285 17.8066 2.52841C17.8066 1.32397 18.9366 0.572804 20.5129 0.572804C22.0892 0.572804 23.2266 1.32397 23.2266 2.52841C23.2266 3.73285 22.1165 4.48401 20.5129 4.48401ZM20.5129 1.07325C19.3357 1.07325 18.4277 1.58759 18.4277 2.52841C18.4277 3.46922 19.3342 3.98307 20.5129 3.98307C21.6915 3.98307 22.604 3.47568 22.604 2.52841C22.604 1.58114 21.6905 1.07325 20.5129 1.07325Z"
          fillRule="evenodd"
          opacity="1"
          stroke="none"
        />
      </g>
    </svg>
  );
};

export default ConsoleAgpl;
