// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package operator_api

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/minio/console/models"
)

// GetPodLogsOKCode is the HTTP code returned for type GetPodLogsOK
const GetPodLogsOKCode int = 200

/*
GetPodLogsOK A successful response.

swagger:response getPodLogsOK
*/
type GetPodLogsOK struct {

	/*
	  In: Body
	*/
	Payload string `json:"body,omitempty"`
}

// NewGetPodLogsOK creates GetPodLogsOK with default headers values
func NewGetPodLogsOK() *GetPodLogsOK {

	return &GetPodLogsOK{}
}

// WithPayload adds the payload to the get pod logs o k response
func (o *GetPodLogsOK) WithPayload(payload string) *GetPodLogsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get pod logs o k response
func (o *GetPodLogsOK) SetPayload(payload string) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetPodLogsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetPodLogsDefault Generic error response.

swagger:response getPodLogsDefault
*/
type GetPodLogsDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetPodLogsDefault creates GetPodLogsDefault with default headers values
func NewGetPodLogsDefault(code int) *GetPodLogsDefault {
	if code <= 0 {
		code = 500
	}

	return &GetPodLogsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get pod logs default response
func (o *GetPodLogsDefault) WithStatusCode(code int) *GetPodLogsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get pod logs default response
func (o *GetPodLogsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the get pod logs default response
func (o *GetPodLogsDefault) WithPayload(payload *models.Error) *GetPodLogsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get pod logs default response
func (o *GetPodLogsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetPodLogsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
