// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package operations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"net/http"
	"strings"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/loads"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/runtime/security"
	"github.com/go-openapi/spec"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/minio/console/models"
	"github.com/minio/console/operatorapi/operations/auth"
	"github.com/minio/console/operatorapi/operations/operator_api"
	"github.com/minio/console/operatorapi/operations/user_api"
)

// NewOperatorAPI creates a new Operator instance
func NewOperatorAPI(spec *loads.Document) *OperatorAPI {
	return &OperatorAPI{
		handlers:            make(map[string]map[string]http.Handler),
		formats:             strfmt.Default,
		defaultConsumes:     "application/json",
		defaultProduces:     "application/json",
		customConsumers:     make(map[string]runtime.Consumer),
		customProducers:     make(map[string]runtime.Producer),
		PreServerShutdown:   func() {},
		ServerShutdown:      func() {},
		spec:                spec,
		useSwaggerUI:        false,
		ServeError:          errors.ServeError,
		BasicAuthenticator:  security.BasicAuth,
		APIKeyAuthenticator: security.APIKeyAuth,
		BearerAuthenticator: security.BearerAuth,

		JSONConsumer: runtime.JSONConsumer(),

		JSONProducer: runtime.JSONProducer(),

		UserAPICheckMinIOVersionHandler: user_api.CheckMinIOVersionHandlerFunc(func(params user_api.CheckMinIOVersionParams) middleware.Responder {
			return middleware.NotImplemented("operation user_api.CheckMinIOVersion has not yet been implemented")
		}),
		OperatorAPICreateNamespaceHandler: operator_api.CreateNamespaceHandlerFunc(func(params operator_api.CreateNamespaceParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.CreateNamespace has not yet been implemented")
		}),
		OperatorAPICreateTenantHandler: operator_api.CreateTenantHandlerFunc(func(params operator_api.CreateTenantParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.CreateTenant has not yet been implemented")
		}),
		OperatorAPIDeletePVCHandler: operator_api.DeletePVCHandlerFunc(func(params operator_api.DeletePVCParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.DeletePVC has not yet been implemented")
		}),
		OperatorAPIDeletePodHandler: operator_api.DeletePodHandlerFunc(func(params operator_api.DeletePodParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.DeletePod has not yet been implemented")
		}),
		OperatorAPIDeleteTenantHandler: operator_api.DeleteTenantHandlerFunc(func(params operator_api.DeleteTenantParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.DeleteTenant has not yet been implemented")
		}),
		OperatorAPIDescribePodHandler: operator_api.DescribePodHandlerFunc(func(params operator_api.DescribePodParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.DescribePod has not yet been implemented")
		}),
		OperatorAPIDirectPVFormatDriveHandler: operator_api.DirectPVFormatDriveHandlerFunc(func(params operator_api.DirectPVFormatDriveParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.DirectPVFormatDrive has not yet been implemented")
		}),
		OperatorAPIDisableTenantLoggingHandler: operator_api.DisableTenantLoggingHandlerFunc(func(params operator_api.DisableTenantLoggingParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.DisableTenantLogging has not yet been implemented")
		}),
		OperatorAPIEnableTenantLoggingHandler: operator_api.EnableTenantLoggingHandlerFunc(func(params operator_api.EnableTenantLoggingParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.EnableTenantLogging has not yet been implemented")
		}),
		OperatorAPIGetAllocatableResourcesHandler: operator_api.GetAllocatableResourcesHandlerFunc(func(params operator_api.GetAllocatableResourcesParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.GetAllocatableResources has not yet been implemented")
		}),
		OperatorAPIGetDirectPVDriveListHandler: operator_api.GetDirectPVDriveListHandlerFunc(func(params operator_api.GetDirectPVDriveListParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.GetDirectPVDriveList has not yet been implemented")
		}),
		OperatorAPIGetDirectPVVolumeListHandler: operator_api.GetDirectPVVolumeListHandlerFunc(func(params operator_api.GetDirectPVVolumeListParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.GetDirectPVVolumeList has not yet been implemented")
		}),
		OperatorAPIGetMPIntegrationHandler: operator_api.GetMPIntegrationHandlerFunc(func(params operator_api.GetMPIntegrationParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.GetMPIntegration has not yet been implemented")
		}),
		OperatorAPIGetMaxAllocatableMemHandler: operator_api.GetMaxAllocatableMemHandlerFunc(func(params operator_api.GetMaxAllocatableMemParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.GetMaxAllocatableMem has not yet been implemented")
		}),
		OperatorAPIGetPVCDescribeHandler: operator_api.GetPVCDescribeHandlerFunc(func(params operator_api.GetPVCDescribeParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.GetPVCDescribe has not yet been implemented")
		}),
		OperatorAPIGetPVCEventsHandler: operator_api.GetPVCEventsHandlerFunc(func(params operator_api.GetPVCEventsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.GetPVCEvents has not yet been implemented")
		}),
		OperatorAPIGetParityHandler: operator_api.GetParityHandlerFunc(func(params operator_api.GetParityParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.GetParity has not yet been implemented")
		}),
		OperatorAPIGetPodEventsHandler: operator_api.GetPodEventsHandlerFunc(func(params operator_api.GetPodEventsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.GetPodEvents has not yet been implemented")
		}),
		OperatorAPIGetPodLogsHandler: operator_api.GetPodLogsHandlerFunc(func(params operator_api.GetPodLogsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.GetPodLogs has not yet been implemented")
		}),
		OperatorAPIGetResourceQuotaHandler: operator_api.GetResourceQuotaHandlerFunc(func(params operator_api.GetResourceQuotaParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.GetResourceQuota has not yet been implemented")
		}),
		OperatorAPIGetTenantEventsHandler: operator_api.GetTenantEventsHandlerFunc(func(params operator_api.GetTenantEventsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.GetTenantEvents has not yet been implemented")
		}),
		OperatorAPIGetTenantLogsHandler: operator_api.GetTenantLogsHandlerFunc(func(params operator_api.GetTenantLogsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.GetTenantLogs has not yet been implemented")
		}),
		OperatorAPIGetTenantMonitoringHandler: operator_api.GetTenantMonitoringHandlerFunc(func(params operator_api.GetTenantMonitoringParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.GetTenantMonitoring has not yet been implemented")
		}),
		OperatorAPIGetTenantPodsHandler: operator_api.GetTenantPodsHandlerFunc(func(params operator_api.GetTenantPodsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.GetTenantPods has not yet been implemented")
		}),
		OperatorAPIGetTenantUsageHandler: operator_api.GetTenantUsageHandlerFunc(func(params operator_api.GetTenantUsageParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.GetTenantUsage has not yet been implemented")
		}),
		OperatorAPIGetTenantYAMLHandler: operator_api.GetTenantYAMLHandlerFunc(func(params operator_api.GetTenantYAMLParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.GetTenantYAML has not yet been implemented")
		}),
		OperatorAPIListAllTenantsHandler: operator_api.ListAllTenantsHandlerFunc(func(params operator_api.ListAllTenantsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.ListAllTenants has not yet been implemented")
		}),
		OperatorAPIListNodeLabelsHandler: operator_api.ListNodeLabelsHandlerFunc(func(params operator_api.ListNodeLabelsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.ListNodeLabels has not yet been implemented")
		}),
		OperatorAPIListPVCsHandler: operator_api.ListPVCsHandlerFunc(func(params operator_api.ListPVCsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.ListPVCs has not yet been implemented")
		}),
		OperatorAPIListPVCsForTenantHandler: operator_api.ListPVCsForTenantHandlerFunc(func(params operator_api.ListPVCsForTenantParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.ListPVCsForTenant has not yet been implemented")
		}),
		OperatorAPIListTenantCertificateSigningRequestHandler: operator_api.ListTenantCertificateSigningRequestHandlerFunc(func(params operator_api.ListTenantCertificateSigningRequestParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.ListTenantCertificateSigningRequest has not yet been implemented")
		}),
		OperatorAPIListTenantsHandler: operator_api.ListTenantsHandlerFunc(func(params operator_api.ListTenantsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.ListTenants has not yet been implemented")
		}),
		AuthLoginDetailHandler: auth.LoginDetailHandlerFunc(func(params auth.LoginDetailParams) middleware.Responder {
			return middleware.NotImplemented("operation auth.LoginDetail has not yet been implemented")
		}),
		AuthLoginOauth2AuthHandler: auth.LoginOauth2AuthHandlerFunc(func(params auth.LoginOauth2AuthParams) middleware.Responder {
			return middleware.NotImplemented("operation auth.LoginOauth2Auth has not yet been implemented")
		}),
		AuthLoginOperatorHandler: auth.LoginOperatorHandlerFunc(func(params auth.LoginOperatorParams) middleware.Responder {
			return middleware.NotImplemented("operation auth.LoginOperator has not yet been implemented")
		}),
		AuthLogoutHandler: auth.LogoutHandlerFunc(func(params auth.LogoutParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation auth.Logout has not yet been implemented")
		}),
		OperatorAPIOperatorSubnetAPIKeyInfoHandler: operator_api.OperatorSubnetAPIKeyInfoHandlerFunc(func(params operator_api.OperatorSubnetAPIKeyInfoParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.OperatorSubnetAPIKeyInfo has not yet been implemented")
		}),
		OperatorAPIOperatorSubnetAPIKeyHandler: operator_api.OperatorSubnetAPIKeyHandlerFunc(func(params operator_api.OperatorSubnetAPIKeyParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.OperatorSubnetAPIKey has not yet been implemented")
		}),
		OperatorAPIOperatorSubnetLoginHandler: operator_api.OperatorSubnetLoginHandlerFunc(func(params operator_api.OperatorSubnetLoginParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.OperatorSubnetLogin has not yet been implemented")
		}),
		OperatorAPIOperatorSubnetLoginMFAHandler: operator_api.OperatorSubnetLoginMFAHandlerFunc(func(params operator_api.OperatorSubnetLoginMFAParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.OperatorSubnetLoginMFA has not yet been implemented")
		}),
		OperatorAPIOperatorSubnetRegisterAPIKeyHandler: operator_api.OperatorSubnetRegisterAPIKeyHandlerFunc(func(params operator_api.OperatorSubnetRegisterAPIKeyParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.OperatorSubnetRegisterAPIKey has not yet been implemented")
		}),
		OperatorAPIPostMPIntegrationHandler: operator_api.PostMPIntegrationHandlerFunc(func(params operator_api.PostMPIntegrationParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.PostMPIntegration has not yet been implemented")
		}),
		OperatorAPIPutTenantYAMLHandler: operator_api.PutTenantYAMLHandlerFunc(func(params operator_api.PutTenantYAMLParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.PutTenantYAML has not yet been implemented")
		}),
		AuthSessionCheckHandler: auth.SessionCheckHandlerFunc(func(params auth.SessionCheckParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation auth.SessionCheck has not yet been implemented")
		}),
		OperatorAPISetTenantAdministratorsHandler: operator_api.SetTenantAdministratorsHandlerFunc(func(params operator_api.SetTenantAdministratorsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.SetTenantAdministrators has not yet been implemented")
		}),
		OperatorAPISetTenantLogsHandler: operator_api.SetTenantLogsHandlerFunc(func(params operator_api.SetTenantLogsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.SetTenantLogs has not yet been implemented")
		}),
		OperatorAPISetTenantMonitoringHandler: operator_api.SetTenantMonitoringHandlerFunc(func(params operator_api.SetTenantMonitoringParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.SetTenantMonitoring has not yet been implemented")
		}),
		OperatorAPISubscriptionActivateHandler: operator_api.SubscriptionActivateHandlerFunc(func(params operator_api.SubscriptionActivateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.SubscriptionActivate has not yet been implemented")
		}),
		OperatorAPISubscriptionInfoHandler: operator_api.SubscriptionInfoHandlerFunc(func(params operator_api.SubscriptionInfoParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.SubscriptionInfo has not yet been implemented")
		}),
		OperatorAPISubscriptionRefreshHandler: operator_api.SubscriptionRefreshHandlerFunc(func(params operator_api.SubscriptionRefreshParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.SubscriptionRefresh has not yet been implemented")
		}),
		OperatorAPISubscriptionValidateHandler: operator_api.SubscriptionValidateHandlerFunc(func(params operator_api.SubscriptionValidateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.SubscriptionValidate has not yet been implemented")
		}),
		OperatorAPITenantAddPoolHandler: operator_api.TenantAddPoolHandlerFunc(func(params operator_api.TenantAddPoolParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.TenantAddPool has not yet been implemented")
		}),
		OperatorAPITenantConfigurationHandler: operator_api.TenantConfigurationHandlerFunc(func(params operator_api.TenantConfigurationParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.TenantConfiguration has not yet been implemented")
		}),
		OperatorAPITenantDeleteEncryptionHandler: operator_api.TenantDeleteEncryptionHandlerFunc(func(params operator_api.TenantDeleteEncryptionParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.TenantDeleteEncryption has not yet been implemented")
		}),
		OperatorAPITenantDetailsHandler: operator_api.TenantDetailsHandlerFunc(func(params operator_api.TenantDetailsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.TenantDetails has not yet been implemented")
		}),
		OperatorAPITenantEncryptionInfoHandler: operator_api.TenantEncryptionInfoHandlerFunc(func(params operator_api.TenantEncryptionInfoParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.TenantEncryptionInfo has not yet been implemented")
		}),
		OperatorAPITenantIdentityProviderHandler: operator_api.TenantIdentityProviderHandlerFunc(func(params operator_api.TenantIdentityProviderParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.TenantIdentityProvider has not yet been implemented")
		}),
		OperatorAPITenantSecurityHandler: operator_api.TenantSecurityHandlerFunc(func(params operator_api.TenantSecurityParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.TenantSecurity has not yet been implemented")
		}),
		OperatorAPITenantUpdateCertificateHandler: operator_api.TenantUpdateCertificateHandlerFunc(func(params operator_api.TenantUpdateCertificateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.TenantUpdateCertificate has not yet been implemented")
		}),
		OperatorAPITenantUpdateEncryptionHandler: operator_api.TenantUpdateEncryptionHandlerFunc(func(params operator_api.TenantUpdateEncryptionParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.TenantUpdateEncryption has not yet been implemented")
		}),
		OperatorAPITenantUpdatePoolsHandler: operator_api.TenantUpdatePoolsHandlerFunc(func(params operator_api.TenantUpdatePoolsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.TenantUpdatePools has not yet been implemented")
		}),
		OperatorAPIUpdateTenantHandler: operator_api.UpdateTenantHandlerFunc(func(params operator_api.UpdateTenantParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.UpdateTenant has not yet been implemented")
		}),
		OperatorAPIUpdateTenantConfigurationHandler: operator_api.UpdateTenantConfigurationHandlerFunc(func(params operator_api.UpdateTenantConfigurationParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.UpdateTenantConfiguration has not yet been implemented")
		}),
		OperatorAPIUpdateTenantDomainsHandler: operator_api.UpdateTenantDomainsHandlerFunc(func(params operator_api.UpdateTenantDomainsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.UpdateTenantDomains has not yet been implemented")
		}),
		OperatorAPIUpdateTenantIdentityProviderHandler: operator_api.UpdateTenantIdentityProviderHandlerFunc(func(params operator_api.UpdateTenantIdentityProviderParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.UpdateTenantIdentityProvider has not yet been implemented")
		}),
		OperatorAPIUpdateTenantSecurityHandler: operator_api.UpdateTenantSecurityHandlerFunc(func(params operator_api.UpdateTenantSecurityParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation operator_api.UpdateTenantSecurity has not yet been implemented")
		}),

		KeyAuth: func(token string, scopes []string) (*models.Principal, error) {
			return nil, errors.NotImplemented("oauth2 bearer auth (key) has not yet been implemented")
		},
		// default authorizer is authorized meaning no requests are blocked
		APIAuthorizer: security.Authorized(),
	}
}

/*OperatorAPI the operator API */
type OperatorAPI struct {
	spec            *loads.Document
	context         *middleware.Context
	handlers        map[string]map[string]http.Handler
	formats         strfmt.Registry
	customConsumers map[string]runtime.Consumer
	customProducers map[string]runtime.Producer
	defaultConsumes string
	defaultProduces string
	Middleware      func(middleware.Builder) http.Handler
	useSwaggerUI    bool

	// BasicAuthenticator generates a runtime.Authenticator from the supplied basic auth function.
	// It has a default implementation in the security package, however you can replace it for your particular usage.
	BasicAuthenticator func(security.UserPassAuthentication) runtime.Authenticator

	// APIKeyAuthenticator generates a runtime.Authenticator from the supplied token auth function.
	// It has a default implementation in the security package, however you can replace it for your particular usage.
	APIKeyAuthenticator func(string, string, security.TokenAuthentication) runtime.Authenticator

	// BearerAuthenticator generates a runtime.Authenticator from the supplied bearer token auth function.
	// It has a default implementation in the security package, however you can replace it for your particular usage.
	BearerAuthenticator func(string, security.ScopedTokenAuthentication) runtime.Authenticator

	// JSONConsumer registers a consumer for the following mime types:
	//   - application/json
	JSONConsumer runtime.Consumer

	// JSONProducer registers a producer for the following mime types:
	//   - application/json
	JSONProducer runtime.Producer

	// KeyAuth registers a function that takes an access token and a collection of required scopes and returns a principal
	// it performs authentication based on an oauth2 bearer token provided in the request
	KeyAuth func(string, []string) (*models.Principal, error)

	// APIAuthorizer provides access control (ACL/RBAC/ABAC) by providing access to the request and authenticated principal
	APIAuthorizer runtime.Authorizer

	// UserAPICheckMinIOVersionHandler sets the operation handler for the check min i o version operation
	UserAPICheckMinIOVersionHandler user_api.CheckMinIOVersionHandler
	// OperatorAPICreateNamespaceHandler sets the operation handler for the create namespace operation
	OperatorAPICreateNamespaceHandler operator_api.CreateNamespaceHandler
	// OperatorAPICreateTenantHandler sets the operation handler for the create tenant operation
	OperatorAPICreateTenantHandler operator_api.CreateTenantHandler
	// OperatorAPIDeletePVCHandler sets the operation handler for the delete p v c operation
	OperatorAPIDeletePVCHandler operator_api.DeletePVCHandler
	// OperatorAPIDeletePodHandler sets the operation handler for the delete pod operation
	OperatorAPIDeletePodHandler operator_api.DeletePodHandler
	// OperatorAPIDeleteTenantHandler sets the operation handler for the delete tenant operation
	OperatorAPIDeleteTenantHandler operator_api.DeleteTenantHandler
	// OperatorAPIDescribePodHandler sets the operation handler for the describe pod operation
	OperatorAPIDescribePodHandler operator_api.DescribePodHandler
	// OperatorAPIDirectPVFormatDriveHandler sets the operation handler for the direct p v format drive operation
	OperatorAPIDirectPVFormatDriveHandler operator_api.DirectPVFormatDriveHandler
	// OperatorAPIDisableTenantLoggingHandler sets the operation handler for the disable tenant logging operation
	OperatorAPIDisableTenantLoggingHandler operator_api.DisableTenantLoggingHandler
	// OperatorAPIEnableTenantLoggingHandler sets the operation handler for the enable tenant logging operation
	OperatorAPIEnableTenantLoggingHandler operator_api.EnableTenantLoggingHandler
	// OperatorAPIGetAllocatableResourcesHandler sets the operation handler for the get allocatable resources operation
	OperatorAPIGetAllocatableResourcesHandler operator_api.GetAllocatableResourcesHandler
	// OperatorAPIGetDirectPVDriveListHandler sets the operation handler for the get direct p v drive list operation
	OperatorAPIGetDirectPVDriveListHandler operator_api.GetDirectPVDriveListHandler
	// OperatorAPIGetDirectPVVolumeListHandler sets the operation handler for the get direct p v volume list operation
	OperatorAPIGetDirectPVVolumeListHandler operator_api.GetDirectPVVolumeListHandler
	// OperatorAPIGetMPIntegrationHandler sets the operation handler for the get m p integration operation
	OperatorAPIGetMPIntegrationHandler operator_api.GetMPIntegrationHandler
	// OperatorAPIGetMaxAllocatableMemHandler sets the operation handler for the get max allocatable mem operation
	OperatorAPIGetMaxAllocatableMemHandler operator_api.GetMaxAllocatableMemHandler
	// OperatorAPIGetPVCDescribeHandler sets the operation handler for the get p v c describe operation
	OperatorAPIGetPVCDescribeHandler operator_api.GetPVCDescribeHandler
	// OperatorAPIGetPVCEventsHandler sets the operation handler for the get p v c events operation
	OperatorAPIGetPVCEventsHandler operator_api.GetPVCEventsHandler
	// OperatorAPIGetParityHandler sets the operation handler for the get parity operation
	OperatorAPIGetParityHandler operator_api.GetParityHandler
	// OperatorAPIGetPodEventsHandler sets the operation handler for the get pod events operation
	OperatorAPIGetPodEventsHandler operator_api.GetPodEventsHandler
	// OperatorAPIGetPodLogsHandler sets the operation handler for the get pod logs operation
	OperatorAPIGetPodLogsHandler operator_api.GetPodLogsHandler
	// OperatorAPIGetResourceQuotaHandler sets the operation handler for the get resource quota operation
	OperatorAPIGetResourceQuotaHandler operator_api.GetResourceQuotaHandler
	// OperatorAPIGetTenantEventsHandler sets the operation handler for the get tenant events operation
	OperatorAPIGetTenantEventsHandler operator_api.GetTenantEventsHandler
	// OperatorAPIGetTenantLogsHandler sets the operation handler for the get tenant logs operation
	OperatorAPIGetTenantLogsHandler operator_api.GetTenantLogsHandler
	// OperatorAPIGetTenantMonitoringHandler sets the operation handler for the get tenant monitoring operation
	OperatorAPIGetTenantMonitoringHandler operator_api.GetTenantMonitoringHandler
	// OperatorAPIGetTenantPodsHandler sets the operation handler for the get tenant pods operation
	OperatorAPIGetTenantPodsHandler operator_api.GetTenantPodsHandler
	// OperatorAPIGetTenantUsageHandler sets the operation handler for the get tenant usage operation
	OperatorAPIGetTenantUsageHandler operator_api.GetTenantUsageHandler
	// OperatorAPIGetTenantYAMLHandler sets the operation handler for the get tenant y a m l operation
	OperatorAPIGetTenantYAMLHandler operator_api.GetTenantYAMLHandler
	// OperatorAPIListAllTenantsHandler sets the operation handler for the list all tenants operation
	OperatorAPIListAllTenantsHandler operator_api.ListAllTenantsHandler
	// OperatorAPIListNodeLabelsHandler sets the operation handler for the list node labels operation
	OperatorAPIListNodeLabelsHandler operator_api.ListNodeLabelsHandler
	// OperatorAPIListPVCsHandler sets the operation handler for the list p v cs operation
	OperatorAPIListPVCsHandler operator_api.ListPVCsHandler
	// OperatorAPIListPVCsForTenantHandler sets the operation handler for the list p v cs for tenant operation
	OperatorAPIListPVCsForTenantHandler operator_api.ListPVCsForTenantHandler
	// OperatorAPIListTenantCertificateSigningRequestHandler sets the operation handler for the list tenant certificate signing request operation
	OperatorAPIListTenantCertificateSigningRequestHandler operator_api.ListTenantCertificateSigningRequestHandler
	// OperatorAPIListTenantsHandler sets the operation handler for the list tenants operation
	OperatorAPIListTenantsHandler operator_api.ListTenantsHandler
	// AuthLoginDetailHandler sets the operation handler for the login detail operation
	AuthLoginDetailHandler auth.LoginDetailHandler
	// AuthLoginOauth2AuthHandler sets the operation handler for the login oauth2 auth operation
	AuthLoginOauth2AuthHandler auth.LoginOauth2AuthHandler
	// AuthLoginOperatorHandler sets the operation handler for the login operator operation
	AuthLoginOperatorHandler auth.LoginOperatorHandler
	// AuthLogoutHandler sets the operation handler for the logout operation
	AuthLogoutHandler auth.LogoutHandler
	// OperatorAPIOperatorSubnetAPIKeyInfoHandler sets the operation handler for the operator subnet API key info operation
	OperatorAPIOperatorSubnetAPIKeyInfoHandler operator_api.OperatorSubnetAPIKeyInfoHandler
	// OperatorAPIOperatorSubnetAPIKeyHandler sets the operation handler for the operator subnet Api key operation
	OperatorAPIOperatorSubnetAPIKeyHandler operator_api.OperatorSubnetAPIKeyHandler
	// OperatorAPIOperatorSubnetLoginHandler sets the operation handler for the operator subnet login operation
	OperatorAPIOperatorSubnetLoginHandler operator_api.OperatorSubnetLoginHandler
	// OperatorAPIOperatorSubnetLoginMFAHandler sets the operation handler for the operator subnet login m f a operation
	OperatorAPIOperatorSubnetLoginMFAHandler operator_api.OperatorSubnetLoginMFAHandler
	// OperatorAPIOperatorSubnetRegisterAPIKeyHandler sets the operation handler for the operator subnet register API key operation
	OperatorAPIOperatorSubnetRegisterAPIKeyHandler operator_api.OperatorSubnetRegisterAPIKeyHandler
	// OperatorAPIPostMPIntegrationHandler sets the operation handler for the post m p integration operation
	OperatorAPIPostMPIntegrationHandler operator_api.PostMPIntegrationHandler
	// OperatorAPIPutTenantYAMLHandler sets the operation handler for the put tenant y a m l operation
	OperatorAPIPutTenantYAMLHandler operator_api.PutTenantYAMLHandler
	// AuthSessionCheckHandler sets the operation handler for the session check operation
	AuthSessionCheckHandler auth.SessionCheckHandler
	// OperatorAPISetTenantAdministratorsHandler sets the operation handler for the set tenant administrators operation
	OperatorAPISetTenantAdministratorsHandler operator_api.SetTenantAdministratorsHandler
	// OperatorAPISetTenantLogsHandler sets the operation handler for the set tenant logs operation
	OperatorAPISetTenantLogsHandler operator_api.SetTenantLogsHandler
	// OperatorAPISetTenantMonitoringHandler sets the operation handler for the set tenant monitoring operation
	OperatorAPISetTenantMonitoringHandler operator_api.SetTenantMonitoringHandler
	// OperatorAPISubscriptionActivateHandler sets the operation handler for the subscription activate operation
	OperatorAPISubscriptionActivateHandler operator_api.SubscriptionActivateHandler
	// OperatorAPISubscriptionInfoHandler sets the operation handler for the subscription info operation
	OperatorAPISubscriptionInfoHandler operator_api.SubscriptionInfoHandler
	// OperatorAPISubscriptionRefreshHandler sets the operation handler for the subscription refresh operation
	OperatorAPISubscriptionRefreshHandler operator_api.SubscriptionRefreshHandler
	// OperatorAPISubscriptionValidateHandler sets the operation handler for the subscription validate operation
	OperatorAPISubscriptionValidateHandler operator_api.SubscriptionValidateHandler
	// OperatorAPITenantAddPoolHandler sets the operation handler for the tenant add pool operation
	OperatorAPITenantAddPoolHandler operator_api.TenantAddPoolHandler
	// OperatorAPITenantConfigurationHandler sets the operation handler for the tenant configuration operation
	OperatorAPITenantConfigurationHandler operator_api.TenantConfigurationHandler
	// OperatorAPITenantDeleteEncryptionHandler sets the operation handler for the tenant delete encryption operation
	OperatorAPITenantDeleteEncryptionHandler operator_api.TenantDeleteEncryptionHandler
	// OperatorAPITenantDetailsHandler sets the operation handler for the tenant details operation
	OperatorAPITenantDetailsHandler operator_api.TenantDetailsHandler
	// OperatorAPITenantEncryptionInfoHandler sets the operation handler for the tenant encryption info operation
	OperatorAPITenantEncryptionInfoHandler operator_api.TenantEncryptionInfoHandler
	// OperatorAPITenantIdentityProviderHandler sets the operation handler for the tenant identity provider operation
	OperatorAPITenantIdentityProviderHandler operator_api.TenantIdentityProviderHandler
	// OperatorAPITenantSecurityHandler sets the operation handler for the tenant security operation
	OperatorAPITenantSecurityHandler operator_api.TenantSecurityHandler
	// OperatorAPITenantUpdateCertificateHandler sets the operation handler for the tenant update certificate operation
	OperatorAPITenantUpdateCertificateHandler operator_api.TenantUpdateCertificateHandler
	// OperatorAPITenantUpdateEncryptionHandler sets the operation handler for the tenant update encryption operation
	OperatorAPITenantUpdateEncryptionHandler operator_api.TenantUpdateEncryptionHandler
	// OperatorAPITenantUpdatePoolsHandler sets the operation handler for the tenant update pools operation
	OperatorAPITenantUpdatePoolsHandler operator_api.TenantUpdatePoolsHandler
	// OperatorAPIUpdateTenantHandler sets the operation handler for the update tenant operation
	OperatorAPIUpdateTenantHandler operator_api.UpdateTenantHandler
	// OperatorAPIUpdateTenantConfigurationHandler sets the operation handler for the update tenant configuration operation
	OperatorAPIUpdateTenantConfigurationHandler operator_api.UpdateTenantConfigurationHandler
	// OperatorAPIUpdateTenantDomainsHandler sets the operation handler for the update tenant domains operation
	OperatorAPIUpdateTenantDomainsHandler operator_api.UpdateTenantDomainsHandler
	// OperatorAPIUpdateTenantIdentityProviderHandler sets the operation handler for the update tenant identity provider operation
	OperatorAPIUpdateTenantIdentityProviderHandler operator_api.UpdateTenantIdentityProviderHandler
	// OperatorAPIUpdateTenantSecurityHandler sets the operation handler for the update tenant security operation
	OperatorAPIUpdateTenantSecurityHandler operator_api.UpdateTenantSecurityHandler

	// ServeError is called when an error is received, there is a default handler
	// but you can set your own with this
	ServeError func(http.ResponseWriter, *http.Request, error)

	// PreServerShutdown is called before the HTTP(S) server is shutdown
	// This allows for custom functions to get executed before the HTTP(S) server stops accepting traffic
	PreServerShutdown func()

	// ServerShutdown is called when the HTTP(S) server is shut down and done
	// handling all active connections and does not accept connections any more
	ServerShutdown func()

	// Custom command line argument groups with their descriptions
	CommandLineOptionsGroups []swag.CommandLineOptionsGroup

	// User defined logger function.
	Logger func(string, ...interface{})
}

// UseRedoc for documentation at /docs
func (o *OperatorAPI) UseRedoc() {
	o.useSwaggerUI = false
}

// UseSwaggerUI for documentation at /docs
func (o *OperatorAPI) UseSwaggerUI() {
	o.useSwaggerUI = true
}

// SetDefaultProduces sets the default produces media type
func (o *OperatorAPI) SetDefaultProduces(mediaType string) {
	o.defaultProduces = mediaType
}

// SetDefaultConsumes returns the default consumes media type
func (o *OperatorAPI) SetDefaultConsumes(mediaType string) {
	o.defaultConsumes = mediaType
}

// SetSpec sets a spec that will be served for the clients.
func (o *OperatorAPI) SetSpec(spec *loads.Document) {
	o.spec = spec
}

// DefaultProduces returns the default produces media type
func (o *OperatorAPI) DefaultProduces() string {
	return o.defaultProduces
}

// DefaultConsumes returns the default consumes media type
func (o *OperatorAPI) DefaultConsumes() string {
	return o.defaultConsumes
}

// Formats returns the registered string formats
func (o *OperatorAPI) Formats() strfmt.Registry {
	return o.formats
}

// RegisterFormat registers a custom format validator
func (o *OperatorAPI) RegisterFormat(name string, format strfmt.Format, validator strfmt.Validator) {
	o.formats.Add(name, format, validator)
}

// Validate validates the registrations in the OperatorAPI
func (o *OperatorAPI) Validate() error {
	var unregistered []string

	if o.JSONConsumer == nil {
		unregistered = append(unregistered, "JSONConsumer")
	}

	if o.JSONProducer == nil {
		unregistered = append(unregistered, "JSONProducer")
	}

	if o.KeyAuth == nil {
		unregistered = append(unregistered, "KeyAuth")
	}

	if o.UserAPICheckMinIOVersionHandler == nil {
		unregistered = append(unregistered, "user_api.CheckMinIOVersionHandler")
	}
	if o.OperatorAPICreateNamespaceHandler == nil {
		unregistered = append(unregistered, "operator_api.CreateNamespaceHandler")
	}
	if o.OperatorAPICreateTenantHandler == nil {
		unregistered = append(unregistered, "operator_api.CreateTenantHandler")
	}
	if o.OperatorAPIDeletePVCHandler == nil {
		unregistered = append(unregistered, "operator_api.DeletePVCHandler")
	}
	if o.OperatorAPIDeletePodHandler == nil {
		unregistered = append(unregistered, "operator_api.DeletePodHandler")
	}
	if o.OperatorAPIDeleteTenantHandler == nil {
		unregistered = append(unregistered, "operator_api.DeleteTenantHandler")
	}
	if o.OperatorAPIDescribePodHandler == nil {
		unregistered = append(unregistered, "operator_api.DescribePodHandler")
	}
	if o.OperatorAPIDirectPVFormatDriveHandler == nil {
		unregistered = append(unregistered, "operator_api.DirectPVFormatDriveHandler")
	}
	if o.OperatorAPIDisableTenantLoggingHandler == nil {
		unregistered = append(unregistered, "operator_api.DisableTenantLoggingHandler")
	}
	if o.OperatorAPIEnableTenantLoggingHandler == nil {
		unregistered = append(unregistered, "operator_api.EnableTenantLoggingHandler")
	}
	if o.OperatorAPIGetAllocatableResourcesHandler == nil {
		unregistered = append(unregistered, "operator_api.GetAllocatableResourcesHandler")
	}
	if o.OperatorAPIGetDirectPVDriveListHandler == nil {
		unregistered = append(unregistered, "operator_api.GetDirectPVDriveListHandler")
	}
	if o.OperatorAPIGetDirectPVVolumeListHandler == nil {
		unregistered = append(unregistered, "operator_api.GetDirectPVVolumeListHandler")
	}
	if o.OperatorAPIGetMPIntegrationHandler == nil {
		unregistered = append(unregistered, "operator_api.GetMPIntegrationHandler")
	}
	if o.OperatorAPIGetMaxAllocatableMemHandler == nil {
		unregistered = append(unregistered, "operator_api.GetMaxAllocatableMemHandler")
	}
	if o.OperatorAPIGetPVCDescribeHandler == nil {
		unregistered = append(unregistered, "operator_api.GetPVCDescribeHandler")
	}
	if o.OperatorAPIGetPVCEventsHandler == nil {
		unregistered = append(unregistered, "operator_api.GetPVCEventsHandler")
	}
	if o.OperatorAPIGetParityHandler == nil {
		unregistered = append(unregistered, "operator_api.GetParityHandler")
	}
	if o.OperatorAPIGetPodEventsHandler == nil {
		unregistered = append(unregistered, "operator_api.GetPodEventsHandler")
	}
	if o.OperatorAPIGetPodLogsHandler == nil {
		unregistered = append(unregistered, "operator_api.GetPodLogsHandler")
	}
	if o.OperatorAPIGetResourceQuotaHandler == nil {
		unregistered = append(unregistered, "operator_api.GetResourceQuotaHandler")
	}
	if o.OperatorAPIGetTenantEventsHandler == nil {
		unregistered = append(unregistered, "operator_api.GetTenantEventsHandler")
	}
	if o.OperatorAPIGetTenantLogsHandler == nil {
		unregistered = append(unregistered, "operator_api.GetTenantLogsHandler")
	}
	if o.OperatorAPIGetTenantMonitoringHandler == nil {
		unregistered = append(unregistered, "operator_api.GetTenantMonitoringHandler")
	}
	if o.OperatorAPIGetTenantPodsHandler == nil {
		unregistered = append(unregistered, "operator_api.GetTenantPodsHandler")
	}
	if o.OperatorAPIGetTenantUsageHandler == nil {
		unregistered = append(unregistered, "operator_api.GetTenantUsageHandler")
	}
	if o.OperatorAPIGetTenantYAMLHandler == nil {
		unregistered = append(unregistered, "operator_api.GetTenantYAMLHandler")
	}
	if o.OperatorAPIListAllTenantsHandler == nil {
		unregistered = append(unregistered, "operator_api.ListAllTenantsHandler")
	}
	if o.OperatorAPIListNodeLabelsHandler == nil {
		unregistered = append(unregistered, "operator_api.ListNodeLabelsHandler")
	}
	if o.OperatorAPIListPVCsHandler == nil {
		unregistered = append(unregistered, "operator_api.ListPVCsHandler")
	}
	if o.OperatorAPIListPVCsForTenantHandler == nil {
		unregistered = append(unregistered, "operator_api.ListPVCsForTenantHandler")
	}
	if o.OperatorAPIListTenantCertificateSigningRequestHandler == nil {
		unregistered = append(unregistered, "operator_api.ListTenantCertificateSigningRequestHandler")
	}
	if o.OperatorAPIListTenantsHandler == nil {
		unregistered = append(unregistered, "operator_api.ListTenantsHandler")
	}
	if o.AuthLoginDetailHandler == nil {
		unregistered = append(unregistered, "auth.LoginDetailHandler")
	}
	if o.AuthLoginOauth2AuthHandler == nil {
		unregistered = append(unregistered, "auth.LoginOauth2AuthHandler")
	}
	if o.AuthLoginOperatorHandler == nil {
		unregistered = append(unregistered, "auth.LoginOperatorHandler")
	}
	if o.AuthLogoutHandler == nil {
		unregistered = append(unregistered, "auth.LogoutHandler")
	}
	if o.OperatorAPIOperatorSubnetAPIKeyInfoHandler == nil {
		unregistered = append(unregistered, "operator_api.OperatorSubnetAPIKeyInfoHandler")
	}
	if o.OperatorAPIOperatorSubnetAPIKeyHandler == nil {
		unregistered = append(unregistered, "operator_api.OperatorSubnetAPIKeyHandler")
	}
	if o.OperatorAPIOperatorSubnetLoginHandler == nil {
		unregistered = append(unregistered, "operator_api.OperatorSubnetLoginHandler")
	}
	if o.OperatorAPIOperatorSubnetLoginMFAHandler == nil {
		unregistered = append(unregistered, "operator_api.OperatorSubnetLoginMFAHandler")
	}
	if o.OperatorAPIOperatorSubnetRegisterAPIKeyHandler == nil {
		unregistered = append(unregistered, "operator_api.OperatorSubnetRegisterAPIKeyHandler")
	}
	if o.OperatorAPIPostMPIntegrationHandler == nil {
		unregistered = append(unregistered, "operator_api.PostMPIntegrationHandler")
	}
	if o.OperatorAPIPutTenantYAMLHandler == nil {
		unregistered = append(unregistered, "operator_api.PutTenantYAMLHandler")
	}
	if o.AuthSessionCheckHandler == nil {
		unregistered = append(unregistered, "auth.SessionCheckHandler")
	}
	if o.OperatorAPISetTenantAdministratorsHandler == nil {
		unregistered = append(unregistered, "operator_api.SetTenantAdministratorsHandler")
	}
	if o.OperatorAPISetTenantLogsHandler == nil {
		unregistered = append(unregistered, "operator_api.SetTenantLogsHandler")
	}
	if o.OperatorAPISetTenantMonitoringHandler == nil {
		unregistered = append(unregistered, "operator_api.SetTenantMonitoringHandler")
	}
	if o.OperatorAPISubscriptionActivateHandler == nil {
		unregistered = append(unregistered, "operator_api.SubscriptionActivateHandler")
	}
	if o.OperatorAPISubscriptionInfoHandler == nil {
		unregistered = append(unregistered, "operator_api.SubscriptionInfoHandler")
	}
	if o.OperatorAPISubscriptionRefreshHandler == nil {
		unregistered = append(unregistered, "operator_api.SubscriptionRefreshHandler")
	}
	if o.OperatorAPISubscriptionValidateHandler == nil {
		unregistered = append(unregistered, "operator_api.SubscriptionValidateHandler")
	}
	if o.OperatorAPITenantAddPoolHandler == nil {
		unregistered = append(unregistered, "operator_api.TenantAddPoolHandler")
	}
	if o.OperatorAPITenantConfigurationHandler == nil {
		unregistered = append(unregistered, "operator_api.TenantConfigurationHandler")
	}
	if o.OperatorAPITenantDeleteEncryptionHandler == nil {
		unregistered = append(unregistered, "operator_api.TenantDeleteEncryptionHandler")
	}
	if o.OperatorAPITenantDetailsHandler == nil {
		unregistered = append(unregistered, "operator_api.TenantDetailsHandler")
	}
	if o.OperatorAPITenantEncryptionInfoHandler == nil {
		unregistered = append(unregistered, "operator_api.TenantEncryptionInfoHandler")
	}
	if o.OperatorAPITenantIdentityProviderHandler == nil {
		unregistered = append(unregistered, "operator_api.TenantIdentityProviderHandler")
	}
	if o.OperatorAPITenantSecurityHandler == nil {
		unregistered = append(unregistered, "operator_api.TenantSecurityHandler")
	}
	if o.OperatorAPITenantUpdateCertificateHandler == nil {
		unregistered = append(unregistered, "operator_api.TenantUpdateCertificateHandler")
	}
	if o.OperatorAPITenantUpdateEncryptionHandler == nil {
		unregistered = append(unregistered, "operator_api.TenantUpdateEncryptionHandler")
	}
	if o.OperatorAPITenantUpdatePoolsHandler == nil {
		unregistered = append(unregistered, "operator_api.TenantUpdatePoolsHandler")
	}
	if o.OperatorAPIUpdateTenantHandler == nil {
		unregistered = append(unregistered, "operator_api.UpdateTenantHandler")
	}
	if o.OperatorAPIUpdateTenantConfigurationHandler == nil {
		unregistered = append(unregistered, "operator_api.UpdateTenantConfigurationHandler")
	}
	if o.OperatorAPIUpdateTenantDomainsHandler == nil {
		unregistered = append(unregistered, "operator_api.UpdateTenantDomainsHandler")
	}
	if o.OperatorAPIUpdateTenantIdentityProviderHandler == nil {
		unregistered = append(unregistered, "operator_api.UpdateTenantIdentityProviderHandler")
	}
	if o.OperatorAPIUpdateTenantSecurityHandler == nil {
		unregistered = append(unregistered, "operator_api.UpdateTenantSecurityHandler")
	}

	if len(unregistered) > 0 {
		return fmt.Errorf("missing registration: %s", strings.Join(unregistered, ", "))
	}

	return nil
}

// ServeErrorFor gets a error handler for a given operation id
func (o *OperatorAPI) ServeErrorFor(operationID string) func(http.ResponseWriter, *http.Request, error) {
	return o.ServeError
}

// AuthenticatorsFor gets the authenticators for the specified security schemes
func (o *OperatorAPI) AuthenticatorsFor(schemes map[string]spec.SecurityScheme) map[string]runtime.Authenticator {
	result := make(map[string]runtime.Authenticator)
	for name := range schemes {
		switch name {
		case "key":
			result[name] = o.BearerAuthenticator(name, func(token string, scopes []string) (interface{}, error) {
				return o.KeyAuth(token, scopes)
			})

		}
	}
	return result
}

// Authorizer returns the registered authorizer
func (o *OperatorAPI) Authorizer() runtime.Authorizer {
	return o.APIAuthorizer
}

// ConsumersFor gets the consumers for the specified media types.
// MIME type parameters are ignored here.
func (o *OperatorAPI) ConsumersFor(mediaTypes []string) map[string]runtime.Consumer {
	result := make(map[string]runtime.Consumer, len(mediaTypes))
	for _, mt := range mediaTypes {
		switch mt {
		case "application/json":
			result["application/json"] = o.JSONConsumer
		}

		if c, ok := o.customConsumers[mt]; ok {
			result[mt] = c
		}
	}
	return result
}

// ProducersFor gets the producers for the specified media types.
// MIME type parameters are ignored here.
func (o *OperatorAPI) ProducersFor(mediaTypes []string) map[string]runtime.Producer {
	result := make(map[string]runtime.Producer, len(mediaTypes))
	for _, mt := range mediaTypes {
		switch mt {
		case "application/json":
			result["application/json"] = o.JSONProducer
		}

		if p, ok := o.customProducers[mt]; ok {
			result[mt] = p
		}
	}
	return result
}

// HandlerFor gets a http.Handler for the provided operation method and path
func (o *OperatorAPI) HandlerFor(method, path string) (http.Handler, bool) {
	if o.handlers == nil {
		return nil, false
	}
	um := strings.ToUpper(method)
	if _, ok := o.handlers[um]; !ok {
		return nil, false
	}
	if path == "/" {
		path = ""
	}
	h, ok := o.handlers[um][path]
	return h, ok
}

// Context returns the middleware context for the operator API
func (o *OperatorAPI) Context() *middleware.Context {
	if o.context == nil {
		o.context = middleware.NewRoutableContext(o.spec, o, nil)
	}

	return o.context
}

func (o *OperatorAPI) initHandlerCache() {
	o.Context() // don't care about the result, just that the initialization happened
	if o.handlers == nil {
		o.handlers = make(map[string]map[string]http.Handler)
	}

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/check-version"] = user_api.NewCheckMinIOVersion(o.context, o.UserAPICheckMinIOVersionHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/namespace"] = operator_api.NewCreateNamespace(o.context, o.OperatorAPICreateNamespaceHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/tenants"] = operator_api.NewCreateTenant(o.context, o.OperatorAPICreateTenantHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/namespaces/{namespace}/tenants/{tenant}/pvc/{PVCName}"] = operator_api.NewDeletePVC(o.context, o.OperatorAPIDeletePVCHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/namespaces/{namespace}/tenants/{tenant}/pods/{podName}"] = operator_api.NewDeletePod(o.context, o.OperatorAPIDeletePodHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/namespaces/{namespace}/tenants/{tenant}"] = operator_api.NewDeleteTenant(o.context, o.OperatorAPIDeleteTenantHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants/{tenant}/pods/{podName}/describe"] = operator_api.NewDescribePod(o.context, o.OperatorAPIDescribePodHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/directpv/drives/format"] = operator_api.NewDirectPVFormatDrive(o.context, o.OperatorAPIDirectPVFormatDriveHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/namespaces/{namespace}/tenants/{tenant}/disable-logging"] = operator_api.NewDisableTenantLogging(o.context, o.OperatorAPIDisableTenantLoggingHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/namespaces/{namespace}/tenants/{tenant}/enable-logging"] = operator_api.NewEnableTenantLogging(o.context, o.OperatorAPIEnableTenantLoggingHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/cluster/allocatable-resources"] = operator_api.NewGetAllocatableResources(o.context, o.OperatorAPIGetAllocatableResourcesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/directpv/drives"] = operator_api.NewGetDirectPVDriveList(o.context, o.OperatorAPIGetDirectPVDriveListHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/directpv/volumes"] = operator_api.NewGetDirectPVVolumeList(o.context, o.OperatorAPIGetDirectPVVolumeListHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/mp-integration"] = operator_api.NewGetMPIntegration(o.context, o.OperatorAPIGetMPIntegrationHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/cluster/max-allocatable-memory"] = operator_api.NewGetMaxAllocatableMem(o.context, o.OperatorAPIGetMaxAllocatableMemHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants/{tenant}/pvcs/{PVCName}/describe"] = operator_api.NewGetPVCDescribe(o.context, o.OperatorAPIGetPVCDescribeHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants/{tenant}/pvcs/{PVCName}/events"] = operator_api.NewGetPVCEvents(o.context, o.OperatorAPIGetPVCEventsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/get-parity/{nodes}/{disksPerNode}"] = operator_api.NewGetParity(o.context, o.OperatorAPIGetParityHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants/{tenant}/pods/{podName}/events"] = operator_api.NewGetPodEvents(o.context, o.OperatorAPIGetPodEventsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants/{tenant}/pods/{podName}"] = operator_api.NewGetPodLogs(o.context, o.OperatorAPIGetPodLogsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/resourcequotas/{resource-quota-name}"] = operator_api.NewGetResourceQuota(o.context, o.OperatorAPIGetResourceQuotaHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants/{tenant}/events"] = operator_api.NewGetTenantEvents(o.context, o.OperatorAPIGetTenantEventsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants/{tenant}/log"] = operator_api.NewGetTenantLogs(o.context, o.OperatorAPIGetTenantLogsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants/{tenant}/monitoring"] = operator_api.NewGetTenantMonitoring(o.context, o.OperatorAPIGetTenantMonitoringHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants/{tenant}/pods"] = operator_api.NewGetTenantPods(o.context, o.OperatorAPIGetTenantPodsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants/{tenant}/usage"] = operator_api.NewGetTenantUsage(o.context, o.OperatorAPIGetTenantUsageHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants/{tenant}/yaml"] = operator_api.NewGetTenantYAML(o.context, o.OperatorAPIGetTenantYAMLHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/tenants"] = operator_api.NewListAllTenants(o.context, o.OperatorAPIListAllTenantsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/nodes/labels"] = operator_api.NewListNodeLabels(o.context, o.OperatorAPIListNodeLabelsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/list-pvcs"] = operator_api.NewListPVCs(o.context, o.OperatorAPIListPVCsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants/{tenant}/pvcs"] = operator_api.NewListPVCsForTenant(o.context, o.OperatorAPIListPVCsForTenantHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants/{tenant}/csr"] = operator_api.NewListTenantCertificateSigningRequest(o.context, o.OperatorAPIListTenantCertificateSigningRequestHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants"] = operator_api.NewListTenants(o.context, o.OperatorAPIListTenantsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/login"] = auth.NewLoginDetail(o.context, o.AuthLoginDetailHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/login/oauth2/auth"] = auth.NewLoginOauth2Auth(o.context, o.AuthLoginOauth2AuthHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/login/operator"] = auth.NewLoginOperator(o.context, o.AuthLoginOperatorHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/logout"] = auth.NewLogout(o.context, o.AuthLogoutHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/subnet/apikey/info"] = operator_api.NewOperatorSubnetAPIKeyInfo(o.context, o.OperatorAPIOperatorSubnetAPIKeyInfoHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/subnet/apikey"] = operator_api.NewOperatorSubnetAPIKey(o.context, o.OperatorAPIOperatorSubnetAPIKeyHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/subnet/login"] = operator_api.NewOperatorSubnetLogin(o.context, o.OperatorAPIOperatorSubnetLoginHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/subnet/login/mfa"] = operator_api.NewOperatorSubnetLoginMFA(o.context, o.OperatorAPIOperatorSubnetLoginMFAHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/subnet/apikey/register"] = operator_api.NewOperatorSubnetRegisterAPIKey(o.context, o.OperatorAPIOperatorSubnetRegisterAPIKeyHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/mp-integration"] = operator_api.NewPostMPIntegration(o.context, o.OperatorAPIPostMPIntegrationHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/namespaces/{namespace}/tenants/{tenant}/yaml"] = operator_api.NewPutTenantYAML(o.context, o.OperatorAPIPutTenantYAMLHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/session"] = auth.NewSessionCheck(o.context, o.AuthSessionCheckHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/namespaces/{namespace}/tenants/{tenant}/set-administrators"] = operator_api.NewSetTenantAdministrators(o.context, o.OperatorAPISetTenantAdministratorsHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/namespaces/{namespace}/tenants/{tenant}/log"] = operator_api.NewSetTenantLogs(o.context, o.OperatorAPISetTenantLogsHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/namespaces/{namespace}/tenants/{tenant}/monitoring"] = operator_api.NewSetTenantMonitoring(o.context, o.OperatorAPISetTenantMonitoringHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/subscription/namespaces/{namespace}/tenants/{tenant}/activate"] = operator_api.NewSubscriptionActivate(o.context, o.OperatorAPISubscriptionActivateHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/subscription/info"] = operator_api.NewSubscriptionInfo(o.context, o.OperatorAPISubscriptionInfoHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/subscription/refresh"] = operator_api.NewSubscriptionRefresh(o.context, o.OperatorAPISubscriptionRefreshHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/subscription/validate"] = operator_api.NewSubscriptionValidate(o.context, o.OperatorAPISubscriptionValidateHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/namespaces/{namespace}/tenants/{tenant}/pools"] = operator_api.NewTenantAddPool(o.context, o.OperatorAPITenantAddPoolHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants/{tenant}/configuration"] = operator_api.NewTenantConfiguration(o.context, o.OperatorAPITenantConfigurationHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/namespaces/{namespace}/tenants/{tenant}/encryption"] = operator_api.NewTenantDeleteEncryption(o.context, o.OperatorAPITenantDeleteEncryptionHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants/{tenant}"] = operator_api.NewTenantDetails(o.context, o.OperatorAPITenantDetailsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants/{tenant}/encryption"] = operator_api.NewTenantEncryptionInfo(o.context, o.OperatorAPITenantEncryptionInfoHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants/{tenant}/identity-provider"] = operator_api.NewTenantIdentityProvider(o.context, o.OperatorAPITenantIdentityProviderHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/namespaces/{namespace}/tenants/{tenant}/security"] = operator_api.NewTenantSecurity(o.context, o.OperatorAPITenantSecurityHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/namespaces/{namespace}/tenants/{tenant}/certificates"] = operator_api.NewTenantUpdateCertificate(o.context, o.OperatorAPITenantUpdateCertificateHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/namespaces/{namespace}/tenants/{tenant}/encryption"] = operator_api.NewTenantUpdateEncryption(o.context, o.OperatorAPITenantUpdateEncryptionHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/namespaces/{namespace}/tenants/{tenant}/pools"] = operator_api.NewTenantUpdatePools(o.context, o.OperatorAPITenantUpdatePoolsHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/namespaces/{namespace}/tenants/{tenant}"] = operator_api.NewUpdateTenant(o.context, o.OperatorAPIUpdateTenantHandler)
	if o.handlers["PATCH"] == nil {
		o.handlers["PATCH"] = make(map[string]http.Handler)
	}
	o.handlers["PATCH"]["/namespaces/{namespace}/tenants/{tenant}/configuration"] = operator_api.NewUpdateTenantConfiguration(o.context, o.OperatorAPIUpdateTenantConfigurationHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/namespaces/{namespace}/tenants/{tenant}/domains"] = operator_api.NewUpdateTenantDomains(o.context, o.OperatorAPIUpdateTenantDomainsHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/namespaces/{namespace}/tenants/{tenant}/identity-provider"] = operator_api.NewUpdateTenantIdentityProvider(o.context, o.OperatorAPIUpdateTenantIdentityProviderHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/namespaces/{namespace}/tenants/{tenant}/security"] = operator_api.NewUpdateTenantSecurity(o.context, o.OperatorAPIUpdateTenantSecurityHandler)
}

// Serve creates a http handler to serve the API over HTTP
// can be used directly in http.ListenAndServe(":8000", api.Serve(nil))
func (o *OperatorAPI) Serve(builder middleware.Builder) http.Handler {
	o.Init()

	if o.Middleware != nil {
		return o.Middleware(builder)
	}
	if o.useSwaggerUI {
		return o.context.APIHandlerSwaggerUI(builder)
	}
	return o.context.APIHandler(builder)
}

// Init allows you to just initialize the handler cache, you can then recompose the middleware as you see fit
func (o *OperatorAPI) Init() {
	if len(o.handlers) == 0 {
		o.initHandlerCache()
	}
}

// RegisterConsumer allows you to add (or override) a consumer for a media type.
func (o *OperatorAPI) RegisterConsumer(mediaType string, consumer runtime.Consumer) {
	o.customConsumers[mediaType] = consumer
}

// RegisterProducer allows you to add (or override) a producer for a media type.
func (o *OperatorAPI) RegisterProducer(mediaType string, producer runtime.Producer) {
	o.customProducers[mediaType] = producer
}

// AddMiddlewareFor adds a http middleware to existing handler
func (o *OperatorAPI) AddMiddlewareFor(method, path string, builder middleware.Builder) {
	um := strings.ToUpper(method)
	if path == "/" {
		path = ""
	}
	o.Init()
	if h, ok := o.handlers[um][path]; ok {
		o.handlers[method][path] = builder(h)
	}
}
