// Copyright 2020 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// This file defines the format of Firestore bundle file/stream. It is not a part of the
// Firestore API, only a specification used by Server and Client SDK to write and read
// bundles.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/firestore/bundle/bundle.proto

package firestore

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	v1 "google.golang.org/genproto/googleapis/firestore/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// If the query is a limit query, should the limit be applied to the beginning or
// the end of results.
type BundledQuery_LimitType int32

const (
	BundledQuery_FIRST BundledQuery_LimitType = 0
	BundledQuery_LAST  BundledQuery_LimitType = 1
)

// Enum value maps for BundledQuery_LimitType.
var (
	BundledQuery_LimitType_name = map[int32]string{
		0: "FIRST",
		1: "LAST",
	}
	BundledQuery_LimitType_value = map[string]int32{
		"FIRST": 0,
		"LAST":  1,
	}
)

func (x BundledQuery_LimitType) Enum() *BundledQuery_LimitType {
	p := new(BundledQuery_LimitType)
	*p = x
	return p
}

func (x BundledQuery_LimitType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BundledQuery_LimitType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_firestore_bundle_bundle_proto_enumTypes[0].Descriptor()
}

func (BundledQuery_LimitType) Type() protoreflect.EnumType {
	return &file_google_firestore_bundle_bundle_proto_enumTypes[0]
}

func (x BundledQuery_LimitType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BundledQuery_LimitType.Descriptor instead.
func (BundledQuery_LimitType) EnumDescriptor() ([]byte, []int) {
	return file_google_firestore_bundle_bundle_proto_rawDescGZIP(), []int{0, 0}
}

// Encodes a query saved in the bundle.
type BundledQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parent resource name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The query to run.
	//
	// Types that are assignable to QueryType:
	//	*BundledQuery_StructuredQuery
	QueryType isBundledQuery_QueryType `protobuf_oneof:"query_type"`
	LimitType BundledQuery_LimitType   `protobuf:"varint,3,opt,name=limit_type,json=limitType,proto3,enum=google.firestore.bundle.BundledQuery_LimitType" json:"limit_type,omitempty"`
}

func (x *BundledQuery) Reset() {
	*x = BundledQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_bundle_bundle_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BundledQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BundledQuery) ProtoMessage() {}

func (x *BundledQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_bundle_bundle_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BundledQuery.ProtoReflect.Descriptor instead.
func (*BundledQuery) Descriptor() ([]byte, []int) {
	return file_google_firestore_bundle_bundle_proto_rawDescGZIP(), []int{0}
}

func (x *BundledQuery) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *BundledQuery) GetQueryType() isBundledQuery_QueryType {
	if m != nil {
		return m.QueryType
	}
	return nil
}

func (x *BundledQuery) GetStructuredQuery() *v1.StructuredQuery {
	if x, ok := x.GetQueryType().(*BundledQuery_StructuredQuery); ok {
		return x.StructuredQuery
	}
	return nil
}

func (x *BundledQuery) GetLimitType() BundledQuery_LimitType {
	if x != nil {
		return x.LimitType
	}
	return BundledQuery_FIRST
}

type isBundledQuery_QueryType interface {
	isBundledQuery_QueryType()
}

type BundledQuery_StructuredQuery struct {
	// A structured query.
	StructuredQuery *v1.StructuredQuery `protobuf:"bytes,2,opt,name=structured_query,json=structuredQuery,proto3,oneof"`
}

func (*BundledQuery_StructuredQuery) isBundledQuery_QueryType() {}

// A Query associated with a name, created as part of the bundle file, and can be read
// by client SDKs once the bundle containing them is loaded.
type NamedQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the query, such that client can use the name to load this query
	// from bundle, and resume from when the query results are materialized
	// into this bundle.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The query saved in the bundle.
	BundledQuery *BundledQuery `protobuf:"bytes,2,opt,name=bundled_query,json=bundledQuery,proto3" json:"bundled_query,omitempty"`
	// The read time of the query, when it is used to build the bundle. This is useful to
	// resume the query from the bundle, once it is loaded by client SDKs.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
}

func (x *NamedQuery) Reset() {
	*x = NamedQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_bundle_bundle_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamedQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamedQuery) ProtoMessage() {}

func (x *NamedQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_bundle_bundle_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamedQuery.ProtoReflect.Descriptor instead.
func (*NamedQuery) Descriptor() ([]byte, []int) {
	return file_google_firestore_bundle_bundle_proto_rawDescGZIP(), []int{1}
}

func (x *NamedQuery) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NamedQuery) GetBundledQuery() *BundledQuery {
	if x != nil {
		return x.BundledQuery
	}
	return nil
}

func (x *NamedQuery) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

// Metadata describing a Firestore document saved in the bundle.
type BundledDocumentMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The document key of a bundled document.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The snapshot version of the document data bundled.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Whether the document exists.
	Exists bool `protobuf:"varint,3,opt,name=exists,proto3" json:"exists,omitempty"`
	// The names of the queries in this bundle that this document matches to.
	Queries []string `protobuf:"bytes,4,rep,name=queries,proto3" json:"queries,omitempty"`
}

func (x *BundledDocumentMetadata) Reset() {
	*x = BundledDocumentMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_bundle_bundle_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BundledDocumentMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BundledDocumentMetadata) ProtoMessage() {}

func (x *BundledDocumentMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_bundle_bundle_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BundledDocumentMetadata.ProtoReflect.Descriptor instead.
func (*BundledDocumentMetadata) Descriptor() ([]byte, []int) {
	return file_google_firestore_bundle_bundle_proto_rawDescGZIP(), []int{2}
}

func (x *BundledDocumentMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BundledDocumentMetadata) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *BundledDocumentMetadata) GetExists() bool {
	if x != nil {
		return x.Exists
	}
	return false
}

func (x *BundledDocumentMetadata) GetQueries() []string {
	if x != nil {
		return x.Queries
	}
	return nil
}

// Metadata describing the bundle file/stream.
type BundleMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the bundle.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Time at which the documents snapshot is taken for this bundle.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The schema version of the bundle.
	Version uint32 `protobuf:"varint,3,opt,name=version,proto3" json:"version,omitempty"`
	// The number of documents in the bundle.
	TotalDocuments uint32 `protobuf:"varint,4,opt,name=total_documents,json=totalDocuments,proto3" json:"total_documents,omitempty"`
	// The size of the bundle in bytes, excluding this `BundleMetadata`.
	TotalBytes uint64 `protobuf:"varint,5,opt,name=total_bytes,json=totalBytes,proto3" json:"total_bytes,omitempty"`
}

func (x *BundleMetadata) Reset() {
	*x = BundleMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_bundle_bundle_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BundleMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BundleMetadata) ProtoMessage() {}

func (x *BundleMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_bundle_bundle_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BundleMetadata.ProtoReflect.Descriptor instead.
func (*BundleMetadata) Descriptor() ([]byte, []int) {
	return file_google_firestore_bundle_bundle_proto_rawDescGZIP(), []int{3}
}

func (x *BundleMetadata) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *BundleMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BundleMetadata) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *BundleMetadata) GetTotalDocuments() uint32 {
	if x != nil {
		return x.TotalDocuments
	}
	return 0
}

func (x *BundleMetadata) GetTotalBytes() uint64 {
	if x != nil {
		return x.TotalBytes
	}
	return 0
}

// A Firestore bundle is a length-prefixed stream of JSON representations of
// `BundleElement`.
// Only one `BundleMetadata` is expected, and it should be the first element.
// The named queries follow after `metadata`. Every `document_metadata` is
// immediately followed by a `document`.
type BundleElement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ElementType:
	//	*BundleElement_Metadata
	//	*BundleElement_NamedQuery
	//	*BundleElement_DocumentMetadata
	//	*BundleElement_Document
	ElementType isBundleElement_ElementType `protobuf_oneof:"element_type"`
}

func (x *BundleElement) Reset() {
	*x = BundleElement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_bundle_bundle_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BundleElement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BundleElement) ProtoMessage() {}

func (x *BundleElement) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_bundle_bundle_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BundleElement.ProtoReflect.Descriptor instead.
func (*BundleElement) Descriptor() ([]byte, []int) {
	return file_google_firestore_bundle_bundle_proto_rawDescGZIP(), []int{4}
}

func (m *BundleElement) GetElementType() isBundleElement_ElementType {
	if m != nil {
		return m.ElementType
	}
	return nil
}

func (x *BundleElement) GetMetadata() *BundleMetadata {
	if x, ok := x.GetElementType().(*BundleElement_Metadata); ok {
		return x.Metadata
	}
	return nil
}

func (x *BundleElement) GetNamedQuery() *NamedQuery {
	if x, ok := x.GetElementType().(*BundleElement_NamedQuery); ok {
		return x.NamedQuery
	}
	return nil
}

func (x *BundleElement) GetDocumentMetadata() *BundledDocumentMetadata {
	if x, ok := x.GetElementType().(*BundleElement_DocumentMetadata); ok {
		return x.DocumentMetadata
	}
	return nil
}

func (x *BundleElement) GetDocument() *v1.Document {
	if x, ok := x.GetElementType().(*BundleElement_Document); ok {
		return x.Document
	}
	return nil
}

type isBundleElement_ElementType interface {
	isBundleElement_ElementType()
}

type BundleElement_Metadata struct {
	Metadata *BundleMetadata `protobuf:"bytes,1,opt,name=metadata,proto3,oneof"`
}

type BundleElement_NamedQuery struct {
	NamedQuery *NamedQuery `protobuf:"bytes,2,opt,name=named_query,json=namedQuery,proto3,oneof"`
}

type BundleElement_DocumentMetadata struct {
	DocumentMetadata *BundledDocumentMetadata `protobuf:"bytes,3,opt,name=document_metadata,json=documentMetadata,proto3,oneof"`
}

type BundleElement_Document struct {
	Document *v1.Document `protobuf:"bytes,4,opt,name=document,proto3,oneof"`
}

func (*BundleElement_Metadata) isBundleElement_ElementType() {}

func (*BundleElement_NamedQuery) isBundleElement_ElementType() {}

func (*BundleElement_DocumentMetadata) isBundleElement_ElementType() {}

func (*BundleElement_Document) isBundleElement_ElementType() {}

var File_google_firestore_bundle_bundle_proto protoreflect.FileDescriptor

var file_google_firestore_bundle_bundle_proto_rawDesc = []byte{
	0x0a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x1a,
	0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66, 0x69, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf9, 0x01, 0x0a, 0x0c, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x51,
	0x0a, 0x10, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x48, 0x00,
	0x52, 0x0f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x4e, 0x0a, 0x0a, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e,
	0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x22, 0x20, 0x0a, 0x09, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x09,
	0x0a, 0x05, 0x46, 0x49, 0x52, 0x53, 0x54, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4c, 0x41, 0x53,
	0x54, 0x10, 0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x22, 0xa5, 0x01, 0x0a, 0x0a, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x0d, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x64, 0x5f,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x62,
	0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x64, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x52, 0x0c, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x98, 0x01, 0x0a, 0x17, 0x42, 0x75,
	0x6e, 0x64, 0x6c, 0x65, 0x64, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x78, 0x69, 0x73, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x06, 0x65, 0x78, 0x69, 0x73, 0x74, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x71, 0x75,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x71, 0x75, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x22, 0xc1, 0x01, 0x0a, 0x0e, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x27,
	0x0a, 0x0f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0e, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0xcc, 0x02, 0x0a, 0x0d, 0x42, 0x75, 0x6e,
	0x64, 0x6c, 0x65, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x46, 0x0a, 0x0b, 0x6e, 0x61, 0x6d, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0a, 0x6e,
	0x61, 0x6d, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x5f, 0x0a, 0x11, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x42,
	0x75, 0x6e, 0x64, 0x6c, 0x65, 0x64, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x10, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x08, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x08, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x65, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x91, 0x01, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x42, 0x0b, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x62, 0x75, 0x6e,
	0x64, 0x6c, 0x65, 0x3b, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0xa2, 0x02, 0x05,
	0x46, 0x53, 0x54, 0x50, 0x42, 0xaa, 0x02, 0x10, 0x46, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0xca, 0x02, 0x10, 0x46, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x5c, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_firestore_bundle_bundle_proto_rawDescOnce sync.Once
	file_google_firestore_bundle_bundle_proto_rawDescData = file_google_firestore_bundle_bundle_proto_rawDesc
)

func file_google_firestore_bundle_bundle_proto_rawDescGZIP() []byte {
	file_google_firestore_bundle_bundle_proto_rawDescOnce.Do(func() {
		file_google_firestore_bundle_bundle_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_firestore_bundle_bundle_proto_rawDescData)
	})
	return file_google_firestore_bundle_bundle_proto_rawDescData
}

var file_google_firestore_bundle_bundle_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_firestore_bundle_bundle_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_firestore_bundle_bundle_proto_goTypes = []interface{}{
	(BundledQuery_LimitType)(0),     // 0: google.firestore.bundle.BundledQuery.LimitType
	(*BundledQuery)(nil),            // 1: google.firestore.bundle.BundledQuery
	(*NamedQuery)(nil),              // 2: google.firestore.bundle.NamedQuery
	(*BundledDocumentMetadata)(nil), // 3: google.firestore.bundle.BundledDocumentMetadata
	(*BundleMetadata)(nil),          // 4: google.firestore.bundle.BundleMetadata
	(*BundleElement)(nil),           // 5: google.firestore.bundle.BundleElement
	(*v1.StructuredQuery)(nil),      // 6: google.firestore.v1.StructuredQuery
	(*timestamppb.Timestamp)(nil),   // 7: google.protobuf.Timestamp
	(*v1.Document)(nil),             // 8: google.firestore.v1.Document
}
var file_google_firestore_bundle_bundle_proto_depIdxs = []int32{
	6,  // 0: google.firestore.bundle.BundledQuery.structured_query:type_name -> google.firestore.v1.StructuredQuery
	0,  // 1: google.firestore.bundle.BundledQuery.limit_type:type_name -> google.firestore.bundle.BundledQuery.LimitType
	1,  // 2: google.firestore.bundle.NamedQuery.bundled_query:type_name -> google.firestore.bundle.BundledQuery
	7,  // 3: google.firestore.bundle.NamedQuery.read_time:type_name -> google.protobuf.Timestamp
	7,  // 4: google.firestore.bundle.BundledDocumentMetadata.read_time:type_name -> google.protobuf.Timestamp
	7,  // 5: google.firestore.bundle.BundleMetadata.create_time:type_name -> google.protobuf.Timestamp
	4,  // 6: google.firestore.bundle.BundleElement.metadata:type_name -> google.firestore.bundle.BundleMetadata
	2,  // 7: google.firestore.bundle.BundleElement.named_query:type_name -> google.firestore.bundle.NamedQuery
	3,  // 8: google.firestore.bundle.BundleElement.document_metadata:type_name -> google.firestore.bundle.BundledDocumentMetadata
	8,  // 9: google.firestore.bundle.BundleElement.document:type_name -> google.firestore.v1.Document
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_google_firestore_bundle_bundle_proto_init() }
func file_google_firestore_bundle_bundle_proto_init() {
	if File_google_firestore_bundle_bundle_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_firestore_bundle_bundle_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BundledQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_bundle_bundle_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamedQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_bundle_bundle_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BundledDocumentMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_bundle_bundle_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BundleMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_bundle_bundle_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BundleElement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_firestore_bundle_bundle_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*BundledQuery_StructuredQuery)(nil),
	}
	file_google_firestore_bundle_bundle_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*BundleElement_Metadata)(nil),
		(*BundleElement_NamedQuery)(nil),
		(*BundleElement_DocumentMetadata)(nil),
		(*BundleElement_Document)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_firestore_bundle_bundle_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_firestore_bundle_bundle_proto_goTypes,
		DependencyIndexes: file_google_firestore_bundle_bundle_proto_depIdxs,
		EnumInfos:         file_google_firestore_bundle_bundle_proto_enumTypes,
		MessageInfos:      file_google_firestore_bundle_bundle_proto_msgTypes,
	}.Build()
	File_google_firestore_bundle_bundle_proto = out.File
	file_google_firestore_bundle_bundle_proto_rawDesc = nil
	file_google_firestore_bundle_bundle_proto_goTypes = nil
	file_google_firestore_bundle_bundle_proto_depIdxs = nil
}
