package requests

import "regexp"

var idURLMap = map[string]string{
	"acct":      "/v1/accounts/",
	"ch":        "/v1/charges/",
	"cn":        "/v1/credit_notes/",
	"cs":        "/v1/checkout/sessions/",
	"cus":       "/v1/customers/",
	"dp":        "/v1/disputes/",
	"evt":       "/v1/events/",
	"fee":       "/v1/application_fees/",
	"file":      "/v1/files/",
	"iauth":     "/v1/issuing/authorizations/",
	"ic":        "/v1/issuing/cards/",
	"ich":       "/v1/issuing/cardholders/",
	"idp":       "/v1/issuing/disputes/",
	"ii":        "/v1/invoiceitems/",
	"in":        "/v1/invoices/",
	"ipi":       "/v1/issuing/transactions/",
	"issfr":     "/v1/radar/early_fraud_warnings/",
	"link":      "/v1/file_links/",
	"or":        "/v1/orders/",
	"orret":     "/v1/order_returns/",
	"pi":        "/v1/payment_intents/",
	"plan":      "/v1/plans/",
	"pm":        "/v1/payment_methods/",
	"po":        "/v1/payouts/",
	"price":     "/v1/prices/",
	"prod":      "/v1/products/",
	"prv":       "/v1/reviews/",
	"py":        "/v1/charges/",
	"re":        "/v1/refunds/",
	"rsl":       "/v1/radar/value_lists/",
	"rsli":      "/v1/radar/value_list_items/",
	"seti":      "/v1/setup_intents/",
	"si":        "/v1/subscription_items/",
	"sku":       "/v1/skus/",
	"sqr":       "/v1/sigma/scheduled_query_runs/",
	"src":       "/v1/sources/",
	"sub":       "/v1/subscriptions/",
	"sub_sched": "/v1/subscription_schedules/",
	"tml":       "/v1/terminal/locations/",
	"tmr":       "/v1/terminal/readers/",
	"tok":       "/v1/tokens/",
	"tr":        "/v1/transfers/",
	"tu":        "/v1/topups/",
	"txi":       "/v1/tax_ids/",
	"txn":       "/v1/balance_transactions/",
	"txr":       "/v1/tax_rates/",
	"we":        "/v1/webhook_endpoints/",
}

var idRegex = regexp.MustCompile("^([a-z]{2,5}(_[a-z]{2,5}[^test|live])?)_(test_|live_)?[a-zA-Z0-9]{3,}$")
