// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/deploy/v1/deploypolicy_evaluation_payload.proto

package deploypb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The policy verdict of the request.
type DeployPolicyEvaluationEvent_PolicyVerdict int32

const (
	// This should never happen.
	DeployPolicyEvaluationEvent_POLICY_VERDICT_UNSPECIFIED DeployPolicyEvaluationEvent_PolicyVerdict = 0
	// Allowed by policy. This enum value is not currently used but may be used
	// in the future. Currently logs are only generated when a request is denied
	// by policy.
	DeployPolicyEvaluationEvent_ALLOWED_BY_POLICY DeployPolicyEvaluationEvent_PolicyVerdict = 1
	// Denied by policy.
	DeployPolicyEvaluationEvent_DENIED_BY_POLICY DeployPolicyEvaluationEvent_PolicyVerdict = 2
)

// Enum value maps for DeployPolicyEvaluationEvent_PolicyVerdict.
var (
	DeployPolicyEvaluationEvent_PolicyVerdict_name = map[int32]string{
		0: "POLICY_VERDICT_UNSPECIFIED",
		1: "ALLOWED_BY_POLICY",
		2: "DENIED_BY_POLICY",
	}
	DeployPolicyEvaluationEvent_PolicyVerdict_value = map[string]int32{
		"POLICY_VERDICT_UNSPECIFIED": 0,
		"ALLOWED_BY_POLICY":          1,
		"DENIED_BY_POLICY":           2,
	}
)

func (x DeployPolicyEvaluationEvent_PolicyVerdict) Enum() *DeployPolicyEvaluationEvent_PolicyVerdict {
	p := new(DeployPolicyEvaluationEvent_PolicyVerdict)
	*p = x
	return p
}

func (x DeployPolicyEvaluationEvent_PolicyVerdict) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeployPolicyEvaluationEvent_PolicyVerdict) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_enumTypes[0].Descriptor()
}

func (DeployPolicyEvaluationEvent_PolicyVerdict) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_enumTypes[0]
}

func (x DeployPolicyEvaluationEvent_PolicyVerdict) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeployPolicyEvaluationEvent_PolicyVerdict.Descriptor instead.
func (DeployPolicyEvaluationEvent_PolicyVerdict) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_rawDescGZIP(), []int{0, 0}
}

// Things that could have overridden the policy verdict. When overrides are
// used, the request will be allowed even if it is DENIED_BY_POLICY.
type DeployPolicyEvaluationEvent_PolicyVerdictOverride int32

const (
	// This should never happen.
	DeployPolicyEvaluationEvent_POLICY_VERDICT_OVERRIDE_UNSPECIFIED DeployPolicyEvaluationEvent_PolicyVerdictOverride = 0
	// The policy was overridden.
	DeployPolicyEvaluationEvent_POLICY_OVERRIDDEN DeployPolicyEvaluationEvent_PolicyVerdictOverride = 1
	// The policy was suspended.
	DeployPolicyEvaluationEvent_POLICY_SUSPENDED DeployPolicyEvaluationEvent_PolicyVerdictOverride = 2
)

// Enum value maps for DeployPolicyEvaluationEvent_PolicyVerdictOverride.
var (
	DeployPolicyEvaluationEvent_PolicyVerdictOverride_name = map[int32]string{
		0: "POLICY_VERDICT_OVERRIDE_UNSPECIFIED",
		1: "POLICY_OVERRIDDEN",
		2: "POLICY_SUSPENDED",
	}
	DeployPolicyEvaluationEvent_PolicyVerdictOverride_value = map[string]int32{
		"POLICY_VERDICT_OVERRIDE_UNSPECIFIED": 0,
		"POLICY_OVERRIDDEN":                   1,
		"POLICY_SUSPENDED":                    2,
	}
)

func (x DeployPolicyEvaluationEvent_PolicyVerdictOverride) Enum() *DeployPolicyEvaluationEvent_PolicyVerdictOverride {
	p := new(DeployPolicyEvaluationEvent_PolicyVerdictOverride)
	*p = x
	return p
}

func (x DeployPolicyEvaluationEvent_PolicyVerdictOverride) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeployPolicyEvaluationEvent_PolicyVerdictOverride) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_enumTypes[1].Descriptor()
}

func (DeployPolicyEvaluationEvent_PolicyVerdictOverride) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_enumTypes[1]
}

func (x DeployPolicyEvaluationEvent_PolicyVerdictOverride) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeployPolicyEvaluationEvent_PolicyVerdictOverride.Descriptor instead.
func (DeployPolicyEvaluationEvent_PolicyVerdictOverride) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_rawDescGZIP(), []int{0, 1}
}

// Payload proto for "clouddeploy.googleapis.com/deploypolicy_evaluation"
// Platform Log event that describes the deploy policy evaluation event.
type DeployPolicyEvaluationEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Debug message for when a deploy policy event occurs.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// Rule type (e.g. Restrict Rollouts).
	RuleType string `protobuf:"bytes,2,opt,name=rule_type,json=ruleType,proto3" json:"rule_type,omitempty"`
	// Rule id.
	Rule string `protobuf:"bytes,3,opt,name=rule,proto3" json:"rule,omitempty"`
	// Unique identifier of the `Delivery Pipeline`.
	PipelineUid string `protobuf:"bytes,4,opt,name=pipeline_uid,json=pipelineUid,proto3" json:"pipeline_uid,omitempty"`
	// The name of the `Delivery Pipeline`.
	DeliveryPipeline string `protobuf:"bytes,5,opt,name=delivery_pipeline,json=deliveryPipeline,proto3" json:"delivery_pipeline,omitempty"`
	// Unique identifier of the `Target`. This is an optional field, as a `Target`
	// may not always be applicable to a policy.
	TargetUid string `protobuf:"bytes,6,opt,name=target_uid,json=targetUid,proto3" json:"target_uid,omitempty"`
	// The name of the `Target`. This is an optional field, as a `Target` may not
	// always be applicable to a policy.
	Target string `protobuf:"bytes,7,opt,name=target,proto3" json:"target,omitempty"`
	// What invoked the action (e.g. a user or automation).
	Invoker DeployPolicy_Invoker `protobuf:"varint,8,opt,name=invoker,proto3,enum=google.cloud.deploy.v1.DeployPolicy_Invoker" json:"invoker,omitempty"`
	// The name of the `DeployPolicy`.
	DeployPolicy string `protobuf:"bytes,9,opt,name=deploy_policy,json=deployPolicy,proto3" json:"deploy_policy,omitempty"`
	// Unique identifier of the `DeployPolicy`.
	DeployPolicyUid string `protobuf:"bytes,10,opt,name=deploy_policy_uid,json=deployPolicyUid,proto3" json:"deploy_policy_uid,omitempty"`
	// Whether the request is allowed. Allowed is set as true if:
	// (1) the request complies with the policy; or
	// (2) the request doesn't comply with the policy but the policy was
	// overridden; or
	// (3) the request doesn't comply with the policy but the policy was suspended
	Allowed bool `protobuf:"varint,11,opt,name=allowed,proto3" json:"allowed,omitempty"`
	// The policy verdict of the request.
	Verdict DeployPolicyEvaluationEvent_PolicyVerdict `protobuf:"varint,12,opt,name=verdict,proto3,enum=google.cloud.deploy.v1.DeployPolicyEvaluationEvent_PolicyVerdict" json:"verdict,omitempty"`
	// Things that could have overridden the policy verdict. Overrides together
	// with verdict decide whether the request is allowed.
	Overrides []DeployPolicyEvaluationEvent_PolicyVerdictOverride `protobuf:"varint,13,rep,packed,name=overrides,proto3,enum=google.cloud.deploy.v1.DeployPolicyEvaluationEvent_PolicyVerdictOverride" json:"overrides,omitempty"`
}

func (x *DeployPolicyEvaluationEvent) Reset() {
	*x = DeployPolicyEvaluationEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployPolicyEvaluationEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployPolicyEvaluationEvent) ProtoMessage() {}

func (x *DeployPolicyEvaluationEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployPolicyEvaluationEvent.ProtoReflect.Descriptor instead.
func (*DeployPolicyEvaluationEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_rawDescGZIP(), []int{0}
}

func (x *DeployPolicyEvaluationEvent) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *DeployPolicyEvaluationEvent) GetRuleType() string {
	if x != nil {
		return x.RuleType
	}
	return ""
}

func (x *DeployPolicyEvaluationEvent) GetRule() string {
	if x != nil {
		return x.Rule
	}
	return ""
}

func (x *DeployPolicyEvaluationEvent) GetPipelineUid() string {
	if x != nil {
		return x.PipelineUid
	}
	return ""
}

func (x *DeployPolicyEvaluationEvent) GetDeliveryPipeline() string {
	if x != nil {
		return x.DeliveryPipeline
	}
	return ""
}

func (x *DeployPolicyEvaluationEvent) GetTargetUid() string {
	if x != nil {
		return x.TargetUid
	}
	return ""
}

func (x *DeployPolicyEvaluationEvent) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *DeployPolicyEvaluationEvent) GetInvoker() DeployPolicy_Invoker {
	if x != nil {
		return x.Invoker
	}
	return DeployPolicy_INVOKER_UNSPECIFIED
}

func (x *DeployPolicyEvaluationEvent) GetDeployPolicy() string {
	if x != nil {
		return x.DeployPolicy
	}
	return ""
}

func (x *DeployPolicyEvaluationEvent) GetDeployPolicyUid() string {
	if x != nil {
		return x.DeployPolicyUid
	}
	return ""
}

func (x *DeployPolicyEvaluationEvent) GetAllowed() bool {
	if x != nil {
		return x.Allowed
	}
	return false
}

func (x *DeployPolicyEvaluationEvent) GetVerdict() DeployPolicyEvaluationEvent_PolicyVerdict {
	if x != nil {
		return x.Verdict
	}
	return DeployPolicyEvaluationEvent_POLICY_VERDICT_UNSPECIFIED
}

func (x *DeployPolicyEvaluationEvent) GetOverrides() []DeployPolicyEvaluationEvent_PolicyVerdictOverride {
	if x != nil {
		return x.Overrides
	}
	return nil
}

var File_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto protoreflect.FileDescriptor

var file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xb5, 0x06, 0x0a, 0x1b, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x72,
	0x75, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x72, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x69, 0x64, 0x12,
	0x2b, 0x0a, 0x11, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x64, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x55, 0x69, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x12, 0x46, 0x0a, 0x07, 0x69, 0x6e, 0x76, 0x6f, 0x6b, 0x65, 0x72, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x6b,
	0x65, 0x72, 0x52, 0x07, 0x69, 0x6e, 0x76, 0x6f, 0x6b, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x2a, 0x0a, 0x11, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x55, 0x69, 0x64, 0x12, 0x18, 0x0a, 0x07,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x12, 0x5b, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x64, 0x69, 0x63,
	0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x45, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x56, 0x65, 0x72, 0x64, 0x69, 0x63, 0x74, 0x52, 0x07, 0x76, 0x65, 0x72, 0x64,
	0x69, 0x63, 0x74, 0x12, 0x67, 0x0a, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73,
	0x18, 0x0d, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x45, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x56, 0x65, 0x72, 0x64, 0x69, 0x63, 0x74, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64,
	0x65, 0x52, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x22, 0x5c, 0x0a, 0x0d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x56, 0x65, 0x72, 0x64, 0x69, 0x63, 0x74, 0x12, 0x1e, 0x0a,
	0x1a, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x56, 0x45, 0x52, 0x44, 0x49, 0x43, 0x54, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a,
	0x11, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x50, 0x4f, 0x4c, 0x49,
	0x43, 0x59, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x5f, 0x42,
	0x59, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x10, 0x02, 0x22, 0x6d, 0x0a, 0x15, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x56, 0x65, 0x72, 0x64, 0x69, 0x63, 0x74, 0x4f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x12, 0x27, 0x0a, 0x23, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x56, 0x45,
	0x52, 0x44, 0x49, 0x43, 0x54, 0x5f, 0x4f, 0x56, 0x45, 0x52, 0x52, 0x49, 0x44, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11,
	0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x4f, 0x56, 0x45, 0x52, 0x52, 0x49, 0x44, 0x44, 0x45,
	0x4e, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x53, 0x55,
	0x53, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x02, 0x42, 0x76, 0x0a, 0x1a, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x42, 0x22, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x70, 0x62, 0x3b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x70,
	0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_rawDescOnce sync.Once
	file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_rawDescData = file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_rawDesc
)

func file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_rawDescGZIP() []byte {
	file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_rawDescOnce.Do(func() {
		file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_rawDescData)
	})
	return file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_rawDescData
}

var file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_goTypes = []any{
	(DeployPolicyEvaluationEvent_PolicyVerdict)(0),         // 0: google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict
	(DeployPolicyEvaluationEvent_PolicyVerdictOverride)(0), // 1: google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride
	(*DeployPolicyEvaluationEvent)(nil),                    // 2: google.cloud.deploy.v1.DeployPolicyEvaluationEvent
	(DeployPolicy_Invoker)(0),                              // 3: google.cloud.deploy.v1.DeployPolicy.Invoker
}
var file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_depIdxs = []int32{
	3, // 0: google.cloud.deploy.v1.DeployPolicyEvaluationEvent.invoker:type_name -> google.cloud.deploy.v1.DeployPolicy.Invoker
	0, // 1: google.cloud.deploy.v1.DeployPolicyEvaluationEvent.verdict:type_name -> google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict
	1, // 2: google.cloud.deploy.v1.DeployPolicyEvaluationEvent.overrides:type_name -> google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_init() }
func file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_init() {
	if File_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto != nil {
		return
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*DeployPolicyEvaluationEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_goTypes,
		DependencyIndexes: file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_depIdxs,
		EnumInfos:         file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_enumTypes,
		MessageInfos:      file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_msgTypes,
	}.Build()
	File_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto = out.File
	file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_rawDesc = nil
	file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_goTypes = nil
	file_google_cloud_deploy_v1_deploypolicy_evaluation_payload_proto_depIdxs = nil
}
