// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AlertRuleNotificationSettings alert rule notification settings
//
// swagger:model AlertRuleNotificationSettings
type AlertRuleNotificationSettings struct {

	// Override the labels by which incoming alerts are grouped together. For example, multiple alerts coming in for
	// cluster=A and alertname=LatencyHigh would be batched into a single group. To aggregate by all possible labels
	// use the special value '...' as the sole label name.
	// This effectively disables aggregation entirely, passing through all alerts as-is. This is unlikely to be what
	// you want, unless you have a very low alert volume or your upstream notification system performs its own grouping.
	// Must include 'alertname' and 'grafana_folder' if not using '...'.
	// Example: ["alertname","grafana_folder","cluster"]
	GroupBy []string `json:"group_by"`

	// Override how long to wait before sending a notification about new alerts that are added to a group of alerts for
	// which an initial notification has already been sent. (Usually ~5m or more.)
	// Example: 5m
	GroupInterval string `json:"group_interval,omitempty"`

	// Override how long to initially wait to send a notification for a group of alerts. Allows to wait for an
	// inhibiting alert to arrive or collect more initial alerts for the same group. (Usually ~0s to few minutes.)
	// Example: 30s
	GroupWait string `json:"group_wait,omitempty"`

	// Override the times when notifications should be muted. These must match the name of a mute time interval defined
	// in the alertmanager configuration mute_time_intervals section. When muted it will not send any notifications, but
	// otherwise acts normally.
	// Example: ["maintenance"]
	MuteTimeIntervals []string `json:"mute_time_intervals"`

	// Name of the receiver to send notifications to.
	// Example: grafana-default-email
	// Required: true
	Receiver *string `json:"receiver"`

	// Override how long to wait before sending a notification again if it has already been sent successfully for an
	// alert. (Usually ~3h or more).
	// Note that this parameter is implicitly bound by Alertmanager's `--data.retention` configuration flag.
	// Notifications will be resent after either repeat_interval or the data retention period have passed, whichever
	// occurs first. `repeat_interval` should not be less than `group_interval`.
	// Example: 4h
	RepeatInterval string `json:"repeat_interval,omitempty"`
}

// Validate validates this alert rule notification settings
func (m *AlertRuleNotificationSettings) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateReceiver(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AlertRuleNotificationSettings) validateReceiver(formats strfmt.Registry) error {

	if err := validate.Required("receiver", "body", m.Receiver); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this alert rule notification settings based on context it is used
func (m *AlertRuleNotificationSettings) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *AlertRuleNotificationSettings) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AlertRuleNotificationSettings) UnmarshalBinary(b []byte) error {
	var res AlertRuleNotificationSettings
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
