// Code generated by go-swagger; DO NOT EDIT.

package signing_keys

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// RetrieveJWKSReader is a Reader for the RetrieveJWKS structure.
type RetrieveJWKSReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RetrieveJWKSReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRetrieveJWKSOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewRetrieveJWKSInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /signing-keys/keys] retrieveJWKS", response, response.Code())
	}
}

// NewRetrieveJWKSOK creates a RetrieveJWKSOK with default headers values
func NewRetrieveJWKSOK() *RetrieveJWKSOK {
	return &RetrieveJWKSOK{}
}

/*
RetrieveJWKSOK describes a response with status code 200, with default header values.

(empty)
*/
type RetrieveJWKSOK struct {
	Payload *models.RetrieveJWKSOKBody
}

// IsSuccess returns true when this retrieve j w k s Ok response has a 2xx status code
func (o *RetrieveJWKSOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this retrieve j w k s Ok response has a 3xx status code
func (o *RetrieveJWKSOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this retrieve j w k s Ok response has a 4xx status code
func (o *RetrieveJWKSOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this retrieve j w k s Ok response has a 5xx status code
func (o *RetrieveJWKSOK) IsServerError() bool {
	return false
}

// IsCode returns true when this retrieve j w k s Ok response a status code equal to that given
func (o *RetrieveJWKSOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the retrieve j w k s Ok response
func (o *RetrieveJWKSOK) Code() int {
	return 200
}

func (o *RetrieveJWKSOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /signing-keys/keys][%d] retrieveJWKSOk %s", 200, payload)
}

func (o *RetrieveJWKSOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /signing-keys/keys][%d] retrieveJWKSOk %s", 200, payload)
}

func (o *RetrieveJWKSOK) GetPayload() *models.RetrieveJWKSOKBody {
	return o.Payload
}

func (o *RetrieveJWKSOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RetrieveJWKSOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRetrieveJWKSInternalServerError creates a RetrieveJWKSInternalServerError with default headers values
func NewRetrieveJWKSInternalServerError() *RetrieveJWKSInternalServerError {
	return &RetrieveJWKSInternalServerError{}
}

/*
RetrieveJWKSInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type RetrieveJWKSInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this retrieve j w k s internal server error response has a 2xx status code
func (o *RetrieveJWKSInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this retrieve j w k s internal server error response has a 3xx status code
func (o *RetrieveJWKSInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this retrieve j w k s internal server error response has a 4xx status code
func (o *RetrieveJWKSInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this retrieve j w k s internal server error response has a 5xx status code
func (o *RetrieveJWKSInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this retrieve j w k s internal server error response a status code equal to that given
func (o *RetrieveJWKSInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the retrieve j w k s internal server error response
func (o *RetrieveJWKSInternalServerError) Code() int {
	return 500
}

func (o *RetrieveJWKSInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /signing-keys/keys][%d] retrieveJWKSInternalServerError %s", 500, payload)
}

func (o *RetrieveJWKSInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /signing-keys/keys][%d] retrieveJWKSInternalServerError %s", 500, payload)
}

func (o *RetrieveJWKSInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *RetrieveJWKSInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
