// Code generated by go-swagger; DO NOT EDIT.

package signed_in_user

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetUserAuthTokensReader is a Reader for the GetUserAuthTokens structure.
type GetUserAuthTokensReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetUserAuthTokensReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetUserAuthTokensOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetUserAuthTokensUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetUserAuthTokensForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetUserAuthTokensInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /user/auth-tokens] getUserAuthTokens", response, response.Code())
	}
}

// NewGetUserAuthTokensOK creates a GetUserAuthTokensOK with default headers values
func NewGetUserAuthTokensOK() *GetUserAuthTokensOK {
	return &GetUserAuthTokensOK{}
}

/*
GetUserAuthTokensOK describes a response with status code 200, with default header values.

(empty)
*/
type GetUserAuthTokensOK struct {
	Payload []*models.UserToken
}

// IsSuccess returns true when this get user auth tokens Ok response has a 2xx status code
func (o *GetUserAuthTokensOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get user auth tokens Ok response has a 3xx status code
func (o *GetUserAuthTokensOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user auth tokens Ok response has a 4xx status code
func (o *GetUserAuthTokensOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get user auth tokens Ok response has a 5xx status code
func (o *GetUserAuthTokensOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get user auth tokens Ok response a status code equal to that given
func (o *GetUserAuthTokensOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get user auth tokens Ok response
func (o *GetUserAuthTokensOK) Code() int {
	return 200
}

func (o *GetUserAuthTokensOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /user/auth-tokens][%d] getUserAuthTokensOk %s", 200, payload)
}

func (o *GetUserAuthTokensOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /user/auth-tokens][%d] getUserAuthTokensOk %s", 200, payload)
}

func (o *GetUserAuthTokensOK) GetPayload() []*models.UserToken {
	return o.Payload
}

func (o *GetUserAuthTokensOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserAuthTokensUnauthorized creates a GetUserAuthTokensUnauthorized with default headers values
func NewGetUserAuthTokensUnauthorized() *GetUserAuthTokensUnauthorized {
	return &GetUserAuthTokensUnauthorized{}
}

/*
GetUserAuthTokensUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetUserAuthTokensUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get user auth tokens unauthorized response has a 2xx status code
func (o *GetUserAuthTokensUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user auth tokens unauthorized response has a 3xx status code
func (o *GetUserAuthTokensUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user auth tokens unauthorized response has a 4xx status code
func (o *GetUserAuthTokensUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get user auth tokens unauthorized response has a 5xx status code
func (o *GetUserAuthTokensUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get user auth tokens unauthorized response a status code equal to that given
func (o *GetUserAuthTokensUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get user auth tokens unauthorized response
func (o *GetUserAuthTokensUnauthorized) Code() int {
	return 401
}

func (o *GetUserAuthTokensUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /user/auth-tokens][%d] getUserAuthTokensUnauthorized %s", 401, payload)
}

func (o *GetUserAuthTokensUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /user/auth-tokens][%d] getUserAuthTokensUnauthorized %s", 401, payload)
}

func (o *GetUserAuthTokensUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetUserAuthTokensUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserAuthTokensForbidden creates a GetUserAuthTokensForbidden with default headers values
func NewGetUserAuthTokensForbidden() *GetUserAuthTokensForbidden {
	return &GetUserAuthTokensForbidden{}
}

/*
GetUserAuthTokensForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetUserAuthTokensForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get user auth tokens forbidden response has a 2xx status code
func (o *GetUserAuthTokensForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user auth tokens forbidden response has a 3xx status code
func (o *GetUserAuthTokensForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user auth tokens forbidden response has a 4xx status code
func (o *GetUserAuthTokensForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get user auth tokens forbidden response has a 5xx status code
func (o *GetUserAuthTokensForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get user auth tokens forbidden response a status code equal to that given
func (o *GetUserAuthTokensForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get user auth tokens forbidden response
func (o *GetUserAuthTokensForbidden) Code() int {
	return 403
}

func (o *GetUserAuthTokensForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /user/auth-tokens][%d] getUserAuthTokensForbidden %s", 403, payload)
}

func (o *GetUserAuthTokensForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /user/auth-tokens][%d] getUserAuthTokensForbidden %s", 403, payload)
}

func (o *GetUserAuthTokensForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetUserAuthTokensForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserAuthTokensInternalServerError creates a GetUserAuthTokensInternalServerError with default headers values
func NewGetUserAuthTokensInternalServerError() *GetUserAuthTokensInternalServerError {
	return &GetUserAuthTokensInternalServerError{}
}

/*
GetUserAuthTokensInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetUserAuthTokensInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get user auth tokens internal server error response has a 2xx status code
func (o *GetUserAuthTokensInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user auth tokens internal server error response has a 3xx status code
func (o *GetUserAuthTokensInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user auth tokens internal server error response has a 4xx status code
func (o *GetUserAuthTokensInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get user auth tokens internal server error response has a 5xx status code
func (o *GetUserAuthTokensInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get user auth tokens internal server error response a status code equal to that given
func (o *GetUserAuthTokensInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get user auth tokens internal server error response
func (o *GetUserAuthTokensInternalServerError) Code() int {
	return 500
}

func (o *GetUserAuthTokensInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /user/auth-tokens][%d] getUserAuthTokensInternalServerError %s", 500, payload)
}

func (o *GetUserAuthTokensInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /user/auth-tokens][%d] getUserAuthTokensInternalServerError %s", 500, payload)
}

func (o *GetUserAuthTokensInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetUserAuthTokensInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
