// Code generated by go-swagger; DO NOT EDIT.

package service_accounts

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// ListTokensReader is a Reader for the ListTokens structure.
type ListTokensReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListTokensReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListTokensOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewListTokensBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewListTokensUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewListTokensForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewListTokensInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /serviceaccounts/{serviceAccountId}/tokens] listTokens", response, response.Code())
	}
}

// NewListTokensOK creates a ListTokensOK with default headers values
func NewListTokensOK() *ListTokensOK {
	return &ListTokensOK{}
}

/*
ListTokensOK describes a response with status code 200, with default header values.

(empty)
*/
type ListTokensOK struct {
	Payload []*models.TokenDTO
}

// IsSuccess returns true when this list tokens Ok response has a 2xx status code
func (o *ListTokensOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list tokens Ok response has a 3xx status code
func (o *ListTokensOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list tokens Ok response has a 4xx status code
func (o *ListTokensOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list tokens Ok response has a 5xx status code
func (o *ListTokensOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list tokens Ok response a status code equal to that given
func (o *ListTokensOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list tokens Ok response
func (o *ListTokensOK) Code() int {
	return 200
}

func (o *ListTokensOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /serviceaccounts/{serviceAccountId}/tokens][%d] listTokensOk %s", 200, payload)
}

func (o *ListTokensOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /serviceaccounts/{serviceAccountId}/tokens][%d] listTokensOk %s", 200, payload)
}

func (o *ListTokensOK) GetPayload() []*models.TokenDTO {
	return o.Payload
}

func (o *ListTokensOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListTokensBadRequest creates a ListTokensBadRequest with default headers values
func NewListTokensBadRequest() *ListTokensBadRequest {
	return &ListTokensBadRequest{}
}

/*
ListTokensBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type ListTokensBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list tokens bad request response has a 2xx status code
func (o *ListTokensBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list tokens bad request response has a 3xx status code
func (o *ListTokensBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list tokens bad request response has a 4xx status code
func (o *ListTokensBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this list tokens bad request response has a 5xx status code
func (o *ListTokensBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this list tokens bad request response a status code equal to that given
func (o *ListTokensBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the list tokens bad request response
func (o *ListTokensBadRequest) Code() int {
	return 400
}

func (o *ListTokensBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /serviceaccounts/{serviceAccountId}/tokens][%d] listTokensBadRequest %s", 400, payload)
}

func (o *ListTokensBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /serviceaccounts/{serviceAccountId}/tokens][%d] listTokensBadRequest %s", 400, payload)
}

func (o *ListTokensBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListTokensBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListTokensUnauthorized creates a ListTokensUnauthorized with default headers values
func NewListTokensUnauthorized() *ListTokensUnauthorized {
	return &ListTokensUnauthorized{}
}

/*
ListTokensUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type ListTokensUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list tokens unauthorized response has a 2xx status code
func (o *ListTokensUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list tokens unauthorized response has a 3xx status code
func (o *ListTokensUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list tokens unauthorized response has a 4xx status code
func (o *ListTokensUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this list tokens unauthorized response has a 5xx status code
func (o *ListTokensUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this list tokens unauthorized response a status code equal to that given
func (o *ListTokensUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the list tokens unauthorized response
func (o *ListTokensUnauthorized) Code() int {
	return 401
}

func (o *ListTokensUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /serviceaccounts/{serviceAccountId}/tokens][%d] listTokensUnauthorized %s", 401, payload)
}

func (o *ListTokensUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /serviceaccounts/{serviceAccountId}/tokens][%d] listTokensUnauthorized %s", 401, payload)
}

func (o *ListTokensUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListTokensUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListTokensForbidden creates a ListTokensForbidden with default headers values
func NewListTokensForbidden() *ListTokensForbidden {
	return &ListTokensForbidden{}
}

/*
ListTokensForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type ListTokensForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list tokens forbidden response has a 2xx status code
func (o *ListTokensForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list tokens forbidden response has a 3xx status code
func (o *ListTokensForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list tokens forbidden response has a 4xx status code
func (o *ListTokensForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this list tokens forbidden response has a 5xx status code
func (o *ListTokensForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this list tokens forbidden response a status code equal to that given
func (o *ListTokensForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the list tokens forbidden response
func (o *ListTokensForbidden) Code() int {
	return 403
}

func (o *ListTokensForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /serviceaccounts/{serviceAccountId}/tokens][%d] listTokensForbidden %s", 403, payload)
}

func (o *ListTokensForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /serviceaccounts/{serviceAccountId}/tokens][%d] listTokensForbidden %s", 403, payload)
}

func (o *ListTokensForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListTokensForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListTokensInternalServerError creates a ListTokensInternalServerError with default headers values
func NewListTokensInternalServerError() *ListTokensInternalServerError {
	return &ListTokensInternalServerError{}
}

/*
ListTokensInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type ListTokensInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list tokens internal server error response has a 2xx status code
func (o *ListTokensInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list tokens internal server error response has a 3xx status code
func (o *ListTokensInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list tokens internal server error response has a 4xx status code
func (o *ListTokensInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this list tokens internal server error response has a 5xx status code
func (o *ListTokensInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this list tokens internal server error response a status code equal to that given
func (o *ListTokensInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the list tokens internal server error response
func (o *ListTokensInternalServerError) Code() int {
	return 500
}

func (o *ListTokensInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /serviceaccounts/{serviceAccountId}/tokens][%d] listTokensInternalServerError %s", 500, payload)
}

func (o *ListTokensInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /serviceaccounts/{serviceAccountId}/tokens][%d] listTokensInternalServerError %s", 500, payload)
}

func (o *ListTokensInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListTokensInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
