// Code generated by go-swagger; DO NOT EDIT.

package playlists

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DeletePlaylistReader is a Reader for the DeletePlaylist structure.
type DeletePlaylistReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeletePlaylistReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeletePlaylistOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewDeletePlaylistUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeletePlaylistForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeletePlaylistNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeletePlaylistInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /playlists/{uid}] deletePlaylist", response, response.Code())
	}
}

// NewDeletePlaylistOK creates a DeletePlaylistOK with default headers values
func NewDeletePlaylistOK() *DeletePlaylistOK {
	return &DeletePlaylistOK{}
}

/*
DeletePlaylistOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type DeletePlaylistOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this delete playlist Ok response has a 2xx status code
func (o *DeletePlaylistOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete playlist Ok response has a 3xx status code
func (o *DeletePlaylistOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete playlist Ok response has a 4xx status code
func (o *DeletePlaylistOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete playlist Ok response has a 5xx status code
func (o *DeletePlaylistOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete playlist Ok response a status code equal to that given
func (o *DeletePlaylistOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete playlist Ok response
func (o *DeletePlaylistOK) Code() int {
	return 200
}

func (o *DeletePlaylistOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /playlists/{uid}][%d] deletePlaylistOk %s", 200, payload)
}

func (o *DeletePlaylistOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /playlists/{uid}][%d] deletePlaylistOk %s", 200, payload)
}

func (o *DeletePlaylistOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *DeletePlaylistOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeletePlaylistUnauthorized creates a DeletePlaylistUnauthorized with default headers values
func NewDeletePlaylistUnauthorized() *DeletePlaylistUnauthorized {
	return &DeletePlaylistUnauthorized{}
}

/*
DeletePlaylistUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type DeletePlaylistUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete playlist unauthorized response has a 2xx status code
func (o *DeletePlaylistUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete playlist unauthorized response has a 3xx status code
func (o *DeletePlaylistUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete playlist unauthorized response has a 4xx status code
func (o *DeletePlaylistUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete playlist unauthorized response has a 5xx status code
func (o *DeletePlaylistUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this delete playlist unauthorized response a status code equal to that given
func (o *DeletePlaylistUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the delete playlist unauthorized response
func (o *DeletePlaylistUnauthorized) Code() int {
	return 401
}

func (o *DeletePlaylistUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /playlists/{uid}][%d] deletePlaylistUnauthorized %s", 401, payload)
}

func (o *DeletePlaylistUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /playlists/{uid}][%d] deletePlaylistUnauthorized %s", 401, payload)
}

func (o *DeletePlaylistUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeletePlaylistUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeletePlaylistForbidden creates a DeletePlaylistForbidden with default headers values
func NewDeletePlaylistForbidden() *DeletePlaylistForbidden {
	return &DeletePlaylistForbidden{}
}

/*
DeletePlaylistForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type DeletePlaylistForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete playlist forbidden response has a 2xx status code
func (o *DeletePlaylistForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete playlist forbidden response has a 3xx status code
func (o *DeletePlaylistForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete playlist forbidden response has a 4xx status code
func (o *DeletePlaylistForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete playlist forbidden response has a 5xx status code
func (o *DeletePlaylistForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete playlist forbidden response a status code equal to that given
func (o *DeletePlaylistForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete playlist forbidden response
func (o *DeletePlaylistForbidden) Code() int {
	return 403
}

func (o *DeletePlaylistForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /playlists/{uid}][%d] deletePlaylistForbidden %s", 403, payload)
}

func (o *DeletePlaylistForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /playlists/{uid}][%d] deletePlaylistForbidden %s", 403, payload)
}

func (o *DeletePlaylistForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeletePlaylistForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeletePlaylistNotFound creates a DeletePlaylistNotFound with default headers values
func NewDeletePlaylistNotFound() *DeletePlaylistNotFound {
	return &DeletePlaylistNotFound{}
}

/*
DeletePlaylistNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type DeletePlaylistNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete playlist not found response has a 2xx status code
func (o *DeletePlaylistNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete playlist not found response has a 3xx status code
func (o *DeletePlaylistNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete playlist not found response has a 4xx status code
func (o *DeletePlaylistNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete playlist not found response has a 5xx status code
func (o *DeletePlaylistNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete playlist not found response a status code equal to that given
func (o *DeletePlaylistNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the delete playlist not found response
func (o *DeletePlaylistNotFound) Code() int {
	return 404
}

func (o *DeletePlaylistNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /playlists/{uid}][%d] deletePlaylistNotFound %s", 404, payload)
}

func (o *DeletePlaylistNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /playlists/{uid}][%d] deletePlaylistNotFound %s", 404, payload)
}

func (o *DeletePlaylistNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeletePlaylistNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeletePlaylistInternalServerError creates a DeletePlaylistInternalServerError with default headers values
func NewDeletePlaylistInternalServerError() *DeletePlaylistInternalServerError {
	return &DeletePlaylistInternalServerError{}
}

/*
DeletePlaylistInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type DeletePlaylistInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete playlist internal server error response has a 2xx status code
func (o *DeletePlaylistInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete playlist internal server error response has a 3xx status code
func (o *DeletePlaylistInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete playlist internal server error response has a 4xx status code
func (o *DeletePlaylistInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete playlist internal server error response has a 5xx status code
func (o *DeletePlaylistInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete playlist internal server error response a status code equal to that given
func (o *DeletePlaylistInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete playlist internal server error response
func (o *DeletePlaylistInternalServerError) Code() int {
	return 500
}

func (o *DeletePlaylistInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /playlists/{uid}][%d] deletePlaylistInternalServerError %s", 500, payload)
}

func (o *DeletePlaylistInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /playlists/{uid}][%d] deletePlaylistInternalServerError %s", 500, payload)
}

func (o *DeletePlaylistInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeletePlaylistInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
