// Code generated by go-swagger; DO NOT EDIT.

package get_current_org

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetCurrentOrgQuotaReader is a Reader for the GetCurrentOrgQuota structure.
type GetCurrentOrgQuotaReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetCurrentOrgQuotaReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetCurrentOrgQuotaOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetCurrentOrgQuotaUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetCurrentOrgQuotaForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetCurrentOrgQuotaNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetCurrentOrgQuotaInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /org/quotas] getCurrentOrgQuota", response, response.Code())
	}
}

// NewGetCurrentOrgQuotaOK creates a GetCurrentOrgQuotaOK with default headers values
func NewGetCurrentOrgQuotaOK() *GetCurrentOrgQuotaOK {
	return &GetCurrentOrgQuotaOK{}
}

/*
GetCurrentOrgQuotaOK describes a response with status code 200, with default header values.

(empty)
*/
type GetCurrentOrgQuotaOK struct {
	Payload []*models.QuotaDTO
}

// IsSuccess returns true when this get current org quota Ok response has a 2xx status code
func (o *GetCurrentOrgQuotaOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get current org quota Ok response has a 3xx status code
func (o *GetCurrentOrgQuotaOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get current org quota Ok response has a 4xx status code
func (o *GetCurrentOrgQuotaOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get current org quota Ok response has a 5xx status code
func (o *GetCurrentOrgQuotaOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get current org quota Ok response a status code equal to that given
func (o *GetCurrentOrgQuotaOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get current org quota Ok response
func (o *GetCurrentOrgQuotaOK) Code() int {
	return 200
}

func (o *GetCurrentOrgQuotaOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /org/quotas][%d] getCurrentOrgQuotaOk %s", 200, payload)
}

func (o *GetCurrentOrgQuotaOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /org/quotas][%d] getCurrentOrgQuotaOk %s", 200, payload)
}

func (o *GetCurrentOrgQuotaOK) GetPayload() []*models.QuotaDTO {
	return o.Payload
}

func (o *GetCurrentOrgQuotaOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCurrentOrgQuotaUnauthorized creates a GetCurrentOrgQuotaUnauthorized with default headers values
func NewGetCurrentOrgQuotaUnauthorized() *GetCurrentOrgQuotaUnauthorized {
	return &GetCurrentOrgQuotaUnauthorized{}
}

/*
GetCurrentOrgQuotaUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetCurrentOrgQuotaUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get current org quota unauthorized response has a 2xx status code
func (o *GetCurrentOrgQuotaUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get current org quota unauthorized response has a 3xx status code
func (o *GetCurrentOrgQuotaUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get current org quota unauthorized response has a 4xx status code
func (o *GetCurrentOrgQuotaUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get current org quota unauthorized response has a 5xx status code
func (o *GetCurrentOrgQuotaUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get current org quota unauthorized response a status code equal to that given
func (o *GetCurrentOrgQuotaUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get current org quota unauthorized response
func (o *GetCurrentOrgQuotaUnauthorized) Code() int {
	return 401
}

func (o *GetCurrentOrgQuotaUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /org/quotas][%d] getCurrentOrgQuotaUnauthorized %s", 401, payload)
}

func (o *GetCurrentOrgQuotaUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /org/quotas][%d] getCurrentOrgQuotaUnauthorized %s", 401, payload)
}

func (o *GetCurrentOrgQuotaUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetCurrentOrgQuotaUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCurrentOrgQuotaForbidden creates a GetCurrentOrgQuotaForbidden with default headers values
func NewGetCurrentOrgQuotaForbidden() *GetCurrentOrgQuotaForbidden {
	return &GetCurrentOrgQuotaForbidden{}
}

/*
GetCurrentOrgQuotaForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetCurrentOrgQuotaForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get current org quota forbidden response has a 2xx status code
func (o *GetCurrentOrgQuotaForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get current org quota forbidden response has a 3xx status code
func (o *GetCurrentOrgQuotaForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get current org quota forbidden response has a 4xx status code
func (o *GetCurrentOrgQuotaForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get current org quota forbidden response has a 5xx status code
func (o *GetCurrentOrgQuotaForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get current org quota forbidden response a status code equal to that given
func (o *GetCurrentOrgQuotaForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get current org quota forbidden response
func (o *GetCurrentOrgQuotaForbidden) Code() int {
	return 403
}

func (o *GetCurrentOrgQuotaForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /org/quotas][%d] getCurrentOrgQuotaForbidden %s", 403, payload)
}

func (o *GetCurrentOrgQuotaForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /org/quotas][%d] getCurrentOrgQuotaForbidden %s", 403, payload)
}

func (o *GetCurrentOrgQuotaForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetCurrentOrgQuotaForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCurrentOrgQuotaNotFound creates a GetCurrentOrgQuotaNotFound with default headers values
func NewGetCurrentOrgQuotaNotFound() *GetCurrentOrgQuotaNotFound {
	return &GetCurrentOrgQuotaNotFound{}
}

/*
GetCurrentOrgQuotaNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetCurrentOrgQuotaNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get current org quota not found response has a 2xx status code
func (o *GetCurrentOrgQuotaNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get current org quota not found response has a 3xx status code
func (o *GetCurrentOrgQuotaNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get current org quota not found response has a 4xx status code
func (o *GetCurrentOrgQuotaNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get current org quota not found response has a 5xx status code
func (o *GetCurrentOrgQuotaNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get current org quota not found response a status code equal to that given
func (o *GetCurrentOrgQuotaNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get current org quota not found response
func (o *GetCurrentOrgQuotaNotFound) Code() int {
	return 404
}

func (o *GetCurrentOrgQuotaNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /org/quotas][%d] getCurrentOrgQuotaNotFound %s", 404, payload)
}

func (o *GetCurrentOrgQuotaNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /org/quotas][%d] getCurrentOrgQuotaNotFound %s", 404, payload)
}

func (o *GetCurrentOrgQuotaNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetCurrentOrgQuotaNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCurrentOrgQuotaInternalServerError creates a GetCurrentOrgQuotaInternalServerError with default headers values
func NewGetCurrentOrgQuotaInternalServerError() *GetCurrentOrgQuotaInternalServerError {
	return &GetCurrentOrgQuotaInternalServerError{}
}

/*
GetCurrentOrgQuotaInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetCurrentOrgQuotaInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get current org quota internal server error response has a 2xx status code
func (o *GetCurrentOrgQuotaInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get current org quota internal server error response has a 3xx status code
func (o *GetCurrentOrgQuotaInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get current org quota internal server error response has a 4xx status code
func (o *GetCurrentOrgQuotaInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get current org quota internal server error response has a 5xx status code
func (o *GetCurrentOrgQuotaInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get current org quota internal server error response a status code equal to that given
func (o *GetCurrentOrgQuotaInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get current org quota internal server error response
func (o *GetCurrentOrgQuotaInternalServerError) Code() int {
	return 500
}

func (o *GetCurrentOrgQuotaInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /org/quotas][%d] getCurrentOrgQuotaInternalServerError %s", 500, payload)
}

func (o *GetCurrentOrgQuotaInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /org/quotas][%d] getCurrentOrgQuotaInternalServerError %s", 500, payload)
}

func (o *GetCurrentOrgQuotaInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetCurrentOrgQuotaInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
