// Code generated by go-swagger; DO NOT EDIT.

package devices

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new devices API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for devices API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	SearchDevices(opts ...ClientOption) (*SearchDevicesOK, error)
	SearchDevicesWithParams(params *SearchDevicesParams, opts ...ClientOption) (*SearchDevicesOK, error)

	ListDevices(opts ...ClientOption) (*ListDevicesOK, error)
	ListDevicesWithParams(params *ListDevicesParams, opts ...ClientOption) (*ListDevicesOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
SearchDevices lists all devices within the last 30 days
*/
func (a *Client) SearchDevices(opts ...ClientOption) (*SearchDevicesOK, error) {
	params := NewSearchDevicesParams()
	return a.SearchDevicesWithParams(params, opts...)
}

func (a *Client) SearchDevicesWithParams(params *SearchDevicesParams, opts ...ClientOption) (*SearchDevicesOK, error) {
	if params == nil {
		params = NewSearchDevicesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "SearchDevices",
		Method:             "POST",
		PathPattern:        "/search",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &SearchDevicesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SearchDevicesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for SearchDevices: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ListDevices lists all devices within the last 30 days
*/
func (a *Client) ListDevices(opts ...ClientOption) (*ListDevicesOK, error) {
	params := NewListDevicesParams()
	return a.ListDevicesWithParams(params, opts...)
}

func (a *Client) ListDevicesWithParams(params *ListDevicesParams, opts ...ClientOption) (*ListDevicesOK, error) {
	if params == nil {
		params = NewListDevicesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "listDevices",
		Method:             "GET",
		PathPattern:        "/stats",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListDevicesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListDevicesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for listDevices: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
