// Code generated by go-swagger; DO NOT EDIT.

package dashboard_public

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// CreatePublicDashboardReader is a Reader for the CreatePublicDashboard structure.
type CreatePublicDashboardReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreatePublicDashboardReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreatePublicDashboardOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreatePublicDashboardBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewCreatePublicDashboardUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreatePublicDashboardForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreatePublicDashboardInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /dashboards/uid/{dashboardUid}/public-dashboards] createPublicDashboard", response, response.Code())
	}
}

// NewCreatePublicDashboardOK creates a CreatePublicDashboardOK with default headers values
func NewCreatePublicDashboardOK() *CreatePublicDashboardOK {
	return &CreatePublicDashboardOK{}
}

/*
CreatePublicDashboardOK describes a response with status code 200, with default header values.

(empty)
*/
type CreatePublicDashboardOK struct {
	Payload *models.PublicDashboard
}

// IsSuccess returns true when this create public dashboard Ok response has a 2xx status code
func (o *CreatePublicDashboardOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create public dashboard Ok response has a 3xx status code
func (o *CreatePublicDashboardOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create public dashboard Ok response has a 4xx status code
func (o *CreatePublicDashboardOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create public dashboard Ok response has a 5xx status code
func (o *CreatePublicDashboardOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create public dashboard Ok response a status code equal to that given
func (o *CreatePublicDashboardOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create public dashboard Ok response
func (o *CreatePublicDashboardOK) Code() int {
	return 200
}

func (o *CreatePublicDashboardOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/uid/{dashboardUid}/public-dashboards][%d] createPublicDashboardOk %s", 200, payload)
}

func (o *CreatePublicDashboardOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/uid/{dashboardUid}/public-dashboards][%d] createPublicDashboardOk %s", 200, payload)
}

func (o *CreatePublicDashboardOK) GetPayload() *models.PublicDashboard {
	return o.Payload
}

func (o *CreatePublicDashboardOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicDashboard)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePublicDashboardBadRequest creates a CreatePublicDashboardBadRequest with default headers values
func NewCreatePublicDashboardBadRequest() *CreatePublicDashboardBadRequest {
	return &CreatePublicDashboardBadRequest{}
}

/*
CreatePublicDashboardBadRequest describes a response with status code 400, with default header values.

BadRequestPublicError is returned when the request is invalid and it cannot be processed.
*/
type CreatePublicDashboardBadRequest struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this create public dashboard bad request response has a 2xx status code
func (o *CreatePublicDashboardBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create public dashboard bad request response has a 3xx status code
func (o *CreatePublicDashboardBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create public dashboard bad request response has a 4xx status code
func (o *CreatePublicDashboardBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create public dashboard bad request response has a 5xx status code
func (o *CreatePublicDashboardBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create public dashboard bad request response a status code equal to that given
func (o *CreatePublicDashboardBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create public dashboard bad request response
func (o *CreatePublicDashboardBadRequest) Code() int {
	return 400
}

func (o *CreatePublicDashboardBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/uid/{dashboardUid}/public-dashboards][%d] createPublicDashboardBadRequest %s", 400, payload)
}

func (o *CreatePublicDashboardBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/uid/{dashboardUid}/public-dashboards][%d] createPublicDashboardBadRequest %s", 400, payload)
}

func (o *CreatePublicDashboardBadRequest) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *CreatePublicDashboardBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePublicDashboardUnauthorized creates a CreatePublicDashboardUnauthorized with default headers values
func NewCreatePublicDashboardUnauthorized() *CreatePublicDashboardUnauthorized {
	return &CreatePublicDashboardUnauthorized{}
}

/*
CreatePublicDashboardUnauthorized describes a response with status code 401, with default header values.

UnauthorisedPublicError is returned when the request is not authenticated.
*/
type CreatePublicDashboardUnauthorized struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this create public dashboard unauthorized response has a 2xx status code
func (o *CreatePublicDashboardUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create public dashboard unauthorized response has a 3xx status code
func (o *CreatePublicDashboardUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create public dashboard unauthorized response has a 4xx status code
func (o *CreatePublicDashboardUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this create public dashboard unauthorized response has a 5xx status code
func (o *CreatePublicDashboardUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this create public dashboard unauthorized response a status code equal to that given
func (o *CreatePublicDashboardUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the create public dashboard unauthorized response
func (o *CreatePublicDashboardUnauthorized) Code() int {
	return 401
}

func (o *CreatePublicDashboardUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/uid/{dashboardUid}/public-dashboards][%d] createPublicDashboardUnauthorized %s", 401, payload)
}

func (o *CreatePublicDashboardUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/uid/{dashboardUid}/public-dashboards][%d] createPublicDashboardUnauthorized %s", 401, payload)
}

func (o *CreatePublicDashboardUnauthorized) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *CreatePublicDashboardUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePublicDashboardForbidden creates a CreatePublicDashboardForbidden with default headers values
func NewCreatePublicDashboardForbidden() *CreatePublicDashboardForbidden {
	return &CreatePublicDashboardForbidden{}
}

/*
CreatePublicDashboardForbidden describes a response with status code 403, with default header values.

ForbiddenPublicError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type CreatePublicDashboardForbidden struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this create public dashboard forbidden response has a 2xx status code
func (o *CreatePublicDashboardForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create public dashboard forbidden response has a 3xx status code
func (o *CreatePublicDashboardForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create public dashboard forbidden response has a 4xx status code
func (o *CreatePublicDashboardForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create public dashboard forbidden response has a 5xx status code
func (o *CreatePublicDashboardForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create public dashboard forbidden response a status code equal to that given
func (o *CreatePublicDashboardForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create public dashboard forbidden response
func (o *CreatePublicDashboardForbidden) Code() int {
	return 403
}

func (o *CreatePublicDashboardForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/uid/{dashboardUid}/public-dashboards][%d] createPublicDashboardForbidden %s", 403, payload)
}

func (o *CreatePublicDashboardForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/uid/{dashboardUid}/public-dashboards][%d] createPublicDashboardForbidden %s", 403, payload)
}

func (o *CreatePublicDashboardForbidden) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *CreatePublicDashboardForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePublicDashboardInternalServerError creates a CreatePublicDashboardInternalServerError with default headers values
func NewCreatePublicDashboardInternalServerError() *CreatePublicDashboardInternalServerError {
	return &CreatePublicDashboardInternalServerError{}
}

/*
CreatePublicDashboardInternalServerError describes a response with status code 500, with default header values.

InternalServerPublicError is a general error indicating something went wrong internally.
*/
type CreatePublicDashboardInternalServerError struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this create public dashboard internal server error response has a 2xx status code
func (o *CreatePublicDashboardInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create public dashboard internal server error response has a 3xx status code
func (o *CreatePublicDashboardInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create public dashboard internal server error response has a 4xx status code
func (o *CreatePublicDashboardInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create public dashboard internal server error response has a 5xx status code
func (o *CreatePublicDashboardInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create public dashboard internal server error response a status code equal to that given
func (o *CreatePublicDashboardInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create public dashboard internal server error response
func (o *CreatePublicDashboardInternalServerError) Code() int {
	return 500
}

func (o *CreatePublicDashboardInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/uid/{dashboardUid}/public-dashboards][%d] createPublicDashboardInternalServerError %s", 500, payload)
}

func (o *CreatePublicDashboardInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/uid/{dashboardUid}/public-dashboards][%d] createPublicDashboardInternalServerError %s", 500, payload)
}

func (o *CreatePublicDashboardInternalServerError) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *CreatePublicDashboardInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
