// Code generated by go-swagger; DO NOT EDIT.

package correlations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewCreateCorrelationParams creates a new CreateCorrelationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateCorrelationParams() *CreateCorrelationParams {
	return &CreateCorrelationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateCorrelationParamsWithTimeout creates a new CreateCorrelationParams object
// with the ability to set a timeout on a request.
func NewCreateCorrelationParamsWithTimeout(timeout time.Duration) *CreateCorrelationParams {
	return &CreateCorrelationParams{
		timeout: timeout,
	}
}

// NewCreateCorrelationParamsWithContext creates a new CreateCorrelationParams object
// with the ability to set a context for a request.
func NewCreateCorrelationParamsWithContext(ctx context.Context) *CreateCorrelationParams {
	return &CreateCorrelationParams{
		Context: ctx,
	}
}

// NewCreateCorrelationParamsWithHTTPClient creates a new CreateCorrelationParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateCorrelationParamsWithHTTPClient(client *http.Client) *CreateCorrelationParams {
	return &CreateCorrelationParams{
		HTTPClient: client,
	}
}

/*
CreateCorrelationParams contains all the parameters to send to the API endpoint

	for the create correlation operation.

	Typically these are written to a http.Request.
*/
type CreateCorrelationParams struct {

	// Body.
	Body *models.CreateCorrelationCommand

	// SourceUID.
	SourceUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create correlation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateCorrelationParams) WithDefaults() *CreateCorrelationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create correlation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateCorrelationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create correlation params
func (o *CreateCorrelationParams) WithTimeout(timeout time.Duration) *CreateCorrelationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create correlation params
func (o *CreateCorrelationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create correlation params
func (o *CreateCorrelationParams) WithContext(ctx context.Context) *CreateCorrelationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create correlation params
func (o *CreateCorrelationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create correlation params
func (o *CreateCorrelationParams) WithHTTPClient(client *http.Client) *CreateCorrelationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create correlation params
func (o *CreateCorrelationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the create correlation params
func (o *CreateCorrelationParams) WithBody(body *models.CreateCorrelationCommand) *CreateCorrelationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create correlation params
func (o *CreateCorrelationParams) SetBody(body *models.CreateCorrelationCommand) {
	o.Body = body
}

// WithSourceUID adds the sourceUID to the create correlation params
func (o *CreateCorrelationParams) WithSourceUID(sourceUID string) *CreateCorrelationParams {
	o.SetSourceUID(sourceUID)
	return o
}

// SetSourceUID adds the sourceUid to the create correlation params
func (o *CreateCorrelationParams) SetSourceUID(sourceUID string) {
	o.SourceUID = sourceUID
}

// WriteToRequest writes these params to a swagger request
func (o *CreateCorrelationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param sourceUID
	if err := r.SetPathParam("sourceUID", o.SourceUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
