// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetResourceDescriptionReader is a Reader for the GetResourceDescription structure.
type GetResourceDescriptionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetResourceDescriptionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetResourceDescriptionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetResourceDescriptionForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetResourceDescriptionInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /access-control/{resource}/description] getResourceDescription", response, response.Code())
	}
}

// NewGetResourceDescriptionOK creates a GetResourceDescriptionOK with default headers values
func NewGetResourceDescriptionOK() *GetResourceDescriptionOK {
	return &GetResourceDescriptionOK{}
}

/*
GetResourceDescriptionOK describes a response with status code 200, with default header values.

(empty)
*/
type GetResourceDescriptionOK struct {
	Payload *models.Description
}

// IsSuccess returns true when this get resource description Ok response has a 2xx status code
func (o *GetResourceDescriptionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get resource description Ok response has a 3xx status code
func (o *GetResourceDescriptionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get resource description Ok response has a 4xx status code
func (o *GetResourceDescriptionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get resource description Ok response has a 5xx status code
func (o *GetResourceDescriptionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get resource description Ok response a status code equal to that given
func (o *GetResourceDescriptionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get resource description Ok response
func (o *GetResourceDescriptionOK) Code() int {
	return 200
}

func (o *GetResourceDescriptionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/{resource}/description][%d] getResourceDescriptionOk %s", 200, payload)
}

func (o *GetResourceDescriptionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/{resource}/description][%d] getResourceDescriptionOk %s", 200, payload)
}

func (o *GetResourceDescriptionOK) GetPayload() *models.Description {
	return o.Payload
}

func (o *GetResourceDescriptionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Description)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetResourceDescriptionForbidden creates a GetResourceDescriptionForbidden with default headers values
func NewGetResourceDescriptionForbidden() *GetResourceDescriptionForbidden {
	return &GetResourceDescriptionForbidden{}
}

/*
GetResourceDescriptionForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetResourceDescriptionForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get resource description forbidden response has a 2xx status code
func (o *GetResourceDescriptionForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get resource description forbidden response has a 3xx status code
func (o *GetResourceDescriptionForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get resource description forbidden response has a 4xx status code
func (o *GetResourceDescriptionForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get resource description forbidden response has a 5xx status code
func (o *GetResourceDescriptionForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get resource description forbidden response a status code equal to that given
func (o *GetResourceDescriptionForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get resource description forbidden response
func (o *GetResourceDescriptionForbidden) Code() int {
	return 403
}

func (o *GetResourceDescriptionForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/{resource}/description][%d] getResourceDescriptionForbidden %s", 403, payload)
}

func (o *GetResourceDescriptionForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/{resource}/description][%d] getResourceDescriptionForbidden %s", 403, payload)
}

func (o *GetResourceDescriptionForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetResourceDescriptionForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetResourceDescriptionInternalServerError creates a GetResourceDescriptionInternalServerError with default headers values
func NewGetResourceDescriptionInternalServerError() *GetResourceDescriptionInternalServerError {
	return &GetResourceDescriptionInternalServerError{}
}

/*
GetResourceDescriptionInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetResourceDescriptionInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get resource description internal server error response has a 2xx status code
func (o *GetResourceDescriptionInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get resource description internal server error response has a 3xx status code
func (o *GetResourceDescriptionInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get resource description internal server error response has a 4xx status code
func (o *GetResourceDescriptionInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get resource description internal server error response has a 5xx status code
func (o *GetResourceDescriptionInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get resource description internal server error response a status code equal to that given
func (o *GetResourceDescriptionInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get resource description internal server error response
func (o *GetResourceDescriptionInternalServerError) Code() int {
	return 500
}

func (o *GetResourceDescriptionInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/{resource}/description][%d] getResourceDescriptionInternalServerError %s", 500, payload)
}

func (o *GetResourceDescriptionInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/{resource}/description][%d] getResourceDescriptionInternalServerError %s", 500, payload)
}

func (o *GetResourceDescriptionInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetResourceDescriptionInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
