// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// NewWaypointServiceUpdateAddOnParams creates a new WaypointServiceUpdateAddOnParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceUpdateAddOnParams() *WaypointServiceUpdateAddOnParams {
	return &WaypointServiceUpdateAddOnParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceUpdateAddOnParamsWithTimeout creates a new WaypointServiceUpdateAddOnParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceUpdateAddOnParamsWithTimeout(timeout time.Duration) *WaypointServiceUpdateAddOnParams {
	return &WaypointServiceUpdateAddOnParams{
		timeout: timeout,
	}
}

// NewWaypointServiceUpdateAddOnParamsWithContext creates a new WaypointServiceUpdateAddOnParams object
// with the ability to set a context for a request.
func NewWaypointServiceUpdateAddOnParamsWithContext(ctx context.Context) *WaypointServiceUpdateAddOnParams {
	return &WaypointServiceUpdateAddOnParams{
		Context: ctx,
	}
}

// NewWaypointServiceUpdateAddOnParamsWithHTTPClient creates a new WaypointServiceUpdateAddOnParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceUpdateAddOnParamsWithHTTPClient(client *http.Client) *WaypointServiceUpdateAddOnParams {
	return &WaypointServiceUpdateAddOnParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceUpdateAddOnParams contains all the parameters to send to the API endpoint

	for the waypoint service update add on operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceUpdateAddOnParams struct {

	// Body.
	Body *models.HashicorpCloudWaypointV20241122WaypointServiceUpdateAddOnBody

	// ExistingAddOnID.
	ExistingAddOnID string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service update add on params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceUpdateAddOnParams) WithDefaults() *WaypointServiceUpdateAddOnParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service update add on params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceUpdateAddOnParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service update add on params
func (o *WaypointServiceUpdateAddOnParams) WithTimeout(timeout time.Duration) *WaypointServiceUpdateAddOnParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service update add on params
func (o *WaypointServiceUpdateAddOnParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service update add on params
func (o *WaypointServiceUpdateAddOnParams) WithContext(ctx context.Context) *WaypointServiceUpdateAddOnParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service update add on params
func (o *WaypointServiceUpdateAddOnParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service update add on params
func (o *WaypointServiceUpdateAddOnParams) WithHTTPClient(client *http.Client) *WaypointServiceUpdateAddOnParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service update add on params
func (o *WaypointServiceUpdateAddOnParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the waypoint service update add on params
func (o *WaypointServiceUpdateAddOnParams) WithBody(body *models.HashicorpCloudWaypointV20241122WaypointServiceUpdateAddOnBody) *WaypointServiceUpdateAddOnParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the waypoint service update add on params
func (o *WaypointServiceUpdateAddOnParams) SetBody(body *models.HashicorpCloudWaypointV20241122WaypointServiceUpdateAddOnBody) {
	o.Body = body
}

// WithExistingAddOnID adds the existingAddOnID to the waypoint service update add on params
func (o *WaypointServiceUpdateAddOnParams) WithExistingAddOnID(existingAddOnID string) *WaypointServiceUpdateAddOnParams {
	o.SetExistingAddOnID(existingAddOnID)
	return o
}

// SetExistingAddOnID adds the existingAddOnId to the waypoint service update add on params
func (o *WaypointServiceUpdateAddOnParams) SetExistingAddOnID(existingAddOnID string) {
	o.ExistingAddOnID = existingAddOnID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service update add on params
func (o *WaypointServiceUpdateAddOnParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) *WaypointServiceUpdateAddOnParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service update add on params
func (o *WaypointServiceUpdateAddOnParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service update add on params
func (o *WaypointServiceUpdateAddOnParams) WithNamespaceLocationProjectID(namespaceLocationProjectID string) *WaypointServiceUpdateAddOnParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service update add on params
func (o *WaypointServiceUpdateAddOnParams) SetNamespaceLocationProjectID(namespaceLocationProjectID string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceUpdateAddOnParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param existing_add_on.id
	if err := r.SetPathParam("existing_add_on.id", o.ExistingAddOnID); err != nil {
		return err
	}

	// path param namespace.location.organization_id
	if err := r.SetPathParam("namespace.location.organization_id", o.NamespaceLocationOrganizationID); err != nil {
		return err
	}

	// path param namespace.location.project_id
	if err := r.SetPathParam("namespace.location.project_id", o.NamespaceLocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
