// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceRunActionReader is a Reader for the WaypointServiceRunAction structure.
type WaypointServiceRunActionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceRunActionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceRunActionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceRunActionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceRunActionOK creates a WaypointServiceRunActionOK with default headers values
func NewWaypointServiceRunActionOK() *WaypointServiceRunActionOK {
	return &WaypointServiceRunActionOK{}
}

/*
WaypointServiceRunActionOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceRunActionOK struct {
	Payload *models.HashicorpCloudWaypointRunActionResponse
}

// IsSuccess returns true when this waypoint service run action o k response has a 2xx status code
func (o *WaypointServiceRunActionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service run action o k response has a 3xx status code
func (o *WaypointServiceRunActionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service run action o k response has a 4xx status code
func (o *WaypointServiceRunActionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service run action o k response has a 5xx status code
func (o *WaypointServiceRunActionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service run action o k response a status code equal to that given
func (o *WaypointServiceRunActionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service run action o k response
func (o *WaypointServiceRunActionOK) Code() int {
	return 200
}

func (o *WaypointServiceRunActionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/action][%d] waypointServiceRunActionOK %s", 200, payload)
}

func (o *WaypointServiceRunActionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/action][%d] waypointServiceRunActionOK %s", 200, payload)
}

func (o *WaypointServiceRunActionOK) GetPayload() *models.HashicorpCloudWaypointRunActionResponse {
	return o.Payload
}

func (o *WaypointServiceRunActionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointRunActionResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceRunActionDefault creates a WaypointServiceRunActionDefault with default headers values
func NewWaypointServiceRunActionDefault(code int) *WaypointServiceRunActionDefault {
	return &WaypointServiceRunActionDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceRunActionDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceRunActionDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service run action default response has a 2xx status code
func (o *WaypointServiceRunActionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service run action default response has a 3xx status code
func (o *WaypointServiceRunActionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service run action default response has a 4xx status code
func (o *WaypointServiceRunActionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service run action default response has a 5xx status code
func (o *WaypointServiceRunActionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service run action default response a status code equal to that given
func (o *WaypointServiceRunActionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service run action default response
func (o *WaypointServiceRunActionDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceRunActionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/action][%d] WaypointService_RunAction default %s", o._statusCode, payload)
}

func (o *WaypointServiceRunActionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/action][%d] WaypointService_RunAction default %s", o._statusCode, payload)
}

func (o *WaypointServiceRunActionDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceRunActionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
