// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceListActionRuns2Reader is a Reader for the WaypointServiceListActionRuns2 structure.
type WaypointServiceListActionRuns2Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceListActionRuns2Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceListActionRuns2OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceListActionRuns2Default(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceListActionRuns2OK creates a WaypointServiceListActionRuns2OK with default headers values
func NewWaypointServiceListActionRuns2OK() *WaypointServiceListActionRuns2OK {
	return &WaypointServiceListActionRuns2OK{}
}

/*
WaypointServiceListActionRuns2OK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceListActionRuns2OK struct {
	Payload *models.HashicorpCloudWaypointListActionRunsResponse
}

// IsSuccess returns true when this waypoint service list action runs2 o k response has a 2xx status code
func (o *WaypointServiceListActionRuns2OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service list action runs2 o k response has a 3xx status code
func (o *WaypointServiceListActionRuns2OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service list action runs2 o k response has a 4xx status code
func (o *WaypointServiceListActionRuns2OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service list action runs2 o k response has a 5xx status code
func (o *WaypointServiceListActionRuns2OK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service list action runs2 o k response a status code equal to that given
func (o *WaypointServiceListActionRuns2OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service list action runs2 o k response
func (o *WaypointServiceListActionRuns2OK) Code() int {
	return 200
}

func (o *WaypointServiceListActionRuns2OK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/action/by-name/{action_name}/runs][%d] waypointServiceListActionRuns2OK %s", 200, payload)
}

func (o *WaypointServiceListActionRuns2OK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/action/by-name/{action_name}/runs][%d] waypointServiceListActionRuns2OK %s", 200, payload)
}

func (o *WaypointServiceListActionRuns2OK) GetPayload() *models.HashicorpCloudWaypointListActionRunsResponse {
	return o.Payload
}

func (o *WaypointServiceListActionRuns2OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointListActionRunsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceListActionRuns2Default creates a WaypointServiceListActionRuns2Default with default headers values
func NewWaypointServiceListActionRuns2Default(code int) *WaypointServiceListActionRuns2Default {
	return &WaypointServiceListActionRuns2Default{
		_statusCode: code,
	}
}

/*
WaypointServiceListActionRuns2Default describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceListActionRuns2Default struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service list action runs2 default response has a 2xx status code
func (o *WaypointServiceListActionRuns2Default) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service list action runs2 default response has a 3xx status code
func (o *WaypointServiceListActionRuns2Default) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service list action runs2 default response has a 4xx status code
func (o *WaypointServiceListActionRuns2Default) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service list action runs2 default response has a 5xx status code
func (o *WaypointServiceListActionRuns2Default) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service list action runs2 default response a status code equal to that given
func (o *WaypointServiceListActionRuns2Default) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service list action runs2 default response
func (o *WaypointServiceListActionRuns2Default) Code() int {
	return o._statusCode
}

func (o *WaypointServiceListActionRuns2Default) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/action/by-name/{action_name}/runs][%d] WaypointService_ListActionRuns2 default %s", o._statusCode, payload)
}

func (o *WaypointServiceListActionRuns2Default) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/action/by-name/{action_name}/runs][%d] WaypointService_ListActionRuns2 default %s", o._statusCode, payload)
}

func (o *WaypointServiceListActionRuns2Default) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceListActionRuns2Default) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
