// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// CreateIntegrationReader is a Reader for the CreateIntegration structure.
type CreateIntegrationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateIntegrationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateIntegrationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreateIntegrationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateIntegrationOK creates a CreateIntegrationOK with default headers values
func NewCreateIntegrationOK() *CreateIntegrationOK {
	return &CreateIntegrationOK{}
}

/*
CreateIntegrationOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreateIntegrationOK struct {
	Payload *models.Secrets20231128CreateIntegrationResponse
}

// IsSuccess returns true when this create integration o k response has a 2xx status code
func (o *CreateIntegrationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create integration o k response has a 3xx status code
func (o *CreateIntegrationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create integration o k response has a 4xx status code
func (o *CreateIntegrationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create integration o k response has a 5xx status code
func (o *CreateIntegrationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create integration o k response a status code equal to that given
func (o *CreateIntegrationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create integration o k response
func (o *CreateIntegrationOK) Code() int {
	return 200
}

func (o *CreateIntegrationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations][%d] createIntegrationOK %s", 200, payload)
}

func (o *CreateIntegrationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations][%d] createIntegrationOK %s", 200, payload)
}

func (o *CreateIntegrationOK) GetPayload() *models.Secrets20231128CreateIntegrationResponse {
	return o.Payload
}

func (o *CreateIntegrationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128CreateIntegrationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateIntegrationDefault creates a CreateIntegrationDefault with default headers values
func NewCreateIntegrationDefault(code int) *CreateIntegrationDefault {
	return &CreateIntegrationDefault{
		_statusCode: code,
	}
}

/*
CreateIntegrationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreateIntegrationDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this create integration default response has a 2xx status code
func (o *CreateIntegrationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create integration default response has a 3xx status code
func (o *CreateIntegrationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create integration default response has a 4xx status code
func (o *CreateIntegrationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create integration default response has a 5xx status code
func (o *CreateIntegrationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create integration default response a status code equal to that given
func (o *CreateIntegrationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the create integration default response
func (o *CreateIntegrationDefault) Code() int {
	return o._statusCode
}

func (o *CreateIntegrationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations][%d] CreateIntegration default %s", o._statusCode, payload)
}

func (o *CreateIntegrationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations][%d] CreateIntegration default %s", o._statusCode, payload)
}

func (o *CreateIntegrationDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *CreateIntegrationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
