// Code generated by go-swagger; DO NOT EDIT.

package integration_subscription_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-radar/preview/2023-05-01/models"
)

// GetIntegrationSubscriptionByNameReader is a Reader for the GetIntegrationSubscriptionByName structure.
type GetIntegrationSubscriptionByNameReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetIntegrationSubscriptionByNameReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetIntegrationSubscriptionByNameOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetIntegrationSubscriptionByNameDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetIntegrationSubscriptionByNameOK creates a GetIntegrationSubscriptionByNameOK with default headers values
func NewGetIntegrationSubscriptionByNameOK() *GetIntegrationSubscriptionByNameOK {
	return &GetIntegrationSubscriptionByNameOK{}
}

/*
GetIntegrationSubscriptionByNameOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetIntegrationSubscriptionByNameOK struct {
	Payload *models.VaultRadar20230501IntegrationSubscription
}

// IsSuccess returns true when this get integration subscription by name o k response has a 2xx status code
func (o *GetIntegrationSubscriptionByNameOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get integration subscription by name o k response has a 3xx status code
func (o *GetIntegrationSubscriptionByNameOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get integration subscription by name o k response has a 4xx status code
func (o *GetIntegrationSubscriptionByNameOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get integration subscription by name o k response has a 5xx status code
func (o *GetIntegrationSubscriptionByNameOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get integration subscription by name o k response a status code equal to that given
func (o *GetIntegrationSubscriptionByNameOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get integration subscription by name o k response
func (o *GetIntegrationSubscriptionByNameOK) Code() int {
	return 200
}

func (o *GetIntegrationSubscriptionByNameOK) Error() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/integrations/subscriptions/search-by-name][%d] getIntegrationSubscriptionByNameOK  %+v", 200, o.Payload)
}

func (o *GetIntegrationSubscriptionByNameOK) String() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/integrations/subscriptions/search-by-name][%d] getIntegrationSubscriptionByNameOK  %+v", 200, o.Payload)
}

func (o *GetIntegrationSubscriptionByNameOK) GetPayload() *models.VaultRadar20230501IntegrationSubscription {
	return o.Payload
}

func (o *GetIntegrationSubscriptionByNameOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.VaultRadar20230501IntegrationSubscription)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIntegrationSubscriptionByNameDefault creates a GetIntegrationSubscriptionByNameDefault with default headers values
func NewGetIntegrationSubscriptionByNameDefault(code int) *GetIntegrationSubscriptionByNameDefault {
	return &GetIntegrationSubscriptionByNameDefault{
		_statusCode: code,
	}
}

/*
GetIntegrationSubscriptionByNameDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetIntegrationSubscriptionByNameDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this get integration subscription by name default response has a 2xx status code
func (o *GetIntegrationSubscriptionByNameDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get integration subscription by name default response has a 3xx status code
func (o *GetIntegrationSubscriptionByNameDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get integration subscription by name default response has a 4xx status code
func (o *GetIntegrationSubscriptionByNameDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get integration subscription by name default response has a 5xx status code
func (o *GetIntegrationSubscriptionByNameDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get integration subscription by name default response a status code equal to that given
func (o *GetIntegrationSubscriptionByNameDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get integration subscription by name default response
func (o *GetIntegrationSubscriptionByNameDefault) Code() int {
	return o._statusCode
}

func (o *GetIntegrationSubscriptionByNameDefault) Error() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/integrations/subscriptions/search-by-name][%d] GetIntegrationSubscriptionByName default  %+v", o._statusCode, o.Payload)
}

func (o *GetIntegrationSubscriptionByNameDefault) String() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/integrations/subscriptions/search-by-name][%d] GetIntegrationSubscriptionByName default  %+v", o._statusCode, o.Payload)
}

func (o *GetIntegrationSubscriptionByNameDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *GetIntegrationSubscriptionByNameDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
GetIntegrationSubscriptionByNameBody get integration subscription by name body
swagger:model GetIntegrationSubscriptionByNameBody
*/
type GetIntegrationSubscriptionByNameBody struct {

	// location
	Location *GetIntegrationSubscriptionByNameParamsBodyLocation `json:"location,omitempty"`

	// Name is the unique name of the integration subscription to retrieve.
	Name string `json:"name,omitempty"`
}

// Validate validates this get integration subscription by name body
func (o *GetIntegrationSubscriptionByNameBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetIntegrationSubscriptionByNameBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this get integration subscription by name body based on the context it is used
func (o *GetIntegrationSubscriptionByNameBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetIntegrationSubscriptionByNameBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GetIntegrationSubscriptionByNameBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GetIntegrationSubscriptionByNameBody) UnmarshalBinary(b []byte) error {
	var res GetIntegrationSubscriptionByNameBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
GetIntegrationSubscriptionByNameParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model GetIntegrationSubscriptionByNameParamsBodyLocation
*/
type GetIntegrationSubscriptionByNameParamsBodyLocation struct {

	// organization_id is the id of the organization.
	OrganizationID string `json:"organization_id,omitempty"`

	// region
	Region *models.LocationRegion `json:"region,omitempty"`
}

// Validate validates this get integration subscription by name params body location
func (o *GetIntegrationSubscriptionByNameParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetIntegrationSubscriptionByNameParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this get integration subscription by name params body location based on the context it is used
func (o *GetIntegrationSubscriptionByNameParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetIntegrationSubscriptionByNameParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GetIntegrationSubscriptionByNameParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GetIntegrationSubscriptionByNameParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res GetIntegrationSubscriptionByNameParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
